/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ArgumentList;
import coldfusion.runtime.Array;
import coldfusion.runtime.ArrayDeleteException;
import coldfusion.runtime.ArrayGenericMultiDimException;
import coldfusion.runtime.ArrayNotOneDimensionException;
import coldfusion.runtime.ArrayResizeException;
import coldfusion.runtime.ArraySetRangeException;
import coldfusion.runtime.ArraySortSimpleValueException;
import coldfusion.runtime.ArraySwapRangeException;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFOutput;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.CFPageMethod;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.InvalidArrayIndexException;
import coldfusion.runtime.InvalidSortOrderException;
import coldfusion.runtime.InvalidSortTypeException;
import coldfusion.runtime.KeyNotNumericException;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.ObjectDuplicator;
import coldfusion.runtime.QueryFunction;
import coldfusion.runtime.StringFunc;
import coldfusion.runtime.StructBean;
import coldfusion.runtime.StructSorted;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.UnsupportedFunctionException;
import coldfusion.runtime.ValueNotNumericException;
import coldfusion.runtime.async.CallableCompletionService;
import coldfusion.runtime.async.CallableResult;
import coldfusion.runtime.async.ColdfusionFuture;
import coldfusion.runtime.async.Future;
import coldfusion.runtime.async.ListProcessingCallable;
import coldfusion.runtime.async.NumericListMetricCallable;
import coldfusion.runtime.parallel.ParallelCallUtil;
import coldfusion.sql.QueryColumn;
import coldfusion.sql.QueryTable;
import coldfusion.sql.Table;
import coldfusion.util.DateUtils;
import coldfusion.util.Key;
import coldfusion.util.RB;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.SortedStructMap;
import coldfusion.util.Utils;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

public class ArrayUtil {
    public static FastArray createArray(int dimension, boolean isSynchronized) {
        FastArray array = null;
        array = isSynchronized ? new Array(dimension) : new FastArray(dimension);
        return array;
    }

    public static FastArray createArray(int dimension, boolean isSynchronized, String typeName) {
        FastArray array = null;
        array = isSynchronized ? new Array(dimension, typeName) : new FastArray(dimension, typeName);
        return array;
    }

    static FastArray copy(List lst) {
        FastArray result = null;
        result = lst instanceof Array ? new Array() : new FastArray();
        result.dimension = ArrayUtil.dimensionOf(lst);
        result.typeName = ArrayUtil.typeOf(lst);
        int count = lst.size();
        for (int i = 0; i < count; ++i) {
            if (ArrayUtil.isArray(lst.get(i)) && !lst.get(i).getClass().isArray()) {
                result.addElement(ArrayUtil.copy(Cast._Array(lst.get(i))));
                continue;
            }
            result.addElement(lst.get(i));
        }
        if (lst instanceof FastArray) {
            result.metadata = ((FastArray)lst).metadata;
        }
        return result;
    }

    static boolean isArray(Object value) {
        return value instanceof List || value != null && value.getClass().isArray();
    }

    static FastArray Duplicate(FastArray src) throws IllegalAccessException {
        return ArrayUtil.Duplicate(src, null);
    }

    static FastArray Duplicate(FastArray src, IdentityHashMap refCache) throws IllegalAccessException {
        FastArray dst = null;
        dst = src instanceof Array ? new Array(src.getDimension()) : new FastArray(src.dimension);
        dst.typeName = src.typeName;
        if (refCache == null) {
            refCache = new IdentityHashMap<FastArray, FastArray>();
        }
        refCache.put(src, dst);
        for (int i = 0; i < src.size(); ++i) {
            Object obj = src.get(i);
            dst.addElement(ObjectDuplicator.duplicate(obj, refCache));
        }
        dst.metadata = src.metadata;
        return dst;
    }

    public static List ArraySlice(List v, int start, int count) {
        ArrayUtil.verifySingleDimension(v);
        if (start > v.size() || start == 0) {
            throw new InvalidArrayIndexException(start, v.size());
        }
        start = start < 0 ? v.size() + start : --start;
        if (start < 0) {
            throw new InvalidArrayIndexException(start, v.size());
        }
        int end = 0;
        end = count >= 0 ? start + count : v.size();
        if (end > v.size()) {
            throw new InvalidArrayIndexException(end, v.size());
        }
        FastArray returnList = new Array(1);
        if (v instanceof FastArray) {
            String typeName;
            returnList = new FastArray(1);
            returnList.typeName = typeName = ((FastArray)v).typeName;
        } else if (v instanceof Array) {
            String typeName;
            returnList.typeName = typeName = ((Array)v).typeName;
        }
        ((FastArray)returnList).addAll((Collection)v.subList(start, end));
        return returnList;
    }

    public static List ArrayAppend(List v, Object obj) {
        return ArrayUtil.ArrayAppend(v, obj, false);
    }

    public static List ArrayAppend(List v, Object obj, boolean arrayConcat) {
        Table table;
        Array a;
        if (v instanceof Array && (a = (Array)v).getDimension() > 1) {
            if (!(obj instanceof Array)) {
                throw new ArrayGenericMultiDimException();
            }
            if (((Array)obj).getDimension() + 1 != a.getDimension()) {
                throw new ArrayGenericMultiDimException();
            }
        }
        if (obj instanceof QueryColumn && (table = ((QueryColumn)obj).getParentTable()) != null && table instanceof QueryTable) {
            int row = ((QueryTable)table).getCurrentRow();
            obj = ((QueryColumn)obj).get(row > 0 ? row - 1 : 0);
        }
        try {
            Object ObjBeingAppended = CfJspPage._arrayAssign(obj);
            if (arrayConcat) {
                if (ObjBeingAppended instanceof List) {
                    v.addAll((List)ObjBeingAppended);
                } else if (ObjBeingAppended.getClass().isArray()) {
                    int length = java.lang.reflect.Array.getLength(ObjBeingAppended);
                    for (int i = 0; i < length; ++i) {
                        v.add(java.lang.reflect.Array.get(ObjBeingAppended, i));
                    }
                } else {
                    v.add(ObjBeingAppended);
                }
            } else {
                v.add(ObjBeingAppended);
            }
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedFunctionException("ArrayAppend", v.getClass().getName());
        }
        return v;
    }

    public static void verifySingleDimension(List a) {
        if (ArrayUtil.dimensionOf(a) != 1) {
            throw new ArrayNotOneDimensionException();
        }
    }

    public static int dimensionOf(List list) {
        if (list instanceof FastArray) {
            return ((FastArray)list).getDimension();
        }
        return 1;
    }

    public static String typeOf(List list) {
        if (list instanceof FastArray) {
            return ((FastArray)list).typeName;
        }
        return null;
    }

    public static void populateDataTypeInfo(Map metadata, String typeName) {
        if (metadata != null) {
            if (typeName != null) {
                metadata.put(RB.getString(ArrayUtil.class, "Array.DataType"), typeName);
            } else {
                metadata.put(RB.getString(ArrayUtil.class, "Array.DataType"), RB.getString(ArrayUtil.class, "Array.DataType.Any"));
            }
        }
    }

    public static double ArrayAvg(List v) {
        int count = v.size();
        ArrayUtil.verifySingleDimension(v);
        if (v.size() == 0) {
            return 0.0;
        }
        double arraySum = ArrayUtil.ArraySum(v);
        BigDecimal arraySumObj = new BigDecimal(arraySum);
        return CfJspPage._divideBD(arraySumObj, new BigDecimal(count)).doubleValue();
    }

    public static double ArrayAvg(List v, int maxThreads) {
        int count = v.size();
        ArrayUtil.verifySingleDimension(v);
        if (v.size() == 0) {
            return 0.0;
        }
        double arraySum = ArrayUtil.ArraySum(v, false, maxThreads);
        BigDecimal arraySumObj = new BigDecimal(arraySum);
        return CfJspPage._divideBD(arraySumObj, new BigDecimal(count)).doubleValue();
    }

    public static List ArrayClear(List v) {
        v.clear();
        return v;
    }

    public static List ArrayDeleteAt(List v, int pos) {
        if (pos <= 0 || pos > v.size()) {
            throw new InvalidArrayIndexException(pos, v.size());
        }
        v.remove(pos - 1);
        return v;
    }

    public static Object ArrayPush(List v, Object val) {
        if (v instanceof FastArray) {
            return ((FastArray)v).push(val);
        }
        Object[] args = new Object[]{val};
        try {
            return new StructBean(v).invoke("push", args);
        }
        catch (Throwable throwable) {
            throw new CfJspPage.MemberFunctionInvocationException(throwable, "push");
        }
    }

    public static Object ArrayPop(List v) {
        if (v instanceof FastArray) {
            return ((FastArray)v).pop();
        }
        try {
            return new StructBean(v).invoke("pop", new Object[0]);
        }
        catch (Throwable throwable) {
            throw new CfJspPage.MemberFunctionInvocationException(throwable, "pop");
        }
    }

    public static Object ArrayShift(List v) {
        if (v instanceof FastArray) {
            return ((FastArray)v).shift();
        }
        try {
            return new StructBean(v).invoke("shift", new Object[0]);
        }
        catch (Throwable throwable) {
            throw new CfJspPage.MemberFunctionInvocationException(throwable, "shift");
        }
    }

    public static List ArraySplice(List v, int index, int elementCountForRemoval, List replacements) {
        if (v instanceof FastArray) {
            return ((FastArray)v).splice(index, elementCountForRemoval, replacements);
        }
        try {
            Object[] args = new Object[]{index, elementCountForRemoval, replacements};
            return (List)new StructBean(v).invoke("splice", args);
        }
        catch (Throwable throwable) {
            throw new CfJspPage.MemberFunctionInvocationException(throwable, "splice");
        }
    }

    public static Object ArrayUnshift(List v, Object val) {
        if (v instanceof FastArray) {
            return ((FastArray)v).unshift(val);
        }
        try {
            return new StructBean(v).invoke("unshift", new Object[0]);
        }
        catch (Throwable throwable) {
            throw new CfJspPage.MemberFunctionInvocationException(throwable, "unshift");
        }
    }

    public static List ArrayInsertAt(List v, int pos, Object val) {
        int listSize = v.size();
        if (pos <= 0) {
            throw new InvalidArrayIndexException(pos, listSize);
        }
        int listDimension = ArrayUtil.dimensionOf(v);
        if (listDimension > 1) {
            if (!(val instanceof Array)) {
                throw new ArrayGenericMultiDimException();
            }
            Array valArray = (Array)val;
            if (valArray.getDimension() + 1 != listDimension) {
                throw new ArrayGenericMultiDimException();
            }
        }
        try {
            while (listSize++ < pos - 1) {
                v.add(null);
            }
            v.add(pos - 1, CfJspPage._arrayAssign(val));
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedFunctionException("ArrayInsertAt", v.getClass().getName());
        }
        return v;
    }

    public static boolean ArrayIsDefined(List v, int pos) {
        if (pos <= 0) {
            throw new InvalidArrayIndexException(pos, v.size());
        }
        if (pos > v.size()) {
            return false;
        }
        Object o = v.get(pos - 1);
        return null != o;
    }

    public static boolean ArrayIsEmpty(List v) {
        return v != null && v.size() == 0;
    }

    public static int ArrayLen(List array) {
        return array.size();
    }

    public static double ArrayMax(List v) {
        ArrayUtil.verifySingleDimension(v);
        double max = 0.0;
        int vsize = v.size();
        for (int i = 0; i < vsize; ++i) {
            try {
                if (i == 0) {
                    max = Cast._double(v.get(i));
                    continue;
                }
                double comp = Cast._double(v.get(i));
                if (!(comp > max)) continue;
                max = comp;
                continue;
            }
            catch (Exception e) {
                throw new ValueNotNumericException(i + 1);
            }
        }
        return max;
    }

    public static double ArrayMax(List v, int maxThreads) {
        double result = Double.MIN_VALUE;
        ArrayUtil.verifySingleDimension(v);
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            ArrayList<java.util.concurrent.Future> futures = new ArrayList<java.util.concurrent.Future>(maxThreads);
            ArrayUtil.splitAndSubmitTasks(v, executor, futures, 0, v.size() / maxThreads, "MAX", false);
            for (int index = 0; index < futures.size(); ++index) {
                java.util.concurrent.Future resFut = (java.util.concurrent.Future)futures.get(index);
                Object res = resFut.get();
                result = Math.max(Cast._double(res), result);
            }
        }
        catch (Exception e) {
            throw new RuntimeWrapper(e);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        return result;
    }

    public static double ArrayMin(List v) {
        ArrayUtil.verifySingleDimension(v);
        double min = 0.0;
        int vsize = v.size();
        for (int i = 0; i < vsize; ++i) {
            try {
                if (i == 0) {
                    min = Cast._double(v.get(i));
                    continue;
                }
                double comp = Cast._double(v.get(i));
                if (!(comp < min)) continue;
                min = comp;
                continue;
            }
            catch (Exception e) {
                throw new ValueNotNumericException(i + 1);
            }
        }
        return min;
    }

    public static double ArrayMin(List v, int maxThreads) {
        double result = Double.MAX_VALUE;
        ArrayUtil.verifySingleDimension(v);
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            ArrayList<java.util.concurrent.Future> futures = new ArrayList<java.util.concurrent.Future>(maxThreads);
            ArrayUtil.splitAndSubmitTasks(v, executor, futures, 0, v.size() / maxThreads, "MIN", false);
            for (int index = 0; index < futures.size(); ++index) {
                java.util.concurrent.Future resFut = (java.util.concurrent.Future)futures.get(index);
                Object res = resFut.get();
                result = Math.min(Cast._double(res), result);
            }
        }
        catch (Exception e) {
            throw new RuntimeWrapper(e);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        return result;
    }

    public static List ArrayPrepend(List v, Object val) {
        Array a;
        if (v instanceof Array && (a = (Array)v).getDimension() > 1) {
            if (!(val instanceof Array)) {
                throw new ArrayGenericMultiDimException();
            }
            if (((Array)val).getDimension() + 1 != a.getDimension()) {
                throw new ArrayGenericMultiDimException();
            }
        }
        try {
            v.add(0, CfJspPage._arrayAssign(val));
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedFunctionException("ArrayPrepend", v.getClass().getName());
        }
        return v;
    }

    public static List ArrayResize(List v, int size) {
        FastArray foo;
        if (size <= 0) {
            throw new ArrayResizeException();
        }
        if (v.size() >= size) {
            return v;
        }
        if (v instanceof ArgumentList) {
            foo = null;
        } else if (((FastArray)v).getDimension() == 1) {
            foo = null;
        } else {
            int newdim = ((FastArray)v).getDimension() - 1;
            foo = v instanceof Array ? new Array(newdim) : new FastArray(newdim);
        }
        try {
            for (int i = v.size(); i < size; ++i) {
                v.add(CfJspPage._arrayAssign(foo));
            }
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedFunctionException("ArrayResize", v.getClass().getName());
        }
        return v;
    }

    public static List ArraySet(List v, int s, int e, Object val) {
        if (s > e || s == 0) {
            throw new ArraySetRangeException(s, e);
        }
        int dimension = ArrayUtil.dimensionOf(v);
        if (dimension > 1) {
            if (!(val instanceof Array)) {
                throw new ArrayGenericMultiDimException();
            }
            if (((Array)val).getDimension() + 1 != dimension) {
                throw new ArrayGenericMultiDimException();
            }
        }
        try {
            if (v.size() < s) {
                for (int i = v.size(); i < s - 1; ++i) {
                    v.add(null);
                }
            }
            boolean isValArray = val instanceof Array;
            for (int i = s - 1; i < e; ++i) {
                Object obj;
                Object object = obj = isValArray ? ArrayUtil.copy((Array)val) : val;
                if (i < v.size()) {
                    v.set(i, obj);
                    continue;
                }
                v.add(obj);
            }
        }
        catch (UnsupportedOperationException exp) {
            throw new UnsupportedFunctionException("ArraySet", v.getClass().getName());
        }
        return v;
    }

    public static List ArraySort(List v, String sort_type, String sort_order) {
        return ArrayUtil.ArraySort(v, sort_type, sort_order, false);
    }

    public static List ArraySort(List v, String sort_type, String sort_order, boolean localeSensitive) {
        ArrayUtil.verifySingleDimension(v);
        if (sort_type.equalsIgnoreCase("text") || sort_type.length() == 0) {
            int vsize = v.size();
            for (int i = 0; i < vsize; ++i) {
                if (CFPage.IsSimpleValue(v.get(i))) continue;
                throw new ArraySortSimpleValueException(i + 1);
            }
            if (localeSensitive) {
                Collator collator = Collator.getInstance();
                collator.setStrength(3);
                collator.setDecomposition(1);
                Collections.sort(v, collator);
            } else {
                Collections.sort(v, new MyStringCompare());
            }
        } else if (sort_type.equalsIgnoreCase("numeric")) {
            int vsize = v.size();
            for (int i = 0; i < vsize; ++i) {
                if (CFPage.IsNumeric(v.get(i)) || CFPage.IsNumericDate(v.get(i))) continue;
                throw new ValueNotNumericException(i + 1);
            }
            Collections.sort(v, new NumberCompare());
        } else if (sort_type.equalsIgnoreCase("textnocase")) {
            int vsize = v.size();
            for (int i = 0; i < vsize; ++i) {
                if (CFPage.IsSimpleValue(v.get(i))) continue;
                throw new ArraySortSimpleValueException(i + 1);
            }
            if (localeSensitive) {
                Collator collator = Collator.getInstance();
                collator.setStrength(2);
                collator.setDecomposition(1);
                Collections.sort(v, collator);
            } else {
                Collections.sort(v, new MyStringCompare(false));
            }
        } else {
            throw new InvalidSortTypeException(sort_type);
        }
        if (sort_order.length() == 0) {
            sort_order = "asc";
        }
        if (!sort_order.equalsIgnoreCase("desc") && !sort_order.equalsIgnoreCase("asc")) {
            throw new InvalidSortOrderException(sort_order);
        }
        if (sort_order.equalsIgnoreCase("desc")) {
            Collections.reverse(v);
        }
        return v;
    }

    private static void useBuiltInComparator(List array, Object callback) {
        String comparator = ((CFPageMethod)callback).getName().toLowerCase();
        if (comparator.equals("comparenocase")) {
            Collections.sort(array, new Comparator<String>(){

                @Override
                public int compare(String string1, String string2) {
                    return StringFunc.compare(string1, string2, true);
                }
            });
        } else if (comparator.equals("compare")) {
            Collections.sort(array, new Comparator<String>(){

                @Override
                public int compare(String string1, String string2) {
                    return StringFunc.compare(string1, string2, false);
                }
            });
        } else if (comparator.equals("datecompare")) {
            Collections.sort(array, new Comparator<Date>(){

                @Override
                public int compare(Date date1, Date date2) {
                    if (date1 == null || date1 == null) {
                        throw new CFPage.InvalidDateException("DateCompare");
                    }
                    return DateUtils.compareDate(date1, date2);
                }
            });
        }
    }

    public static boolean ArraySort(List list, Object sortFunc) {
        ArrayUtil.verifySingleDimension(list);
        if (sortFunc instanceof UDFMethod) {
            Collections.sort(list, new FunctionBasedComparator((UDFMethod)sortFunc));
        } else if (sortFunc instanceof CFPageMethod) {
            ArrayUtil.useBuiltInComparator(list, sortFunc);
        }
        return true;
    }

    public static void ArrayEach(List list, UDFMethod closureFunc) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        Object[] args = new Object[3];
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            try {
                args[0] = item;
                args[1] = i + 1;
                args[2] = list;
                CFPage._invokeUDF((Object)closureFunc, closureFunc.getName(), cfpage, args);
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
    }

    public static boolean ArrayContains(List list, Object obj) {
        return ArrayUtil.find(list, obj) != 0;
    }

    public static boolean ArrayContainsNoCase(List list, Object obj) {
        return ArrayUtil.findNoCase(list, obj) != 0;
    }

    public static int find(List list, Object obj) {
        return ArrayUtil.find(list, obj, false);
    }

    public static int findNoCase(List list, Object obj) {
        return ArrayUtil.find(list, obj, true);
    }

    public static int find(List list, UDFMethod findClosure) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            try {
                int arrayIndex = i + 1;
                Object retVal = CFPage._invokeUDF((Object)findClosure, findClosure.getName(), cfpage, new Object[]{item, arrayIndex, list});
                if (retVal == null) {
                    throw new InvalidReturnTypeForArrayFindException();
                }
                if (!Cast._boolean(retVal)) continue;
                return i + 1;
            }
            catch (Cast.BooleanConversionException ex) {
                throw new InvalidReturnTypeForArrayFindException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new InvalidReturnTypeForArrayFindException();
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return 0;
    }

    public static boolean some(List list, UDFMethod someClosure) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            try {
                int arrayIndex = i + 1;
                Object retVal = CFPage._invokeUDF((Object)someClosure, someClosure.getName(), cfpage, new Object[]{item, arrayIndex, list});
                if (retVal == null) {
                    throw new InvalidReturnTypeForArraySomeException();
                }
                if (!Cast._boolean(retVal)) continue;
                return true;
            }
            catch (Cast.BooleanConversionException ex) {
                throw new InvalidReturnTypeForArraySomeException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new InvalidReturnTypeForArraySomeException();
            }
            catch (Throwable throwable) {
                if (throwable instanceof NeoException) {
                    throw (NeoException)throwable;
                }
                throw new RuntimeWrapper(throwable);
            }
        }
        return false;
    }

    public static boolean every(List list, UDFMethod everyClosure) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            try {
                int arrayIndex = i + 1;
                Object retVal = CFPage._invokeUDF((Object)everyClosure, everyClosure.getName(), cfpage, new Object[]{item, arrayIndex, list});
                if (retVal == null) {
                    throw new InvalidReturnTypeForArrayEveryException();
                }
                if (Cast._boolean(retVal)) continue;
                return false;
            }
            catch (Cast.BooleanConversionException ex) {
                throw new InvalidReturnTypeForArrayEveryException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new InvalidReturnTypeForArrayEveryException();
            }
            catch (Throwable throwable) {
                if (throwable instanceof NeoException) {
                    throw (NeoException)throwable;
                }
                throw new RuntimeWrapper(throwable);
            }
        }
        return true;
    }

    private static int find(List list, Object obj, boolean ignoreCase) {
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            if (item == null) continue;
            if (!(!ignoreCase || item instanceof String || item instanceof Number || item instanceof CFBoolean || item instanceof Boolean)) {
                throw new InvalidArgumentforArrayFindNoCase((Object)"Valid datatypes in array are String|Boolean|Number. ");
            }
            if (!Utils.cfobjectEquals(item, obj, ignoreCase)) continue;
            return i + 1;
        }
        return 0;
    }

    public static List findAll(List list, Object obj) {
        return ArrayUtil.findAll(list, obj, false);
    }

    public static List findAllNoCase(List list, Object obj) {
        return ArrayUtil.findAll(list, obj, true);
    }

    static List findAllNoCase(List list, Object obj, int maxThreads) {
        List arrayOfIndices = ArrayUtil.findAll(list, obj, maxThreads, "FINDALLNOCASE");
        return arrayOfIndices;
    }

    private static List findAll(List list, Object obj, boolean ignoreCase) {
        Array arrayOfIndices = new Array(1);
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            if (!Utils.cfobjectEquals(item, obj, ignoreCase)) continue;
            arrayOfIndices.add(i + 1);
        }
        return arrayOfIndices;
    }

    static List findAll(List list, Object obj, int maxThreads) {
        List arrayOfIndices = ArrayUtil.findAll(list, obj, maxThreads, "FINDALL");
        return arrayOfIndices;
    }

    private static List findAll(List list, Object obj, int maxThreads, String operation) {
        Array arrayOfIndices = new Array(1);
        ExecutorService executor = null;
        try {
            int subListEndIndex;
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            ArrayList<java.util.concurrent.Future> futures = new ArrayList<java.util.concurrent.Future>(maxThreads);
            int subListBeginIndex = 0;
            int sublistSize = list.size() / maxThreads;
            do {
                subListEndIndex = sublistSize == 0 ? list.size() : (subListBeginIndex + sublistSize <= list.size() ? subListBeginIndex + sublistSize : list.size());
                ListProcessingCallable callable = new ListProcessingCallable(list, subListBeginIndex, subListEndIndex, obj, operation);
                futures.add(ParallelCallUtil.submitMetricCalculatorTask(callable, executor));
                subListBeginIndex += sublistSize;
            } while (subListEndIndex < list.size());
            for (int index = 0; index < futures.size(); ++index) {
                java.util.concurrent.Future resFut = (java.util.concurrent.Future)futures.get(index);
                Object res = resFut.get();
                if (res == null) continue;
                arrayOfIndices.addAll((List)res);
            }
        }
        catch (Exception e) {
            throw new RuntimeWrapper(e);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        return arrayOfIndices;
    }

    public static List findAll(List list, UDFMethod findClosure) {
        Array arrayOfIndices = new Array(1);
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            try {
                Object retVal = CFPage._invokeUDF((Object)findClosure, findClosure.getName(), cfpage, new Object[]{item});
                if (retVal == null) {
                    throw new InvalidReturnTypeForArrayFindException();
                }
                if (!Cast._boolean(retVal)) continue;
                arrayOfIndices.add(i + 1);
                continue;
            }
            catch (Cast.BooleanConversionException ex) {
                throw new InvalidReturnTypeForArrayFindException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new InvalidReturnTypeForArrayFindException();
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return arrayOfIndices;
    }

    public static List findAll(List list, UDFMethod findClosure, int maxThreads) {
        Array arrayOfIndices = new Array(1);
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            List<Future> futures = ParallelCallUtil.submitParallelTaskForList(list, findClosure, true, executor);
            for (int index = 0; index < futures.size(); ++index) {
                try {
                    Future resFut = futures.get(index);
                    Object res = resFut.get();
                    if (res == null) {
                        throw new InvalidReturnTypeForArrayFindException();
                    }
                    ArrayUtil.printOutput(resFut.getUdfMethodRef().getOutput());
                    if (!Cast._boolean(res)) continue;
                    arrayOfIndices.add(index + 1);
                    continue;
                }
                catch (Cast.BooleanConversionException | Cast.BooleanStringConversionException ex) {
                    throw new InvalidReturnTypeForArrayFindException();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeWrapper(e.getCause());
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        return arrayOfIndices;
    }

    public static List ArrayFilter(List list, UDFMethod filterFunc) {
        FusionContext fusionContext = FusionContext.getCurrent();
        Array result_List = new Array(1);
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        boolean passArray = filterFunc.paramNames.length == 3;
        Object[] args = filterFunc.paramNames.length == 3 ? new Object[3] : new Object[2];
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            try {
                Object retVal;
                args[0] = item;
                args[1] = i + 1;
                if (passArray) {
                    args[2] = list;
                }
                if ((retVal = CFPage._invokeUDF((Object)filterFunc, filterFunc.getName(), cfpage, args)) == null) {
                    throw new InvalidReturnTypeForArrayFilterException();
                }
                if (!Cast._boolean(retVal)) continue;
                result_List.add(item);
                continue;
            }
            catch (Cast.BooleanConversionException ex) {
                throw new InvalidReturnTypeForArrayFilterException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new InvalidReturnTypeForArrayFilterException();
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return result_List;
    }

    public static List ArrayFilter(List list, UDFMethod filterFunc, int maxThreads) {
        Array resultList = new Array(1);
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            List<Future> futures = ParallelCallUtil.submitParallelTaskForList(list, filterFunc, filterFunc.paramNames.length == 3, executor);
            for (int index = 0; index < futures.size(); ++index) {
                Future resFut = futures.get(index);
                Object res = resFut.get();
                if (res == null) {
                    throw new InvalidReturnTypeForArrayFilterException();
                }
                try {
                    if (Cast._boolean(res)) {
                        resultList.add(list.get(index));
                    }
                }
                catch (Cast.BooleanConversionException | Cast.BooleanStringConversionException ex) {
                    throw new InvalidReturnTypeForArrayFilterException();
                }
                ArrayUtil.printOutput(resFut.getUdfMethodRef().getOutput());
            }
        }
        catch (Exception e) {
            throw new RuntimeWrapper(e);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        return resultList;
    }

    public static List ArrayDelete(List list, Object obj) {
        int index = ArrayUtil.find(list, obj);
        if (index != 0) {
            return ArrayUtil.ArrayDeleteAt(list, index);
        }
        throw new ArrayDeleteException(obj);
    }

    public static List ArrayDeleteNoCase(List list, Object obj) {
        int index = ArrayUtil.findNoCase(list, obj);
        if (index != 0) {
            return ArrayUtil.ArrayDeleteAt(list, index);
        }
        throw new ArrayDeleteException(obj);
    }

    private static Object CFPageMap(List list, CFPageMethod callback) {
        String mapMethod;
        List result = null;
        switch (mapMethod = callback.getName().toLowerCase()) {
            case "trim": {
                result = list.stream().map(e -> CFPage.Trim((String)e)).collect(Collectors.toList());
                break;
            }
            case "ltrim": {
                result = list.stream().map(e -> StringFunc.LTrim((String)e)).collect(Collectors.toList());
                break;
            }
            case "rtrim": {
                result = list.stream().map(e -> StringFunc.RTrim((String)e)).collect(Collectors.toList());
                break;
            }
            default: {
                throw new UnsupportedFunctionException(mapMethod, "Array");
            }
        }
        return result;
    }

    public static List ArrayMap(List list, Object callback) {
        if (callback instanceof CFPageMethod) {
            return (ArrayList)ArrayUtil.CFPageMap(list, (CFPageMethod)callback);
        }
        if (callback instanceof UDFMethod) {
            Array resultList = new Array(1, list.size());
            UDFMethod mapFunc = (UDFMethod)callback;
            FusionContext fusionContext = FusionContext.getCurrent();
            CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
            boolean passArray = mapFunc.paramNames.length == 3;
            Object[] args = mapFunc.paramNames.length == 3 ? new Object[3] : new Object[2];
            for (int i = 0; i < list.size(); ++i) {
                Object item = list.get(i);
                try {
                    args[0] = item;
                    args[1] = i + 1;
                    if (passArray) {
                        args[2] = list;
                    }
                    Object retVal = CFPage._invokeUDF((Object)mapFunc, mapFunc.getName(), cfpage, args);
                    resultList.add(retVal);
                    continue;
                }
                catch (Throwable throwable) {
                    throw new RuntimeWrapper(throwable);
                }
            }
            return resultList;
        }
        throw new UnsupportedFunctionException(callback.toString(), "Array");
    }

    public static List ArrayMap(List list, Object callback, int maxThreads) {
        Array resultList = new Array(1, list.size());
        if (callback instanceof CFPageMethod) {
            return (ArrayList)ArrayUtil.CFPageMap(list, (CFPageMethod)callback);
        }
        if (callback instanceof UDFMethod) {
            UDFMethod mapFunc = (UDFMethod)callback;
            boolean passArray = mapFunc.paramNames.length == 3;
            Object[] args = mapFunc.paramNames.length == 3 ? new Object[3] : new Object[2];
            ExecutorService executor = null;
            try {
                executor = ParallelCallUtil.createThreadPool(maxThreads);
                List<Future> futures = ParallelCallUtil.submitParallelTaskForList(list, mapFunc, mapFunc.paramNames.length == 3, executor);
                for (int index = 0; index < futures.size(); ++index) {
                    Future resFut = futures.get(index);
                    Object res = resFut.get();
                    ArrayUtil.printOutput(resFut.getUdfMethodRef().getOutput());
                    resultList.add(res);
                }
            }
            catch (Exception e) {
                throw new RuntimeWrapper(e);
            }
            finally {
                if (executor != null) {
                    executor.shutdown();
                }
            }
        }
        return resultList;
    }

    public static Object ArrayReduce(List list, UDFMethod reduceFunc, Object initialValue, boolean reverseOrder) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        Object result = initialValue;
        boolean passArray = reduceFunc.paramNames.length == 4;
        Object[] args = reduceFunc.paramNames.length == 4 ? new Object[4] : new Object[3];
        int begin = reverseOrder ? list.size() - 1 : 0;
        int end = reverseOrder ? -1 : list.size();
        int increment = reverseOrder ? -1 : 1;
        for (int i = begin; i != end; i += increment) {
            Object item = list.get(i);
            try {
                args[0] = result;
                args[1] = item;
                args[2] = i + 1;
                if (passArray) {
                    args[3] = list;
                }
                result = CFPage._invokeUDF((Object)reduceFunc, reduceFunc.getName(), cfpage, args);
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return result;
    }

    public static double ArraySum(List v, boolean ignoreEmpty) {
        double sum = 0.0;
        ArrayUtil.verifySingleDimension(v);
        int vsize = v.size();
        for (int i = 0; i < vsize; ++i) {
            try {
                if (ignoreEmpty && (v.get(i) == null || v.get(i) == "")) continue;
                sum += Cast._double(v.get(i));
                continue;
            }
            catch (Exception e) {
                throw new ValueNotNumericException(i + 1);
            }
        }
        return sum;
    }

    public static double ArraySum(List v) {
        return ArrayUtil.ArraySum(v, false);
    }

    public static List ArraySwap(List array, int position1, int position2) {
        --position2;
        if (--position1 >= array.size()) {
            throw new ArraySwapRangeException(position1 + 1, array.size());
        }
        if (position2 >= array.size()) {
            throw new ArraySwapRangeException(position2 + 1, array.size());
        }
        Object temp = array.get(position1);
        try {
            array.set(position1, array.get(position2));
            array.set(position2, temp);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedFunctionException("ArraySwap", array.getClass().getName());
        }
        return array;
    }

    public static String ArrayToList(List a, String delimiter) {
        ArrayUtil.verifySingleDimension(a);
        StringBuilder str = new StringBuilder();
        int asize = a.size();
        if (asize > 0) {
            str.append(Cast._String(a.get(0)));
        }
        for (int i = 1; i < asize; ++i) {
            str.append(delimiter);
            str.append(Cast._String(a.get(i)));
        }
        return str.toString();
    }

    public static String ArrayToList(Collection col, String delimiter) {
        StringBuilder str = new StringBuilder();
        Iterator iterator = col.iterator();
        if (iterator.hasNext()) {
            str.append(Cast._String(iterator.next()));
        }
        while (iterator.hasNext()) {
            str.append(delimiter);
            str.append(Cast._String(iterator.next()));
        }
        return str.toString();
    }

    public static void checkArrayAssignmentDimensionality(Object target, Object element) {
        int elementDimension;
        int targetDimension;
        if (target instanceof Array && (targetDimension = ArrayUtil.dimensionOf(target)) > 1 && (elementDimension = ArrayUtil.dimensionOf(element)) != targetDimension - 1) {
            if (elementDimension == 3) {
                throw new ArrayAssignmentDimensionException(element, elementDimension);
            }
            throw new ArrayAssignmentInvalidScalarException(element);
        }
    }

    public static int dimensionOf(Object x) {
        if (x instanceof Array) {
            return ((Array)x).getDimension();
        }
        if (x instanceof List) {
            return 1;
        }
        return 0;
    }

    public static Object ArrayFirst(List list) {
        if (list.size() > 0) {
            return list.get(0);
        }
        throw new RuntimeException("Array is empty.Cannot return first element of array.");
    }

    public static Object ArrayLast(List list) {
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        throw new RuntimeException("Array is empty.Cannot return last element of array.");
    }

    public static double ArraySum(List v, boolean ignoreEmpty, int maxThreads) {
        double sum = 0.0;
        BigDecimal result = new BigDecimal(sum);
        ArrayUtil.verifySingleDimension(v);
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            ArrayList<java.util.concurrent.Future> futures = new ArrayList<java.util.concurrent.Future>(maxThreads);
            ArrayUtil.splitAndSubmitTasks(v, executor, futures, 0, v.size() / maxThreads, "SUM", ignoreEmpty);
            for (int index = 0; index < futures.size(); ++index) {
                java.util.concurrent.Future resFut = (java.util.concurrent.Future)futures.get(index);
                Object res = resFut.get();
                result = result.add(new BigDecimal(Cast._double(res)));
            }
        }
        catch (Exception e) {
            throw new RuntimeWrapper(e);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        return result.doubleValue();
    }

    private static void splitAndSubmitTasks(List v, ExecutorService executor, List<java.util.concurrent.Future> futures, int subListBeginIndex, int sublistSize, String metric, boolean ignoreEmpty) {
        int subListEndIndex;
        do {
            subListEndIndex = sublistSize == 0 ? v.size() : (subListBeginIndex + sublistSize <= v.size() ? subListBeginIndex + sublistSize : v.size());
            NumericListMetricCallable callable = new NumericListMetricCallable(v, subListBeginIndex, subListEndIndex, metric, ignoreEmpty);
            futures.add(ParallelCallUtil.submitMetricCalculatorTask(callable, executor));
            subListBeginIndex += sublistSize;
        } while (subListEndIndex < v.size());
    }

    public static void each(List list, UDFMethod closureFunc, boolean isParallel, int maxThreads) {
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            List<Future> futures = ParallelCallUtil.submitParallelTaskForList(list, closureFunc, true, executor);
            for (int index = 0; index < futures.size(); ++index) {
                Future resFut = futures.get(index);
                Object res = resFut.get();
                ArrayUtil.printOutput(resFut.getUdfMethodRef().getOutput());
            }
        }
        catch (Exception e) {
            throw new RuntimeWrapper(e);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    public static boolean some(List list, UDFMethod closureFunc, boolean isParallel, int maxThreads) {
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            CallableCompletionService completionService = new CallableCompletionService(executor);
            ParallelCallUtil.submitCallablesForList(list, closureFunc, completionService);
            for (int index = 0; index < list.size(); ++index) {
                ColdfusionFuture resFut = (ColdfusionFuture)completionService.take();
                Object res = resFut.get();
                CallableResult result = (CallableResult)res;
                try {
                    if (result.getResult() == null) {
                        throw new InvalidReturnTypeForArraySomeException();
                    }
                    boolean resBoolVal = Cast._boolean(result.getResult());
                    ArrayUtil.printOutput(result.getOutput());
                    if (!resBoolVal) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Cast.BooleanConversionException | Cast.BooleanStringConversionException ex) {
                    throw new InvalidReturnTypeForArraySomeException();
                }
                catch (Throwable throwable) {
                    throw new RuntimeWrapper(throwable);
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeWrapper(e);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    public static boolean every(List list, UDFMethod closureFunc, boolean isParallelMode, int maxThreads) {
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            CallableCompletionService completionService = new CallableCompletionService(executor);
            ParallelCallUtil.submitCallablesForList(list, closureFunc, completionService);
            for (int index = 0; index < list.size(); ++index) {
                ColdfusionFuture resFut = (ColdfusionFuture)completionService.take();
                Object res = resFut.get();
                CallableResult result = (CallableResult)res;
                try {
                    if (res == null) {
                        throw new InvalidReturnTypeForArraySomeException();
                    }
                    boolean resBoolVal = Cast._boolean(result.getResult());
                    ArrayUtil.printOutput(result.getOutput());
                    if (resBoolVal) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (Cast.BooleanConversionException | Cast.BooleanStringConversionException ex) {
                    throw new InvalidReturnTypeForArraySomeException();
                }
                catch (Throwable throwable) {
                    throw new RuntimeWrapper(throwable);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeWrapper(e);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    private static void printOutput(Object printMe) throws IOException {
        if (printMe == null) {
            return;
        }
        JspWriter outWriter = FusionContext.getCurrent().pageContext.getOut();
        if (outWriter instanceof CFOutput) {
            ((CFOutput)outWriter).cfoutput(true);
        }
        outWriter.print(printMe);
        if (outWriter instanceof CFOutput) {
            ((CFOutput)outWriter).cfoutput(false);
        }
    }

    static class MyStringCompare
    implements Comparator {
        boolean CaseSensitive = false;

        public MyStringCompare() {
            this.CaseSensitive = true;
        }

        public MyStringCompare(boolean b) {
            this.CaseSensitive = b;
        }

        public int compare(Object a, Object b) {
            String sb;
            String sa;
            if (a instanceof Key && b instanceof Key) {
                if (((Key)a).equals((Key)b)) {
                    return 0;
                }
                sa = ((Key)a).getKeyString();
                sb = ((Key)b).getKeyString();
            } else {
                sa = Cast._String(a);
                sb = Cast._String(b);
            }
            if (!this.CaseSensitive) {
                return sa.compareToIgnoreCase(sb);
            }
            return sa.compareTo(sb);
        }
    }

    static class NumberCompare
    implements Comparator {
        NumberCompare() {
        }

        public int compare(Object a, Object b) {
            try {
                double db;
                double da;
                if (a instanceof Key && b instanceof Key) {
                    if (((Key)a).equals((Key)b)) {
                        return 0;
                    }
                    String aKeyStr = ((Key)a).getKeyString();
                    String bKeyStr = ((Key)b).getKeyString();
                    try {
                        da = Double.parseDouble(aKeyStr);
                    }
                    catch (NumberFormatException e) {
                        throw new KeyNotNumericException(aKeyStr);
                    }
                    try {
                        db = Double.parseDouble(bKeyStr);
                    }
                    catch (NumberFormatException e) {
                        throw new KeyNotNumericException(bKeyStr);
                    }
                }
                da = Cast._double(a);
                db = Cast._double(b);
                if (da < db) {
                    return -1;
                }
                if (da > db) {
                    return 1;
                }
                return 0;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public boolean equals(Object c) {
            return c instanceof NumberCompare;
        }
    }

    static class FunctionBasedComparator
    implements Comparator {
        private UDFMethod sortFunction;
        private CFPage cfpage;
        private String comparatorType;
        public static final String QUERY_COMP = "QUERY_COMPARATOR";
        public static final String STRUCT_COMP = "STRUCT_COMPARATOR";
        public static final String ARRAY_COMP = "ARRAY_COMPARATOR";

        FunctionBasedComparator(UDFMethod sortFunc) {
            this(sortFunc, ARRAY_COMP);
        }

        FunctionBasedComparator(UDFMethod sortFunc, String comparatorType) {
            this.sortFunction = sortFunc;
            FusionContext fusionContext = FusionContext.getCurrent();
            this.cfpage = (CFPage)fusionContext.pageContext.getPage();
            this.comparatorType = comparatorType;
        }

        public int compare(Object a, Object b) {
            try {
                Object retVal;
                if (a instanceof SortedStructMap.Entry && b instanceof SortedStructMap.Entry) {
                    Object k1 = ((SortedStructMap.Entry)a).getKey();
                    Object v1 = ((SortedStructMap.Entry)a).getValue();
                    Object k2 = ((SortedStructMap.Entry)b).getKey();
                    Object v2 = ((SortedStructMap.Entry)b).getValue();
                    if (k1 instanceof Key) {
                        k1 = ((Key)k1).getKeyString();
                    }
                    if (k2 instanceof Key) {
                        k2 = ((Key)k2).getKeyString();
                    }
                    retVal = CFPage._invokeUDF((Object)this.sortFunction, this.sortFunction.getName(), this.cfpage, new Object[]{v1, v2, k1, k2});
                } else {
                    if (a instanceof Key) {
                        a = ((Key)a).getKeyString();
                    }
                    if (b instanceof Key) {
                        b = ((Key)b).getKeyString();
                    }
                    retVal = CFPage._invokeUDF((Object)this.sortFunction, this.sortFunction.getName(), this.cfpage, new Object[]{a, b});
                }
                if (retVal == null) {
                    this.throwRelevantException();
                }
                int ret_integer = 0;
                try {
                    ret_integer = (int)Math.signum(Cast._double(retVal));
                }
                catch (Cast.NumberConversionException e) {
                    this.throwRelevantException();
                }
                return ret_integer;
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }

        @Override
        public boolean equals(Object c) {
            return c instanceof FunctionBasedComparator;
        }

        private void throwRelevantException() {
            if (this.comparatorType.equalsIgnoreCase(QUERY_COMP)) {
                throw new QueryFunction.InvalidReturnTypeForQuerySortException();
            }
            if (this.comparatorType.equalsIgnoreCase(STRUCT_COMP)) {
                throw new StructSorted.InvalidReturnTypeForSortedStructComparatorException();
            }
            throw new InvalidReturnTypeForArraySortException();
        }
    }

    public static class InvalidReturnTypeForArrayFindException
    extends ApplicationException {
    }

    public static class InvalidReturnTypeForArraySomeException
    extends ApplicationException {
    }

    public static class InvalidReturnTypeForArrayEveryException
    extends ApplicationException {
    }

    public static class InvalidArgumentforArrayFindNoCase
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public Object inputArray;

        public InvalidArgumentforArrayFindNoCase(Object inputArray) {
            this.inputArray = inputArray;
        }
    }

    public static class InvalidReturnTypeForArrayFilterException
    extends ApplicationException {
    }

    public static class ArrayAssignmentDimensionException
    extends ArrayAssignmentInvalidScalarException {
        public int elementDimension;

        public ArrayAssignmentDimensionException(Object element, int elementDimension) {
            super(element);
            this.elementDimension = elementDimension;
        }
    }

    public static class ArrayAssignmentInvalidScalarException
    extends ExpressionException {
        public String elementType;

        public ArrayAssignmentInvalidScalarException(Object element) {
            this.elementType = element.getClass().getName();
        }
    }

    public static class InvalidReturnTypeForArraySortException
    extends ApplicationException {
    }

    public static class InvalidArrayCountException
    extends ExpressionException {
        public int count;
        public int len;

        InvalidArrayCountException(int count, int len) {
            this.count = count;
            this.len = len;
        }
    }

    static class ReverseNumberCompare
    implements Comparator {
        ReverseNumberCompare() {
        }

        public int compare(Object a, Object b) {
            try {
                double db;
                double da;
                if (a instanceof Key && b instanceof Key) {
                    if (((Key)a).equals((Key)b)) {
                        return 0;
                    }
                    String aKeyStr = ((Key)a).getKeyString();
                    String bKeyStr = ((Key)b).getKeyString();
                    try {
                        da = Double.parseDouble(aKeyStr);
                    }
                    catch (NumberFormatException e) {
                        throw new KeyNotNumericException(aKeyStr);
                    }
                    try {
                        db = Double.parseDouble(bKeyStr);
                    }
                    catch (NumberFormatException e) {
                        throw new KeyNotNumericException(bKeyStr);
                    }
                }
                da = Cast._double(a);
                db = Cast._double(b);
                if (da < db) {
                    return 1;
                }
                if (da > db) {
                    return -1;
                }
                return 0;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public boolean equals(Object c) {
            return c instanceof NumberCompare;
        }
    }

    static class MyReverseStringCompare
    implements Comparator {
        boolean CaseSensitive = false;

        public MyReverseStringCompare() {
            this.CaseSensitive = true;
        }

        public MyReverseStringCompare(boolean b) {
            this.CaseSensitive = b;
        }

        public int compare(Object a, Object b) {
            String sb;
            String sa;
            if (a instanceof Key && b instanceof Key) {
                if (((Key)a).equals((Key)b)) {
                    return 0;
                }
                sa = ((Key)a).getKeyString();
                sb = ((Key)b).getKeyString();
            } else {
                sa = Cast._String(a);
                sb = Cast._String(b);
            }
            if (!this.CaseSensitive) {
                return sb.compareToIgnoreCase(sa);
            }
            return sb.compareTo(sa);
        }
    }
}

