/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.bootstrap.AppServerUtils;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.runtime.CookieHelper;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import jakarta.servlet.http.Cookie;
import java.lang.reflect.Method;

public class CFCookie
extends Cookie {
    private static final long serialVersionUID = 1L;
    public static final String HTTP_ONLY = "; HttpOnly";
    private static boolean httpOnlyAPIAvailable = false;
    private static boolean httponlySupportedServer = true;
    private String actualValue;
    private static Method m;
    private boolean httpOnly;
    private String samesite;

    public CFCookie(String name, String value) {
        super(name, value);
        this.actualValue = value;
        this.validateIfSessionCookie(name);
    }

    public CFCookie(String name, String value, String domain) {
        super(name, value);
        this.actualValue = value;
        boolean isAppAuthCookie = name.toUpperCase().startsWith("CFAUTHORIZATION");
        if (name.equalsIgnoreCase("CFID") || name.equalsIgnoreCase("CFTOKEN") || isAppAuthCookie || name.equalsIgnoreCase(CookieHelper.GlobalCookie)) {
            this.configureSessionCookiesProperties(domain, isAppAuthCookie);
        }
    }

    public CFCookie(String name, String value, boolean isHttpOnly, boolean secure, int maxage, String domain, String samesite) {
        super(name, value);
        this.actualValue = value;
        this.validateIfSessionCookie(name);
        this.configureGenericCookiesProperties(isHttpOnly, secure, maxage, domain, samesite);
    }

    private void validateIfSessionCookie(String name) {
        ApplicationSettings appSettings;
        boolean isAppAuthCookie = name.toUpperCase().startsWith("CFAUTHORIZATION");
        if ((name.equalsIgnoreCase("CFID") || name.equalsIgnoreCase("CFTOKEN") || isAppAuthCookie) && (appSettings = CFCookie.getApplicationSettingsObject()) != null) {
            if (isAppAuthCookie && appSettings.isAuthCookieUpdateDisabled()) {
                throw new InvalidCookieOperationException();
            }
            if (appSettings.isSessionCookieUpdateDisabled()) {
                throw new InvalidCookieOperationException();
            }
        }
    }

    public String getActualValue() {
        return this.actualValue;
    }

    public void setValue(String value) {
        this.actualValue = value;
        super.setValue(value);
    }

    public void setHttpOnly() {
        if (this.httpOnly) {
            if (httpOnlyAPIAvailable) {
                try {
                    m.invoke((Object)this, new Boolean(this.httpOnly));
                }
                catch (Exception e) {
                    this.actualValue = super.getValue();
                    super.setValue(super.getValue() + HTTP_ONLY);
                }
            } else {
                String superValue = super.getValue();
                if (httponlySupportedServer && superValue != null && !superValue.endsWith(HTTP_ONLY)) {
                    this.actualValue = superValue;
                    super.setValue(superValue + HTTP_ONLY);
                }
            }
        }
    }

    public boolean isHttpOnlySet() {
        return this.httpOnly;
    }

    private void configureGenericCookiesProperties(boolean isHttpOnly, boolean secure, int maxage, String domain, String samesite) {
        this.httpOnly = isHttpOnly;
        this.setHttpOnly();
        this.setSecure(secure);
        this.setMaxAge(maxage);
        if (domain != null && domain.length() > 0) {
            this.setDomain(domain);
        }
        this.samesite = samesite;
    }

    public String getSamesite() {
        return this.samesite;
    }

    public void setSamesite(String samesite) {
        this.samesite = samesite;
    }

    private void configureSessionCookiesProperties(String domain, boolean isAppAuthCookie) {
        String sessionDomain;
        boolean secure;
        int maxAge;
        ApplicationSettings appSettings = CFCookie.getApplicationSettingsObject();
        if (appSettings != null) {
            if (isAppAuthCookie) {
                maxAge = appSettings.getAuthCookieTimeout();
                this.samesite = appSettings.getAuthCookieSamesite();
            } else {
                maxAge = appSettings.getSessionCookieTimeout();
                this.samesite = appSettings.getSessionCookieSamesite();
            }
            this.httpOnly = appSettings.isHttpOnlySessionCookie();
            secure = appSettings.isSecureSessionCookie();
            sessionDomain = appSettings.getSessionCookieDomain();
        } else {
            RuntimeService runtimeService = ServiceFactory.getRuntimeService();
            maxAge = runtimeService.getSessionCookieTimeout();
            this.httpOnly = runtimeService.isHttpOnlySessionCookie();
            secure = runtimeService.isSecureSessionCookie();
            sessionDomain = runtimeService.getSessionCookieDomain();
            this.samesite = runtimeService.getSessionCookieSamesite();
        }
        if (sessionDomain != null && sessionDomain.length() > 0) {
            domain = sessionDomain;
        }
        this.setMaxAge(maxAge);
        this.setHttpOnly();
        this.setSecure(secure);
        if (domain != null && domain.length() > 0) {
            this.setDomain(domain);
        }
    }

    private static ApplicationSettings getApplicationSettingsObject() {
        ApplicationScope appScope;
        FusionContext context = FusionContext.getCurrent();
        if (context == null) {
            return null;
        }
        String appName = context.getApplicationName();
        if (appName != null && (appScope = ApplicationScopeTracker.getApplicationScope(appName)) != null) {
            ApplicationSettings appSettings = appScope.getApplicationSettings();
            return appSettings;
        }
        return null;
    }

    static {
        try {
            m = Cookie.class.getDeclaredMethod("setHttpOnly", Boolean.TYPE);
            httpOnlyAPIAvailable = true;
        }
        catch (NoSuchMethodException e) {
            httpOnlyAPIAvailable = false;
        }
        int appServerType = AppServerUtils.getAppServerType();
        if (appServerType == 5 || appServerType == 10) {
            httponlySupportedServer = false;
        }
    }

    public static class InvalidCookieOperationException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }
}

