/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.LockManager;
import coldfusion.runtime.LockStore;
import coldfusion.runtime.LockableScope;
import coldfusion.runtime.RWLock;
import coldfusion.util.Semaphore;
import jakarta.servlet.jsp.PageContext;
import java.util.HashMap;
import java.util.Map;

public final class CFLockStore
implements LockStore {
    private Map<String, RWLock> namedLocks = new HashMap<String, RWLock>();
    private RWLock serverLock = new RWLock();
    private Map<String, Semaphore> concurrentLocks = new HashMap<String, Semaphore>();

    CFLockStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestNamedLock(String key, boolean readonly, long timeout) throws InterruptedException {
        RWLock lock;
        key = key.toUpperCase();
        CFLockStore cFLockStore = this;
        synchronized (cFLockStore) {
            lock = this.namedLocks.get(key);
            if (lock == null) {
                lock = new RWLock();
                this.namedLocks.put(key, lock);
            }
            lock.setPending(true);
        }
        lock.requestLock(readonly, timeout);
        lock.setPending(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseNamedLock(String key, boolean readonly) {
        RWLock lock;
        key = key.toUpperCase();
        CFLockStore cFLockStore = this;
        synchronized (cFLockStore) {
            lock = this.namedLocks.get(key);
            if (lock == null) {
                throw new LockManager.UnknownLockException(key);
            }
            lock.setPending(true);
        }
        lock.releaseLock(readonly);
        lock.setPending(false);
        cFLockStore = this;
        synchronized (cFLockStore) {
            lock = this.namedLocks.get(key);
            if (lock != null && lock.referenceCount() == 0) {
                this.namedLocks.remove(key);
            }
        }
    }

    @Override
    public void requestScopedLock(String scopeName, PageContext page, boolean readonly, long timeout) throws InterruptedException {
        this.getScopedLock(scopeName, page).requestLock(readonly, timeout);
    }

    @Override
    public void releaseScopedLock(String scopeName, PageContext page, boolean readonly) {
        this.getScopedLock(scopeName, page).releaseLock(readonly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestConcurrentLock(String key, int count, long timeout) throws InterruptedException {
        Semaphore lock;
        key = key.toUpperCase();
        CFLockStore cFLockStore = this;
        synchronized (cFLockStore) {
            lock = this.concurrentLocks.get(key);
            if (lock == null) {
                lock = new Semaphore(count);
                this.concurrentLocks.put(key, lock);
            }
        }
        lock.acquire(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConcurrentLock(String key) {
        Semaphore lock;
        key = key.toUpperCase();
        CFLockStore cFLockStore = this;
        synchronized (cFLockStore) {
            lock = this.concurrentLocks.get(key);
            if (lock == null) {
                throw new LockManager.UnknownLockException(key);
            }
        }
        lock.release();
        cFLockStore = this;
        synchronized (cFLockStore) {
            lock = this.concurrentLocks.get(key);
            if (lock != null && lock.getCount() == lock.getMaxCount()) {
                this.concurrentLocks.remove(key);
            }
        }
    }

    private RWLock getScopedLock(String scopeName, PageContext page) {
        RWLock result;
        if (scopeName.equalsIgnoreCase("SERVER")) {
            result = this.serverLock;
        } else {
            FusionContext context = FusionContext.getCurrent();
            Object candidateScope = context.hiddenScope.get(scopeName.toUpperCase());
            if (candidateScope != null && candidateScope instanceof LockableScope) {
                result = (RWLock)((LockableScope)candidateScope).getLock();
            } else {
                if (scopeName.equalsIgnoreCase("APPLICATION") || scopeName.equalsIgnoreCase("SESSION")) {
                    throw new LockManager.InvalidScopeStateException(scopeName);
                }
                throw new LockManager.UnknownLockScopeException(scopeName);
            }
        }
        return result;
    }

    @Override
    public Object requestNewLock() {
        return new RWLock();
    }
}

