/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFIterable;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.StringCharacterIterator;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyIteratorUtil;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.UDFMethodIterator;
import coldfusion.sql.QueryTable;
import coldfusion.sql.imq.Row;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CFObjectIterable
implements CFIterable,
Iterator {
    private final Object obj;
    private Iterator itr;

    public CFObjectIterable(Object obj) {
        this.obj = obj;
    }

    @Override
    public Iterator iterator() {
        Iterator it = CFObjectIterable.getIterator(this.obj);
        if (it == null) {
            throw new NotAnIteratorException();
        }
        return it;
    }

    static Iterator getIterator(Object obj) {
        block10: {
            if (obj instanceof Iterable) {
                return ((Iterable)obj).iterator();
            }
            if (obj instanceof String) {
                return new StringCharacterIterator((String)obj);
            }
            if (obj instanceof TemplateProxy) {
                try {
                    Iterator iterator = TemplateProxyIteratorUtil.getIteratorForTemplateProxy((TemplateProxy)obj);
                    if (iterator != null) {
                        return iterator;
                    }
                    break block10;
                }
                catch (Throwable e) {
                    throw new NotAnIteratorException(e);
                }
            }
            if (obj instanceof UDFMethod) {
                return new UDFMethodIterator((UDFMethod)obj);
            }
            if (obj instanceof Iterator) {
                return (Iterator)obj;
            }
            if (obj instanceof QueryTable) {
                return new QueryTableIterator((QueryTable)obj);
            }
        }
        if (obj instanceof Map) {
            return ((Map)obj).entrySet().iterator();
        }
        return null;
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    @Override
    public boolean canGetSize() {
        return this.obj instanceof List || this.obj instanceof String || this.obj instanceof QueryTable || this.obj instanceof Map && !(this.obj instanceof TemplateProxy);
    }

    @Override
    public int size() {
        if (this.obj instanceof List) {
            return ((List)this.obj).size();
        }
        if (this.obj instanceof String) {
            return ((String)this.obj).length();
        }
        if (this.obj instanceof QueryTable) {
            return ((QueryTable)this.obj).getRowCount();
        }
        if (this.obj instanceof Map) {
            return ((Map)this.obj).size();
        }
        return -1;
    }

    public static CFObjectIterable getIterable(Object obj) {
        return new CFObjectIterable(obj);
    }

    @Override
    public boolean hasNext() {
        if (this.itr == null) {
            this.itr = this.iterator();
        }
        return this.itr.hasNext();
    }

    public Object next() {
        if (this.itr == null) {
            this.itr = this.iterator();
        }
        return this.itr.next();
    }

    public int skip(int steps) {
        int i;
        for (i = 0; i < steps - 1 && this.hasNext(); ++i) {
            this.next();
        }
        return i;
    }

    public List rest(int skips) {
        this.skip(skips);
        return this.rest();
    }

    public List rest() {
        if (!this.hasNext()) {
            return null;
        }
        Array restArray = new Array(1);
        do {
            restArray.add(this.next());
        } while (this.hasNext());
        return restArray;
    }

    public Object nextForDeref(boolean forStruct) {
        if (this.hasNext()) {
            return this.next();
        }
        return forStruct ? Collections.emptyMap() : Collections.emptyList();
    }

    public Object nextForDeref(boolean forStruct, Object defaultValue) {
        if (this.hasNext()) {
            return this.next();
        }
        return forStruct ? Cast._Map(defaultValue) : Cast._List(defaultValue);
    }

    public static class NotAnIteratorException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public NotAnIteratorException() {
        }

        public NotAnIteratorException(Throwable e) {
            super(e);
        }
    }

    public static class QueryTableIterator
    implements Iterator {
        private QueryTable q;
        private Iterator itr;

        public QueryTableIterator(QueryTable q) {
            this.q = q;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.getIterator().hasNext();
            if (!hasNext && this.itr != null) {
                this.itr = null;
                this.q.absolute(0);
            }
            return hasNext;
        }

        public Object next() {
            Object next = this.getIterator().next();
            if (next instanceof Row) {
                next = CfJspPage._queryRowDataToStruct(next, this.q.getColumnList(), this.q.getMetaData());
                this.q.relative(1);
            }
            return next;
        }

        private Iterator getIterator() {
            if (this.itr == null) {
                this.itr = this.q.getRowVector().iterator();
                this.q.absolute(0);
            }
            return this.itr;
        }
    }
}

