/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.compiler.validation.IllegalFuncArgumentException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFMethod;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.IllegalDateFormatException;
import coldfusion.util.DateUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class CFPageMethod
implements CFMethod {
    protected static HashMap<String, Map<Integer, Method>> CFMethods;
    private String methodName;

    public static CFPageMethod getInstance(String mName) {
        Map<Integer, Method> methodMap = CFMethods.get(mName = mName.toLowerCase());
        if (methodMap != null) {
            return new CFPageMethod(mName);
        }
        return null;
    }

    public static Map getMethodMap(String mName) {
        Map<Integer, Method> methodMap = CFMethods.get(mName = mName.toLowerCase());
        if (methodMap != null) {
            return methodMap;
        }
        return null;
    }

    private CFPageMethod(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public Object invoke(Object instance, String calledName, Object caller, Object[] args) throws Throwable {
        Map<Integer, Method> methodMap = CFMethods.get(this.methodName);
        Method method = methodMap.get(args.length);
        if (method == null) {
            int firstCorrectArgCount = (Integer)methodMap.keySet().toArray()[0];
            throw new MethodArgumentMismatchException(this.methodName, firstCorrectArgCount, args.length);
        }
        args = CFPageMethod.resolveArgs(method, args);
        try {
            return method.invoke(caller, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static Object[] resolveArgs(Method method, Object[] args) {
        Class<?>[] argClazz = method.getParameterTypes();
        for (int i = 0; i < argClazz.length; ++i) {
            Class<?> aClass = argClazz[i];
            String argType = aClass.getName();
            if (argType.equals("boolean")) {
                args[i] = Cast._boolean(args[i]);
                continue;
            }
            if (argType.equals("int")) {
                args[i] = Cast._int(args[i]);
                continue;
            }
            if (argType.equals("double")) {
                args[i] = Cast._double(args[i]);
                continue;
            }
            if (argType.equals("long")) {
                args[i] = Cast._long(args[i]);
                continue;
            }
            if (argType.equals("java.util.Date") && args[i] instanceof String) {
                try {
                    args[i] = DateUtils.parseDateTime((String)args[i]);
                    continue;
                }
                catch (IllegalDateFormatException e) {
                    throw new IllegalFuncArgumentException(method.getName(), args[i].toString(), i + 1, aClass);
                }
            }
            if (!argType.equals("java.lang.String")) continue;
            Object obj = args[i];
            if (obj instanceof Double) {
                int val = Cast._int(obj);
                args[i] = "" + val;
                continue;
            }
            args[i] = obj.toString();
        }
        return args;
    }

    static {
        Method[] cfMethods;
        CFMethods = new HashMap(700);
        for (Method cfMethod : cfMethods = CFPage.class.getMethods()) {
            Map<Integer, Method> overLoadedMethodMap = CFMethods.get(cfMethod.getName().toLowerCase());
            if (overLoadedMethodMap == null) {
                overLoadedMethodMap = new HashMap<Integer, Method>(3);
                CFMethods.put(cfMethod.getName().toLowerCase(), overLoadedMethodMap);
            }
            overLoadedMethodMap.put(cfMethod.getParameterTypes().length, cfMethod);
        }
    }

    public static class MethodArgumentMismatchException
    extends ApplicationException {
        public int actualArgCount;
        public int formalArgCount;
        public String methodName;

        MethodArgumentMismatchException(String methodName, int formalArgCount, int actualArgCount) {
            this.formalArgCount = formalArgCount;
            this.actualArgCount = actualArgCount;
            this.methodName = methodName;
        }
    }
}

