/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.server.ServiceFactory;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.IOException;
import java.io.OutputStream;

public class CachedBufferedOutputStream
extends ServletOutputStream {
    public static final int DEFAULT_MAX_BUFFER_SIZE = 1024;
    protected byte[] buf;
    private int maxBufferSize;
    private boolean autoFlushed = false;
    protected OutputStream out;
    protected int count;
    protected int flushedByteIndex = 0;

    public boolean isAutoFlushed() {
        return this.autoFlushed;
    }

    public CachedBufferedOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public CachedBufferedOutputStream(OutputStream out, int size) {
        this.out = out;
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
        this.maxBufferSize = ServiceFactory.getRuntimeService().getMaxOutputBufferSize() * 1024;
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0 && this.flushedByteIndex < this.count) {
            this.out.write(this.buf, this.flushedByteIndex, this.count - this.flushedByteIndex);
            this.flushedByteIndex = this.count;
        }
    }

    public synchronized void write(int b) throws IOException {
        int newcount = this.count + 1;
        if (this.autoFlushed) {
            this.out.write(b);
            return;
        }
        if (newcount > this.buf.length) {
            int max = Math.max(this.buf.length << 1, newcount);
            if ((max = Math.min(max, this.maxBufferSize)) < newcount) {
                this.autoFlushed = true;
                this.flushBuffer();
                this.out.write(b);
                return;
            }
            byte[] newbuf = new byte[max];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.autoFlushed) {
            this.writeThrough(b, off, len);
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            int max = Math.max(this.buf.length << 1, newcount);
            if ((max = Math.min(max, this.maxBufferSize)) < newcount) {
                this.autoFlushed = true;
                this.flushBuffer();
                this.writeThrough(b, off, len);
                return;
            }
            byte[] newbuf = new byte[max];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    public synchronized void writeThrough(byte[] b) throws IOException {
        if (b != null && b.length > 0) {
            this.out.write(b);
        }
    }

    public synchronized void writeThrough(byte[] b, int off, int len) throws IOException {
        if (b != null && b.length > 0) {
            this.out.write(b, off, len);
        }
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.close();
    }

    public synchronized byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public boolean isReady() {
        return false;
    }

    public void setWriteListener(WriteListener arg0) {
    }

    public void clear() {
        this.buf = new byte[0];
    }
}

