/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.osgi.services.PDFService;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.ArgumentList;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFDateTimeParser;
import coldfusion.runtime.CFDouble;
import coldfusion.runtime.CFInteger;
import coldfusion.runtime.CFLong;
import coldfusion.runtime.CFNumber;
import coldfusion.runtime.CFObjectIterable;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.ExceptionScope;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NonArrayException;
import coldfusion.runtime.OleDate;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.OleTime;
import coldfusion.runtime.PageScope;
import coldfusion.runtime.QueryVector;
import coldfusion.runtime.RequestScope;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.ScopeCastException;
import coldfusion.runtime.StructBean;
import coldfusion.runtime.java.ClassUtility;
import coldfusion.runtime.java.JavaProxy;
import coldfusion.runtime.locale.CFLocaleBase;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.io.FileStreamWrapper;
import coldfusion.util.CFDumpable;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.DateUtils;
import coldfusion.wddx.Base64Encoder;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.XmlNodeListWrapper;
import coldfusion.xml.XmlNodeMap;
import coldfusion.xml.XmlProcessor;
import com.allaire.cfx.Query;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.jsp.PageContext;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.sql.RowSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Cast {
    private static DecimalFormat expFormat;
    private static DecimalFormat decFormat;
    private static SimpleDateFormat jsDateFormat;
    public static ThreadLocal<Boolean> parseDateInThread;
    private static Method[] castMethods;
    private static Class[] castParamTypes;
    private static final Map primitiveTypeMap;

    private Cast() {
    }

    public static Object _cast(Object val, Class t) {
        if (val == null || t.isAssignableFrom(val.getClass())) {
            return val;
        }
        if (t == Integer.TYPE || t == Integer.class) {
            return new Integer(Cast._int(val));
        }
        if (t == Long.TYPE || t == Long.class) {
            return new Long(Cast._long(val));
        }
        if (t == Short.TYPE || t == Short.class) {
            return new Short(Cast._short(val));
        }
        if (t == Character.TYPE || t == Character.class) {
            return new Character(Cast._char(val));
        }
        if (t == Byte.TYPE || t == Byte.class) {
            return new Byte(Cast._byte(val));
        }
        if (t == Float.TYPE || t == Float.class) {
            return new Float(Cast._float(Cast._double(val)));
        }
        if (t == Double.TYPE || t == Double.class) {
            return Cast._Object(Cast._double(val));
        }
        if (t == BigInteger.class) {
            return Cast._BigInteger(val);
        }
        if (t == BigDecimal.class) {
            return Cast._BigDecimal(val);
        }
        if (t == Boolean.TYPE || t == Boolean.class) {
            return Cast._boolean(val) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (t == Number.class) {
            return Cast._Object(Cast._double(val));
        }
        if (t == String.class) {
            return Cast._String(val);
        }
        if (t.isAssignableFrom(Date.class)) {
            return Cast._Date(val);
        }
        if (t.isAssignableFrom(Calendar.class)) {
            return Cast._Calendar(val);
        }
        if (t.isAssignableFrom(Map.class)) {
            return Cast._Map(val);
        }
        if (t.isAssignableFrom(List.class)) {
            return Cast._List(val);
        }
        if (t.isAssignableFrom(Array.class)) {
            return Cast._Array(val);
        }
        if (t.isAssignableFrom(Query.class)) {
            return Cast._Query(val);
        }
        if (t.isAssignableFrom(Document.class)) {
            if (val instanceof XmlNodeList) {
                return ((XmlNodeList)val).getFirstNode();
            }
            if (val instanceof String) {
                XmlNodeList nl = XmlProcessor.parse((String)val, true);
                return nl.getFirstNode();
            }
        }
        if (t.isAssignableFrom(XmlNodeList.class)) {
            return Cast._Xml(val);
        }
        if (ServiceFactory.getImageService(false) != null && ServiceFactory.getImageService().isImageAssignable(t)) {
            return Cast._Image(val);
        }
        if (t.isAssignableFrom(FileStreamWrapper.class)) {
            return Cast._FileObject(val);
        }
        throw new ClassCastException(val.getClass().getName());
    }

    public static <T> T _castForInvokeGen(Object val, Class<T> t) {
        if (val == null || t.isAssignableFrom(val.getClass())) {
            return (T)val;
        }
        if (t.isAssignableFrom(Date.class)) {
            return (T)Cast._Date(val);
        }
        if (t.isAssignableFrom(Calendar.class)) {
            return (T)Cast._Calendar(val);
        }
        if (t.isAssignableFrom(Map.class)) {
            return (T)Cast._Map(val);
        }
        if (t.isAssignableFrom(List.class)) {
            return (T)Cast._List(val);
        }
        if (t.isAssignableFrom(Array.class)) {
            return (T)Cast._Array(val);
        }
        if (t.isAssignableFrom(Query.class)) {
            return (T)Cast._Query(val);
        }
        if (t.isAssignableFrom(Document.class)) {
            if (val instanceof XmlNodeList) {
                return (T)((XmlNodeList)val).getFirstNode();
            }
            if (val instanceof String) {
                XmlNodeList nl = XmlProcessor.parse((String)val, true);
                return (T)nl.getFirstNode();
            }
        }
        if (t.isAssignableFrom(XmlNodeList.class)) {
            return (T)Cast._Xml(val);
        }
        if (ServiceFactory.getImageService(false) != null && ServiceFactory.getImageService().isImageAssignable(t)) {
            return (T)Cast._Image(val);
        }
        if (t.isAssignableFrom(FileStreamWrapper.class)) {
            return (T)Cast._FileObject(val);
        }
        throw new ClassCastException(val.getClass().getName());
    }

    public static boolean _boolean(double x) {
        return x != 0.0;
    }

    public static boolean _boolean(long x) {
        return x != 0L;
    }

    public static boolean _boolean(String s) {
        if (s.length() != 0) {
            switch (s.charAt(0)) {
                case 'Y': 
                case 'y': {
                    if (!s.equalsIgnoreCase("yes")) break;
                    return true;
                }
                case 'N': 
                case 'n': {
                    if (!s.equalsIgnoreCase("no")) break;
                    return false;
                }
                case 'T': 
                case 't': {
                    if (!s.equalsIgnoreCase("true")) break;
                    return true;
                }
                case 'F': 
                case 'f': {
                    if (!s.equalsIgnoreCase("false")) break;
                    return false;
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    Double d = CFDouble.parseDouble((String)s, (boolean)false);
                    if (d == null) break;
                    return 0.0 != d;
                }
            }
        }
        throw new BooleanStringConversionException(s);
    }

    public static Boolean _boolean(String s, boolean throwError) {
        if (s.length() != 0) {
            switch (s.charAt(0)) {
                case 'Y': 
                case 'y': {
                    if (!s.equalsIgnoreCase("yes")) break;
                    return true;
                }
                case 'N': 
                case 'n': {
                    if (!s.equalsIgnoreCase("no")) break;
                    return false;
                }
                case 'T': 
                case 't': {
                    if (!s.equalsIgnoreCase("true")) break;
                    return true;
                }
                case 'F': 
                case 'f': {
                    if (!s.equalsIgnoreCase("false")) break;
                    return false;
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    Double d = CFDouble.parseDouble((String)s, (boolean)false);
                    if (d == null) break;
                    return 0.0 != d;
                }
            }
        }
        if (throwError) {
            throw new BooleanStringConversionException(s);
        }
        return null;
    }

    public static boolean _boolean(Object x) {
        if (x instanceof Number) {
            return ((Number)x).doubleValue() != 0.0;
        }
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        if (x instanceof CFBoolean) {
            return ((CFBoolean)x).value;
        }
        if (x instanceof String) {
            return Cast._boolean((String)x);
        }
        throw new BooleanConversionException(x.getClass());
    }

    public static boolean _boolean(CFBoolean x) {
        return x.value;
    }

    public static boolean _boolean(Object x, boolean defaultValue) {
        try {
            return Cast._boolean(x);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigInteger _BigInteger(byte[] x) {
        return new BigInteger(x);
    }

    public static BigInteger _BigInteger(Object x) {
        String str = x instanceof String ? (String)x : Cast._String(Cast._long(x));
        return new BigInteger(str);
    }

    public static BigDecimal _BigDecimal(BigInteger x) {
        return new BigDecimal(x);
    }

    public static BigDecimal _BigDecimal(Double x) {
        return new BigDecimal(x);
    }

    public static BigDecimal _BigDecimal(Object x) {
        return Cast._BigDecimal(x, true);
    }

    public static BigDecimal _BigDecimal(Object x, boolean parseDate) {
        BigDecimal decimal;
        try {
            decimal = new BigDecimal(x.toString());
        }
        catch (Throwable t) {
            decimal = new BigDecimal(Cast._double(x, parseDate));
        }
        return decimal;
    }

    public static byte _byte(double d) {
        if (d < -128.0 || d > 127.0) {
            throw new OutOfBoundsException("byte", d);
        }
        return (byte)d;
    }

    public static byte _byte(String str) {
        return Cast._byte(Cast._double(str, false));
    }

    public static byte _byte(Object obj) {
        if (obj instanceof Byte) {
            return (Byte)obj;
        }
        return Cast._byte(Cast._double(obj));
    }

    public static char _char(double d) {
        if (d < 0.0 || d > 65535.0) {
            throw new CharCastException(new Double(d));
        }
        return (char)d;
    }

    public static char _char(boolean b) {
        return b ? (char)'Y' : 'N';
    }

    public static char _char(CFBoolean b) {
        return b.value ? (char)'Y' : 'N';
    }

    public static char _char(Object obj) {
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        if (obj instanceof String) {
            return Cast._char((String)obj);
        }
        return Cast._char(Cast._double(obj));
    }

    public static char _char(String str) {
        if (str == null || str.length() == 0) {
            return ' ';
        }
        if (str.length() > 1) {
            throw new CharCastException((Object)str);
        }
        return str.charAt(0);
    }

    public static short _short(double d) {
        if (d < -32768.0 || d > 32767.0) {
            throw new OutOfBoundsException("short", d);
        }
        return (short)d;
    }

    public static short _short(long l) {
        if (l < -32768L || l > 32767L) {
            throw new OutOfBoundsException("short", l);
        }
        return (short)l;
    }

    public static int _int(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new OutOfBoundsException("integer", l);
        }
        return (int)l;
    }

    public static double _double(long l) {
        return l;
    }

    public static short _short(String s) {
        return Cast._short(Cast._double(s, false));
    }

    public static short _short(Object obj) {
        if (obj instanceof Short) {
            return (Short)obj;
        }
        return Cast._short(Cast._double(obj));
    }

    public static short _short(Object obj, boolean parseDate) {
        if (obj instanceof Short) {
            return (Short)obj;
        }
        return Cast._short(Cast._double(obj, parseDate));
    }

    public static int _int(double d) {
        if (d < -2.147483648E9 || d > 2.147483647E9) {
            throw new OutOfBoundsException("integer", d);
        }
        return (int)d;
    }

    public static int _int(boolean b) {
        return b ? 1 : 0;
    }

    public static int _int(CFBoolean b) {
        return b.value ? 1 : 0;
    }

    public static int _int(Object x, boolean parseDate) {
        if (x instanceof Integer) {
            return (Integer)x;
        }
        return Cast._int(Cast._double(x, parseDate));
    }

    public static int _int(Object x) {
        return Cast._int(x, true);
    }

    public static int _int(String s) {
        return Cast._int(Cast._double(s));
    }

    public static long _long(double d) {
        if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
            throw new OutOfBoundsException("long", d);
        }
        return (long)d;
    }

    public static long _long(boolean b) {
        return b ? 1L : 0L;
    }

    public static long _long(CFBoolean b) {
        return b.value ? 1L : 0L;
    }

    public static Long _Long(Date val) {
        return val.getTime();
    }

    public static long _long(Object x) {
        return Cast._long(x, true);
    }

    public static long _long(Object x, boolean parseDate) {
        if (x instanceof Number) {
            if (x instanceof Double) {
                return Cast._long((Double)x);
            }
            return ((Number)x).longValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1L : 0L;
        }
        if (x instanceof CFBoolean) {
            return ((CFBoolean)x).value ? 1L : 0L;
        }
        if (x instanceof Date) {
            return Cast._long(OleDate.days(((Date)x).getTime()));
        }
        if (x instanceof String) {
            return Cast._long((String)x, parseDate);
        }
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        throw new NumberConversionException(x.getClass().getName());
    }

    public static long _long(String s) {
        return Cast._long(s, true);
    }

    public static long _long(String s, boolean parseDate) {
        OleDateTime d;
        int len = (s = s.trim()).length();
        if (len == 0) {
            throw new NumberConversionException(s);
        }
        switch (s.charAt(0)) {
            case '+': 
            case '-': 
            case '.': {
                try {
                    return Long.parseLong(s);
                }
                catch (RuntimeException ex) {
                    return Cast._long(Cast._double(s, false));
                }
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (len == 1) {
                    return s.charAt(0) - 48;
                }
                try {
                    return Long.parseLong(s);
                }
                catch (RuntimeException ex) {
                    return Cast._long(Cast._double(s, parseDate));
                }
            }
            case 'Y': 
            case 'y': {
                if (s.equalsIgnoreCase("yes")) {
                    return 1L;
                }
                throw new NumberConversionException(s);
            }
            case 'T': 
            case 't': {
                if (s.equalsIgnoreCase("true")) {
                    return 1L;
                }
                throw new NumberConversionException(s);
            }
            case 'N': 
            case 'n': {
                if (!s.equalsIgnoreCase("no")) break;
                return 0L;
            }
            case 'F': 
            case 'f': {
                if (!s.equalsIgnoreCase("false")) break;
                return 0L;
            }
            case 'A': 
            case 'D': 
            case 'J': 
            case 'M': 
            case 'O': 
            case 'S': 
            case 'a': 
            case 'd': 
            case 'j': 
            case 'm': 
            case 'o': 
            case 's': 
            case '{': {
                break;
            }
            default: {
                throw new NumberConversionException(s);
            }
        }
        if ((d = CFDateTimeParser.parseDateTime(s)) != null) {
            return Cast._long(OleDate.days(d.getTime()));
        }
        throw new NumberConversionException(s);
    }

    public static float _float(Object obj) {
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        return Cast._float(Cast._double(obj));
    }

    public static float _float(Object obj, boolean parseDate) {
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        return Cast._float(Cast._double(obj, parseDate));
    }

    public static float _float(double d) {
        if (d < -3.4028234663852886E38 || d > 3.4028234663852886E38) {
            throw new OutOfBoundsException("float", d);
        }
        return (float)d;
    }

    public static double _double(String s) {
        return Cast._double(s, true);
    }

    public static double _double(String s, boolean parseDate) {
        return Cast._double(s, parseDate, true);
    }

    public static double _double(String s, boolean parseDate, boolean parseBoolean) {
        int len = (s = s.trim()).length();
        if (len == 0) {
            throw new NumberConversionException(s);
        }
        switch (s.charAt(0)) {
            case '+': 
            case '-': 
            case '.': {
                try {
                    double d = CFDouble.parseDouble((String)s);
                    if (Double.isInfinite(d)) {
                        throw new NumberConversionException(s);
                    }
                    return d;
                }
                catch (RuntimeException ex) {
                    throw new NumberConversionException(s);
                }
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (len == 1) {
                    return s.charAt(0) - 48;
                }
                try {
                    double d = CFDouble.parseDouble((String)s);
                    if (Double.isInfinite(d)) {
                        throw new NumberConversionException(s);
                    }
                    return d;
                }
                catch (RuntimeException ex) {
                    break;
                }
            }
            case 'Y': 
            case 'y': {
                if (!parseBoolean) break;
                if (s.equalsIgnoreCase("yes")) {
                    return 1.0;
                }
                throw new NumberConversionException(s);
            }
            case 'T': 
            case 't': {
                if (!parseBoolean) break;
                if (s.equalsIgnoreCase("true")) {
                    return 1.0;
                }
                throw new NumberConversionException(s);
            }
            case 'N': 
            case 'n': {
                if (!parseBoolean || !s.equalsIgnoreCase("no")) break;
                return 0.0;
            }
            case 'F': 
            case 'f': {
                if (!parseBoolean || !s.equalsIgnoreCase("false")) break;
                return 0.0;
            }
            case 'A': 
            case 'D': 
            case 'J': 
            case 'M': 
            case 'O': 
            case 'S': 
            case 'a': 
            case 'd': 
            case 'j': 
            case 'm': 
            case 'o': 
            case 's': 
            case '{': {
                break;
            }
            default: {
                throw new NumberConversionException(s);
            }
        }
        if (!parseDate || !parseDateInThread.get().booleanValue()) {
            throw new NumberConversionException(s);
        }
        OleDateTime d = CFDateTimeParser.parseDateTime(s);
        if (d != null) {
            return OleDate.days(d.getTime());
        }
        throw new NumberConversionException(s);
    }

    public static Double _double(String s, boolean parseDate, boolean parseBoolean, boolean throwError) {
        int len = (s = s.trim()).length();
        if (len == 0) {
            if (throwError) {
                throw new NumberConversionException(s);
            }
            return null;
        }
        switch (s.charAt(0)) {
            case '+': 
            case '-': 
            case '.': {
                Double d = CFDouble.parseDouble((String)s, (boolean)false);
                if (d != null && !d.isInfinite()) {
                    return d;
                }
                if (throwError) {
                    throw new NumberConversionException(s);
                }
                return null;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (len == 1) {
                    return s.charAt(0) - 48;
                }
                Double d1 = CFDouble.parseDouble((String)s, (boolean)false);
                if (d1 == null) break;
                if (d1.isInfinite()) {
                    if (throwError) {
                        throw new NumberConversionException(s);
                    }
                    return null;
                }
                return d1;
            }
            case 'Y': 
            case 'y': {
                if (!parseBoolean) break;
                if (s.equalsIgnoreCase("yes")) {
                    return 1.0;
                }
                if (throwError) {
                    throw new NumberConversionException(s);
                }
                return null;
            }
            case 'T': 
            case 't': {
                if (!parseBoolean) break;
                if (s.equalsIgnoreCase("true")) {
                    return 1.0;
                }
                if (throwError) {
                    throw new NumberConversionException(s);
                }
                return null;
            }
            case 'N': 
            case 'n': {
                if (!parseBoolean || !s.equalsIgnoreCase("no")) break;
                return 0.0;
            }
            case 'F': 
            case 'f': {
                if (!parseBoolean || !s.equalsIgnoreCase("false")) break;
                return 0.0;
            }
            case 'A': 
            case 'D': 
            case 'J': 
            case 'M': 
            case 'O': 
            case 'S': 
            case 'a': 
            case 'd': 
            case 'j': 
            case 'm': 
            case 'o': 
            case 's': 
            case '{': {
                break;
            }
            default: {
                if (throwError) {
                    throw new NumberConversionException(s);
                }
                return null;
            }
        }
        if (!parseDate || !parseDateInThread.get().booleanValue()) {
            if (throwError) {
                throw new NumberConversionException(s);
            }
            return null;
        }
        OleDateTime d = CFDateTimeParser.parseDateTime(s);
        if (d != null) {
            return OleDate.days(d.getTime());
        }
        if (throwError) {
            throw new NumberConversionException(s);
        }
        return null;
    }

    public static double _double(Object x) {
        return Cast._double(x, true);
    }

    public static double _double(Object x, boolean parseDate) {
        if (x instanceof Number) {
            return ((Number)x).doubleValue();
        }
        if (x instanceof String) {
            return Cast._double((String)x, parseDate);
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1.0 : 0.0;
        }
        if (x instanceof CFBoolean) {
            return ((CFBoolean)x).value ? 1.0 : 0.0;
        }
        if (x instanceof Date) {
            return OleDate.days(((Date)x).getTime());
        }
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        throw new NumberConversionException(x.getClass().getName());
    }

    public static Double _double(Object x, boolean parseDate, boolean throwError) {
        if (x instanceof Number) {
            return ((Number)x).doubleValue();
        }
        if (x instanceof String) {
            return Cast._double((String)x, parseDate, true, throwError);
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1.0 : 0.0;
        }
        if (x instanceof CFBoolean) {
            return ((CFBoolean)x).value ? 1.0 : 0.0;
        }
        if (x instanceof Date) {
            return OleDate.days(((Date)x).getTime());
        }
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        if (throwError) {
            throw new NumberConversionException(x.getClass().getName());
        }
        return null;
    }

    public static double _double(boolean b) {
        return b ? 1.0 : 0.0;
    }

    public static double _double(CFBoolean b) {
        return b.value ? 1.0 : 0.0;
    }

    public static Object _Object(int x) {
        return x;
    }

    public static Object _Object(double x) {
        return x;
    }

    public static Object _Object(boolean x) {
        return x ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object _Object(CFBoolean x) {
        return x.value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object _Object(CFNumber obj) {
        if (obj instanceof CFInteger) {
            return ((CFInteger)obj).intValue();
        }
        if (obj instanceof CFDouble) {
            return ((CFDouble)obj).doubleValue();
        }
        if (obj instanceof CFLong) {
            return ((CFDouble)obj).longValue();
        }
        return obj;
    }

    public static String _String(int x) {
        return String.valueOf(x);
    }

    public static String _String(long x) {
        return String.valueOf(x);
    }

    public static String _String(float x) {
        return String.valueOf(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _String(double x) {
        double a;
        long ix = (long)x;
        if ((double)ix == x && x > -1.0E12 && x < 1.0E12) {
            return String.valueOf(ix);
        }
        if (Double.isInfinite(x)) {
            return x < 0.0 ? "-1.#INF" : "1.#INF";
        }
        double d = a = x < 0.0 ? 0.0 - x : x;
        if (a >= 1.0E-4 && a < 1.0E12) {
            int pow = (int)Math.floor(0.4342944819032518 * Math.log(a));
            DecimalFormat decimalFormat = decFormat;
            synchronized (decimalFormat) {
                decFormat.setMaximumFractionDigits(11 - pow);
                return decFormat.format(x);
            }
        }
        StringBuffer b = new StringBuffer(20);
        DecimalFormat decimalFormat = expFormat;
        synchronized (decimalFormat) {
            b = expFormat.format(x, b, new FieldPosition(0));
        }
        if (a > 1.0) {
            b.insert(b.length() - 3, '+');
        }
        return b.toString();
    }

    public static String _String(boolean x) {
        return x ? "YES" : "NO";
    }

    public static String _String(CFBoolean x) {
        return x.image;
    }

    public static String _String(Object x) {
        return Cast._String(x, true);
    }

    public static String _String(Object x, boolean throwError) {
        if (x == null) {
            if (!FusionContext.isPreserveNullValues()) {
                return "";
            }
            return null;
        }
        if (x instanceof String) {
            return (String)x;
        }
        if (!RuntimeServiceImpl.getDefaultLongIntegerFormat() && x instanceof Long) {
            return x.toString();
        }
        if (x instanceof Float || x instanceof CFNumber || x instanceof BigDecimal) {
            return x.toString();
        }
        if (x instanceof Number) {
            return Cast._String(((Number)x).doubleValue());
        }
        if (x instanceof Boolean) {
            return Cast._String((Boolean)x);
        }
        if (x instanceof CFBoolean) {
            return ((CFBoolean)x).image;
        }
        if (x instanceof Timestamp) {
            return x.toString();
        }
        if (x instanceof OleDate) {
            return x.toString();
        }
        if (x instanceof OleTime) {
            return x.toString();
        }
        if (x instanceof OleDateTime) {
            return x.toString();
        }
        if (x instanceof Time) {
            return x.toString();
        }
        if (x instanceof java.sql.Date) {
            return x.toString();
        }
        if (x instanceof Date) {
            return new OleDateTime((Date)x).toString();
        }
        if (x instanceof Calendar) {
            return new OleDateTime(((Calendar)x).getTime()).toString();
        }
        if (x instanceof byte[]) {
            if (throwError) {
                throw new ComplexByteArrayException();
            }
            return null;
        }
        if (x instanceof Map || x instanceof Query || x instanceof RowSet || x instanceof Array || x instanceof List || x instanceof JavaProxy || x instanceof FileStreamWrapper) {
            if (throwError) {
                throw new CfJspPage.ComplexObjectException();
            }
            return null;
        }
        return x.toString();
    }

    public static Date _Date(String s) {
        return Cast._Date(s, true);
    }

    public static Date _Date(String s, boolean throwError) {
        OleDateTime d;
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        switch (s.charAt(0)) {
            case '+': 
            case '-': 
            case '.': {
                try {
                    return new OleDateTime(CFDouble.parseDouble((String)s));
                }
                catch (RuntimeException ex) {
                    if (throwError) {
                        throw new DateStringConversionException(s);
                    }
                    return null;
                }
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                Double number = CFDouble.parseDouble((String)s, (boolean)false);
                if (number == null) break;
                return new OleDateTime(number);
            }
            case 'F': 
            case 'f': {
                if (!s.equalsIgnoreCase("false")) break;
                if (throwError) {
                    throw new DateStringConversionException(s);
                }
                return null;
            }
            case 'N': 
            case 'n': {
                if (!s.equalsIgnoreCase("no")) break;
                if (throwError) {
                    throw new DateStringConversionException(s);
                }
                return null;
            }
            case 'A': 
            case 'D': 
            case 'J': 
            case 'M': 
            case 'O': 
            case 'S': 
            case 'T': 
            case 'W': 
            case 'a': 
            case 'd': 
            case 'j': 
            case 'm': 
            case 'o': 
            case 's': 
            case 't': 
            case 'w': 
            case '{': {
                break;
            }
            default: {
                if (throwError) {
                    throw new DateStringConversionException(s);
                }
                return null;
            }
        }
        if ((d = CFDateTimeParser.parseDateTime(s)) == null) {
            if (!DateUtils.IS_ENGLISH_DEFAULT_LOCALE) {
                try {
                    d = CFPage.internal_LSParseDateTime(s, Locale.getDefault());
                }
                catch (CFLocaleBase.InvalidDateTimeException e) {
                    if (throwError) {
                        throw e;
                    }
                    return null;
                }
                catch (Exception e) {
                    if (throwError) {
                        throw new DateStringConversionException(s);
                    }
                    return null;
                }
            } else if (throwError) {
                throw new CFLocaleBase.InvalidDateTimeException(s);
            }
            if (d == null && throwError) {
                throw new DateStringConversionException(s);
            }
        }
        return d;
    }

    public static Date _Date(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Date) {
            return (Date)x;
        }
        if (x instanceof Calendar) {
            return ((Calendar)x).getTime();
        }
        if (x instanceof Number) {
            return Cast._Date(((Number)x).doubleValue());
        }
        if (x instanceof String) {
            return Cast._Date((String)x);
        }
        if (x instanceof Instant) {
            return Date.from((Instant)x);
        }
        throw new DateConversionException(x.getClass());
    }

    public static Date _Date(double x) {
        return new Date(new OleDateTime(x).getTime());
    }

    public static Date _Date(boolean b) {
        throw new DateConversionException(b);
    }

    public static Date _Date(CFBoolean b) {
        throw new DateConversionException(b.value);
    }

    public static Object _Calendar(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Date) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)x);
            return c;
        }
        if (x instanceof Calendar) {
            return (Calendar)x;
        }
        if (x instanceof Number) {
            Calendar c = Calendar.getInstance();
            c.setTime(Cast._Date(((Number)x).doubleValue()));
            return c;
        }
        if (x instanceof String) {
            Calendar c = Calendar.getInstance();
            c.setTime(Cast._Date((String)x));
            return c;
        }
        throw new DateConversionException(x.getClass());
    }

    public static Map _Map(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Map) {
            return (Map)x;
        }
        if (x instanceof Throwable) {
            return new ExceptionScope((Throwable)x);
        }
        if (x instanceof PageContext) {
            return new PageScope((PageContext)x);
        }
        if (x instanceof ServletRequest) {
            return new RequestScope();
        }
        if (x instanceof QueryTable) {
            return new QueryVector("", (QueryTable)x);
        }
        if (x instanceof CfJspPage) {
            return Cast._Map(((CfJspPage)x).pageContext);
        }
        if (x instanceof XmlNodeList) {
            return new XmlNodeMap((XmlNodeList)x);
        }
        if (x instanceof CFDumpable) {
            return (Map)((CFDumpable)x).getMetadata();
        }
        if (CfJspPage.isNotMap(x)) {
            throw new ScopeCastException(x);
        }
        return new StructBean(x);
    }

    public static Map _Map(Throwable ex) {
        return new ExceptionScope(ex);
    }

    public static FastArray _Array(Object x) {
        if (x instanceof FastArray) {
            return (FastArray)x;
        }
        if (x instanceof List) {
            List src = (List)x;
            Array result = new Array();
            int srcSize = src.size();
            for (int i = 0; i < srcSize; ++i) {
                result.addElement(src.get(i));
            }
            return result;
        }
        throw new ArrayConversionException(x.getClass());
    }

    public static List _List(final Object x) {
        if (x instanceof List) {
            return (List)x;
        }
        if (x instanceof Object[]) {
            final Object[] array = (Object[])x;
            return new AbstractList(){

                @Override
                public Object get(int i) {
                    return array[i];
                }

                @Override
                public int size() {
                    return array.length;
                }
            };
        }
        if (x instanceof int[] || x instanceof boolean[] || x instanceof double[] || x instanceof char[] || x instanceof byte[] || x instanceof short[] || x instanceof long[] || x instanceof float[]) {
            return new AbstractList(){

                @Override
                public Object get(int i) {
                    return java.lang.reflect.Array.get(x, i);
                }

                @Override
                public int size() {
                    return java.lang.reflect.Array.getLength(x);
                }
            };
        }
        if (x instanceof XmlNodeList) {
            return new XmlNodeListWrapper((XmlNodeList)x);
        }
        if (x instanceof ArgumentCollection) {
            return new ArgumentList((ArgumentCollection)x);
        }
        if (x instanceof CFObjectIterable) {
            ArrayList<Object> iterList = new ArrayList<Object>();
            CFObjectIterable cfObjectIterableClone = new CFObjectIterable(x);
            while (cfObjectIterableClone.hasNext()) {
                iterList.add(cfObjectIterableClone.next());
            }
            return iterList;
        }
        throw new NonArrayException(x.getClass());
    }

    public static Query _Query(Object x) {
        if (x instanceof Query) {
            return (Query)x;
        }
        throw new QueryCastException(x);
    }

    public static Object _Image(Object x) {
        if (ServiceFactory.getImageService(false) != null && ServiceFactory.getImageService().isImage(x)) {
            return ServiceFactory.getImageService().castImage(x);
        }
        throw new ImageCastException(x);
    }

    public static XmlNodeList _Xml(Object x) {
        if (x instanceof XmlNodeList) {
            return (XmlNodeList)x;
        }
        if (x instanceof String) {
            return XmlProcessor.parse((String)x, false);
        }
        if (x instanceof Document) {
            return new XmlNodeList((Document)x, false);
        }
        if (x instanceof Element) {
            return new XmlNodeList((Element)x, false);
        }
        throw new XmlCastException(x);
    }

    public static FileStreamWrapper _FileObject(Object x) {
        if (x instanceof FileStreamWrapper) {
            return (FileStreamWrapper)x;
        }
        throw new FileObjectCastException(x);
    }

    public static Method findCastMethod(Class to, Class from) {
        Method[] m = castMethods;
        Method candidate = null;
        Class<?> candidateTo = null;
        Class candidateFrom = null;
        for (int i = 0; i < m.length; ++i) {
            if (m[i] == null) continue;
            Class<?> returnType = m[i].getReturnType();
            Class paramType = castParamTypes[i];
            if (!Cast.assignable(to, returnType) || !Cast.assignable(paramType, from) || candidate != null && (!Cast.assignable(returnType, candidateTo) || !Cast.assignable(candidateFrom, paramType))) continue;
            candidate = m[i];
            candidateTo = returnType;
            candidateFrom = paramType;
        }
        return candidate;
    }

    public static boolean assignable(Class to, Class from) {
        if (to.isAssignableFrom(from)) {
            return true;
        }
        if (to == Double.TYPE && (from == Float.TYPE || from == Integer.TYPE || from == Short.TYPE || from == Byte.TYPE)) {
            return true;
        }
        if (to == Float.TYPE && (from == Short.TYPE || from == Byte.TYPE)) {
            return true;
        }
        if (to == Long.TYPE && (from == Integer.TYPE || from == Short.TYPE || from == Byte.TYPE)) {
            return true;
        }
        if (to == Integer.TYPE && (from == Short.TYPE || from == Byte.TYPE)) {
            return true;
        }
        return to == Short.TYPE && from == Byte.TYPE;
    }

    public static byte[] _Binary(Object x) {
        return Cast._Binary(x, null);
    }

    public static byte[] _Binary(Object binObj, String charset) {
        byte[] attachBin = null;
        PDFService pdfService = ServiceFactory.getPDFService(false);
        if (pdfService != null && pdfService.isPDFCoreObject(binObj)) {
            try {
                attachBin = pdfService.getSourceAsByte(binObj);
            }
            catch (Exception ex) {
                attachBin = null;
            }
        } else if (binObj instanceof byte[]) {
            attachBin = (byte[])binObj;
        } else if (ServiceFactory.getImageService(false) != null && ServiceFactory.getImageService().isImage(binObj)) {
            try {
                String srcFormat = ServiceFactory.getImageService().getSrcFormat(binObj);
                if (srcFormat == null) {
                    srcFormat = "jpeg";
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)ServiceFactory.getImageService().getBufferedImage(binObj), srcFormat, baos);
                attachBin = baos.toByteArray();
            }
            catch (Exception ex) {
                attachBin = null;
            }
        } else if (binObj instanceof String) {
            if (charset == null) {
                return ((String)binObj).getBytes();
            }
            try {
                return ((String)binObj).getBytes(charset);
            }
            catch (Exception ex) {
                attachBin = ((String)binObj).getBytes();
            }
        } else if (binObj instanceof Number) {
            try {
                attachBin = ((Number)binObj).toString().getBytes(charset);
            }
            catch (Exception ex) {
                attachBin = ((Number)binObj).toString().getBytes();
            }
        } else if (binObj instanceof char[]) {
            char[] cArray = (char[])binObj;
            attachBin = new byte[cArray.length];
            for (int i = 0; i < attachBin.length; ++i) {
                attachBin[i] = (byte)cArray[i];
            }
        } else if (binObj instanceof CFBoolean) {
            try {
                attachBin = ((CFBoolean)binObj).image.getBytes(charset);
            }
            catch (Exception ex) {
                attachBin = ((CFBoolean)binObj).image.getBytes();
            }
        } else {
            throw new CfJspPage.BinaryConversionException(binObj.getClass());
        }
        return attachBin;
    }

    public static byte[] ToBinary(Object data) {
        if (data instanceof byte[]) {
            return (byte[])data;
        }
        PDFService pdfService = ServiceFactory.getPDFService();
        if (pdfService != null && pdfService.isPDFObject(data)) {
            return pdfService.deepCopyByte(data);
        }
        if (ServiceFactory.getExcelService(false) != null && ServiceFactory.getExcelService().isExcelObject(data)) {
            return ServiceFactory.getExcelService().readBinary(data);
        }
        try {
            String val = Cast._String(data);
            return Base64Encoder.decode(val);
        }
        catch (Exception iaex) {
            throw new CFPage.InvalidBinaryValueException(data.toString());
        }
    }

    public static Object toJavaArray(String type, List list) {
        return Cast.toJavaArray(type, 1, list);
    }

    public static Object toJavaArray(String type, int dimension, List list) {
        Class<?> clazz = (Class<?>)primitiveTypeMap.get(type);
        if (clazz == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                if (loader != null) {
                    clazz = loader.loadClass(type);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (clazz == null) {
                throw new UnknownTypeException(type);
            }
        }
        return Cast.castAndConvertToArray(list, clazz, dimension);
    }

    private static Object castAndConvertToArray(List list, Class clazz, int dimension) {
        if (dimension == 1) {
            Object oneDArray = java.lang.reflect.Array.newInstance(clazz, list.size());
            for (int i = 0; i < list.size(); ++i) {
                java.lang.reflect.Array.set(oneDArray, i, ClassUtility.cast(list.get(i), clazz));
            }
            return oneDArray;
        }
        if (list.size() == 0) {
            return java.lang.reflect.Array.newInstance(clazz, 0);
        }
        ArrayList<Object> nestedList = new ArrayList<Object>(list.size());
        for (Object child : list) {
            try {
                nestedList.add(Cast.castAndConvertToArray((List)child, clazz, dimension - 1));
            }
            catch (ClassCastException exception) {
                throw new TypeToListConversionException(clazz.getName());
            }
        }
        Object multiDArray = java.lang.reflect.Array.newInstance(nestedList.get(0).getClass(), nestedList.size());
        for (int i = 0; i < nestedList.size(); ++i) {
            java.lang.reflect.Array.set(multiDArray, i, nestedList.get(i));
        }
        return multiDArray;
    }

    public static Object translate(Object suppliedObject, String type) {
        if (type == null || suppliedObject == null) {
            return suppliedObject;
        }
        if (type.equalsIgnoreCase("any")) {
            return suppliedObject;
        }
        if (type.equalsIgnoreCase("array")) {
            return Cast._Array(suppliedObject);
        }
        if (type.equalsIgnoreCase("binary")) {
            return Cast._Binary(suppliedObject);
        }
        if (type.equalsIgnoreCase("boolean")) {
            if (suppliedObject == null) {
                return null;
            }
            if (suppliedObject instanceof String && ((String)suppliedObject).length() == 0) {
                return null;
            }
            return Cast._boolean(suppliedObject);
        }
        if (type.equalsIgnoreCase("date")) {
            return Cast._Date(suppliedObject);
        }
        if (type.equalsIgnoreCase("guid")) {
            return Cast._String(suppliedObject);
        }
        if (type.equalsIgnoreCase("numeric")) {
            if (suppliedObject instanceof String && ((String)suppliedObject).length() == 0) {
                return null;
            }
            return Cast._double(suppliedObject);
        }
        if (type.equalsIgnoreCase("query")) {
            return suppliedObject;
        }
        if (type.equalsIgnoreCase("string")) {
            return Cast._String(suppliedObject);
        }
        if (type.equalsIgnoreCase("struct")) {
            return Cast._Map(suppliedObject);
        }
        if (type.equalsIgnoreCase("uuid")) {
            return Cast._String(suppliedObject);
        }
        if (type.equalsIgnoreCase("xml")) {
            XmlNodeList x = Cast._Xml(suppliedObject);
            return x.getFirstNode();
        }
        return suppliedObject;
    }

    static {
        jsDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        parseDateInThread = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return true;
            }
        };
        primitiveTypeMap = new CaseInsensitiveMap();
        parseDateInThread.set(true);
        decFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        decFormat.applyPattern("0.#");
        expFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        expFormat.applyPattern("#.###########E000");
        Method[] methods = Cast.class.getMethods();
        castParamTypes = new Class[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            String name = method.getName();
            if (returnType.equals(Void.TYPE) || params.length != 1 || !name.startsWith("_")) {
                methods[i] = null;
                continue;
            }
            Cast.castParamTypes[i] = method.getParameterTypes()[0];
        }
        castMethods = methods;
        primitiveTypeMap.put("byte", Byte.TYPE);
        primitiveTypeMap.put("char", Character.TYPE);
        primitiveTypeMap.put("short", Short.TYPE);
        primitiveTypeMap.put("int", Integer.TYPE);
        primitiveTypeMap.put("long", Long.TYPE);
        primitiveTypeMap.put("float", Float.TYPE);
        primitiveTypeMap.put("double", Double.TYPE);
        primitiveTypeMap.put("boolean", Boolean.TYPE);
        primitiveTypeMap.put("String", String.class);
        primitiveTypeMap.put("bigdecimal", BigDecimal.class);
    }

    public static class BooleanStringConversionException
    extends ExpressionException {
        public String value;

        BooleanStringConversionException(String s) {
            this.value = s;
        }
    }

    public static class BooleanConversionException
    extends ExpressionException {
        public Class sourceType;

        BooleanConversionException(Class c) {
            this.sourceType = c;
        }
    }

    public static class OutOfBoundsException
    extends ExpressionException {
        private String type;
        public double number;

        OutOfBoundsException(String type, double d) {
            this.type = type;
            this.number = d;
        }

        @Override
        public String getMessage() {
            if (this.type == null) {
                return super.getMessage();
            }
            if (this.type.equals("integer")) {
                return OutOfBoundsException.getString(this, "messageInt", this.locale);
            }
            if (this.type.equals("short")) {
                return OutOfBoundsException.getString(this, "messageShort", this.locale);
            }
            if (this.type.equals("long")) {
                return OutOfBoundsException.getString(this, "messageLong", this.locale);
            }
            if (this.type.equals("byte")) {
                return OutOfBoundsException.getString(this, "messageByte", this.locale);
            }
            if (this.type.equals("float")) {
                return OutOfBoundsException.getString(this, "messageFloat", this.locale);
            }
            return super.getMessage();
        }
    }

    public static class CharCastException
    extends NeoException {
        public Object obj;

        public CharCastException(Object obj) {
            this.obj = obj;
        }
    }

    public static class NumberConversionException
    extends ExpressionException {
        public String source;

        public NumberConversionException(String source) {
            this.source = source;
        }
    }

    public static class ComplexByteArrayException
    extends CfJspPage.ComplexObjectException {
    }

    public static class DateStringConversionException
    extends ExpressionException {
        public String value;

        DateStringConversionException(String value) {
            this.value = value;
        }
    }

    public static class DateConversionException
    extends ExpressionException {
        public String value;

        DateConversionException(Class sourceType) {
            this.value = sourceType.toString();
        }

        DateConversionException(boolean value) {
            this.value = String.valueOf(value);
        }
    }

    public static class ArrayConversionException
    extends ExpressionException {
        public final Class sourceType;

        ArrayConversionException(Class sourceType) {
            this.sourceType = sourceType;
        }
    }

    public static class QueryCastException
    extends NeoException {
        private Object x;

        public QueryCastException(Object x) {
            this.x = x;
        }

        public String getOtype() {
            if (this.x != null) {
                return this.x.getClass().getName();
            }
            return "null";
        }
    }

    public static class ImageCastException
    extends NeoException {
        private Object x;

        public ImageCastException(Object x) {
            this.x = x;
        }

        public String getOtype() {
            if (this.x != null) {
                return this.x.getClass().getName();
            }
            return "null";
        }
    }

    public static class XmlCastException
    extends NeoException {
        private Object x;

        public XmlCastException(Object x) {
            this.x = x;
        }

        public String getOtype() {
            if (this.x != null) {
                return this.x.getClass().getName();
            }
            return "null";
        }
    }

    public static class FileObjectCastException
    extends NeoException {
        public Object obj;

        public FileObjectCastException(Object obj) {
            this.obj = obj;
        }

        public String getOtype() {
            if (this.obj != null) {
                return this.obj.getClass().getName();
            }
            return "null";
        }
    }

    public static class UnknownTypeException
    extends ApplicationException {
        public String classtype;

        public UnknownTypeException(String type) {
            this.classtype = type;
        }
    }

    public static class TypeToListConversionException
    extends ApplicationException {
        public String type;

        public TypeToListConversionException(String type) {
            this.type = type;
        }
    }
}

