/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.ScopeSearchResult;
import coldfusion.runtime.Variable;
import coldfusion.runtime.VariableScope;
import coldfusion.util.Key;

public class ClosureLocalScope
extends LocalScope {
    private LocalScope functionScope;

    public ClosureLocalScope(LocalScope src) {
        this.functionScope = src;
    }

    @Override
    public final void search(ScopeSearchResult searcher) {
        super.search(searcher);
        if (!searcher.found()) {
            Object args = this.get(Key.ARGUMENTS);
            if (args != null && args instanceof ArgumentCollection) {
                searcher.search((ArgumentCollection)args, true);
            }
            if (!searcher.found() && this.functionScope != null) {
                if (searcher.hasDottedReferences() && "ARGUMENTS".equalsIgnoreCase(searcher.getBaseName())) {
                    searcher.setFound(false);
                    return;
                }
                this.functionScope.search(searcher);
                if (!searcher.found() && (args = this.functionScope.get(Key.ARGUMENTS)) != null && args instanceof ArgumentCollection) {
                    searcher.search((ArgumentCollection)args, true);
                }
            }
        }
    }

    public final void search(ScopeSearchResult searcher, VariableScope varScope) {
        super.search(searcher);
        if (!searcher.found()) {
            Object args = this.get(Key.ARGUMENTS);
            if (args != null && args instanceof ArgumentCollection) {
                searcher.search((ArgumentCollection)args, true);
            }
            if (!searcher.found() && this.functionScope != null) {
                if (searcher.hasDottedReferences() && "ARGUMENTS".equalsIgnoreCase(searcher.getBaseName())) {
                    searcher.setFound(false);
                    return;
                }
                if (varScope != null) {
                    varScope.search(searcher);
                    if (searcher.found()) {
                        return;
                    }
                }
                this.functionScope.search(searcher);
                if (!searcher.found() && (args = this.functionScope.get(Key.ARGUMENTS)) != null && args instanceof ArgumentCollection) {
                    searcher.search((ArgumentCollection)args, true);
                }
            }
        }
    }

    @Override
    public boolean isDeclaredKey(String key) {
        Object args;
        Variable var = this.findVariable(key);
        if (var != null) {
            return true;
        }
        if (var == null && (args = this.get(Key.ARGUMENTS)) != null && args instanceof ArgumentCollection && ((ArgumentCollection)args).get(key) != null) {
            return true;
        }
        if (var == null && this.functionScope != null) {
            var = this.functionScope.findVariable(key);
            if (var != null) {
                return true;
            }
            if (var == null) {
                if (this.functionScope.isDeclaredKey(key)) {
                    return true;
                }
                args = this.functionScope.get(Key.ARGUMENTS);
                if (args != null && args instanceof ArgumentCollection && ((ArgumentCollection)args).get(key) != null) {
                    return true;
                }
            }
        }
        return var != null;
    }

    @Override
    public Object put(Object keyObj, Object value) {
        Object ret = this.putUtil(keyObj, value);
        if (ret == null && this.findVariable(keyObj.toString()) == null) {
            return this.putInternal(keyObj.toString(), value);
        }
        return ret;
    }

    public Object putUtil(Object keyObj, Object value) {
        Object args;
        String key = keyObj.toString();
        Variable var = this.findVariable(key);
        if (var != null) {
            return this.putInternal(key, value);
        }
        if (var == null && (args = this.get(Key.ARGUMENTS)) != null && args instanceof ArgumentCollection && ((ArgumentCollection)args).get(key) != null) {
            return ((ArgumentCollection)args).put(key, value);
        }
        if (var == null && this.functionScope != null) {
            var = this.functionScope.findVariable(key);
            if (var != null) {
                return this.functionScope.putInternal(key, value);
            }
            if (var == null) {
                Object varParent = this.functionScope.put(keyObj, value);
                if (varParent != null) {
                    return varParent;
                }
                Object args2 = this.functionScope.get(Key.ARGUMENTS);
                if (args2 != null && args2 instanceof ArgumentCollection && ((ArgumentCollection)args2).get(key) != null) {
                    return ((ArgumentCollection)args2).put(key, value);
                }
            }
        }
        return null;
    }
}

