/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.runtime.CFCookie;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.FlatScope;
import coldfusion.runtime.Scope;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.net.CookieTag;
import coldfusion.tagext.net.ThreadRequestException;
import coldfusion.util.URLDecoder;
import coldfusion.util.URLEncoder;
import coldfusion.util.Utils;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public final class CookieScope
extends Scope
implements FlatScope {
    public static final String DOMAIN_COOKIE_START = "Z";
    public static final String DOMAIN_HASH_SEPERATOR = "-";
    String cfid = "CFID";
    String cftoken = "CFTOKEN";
    private Cookie[] cookies;

    private boolean setRealCookieValue(String cookieValue, AppHelper helper) {
        String realCookieValue = helper.validateCookieValue(cookieValue, true);
        return realCookieValue != null;
    }

    protected String getCookieValue(String cookieValue) {
        int realCookieStart;
        if (cookieValue.startsWith(DOMAIN_COOKIE_START) && (realCookieStart = cookieValue.indexOf(DOMAIN_HASH_SEPERATOR)) != -1) {
            return cookieValue.substring(realCookieStart + 1);
        }
        return cookieValue;
    }

    private void removeInvalidCFCookies(Cookie[] cookies, FusionContext fc) {
        AppHelper helper = fc.getAppHelper();
        if (helper != null) {
            ArrayList<Cookie> cookiesList = new ArrayList<Cookie>();
            boolean cfidFound = false;
            boolean cfTokenFound = false;
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (cookieName.equalsIgnoreCase("CFID")) {
                    if (cfidFound) continue;
                    cookieValue = cookie.getValue();
                    boolean bl = cfidFound = this.setRealCookieValue(cookieValue, helper) && AppHelper.isValidCFID(this.getCookieValue(cookieValue));
                    if (!cfidFound) {
                        continue;
                    }
                } else if (cookieName.equalsIgnoreCase("CFTOKEN")) {
                    if (cfTokenFound) continue;
                    cookieValue = cookie.getValue();
                    boolean bl = cfTokenFound = this.setRealCookieValue(cookieValue, helper) && AppHelper.isValidCFTOKEN(cookieValue);
                    if (!cfTokenFound) continue;
                }
                cookiesList.add(cookie);
            }
            this.cookies = cookiesList.size() > 0 ? cookiesList.toArray(new Cookie[cookiesList.size()]) : new Cookie[0];
        } else {
            this.cookies = cookies;
        }
    }

    private void initCookies() {
        FusionContext fc = FusionContext.getCurrent();
        if (fc != null) {
            this.cookies = fc.getRequest().getCookies();
        }
        if (this.cookies == null) {
            this.cookies = new Cookie[0];
        } else {
            this.removeInvalidCFCookies(this.cookies, fc);
        }
        if (FusionContext.getApplicationSettings() != null) {
            fc.getRequest().setAttribute("samesite_value", (Object)FusionContext.getApplicationSettings().getSessionCookieSamesite());
        } else {
            fc.getRequest().setAttribute("samesite_value", (Object)ServiceFactory.getRuntimeService().getSessionCookieSamesite());
        }
    }

    private int findCookie(String name) {
        if (this.cookies == null) {
            this.initCookies();
        }
        for (int i = 0; i < this.cookies.length; ++i) {
            if (this.cookies[i] == null || !this.cookies[i].getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    protected String getActualValue(Cookie cookie) {
        if (cookie instanceof CFCookie) {
            return URLDecoder.decode(((CFCookie)cookie).getActualValue());
        }
        return URLDecoder.decode(cookie.getValue());
    }

    protected boolean isCFCookie(String name) {
        return name.equalsIgnoreCase("CFID") || name.equalsIgnoreCase("CFTOKEN");
    }

    protected String prepareDomainSafe(String value, FusionContext fcontext) {
        AppHelper helper = fcontext.getAppHelper();
        if (helper != null) {
            value = helper.prepareDomainCookie(value, true);
        }
        return value;
    }

    @Override
    protected Object resolveName(String name) {
        String obj = null;
        int i = this.findCookie(name);
        if (i != -1) {
            obj = this.getActualValue(this.cookies[i]);
            if (this.isCFCookie(name)) {
                obj = this.getCookieValue(obj);
            }
        }
        return obj;
    }

    @Override
    protected boolean containsName(String name) {
        return this.findCookie(name) != -1;
    }

    @Override
    public void bindAsScaler(Object[] args, Object value) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            String key = (String)args[i];
            buf.append(key);
            if (key.endsWith(".") || i == args.length - 1) continue;
            buf.append('.');
        }
        this.bindName(buf.toString(), value);
    }

    @Override
    protected void bindName_Final(String name, Object value) {
        this.bindName(name, value);
    }

    @Override
    protected void bindName(String name, Object value) {
        FusionContext ctx = FusionContext.getCurrent();
        if (ctx.pageContext.isUnderCFThread() && ctx.getState() == null) {
            throw new ThreadRequestException("cookie");
        }
        HttpServletRequest request = ctx.getRequest();
        HttpServletResponse response = ctx.getResponse();
        boolean isCFCookie = this.isCFCookie(name);
        int i = this.findCookie(name);
        if (i == -1) {
            Cookie[] newCookies = new Cookie[this.cookies.length + 1];
            System.arraycopy(this.cookies, 0, newCookies, 0, this.cookies.length);
            i = this.cookies.length;
            this.cookies = newCookies;
        }
        if (value instanceof CFCookie) {
            CFCookie cfCookie = (CFCookie)((Object)value);
            if (isCFCookie) {
                cfCookie.setValue(this.prepareDomainSafe(cfCookie.getValue(), ctx));
            }
            this.validateNAddCookie(response, cfCookie);
            this.cookies[i] = cfCookie;
        } else if (value instanceof Cookie) {
            if (isCFCookie) {
                Cookie cookieVal = (Cookie)value;
                cookieVal.setValue(this.prepareDomainSafe(cookieVal.getValue(), ctx));
            }
            response.addCookie((Cookie)value);
            this.cookies[i] = (Cookie)value;
        } else {
            String cookieValue;
            if (value instanceof Struct) {
                Struct cookStruct = (Struct)value;
                String cookieValue2 = "";
                boolean isHttpOnly = false;
                boolean encode = true;
                boolean secure = false;
                String domain = null;
                int maxage = -1;
                String samesite = "Lax";
                try {
                    if (cookStruct.containsKey("value")) {
                        cookieValue2 = Cast._String(cookStruct.get("value"));
                        cookieValue2 = Utils.stripCRLF(cookieValue2);
                        if (isCFCookie) {
                            cookieValue2 = this.prepareDomainSafe(cookieValue2, ctx);
                        }
                        if (cookStruct.containsKey("encodevalue")) {
                            encode = Cast._boolean(cookStruct.get("encodevalue"));
                        }
                        if (encode) {
                            cookieValue2 = URLEncoder.encode(cookieValue2);
                        }
                    }
                    if (cookStruct.containsKey("httponly")) {
                        isHttpOnly = Cast._boolean(cookStruct.get("httponly"));
                    }
                    if (cookStruct.containsKey("secure")) {
                        secure = Cast._boolean(cookStruct.get("secure"));
                    }
                    if (cookStruct.containsKey("domain")) {
                        domain = Cast._String(cookStruct.get("domain"));
                    }
                    if (cookStruct.containsKey("expires")) {
                        maxage = this.setExpires(cookStruct.get("expires"));
                    }
                    if (cookStruct.containsKey("samesite")) {
                        samesite = Cast._String(cookStruct.get("samesite"));
                    }
                    CFCookie cfCookie = new CFCookie(name, cookieValue2, isHttpOnly, secure, maxage, domain, samesite);
                    if (cookStruct.containsKey("path")) {
                        cfCookie.setPath(Cast._String(cookStruct.get("path")));
                    } else {
                        cfCookie.setPath(request.getContextPath() + "/");
                    }
                    this.validateNAddCookie(response, cfCookie);
                    this.cookies[i] = cfCookie;
                }
                catch (CfJspPage.ComplexObjectException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new InvalidCookieAttributesException(ex);
                }
            }
            boolean isAppAuthCookie = name.toUpperCase().startsWith("CFAUTHORIZATION");
            if (isCFCookie || isAppAuthCookie) {
                if (isAppAuthCookie && this.getApplicationSettingsObject().isAuthCookieUpdateDisabled()) {
                    throw new CFCookie.InvalidCookieOperationException();
                }
                if (this.getApplicationSettingsObject().isSessionCookieUpdateDisabled()) {
                    throw new CFCookie.InvalidCookieOperationException();
                }
            }
            try {
                cookieValue = Cast._String(value);
            }
            catch (Exception ex) {
                throw new InvalidCookieException();
            }
            cookieValue = Utils.stripCRLF(cookieValue);
            if (isCFCookie) {
                cookieValue = this.prepareDomainSafe(cookieValue, ctx);
            }
            CFCookie cfCookie = new CFCookie(name, URLEncoder.encode(cookieValue));
            cfCookie.setPath(request.getContextPath() + "/");
            this.validateNAddCookie(response, cfCookie);
            this.cookies[i] = cfCookie;
        }
    }

    private void validateNAddCookie(HttpServletResponse response, CFCookie cookie) {
        if (cookie != null) {
            String value = cookie.getValue();
            boolean emptyCookie = value != null && value.length() == 0;
            boolean samesite = cookie.getSamesite() != null && cookie.getSamesite().trim().length() != 0;
            boolean preserveEmptyCookie = Boolean.getBoolean("coldfusion.preserveemptycookies");
            if (samesite) {
                boolean setValue = true;
                if (emptyCookie && preserveEmptyCookie) {
                    setValue = false;
                }
                String header = this.createCookieHeader(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getMaxAge(), cookie.getSecure(), cookie.getComment(), cookie.getVersion(), cookie.isHttpOnlySet(), cookie.getSamesite(), setValue);
                if (!setValue) {
                    StringBuffer buf = new StringBuffer(header);
                    buf.append("; Value=");
                    buf.append(cookie.getActualValue());
                    header = buf.toString();
                }
                response.addHeader("Set-Cookie", header);
            } else if (emptyCookie) {
                if (preserveEmptyCookie) {
                    response.addCookie((Cookie)cookie);
                } else {
                    String header = this.createCookieHeader(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getMaxAge(), cookie.getSecure(), cookie.getComment(), cookie.getVersion(), cookie.isHttpOnlySet(), cookie.getSamesite(), false);
                    response.addHeader("Set-Cookie", header);
                }
            } else {
                response.addCookie((Cookie)cookie);
            }
        }
    }

    private String createCookieHeader(String name, String value, String domain, String path, int maxAge, boolean secure, String comment, int version, boolean httpOnly, String samesite, boolean setValue) {
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append("=");
        if (setValue) {
            buf.append(value);
        } else {
            buf.append("\"\"");
        }
        if (version == 1) {
            buf.append("; Version=1");
        }
        if (comment != null) {
            buf.append("; Comment=");
            buf.append(comment);
        }
        if (domain != null) {
            buf.append("; Domain=");
            buf.append(domain);
        }
        if (maxAge >= 0) {
            buf.append("; Max-Age=");
            buf.append(maxAge);
            buf.append("; Expires=");
            buf.append(this.getExpiresHeaderForMaxAge(maxAge));
        }
        if (path != null) {
            buf.append("; Path=");
            buf.append(path);
        }
        if (secure) {
            buf.append("; Secure");
        }
        if (httpOnly) {
            buf.append("; HttpOnly");
        }
        if (samesite != null && samesite.trim().length() > 0) {
            buf.append("; SameSite=");
            buf.append(samesite);
        }
        return buf.toString();
    }

    private String getExpiresHeaderForMaxAge(int maxAge) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss zzz", Locale.ROOT);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar gmtCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        Date expiryDate = maxAge == 0 ? new Date(0L) : new Date();
        gmtCal.setTime(expiryDate);
        gmtCal.add(13, maxAge);
        return sdf.format(gmtCal.getTime());
    }

    private int setExpires(Object e) {
        Date date;
        long diff;
        long diff2;
        int maxage = CookieTag.Max_Cookie_Age;
        maxage = e instanceof Date ? ((diff2 = ((Date)e).getTime() - System.currentTimeMillis()) < 0L ? 0 : (int)((double)diff2 / 1000.0)) : (e instanceof String ? (((String)e).equalsIgnoreCase("now") ? 0 : (((String)e).equalsIgnoreCase("never") ? CookieTag.Max_Cookie_Age : (this.isDateFormat(e) ? ((diff = (date = CFPage.ParseDateTime((String)e)).getTime() - System.currentTimeMillis()) < 0L ? 0 : (int)((double)diff / 1000.0)) : this.processDouble(e)))) : (e instanceof Number ? this.processDouble(e) : ((diff = (date = Cast._Date(e)).getTime() - System.currentTimeMillis()) < 0L ? 0 : (int)((double)diff / 1000.0))));
        return maxage;
    }

    private int processDouble(Object e) {
        int maxage = (int)(86400.0 * Cast._double(e));
        if (maxage < 0) {
            maxage = 0;
        }
        return maxage;
    }

    private final boolean isDateFormat(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern perlPattern = null;
        String pattern = "\\d\\d?/\\d\\d?/\\d\\d(\\d\\d)?";
        try {
            perlPattern = compiler.compile(pattern);
        }
        catch (MalformedPatternException malformedPatternException) {
            // empty catch block
        }
        Perl5Matcher matcher = new Perl5Matcher();
        return matcher.matches((String)obj, perlPattern);
    }

    @Override
    protected void unbindName(String name) {
        FusionContext ctx = FusionContext.getCurrent();
        HttpServletRequest request = ctx.getRequest();
        HttpServletResponse response = ctx.getResponse();
        int i = this.findCookie(name);
        if (i != -1) {
            this.cookies[i] = new CFCookie(name.toUpperCase(), "");
            this.cookies[i].setPath(request.getContextPath() + "/");
            this.cookies[i].setMaxAge(0);
            response.addCookie(this.cookies[i]);
        }
    }

    @Override
    protected Iterator getNames() {
        if (this.cookies == null) {
            this.initCookies();
        }
        return new CookieIterator();
    }

    @Override
    public int size() {
        if (this.cookies == null) {
            this.initCookies();
        }
        return this.cookies.length;
    }

    private ApplicationSettings getApplicationSettingsObject() {
        ApplicationScope appScope;
        FusionContext context = FusionContext.getCurrent();
        if (context == null) {
            return null;
        }
        String appName = context.getApplicationName();
        if (appName != null && (appScope = ApplicationScopeTracker.getApplicationScope(appName)) != null) {
            ApplicationSettings appSettings = appScope.getApplicationSettings();
            return appSettings;
        }
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.cloneAsStruct();
    }

    public static class InvalidCookieAttributesException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private Throwable rootEx;

        InvalidCookieAttributesException(Throwable rootEx) {
            this.rootEx = rootEx;
        }

        public String getRootMessage() {
            return this.rootEx.getMessage();
        }
    }

    public static class InvalidCookieException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    private class CookieIterator
    implements Iterator {
        private int i = -1;

        private CookieIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < CookieScope.this.cookies.length - 1;
        }

        public Object next() {
            return CookieScope.this.cookies[++this.i].getName();
        }

        @Override
        public void remove() {
            CookieScope.this.unbindName(CookieScope.this.cookies[this.i].getName());
        }
    }
}

