/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.log.Logger;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.InvalidDecryptStringLengthException;
import coldfusion.runtime.InvalidEncryptionValException;
import coldfusion.runtime.MissingDESedeException;
import coldfusion.runtime.UUEncDec;
import coldfusion.security.SecurityUtils;
import coldfusion.util.Hex;
import coldfusion.util.RB;
import coldfusion.wddx.Base64Encoder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class Encryptor {
    public static final String DEFAULT_ENC_ALGO = "AES/CBC/PKCS5Padding";
    public static final String DEFAULT_ENCODING = "UU";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String TRIPLE_DES = "DESede";
    public static final String BASE64 = "Base64";
    public static final String BASE64URL = "Base64URL";
    private static Logger logger = Logger.getLogger(Encryptor.class.getName());
    private static BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();

    public static String generateSecretKey(String algorithm, int keysize) {
        SecretKey secretkey;
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
            if (keysize > 0) {
                keyGenerator.init(keysize);
            }
            secretkey = keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException nae) {
            throw new InvalidAlgorithmException(algorithm);
        }
        return Base64Encoder.encode(secretkey.getEncoded());
    }

    public static String generatePBKDFKey(String algorithm, String password, String salt, int iterations, int keysize) {
        SecretKey pwSecretKey = null;
        if (algorithm == null) {
            throw new InvalidAlgorithmException("");
        }
        algorithm = algorithm.trim();
        try {
            SecretKeyFactory skFactory;
            PBEKeySpec pwSpec;
            if (algorithm.length() > 0 && algorithm.toUpperCase().startsWith("PBK")) {
                pwSpec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), iterations, keysize);
                skFactory = null;
                if (algorithm.equalsIgnoreCase("PBKDF2WithHmacSHA1") && Security.getProvider("JsafeJCE") != null) {
                    try {
                        if (Security.getProvider("SunJCE") != null) {
                            skFactory = SecretKeyFactory.getInstance(algorithm, "SunJCE");
                        } else if (Security.getProvider("IBMJCE") != null) {
                            skFactory = SecretKeyFactory.getInstance(algorithm, "IBMJCE");
                        }
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        // empty catch block
                    }
                }
                if (skFactory == null) {
                    skFactory = SecretKeyFactory.getInstance(algorithm);
                }
            } else {
                throw new InvalidAlgorithmException(algorithm);
            }
            pwSecretKey = skFactory.generateSecret(pwSpec);
        }
        catch (NoSuchAlgorithmException nae) {
            throw new InvalidAlgorithmException(algorithm);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeySpecificationException(e);
        }
        if (pwSecretKey != null) {
            return Base64Encoder.encode(pwSecretKey.getEncoded());
        }
        throw new InvalidAlgorithmException(algorithm);
    }

    public static String generate3DesKey(String string) {
        SecretKeySpec secretKey = new SecretKeySpec(string.getBytes(), TRIPLE_DES);
        return Base64Encoder.encode(secretKey.getEncoded());
    }

    public static String encrypt(String string, String key) {
        return Encryptor.encrypt(string, key, DEFAULT_ENC_ALGO);
    }

    public static String encrypt(String string, String key, String algorithm) {
        return Encryptor.encrypt(string, key, algorithm, DEFAULT_ENCODING);
    }

    public static String encrypt(String string, String key, String algorithm, String encoding) {
        return Encryptor.encrypt(string, key, algorithm, encoding, null, 0);
    }

    public static String encrypt(String string, String charset, String key, String algo, String encoding) {
        return Encryptor.encrypt(string, charset, key, algo, encoding, null, 0);
    }

    public static String encrypt(String string, String key, String algorithm, String encoding, byte[] prefix) {
        return Encryptor.encrypt(string, key, algorithm, encoding, prefix, 0);
    }

    public static String encrypt(String string, String key, String algorithm, String encoding, byte[] prefix, Object iter) {
        return Encryptor.encrypt(string, DEFAULT_CHARSET, key, algorithm, encoding, prefix, iter);
    }

    public static String encrypt(String string, String charset, String key, String algorithm, String encoding, byte[] prefix, Object iter) {
        byte[] bytes;
        if (string.length() == 0) {
            throw new InvalidEncryptionValException();
        }
        try {
            bytes = string.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidCharacterEncodingException(e);
        }
        byte[] enc = Encryptor.encrypt(bytes, key, algorithm, prefix, iter);
        return Encryptor.binaryEncode(enc, encoding);
    }

    public static byte[] encrypt(byte[] bytes, String key) {
        return Encryptor.encrypt(bytes, key, DEFAULT_ENC_ALGO);
    }

    public static byte[] encrypt(byte[] bytes, String key, String algorithm) {
        return Encryptor.encrypt(bytes, key, algorithm, null, 0);
    }

    static byte[] encrypt(byte[] bytes, String key, String algorithm, byte[] prefix, Object iter) {
        byte[] enc;
        try {
            enc = Encryptor.processCipherWork(bytes, null, key, algorithm, 1, prefix, iter);
        }
        catch (NoSuchAlgorithmException nsae) {
            if (algorithm.equalsIgnoreCase(TRIPLE_DES)) {
                Encryptor.registerSunCryptoProvider();
                try {
                    enc = Encryptor.processCipherWork(bytes, null, key, algorithm, 1, prefix, iter);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new InvalidAlgorithmException(algorithm);
                }
            }
            throw new InvalidAlgorithmException(algorithm);
        }
        catch (ExpressionException e) {
            throw e;
        }
        return enc;
    }

    public static String decrypt(String string, String key) {
        return Encryptor.decrypt(string, key, DEFAULT_ENC_ALGO, DEFAULT_ENCODING);
    }

    public static String decrypt(String string, String key, String algorithm) {
        return Encryptor.decrypt(string, key, algorithm, DEFAULT_ENCODING);
    }

    public static String decrypt(String string, String key, String algorithm, String encoding) {
        return Encryptor.decrypt(string, key, algorithm, encoding, null, 0);
    }

    public static String decrypt(String string, String charset, String key, String algorithm, String encoding) {
        return Encryptor.decrypt(string, charset, key, algorithm, encoding, null, 0);
    }

    public static String decrypt(String string, String key, String algorithm, String encoding, byte[] prefix) {
        return Encryptor.decrypt(string, key, algorithm, encoding, prefix, 0);
    }

    public static String decrypt(String string, String key, String algorithm, String encoding, byte[] prefix, Object iter) {
        return Encryptor.decrypt(string, DEFAULT_CHARSET, key, algorithm, encoding, prefix, iter);
    }

    public static String decrypt(String string, String charset, String key, String algorithm, String encoding, byte[] prefix, Object iter) {
        byte[] decoded;
        if (string.length() == 0) {
            throw new InvalidDecryptStringLengthException();
        }
        try {
            decoded = Encryptor.binaryDecode(string, encoding);
        }
        catch (Exception e) {
            throw new InvalidParamsForEncryptionException(e);
        }
        byte[] decrypted = Encryptor.decrypt(decoded, key, algorithm, prefix, iter);
        try {
            return new String(decrypted, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidCharacterEncodingException(e);
        }
    }

    public static byte[] decrypt(byte[] bytes, String key) {
        return Encryptor.decrypt(bytes, key, DEFAULT_ENC_ALGO);
    }

    public static byte[] decrypt(byte[] bytes, String key, String algo) {
        return Encryptor.decrypt(bytes, key, algo, null, 0);
    }

    public static byte[] decrypt(byte[] bytes, String key, String algorithm, byte[] prefix, Object iter) {
        byte[] decrypted;
        try {
            decrypted = Encryptor.processCipherWork(null, bytes, key, algorithm, 2, prefix, iter);
        }
        catch (NoSuchAlgorithmException nsae) {
            if (algorithm.equalsIgnoreCase(TRIPLE_DES)) {
                Encryptor.registerSunCryptoProvider();
                try {
                    decrypted = Encryptor.processCipherWork(null, bytes, key, algorithm, 2, prefix, iter);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new InvalidAlgorithmException(algorithm);
                }
            }
            throw new InvalidAlgorithmException(algorithm);
        }
        return decrypted;
    }

    private static void registerSunCryptoProvider() {
        try {
            Provider sunjce = null;
            try {
                Class<?> clazz = Class.forName("com.sun.crypto.provider.SunJCE");
                if (clazz != null) {
                    sunjce = (Provider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                MissingDESedeException ex = new MissingDESedeException(e);
                logger.error(ex);
                throw ex;
            }
            catch (Exception e) {
                MissingDESedeException ex = new MissingDESedeException(e);
                logger.error(ex);
                throw ex;
            }
            logger.warn(RB.getString(CFPage.class, "CFPage.DESedeWarn"));
            Security.addProvider(sunjce);
        }
        catch (Exception e) {
            MissingDESedeException ex = new MissingDESedeException(e);
            logger.error(ex);
            throw ex;
        }
    }

    private static byte[] processCipherWork(byte[] original, byte[] decoded, String key, String algorithm, int CRYPT_MODE, byte[] prefix, Object iter) throws ExpressionException, NoSuchAlgorithmException {
        byte[] enc;
        int offset = 0;
        int iterations = 0;
        String associatedData = null;
        if (iter instanceof Integer) {
            iterations = (Integer)iter;
        }
        if (iter instanceof String) {
            associatedData = (String)iter;
        }
        try {
            int slshIndx = algorithm.indexOf(47);
            String algName = algorithm;
            boolean feedbackMode = false;
            if (slshIndx != -1) {
                algName = algorithm.substring(0, slshIndx);
                String mode = algorithm.substring(slshIndx + 1);
                if (!mode.startsWith("ECB")) {
                    feedbackMode = true;
                }
            }
            Cipher cipher = Cipher.getInstance(algorithm);
            if (algorithm.startsWith("AES/GCM")) {
                if (prefix == null) {
                    prefix = new byte[12];
                    offset = 12;
                    if (CRYPT_MODE == 1) {
                        new SecureRandom().nextBytes(prefix);
                    } else {
                        System.arraycopy(decoded, 0, prefix, 0, offset);
                    }
                }
                byte[] secretKeyBytes = Base64Encoder.decode(key);
                SecretKeySpec secKey = new SecretKeySpec(secretKeyBytes, 0, secretKeyBytes.length, algName);
                GCMParameterSpec parameterSpec = new GCMParameterSpec(128, prefix);
                cipher.init(CRYPT_MODE, (Key)secKey, parameterSpec);
                if (associatedData != null && associatedData.trim().length() != 0) {
                    cipher.updateAAD(associatedData.getBytes());
                }
            } else if (algorithm.startsWith("AES/CCM")) {
                cipher = Cipher.getInstance(algorithm, (Provider)bouncyCastleProvider);
                if (prefix == null) {
                    prefix = new byte[12];
                    offset = 12;
                    if (CRYPT_MODE == 1) {
                        new SecureRandom().nextBytes(prefix);
                    } else {
                        System.arraycopy(decoded, 0, prefix, 0, offset);
                    }
                }
                byte[] secretKeyBytes = Base64Encoder.decode(key);
                SecretKeySpec secKey = new SecretKeySpec(secretKeyBytes, 0, secretKeyBytes.length, algName);
                GCMParameterSpec parameterSpec = new GCMParameterSpec(128, prefix);
                cipher.init(CRYPT_MODE, (Key)secKey, parameterSpec);
                if (associatedData != null && associatedData.trim().length() != 0) {
                    cipher.updateAAD(associatedData.getBytes());
                }
            } else if (algName.toUpperCase().startsWith("PBE")) {
                if (prefix == null) {
                    prefix = new byte[8];
                    offset = 8;
                    if (CRYPT_MODE == 1) {
                        new SecureRandom().nextBytes(prefix);
                    } else {
                        System.arraycopy(decoded, 0, prefix, 0, offset);
                    }
                }
                if (iterations == 0) {
                    iterations = 1000;
                }
                PBEKeySpec pwSpec = new PBEKeySpec(key.toCharArray());
                SecretKeyFactory skFactory = SecretKeyFactory.getInstance(algorithm);
                SecretKey pwSecretKey = skFactory.generateSecret(pwSpec);
                PBEParameterSpec pbeSpec = new PBEParameterSpec(prefix, iterations);
                cipher.init(CRYPT_MODE, (Key)pwSecretKey, pbeSpec);
            } else if (algName.toUpperCase().startsWith("PBK")) {
                if (prefix == null) {
                    prefix = new byte[8];
                    offset = 8;
                    if (CRYPT_MODE == 1) {
                        new SecureRandom().nextBytes(prefix);
                    } else {
                        System.arraycopy(decoded, 0, prefix, 0, offset);
                    }
                }
                if (iterations == 0) {
                    iterations = 1000;
                }
                PBEKeySpec pwSpec = new PBEKeySpec(key.toCharArray(), prefix, iterations);
                SecretKeyFactory skFactory = SecretKeyFactory.getInstance(algorithm);
                SecretKey pwSecretKey = skFactory.generateSecret(pwSpec);
                cipher.init(CRYPT_MODE, pwSecretKey);
            } else {
                SecretKey recreatedSecretKey = Encryptor.retrieveSecretKey(key, algName);
                if (feedbackMode) {
                    if (prefix == null) {
                        prefix = new byte[cipher.getBlockSize()];
                        offset = prefix.length;
                        if (CRYPT_MODE == 1) {
                            new SecureRandom().nextBytes(prefix);
                        } else {
                            System.arraycopy(decoded, 0, prefix, 0, offset);
                        }
                    }
                    IvParameterSpec ivParamSpec = new IvParameterSpec(prefix);
                    cipher.init(CRYPT_MODE, (Key)recreatedSecretKey, ivParamSpec);
                } else {
                    cipher.init(CRYPT_MODE, recreatedSecretKey);
                }
            }
            if (CRYPT_MODE == 2) {
                enc = cipher.doFinal(decoded, offset, decoded.length - offset);
            } else {
                enc = new byte[cipher.getOutputSize(original.length) + offset];
                if (offset != 0) {
                    System.arraycopy(prefix, 0, enc, 0, offset);
                }
                cipher.doFinal(original, 0, original.length, enc, offset);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw nsae;
        }
        catch (InvalidKeyException ike) {
            throw new InvalidEncryptionKeyException(ike);
        }
        catch (Exception e) {
            throw new InvalidParamsForEncryptionException(e);
        }
        catch (ExceptionInInitializerError initerr) {
            throw new UninitializedCryptoException(initerr.getException());
        }
        catch (Error err) {
            throw new UninitializedCryptoException(err);
        }
        return enc;
    }

    public static String binaryEncode(Object inputbinary, String encoding) {
        if (inputbinary instanceof byte[]) {
            byte[] inputbytes = Cast._Binary(inputbinary);
            if (encoding.equalsIgnoreCase("Hex")) {
                return Hex.bytesToHex(inputbytes);
            }
            if (encoding.equalsIgnoreCase(DEFAULT_ENCODING)) {
                return UUEncDec.encode(inputbytes);
            }
            if (encoding.equalsIgnoreCase(BASE64)) {
                return Base64Encoder.encode(inputbytes);
            }
            if (encoding.equalsIgnoreCase(BASE64URL)) {
                return Base64Encoder.encodeUrl(inputbytes);
            }
            throw new InvalidEncodingException(encoding);
        }
        throw new InvalidInputBinaryException(inputbinary.toString(), "BinaryEncode");
    }

    public static byte[] binaryDecode(String string, String encoding) {
        try {
            if (encoding.equalsIgnoreCase("Hex")) {
                return Hex.hexToBytes(string);
            }
            if (encoding.equalsIgnoreCase(DEFAULT_ENCODING)) {
                return UUEncDec.decode(string);
            }
            if (encoding.equalsIgnoreCase(BASE64)) {
                return Base64Encoder.decode(string);
            }
            if (encoding.equalsIgnoreCase(BASE64URL)) {
                return Base64Encoder.decodeUrl(string);
            }
        }
        catch (Exception e) {
            throw new InvalidEncDecException();
        }
        throw new InvalidEncodingException(encoding);
    }

    public static SecretKey retrieveSecretKey(String key, String algorithm) {
        byte[] encodedkey = Base64Encoder.decode(key);
        return new SecretKeySpec(encodedkey, algorithm);
    }

    public static class InvalidAlgorithmException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String algorithm;
        public String function;

        InvalidAlgorithmException(String algorithm) {
            this.algorithm = algorithm;
        }
    }

    public static class InvalidKeySpecificationException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;

        InvalidKeySpecificationException(InvalidKeySpecException ex) {
            super(ex);
        }
    }

    public static class InvalidCharacterEncodingException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;

        InvalidCharacterEncodingException(IOException ex) {
            super(ex);
        }
    }

    public static class InvalidParamsForEncryptionException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String err;

        InvalidParamsForEncryptionException(Throwable rootCause) {
            this.err = rootCause.getLocalizedMessage();
        }
    }

    public static class InvalidEncryptionKeyException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String err;
        public String policyFilesMessage;

        InvalidEncryptionKeyException(Throwable rootCause) {
            this.err = rootCause.getLocalizedMessage();
            this.policyFilesMessage = SecurityUtils.isPolicyFilesInstalled() ? "" : "If encryption key size is greater than 128 bits make sure to insall JCE Unlimited Strength Policy Files";
        }
    }

    public static class UninitializedCryptoException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String err;

        public UninitializedCryptoException(Throwable rootCause) {
            this.err = rootCause.getLocalizedMessage();
        }
    }

    public static class InvalidEncodingException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String enc;

        InvalidEncodingException(String encoding) {
            this.enc = encoding;
        }
    }

    public static class InvalidInputBinaryException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String sVal;
        public String function;

        InvalidInputBinaryException(String sVal, String function) {
            this.sVal = sVal;
            this.function = function;
        }
    }

    public static class InvalidEncDecException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;

        InvalidEncDecException() {
        }
    }

    public static class InvalidDecryptionKeyException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String err;

        InvalidDecryptionKeyException(Throwable rootCause) {
            this.err = rootCause.getLocalizedMessage();
        }
    }
}

