/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.TemplateName;
import coldfusion.util.FastHashtable;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ExceptionInformation
extends Vector {
    private boolean initialized;
    static Map builtInTags = new HashMap();
    static Map builtInCFCs = new HashMap();

    public ExceptionInformation(Throwable ex) {
        try {
            CharArrayWriter traceWriter = new CharArrayWriter(1024);
            ex.printStackTrace(new PrintWriter(traceWriter));
            BufferedReader lineReader = new BufferedReader(new CharArrayReader(traceWriter.toCharArray()));
            String nextLine = lineReader.readLine();
            ExceptionTraceElement prev = null;
            while (nextLine != null) {
                ExceptionTraceElement temp = new ExceptionTraceElement(nextLine);
                if (temp.get("TYPE").equals("CFML")) {
                    String curPath = (String)temp.get("TEMPLATE");
                    int cftagloc = curPath.indexOf("cftags");
                    if (this.isBuiltInTag(curPath)) {
                        temp.setAsReadOnly();
                        prev = temp;
                        nextLine = lineReader.readLine();
                        continue;
                    }
                    if (prev != null) {
                        Object sTagName;
                        String prevTemp = (String)prev.get("TEMPLATE");
                        if (this.isBuiltInTag(prevTemp)) {
                            sTagName = this.getBuiltInName(prevTemp);
                        } else if (prevTemp.endsWith("Tag.java")) {
                            int i = prevTemp.indexOf("Tag.java");
                            sTagName = prevTemp.startsWith("CF") ? prevTemp.substring(0, i).toUpperCase() : "CF" + prevTemp.substring(0, i).toUpperCase();
                        } else {
                            sTagName = TemplateName.getTemplateName(prevTemp, false);
                        }
                        temp.put("ID", sTagName);
                    }
                    temp.setAsReadOnly();
                    this.addElement(temp);
                    prev = temp;
                } else if (prev == null) {
                    prev = temp;
                } else {
                    String tempTemplate = (String)temp.get("TEMPLATE");
                    if (!tempTemplate.equalsIgnoreCase("CfJspPage.java")) {
                        prev = temp;
                    }
                }
                nextLine = lineReader.readLine();
            }
            this.initialized = true;
        }
        catch (Exception ePrime) {
            this.initialized = false;
            ePrime.printStackTrace();
        }
    }

    private boolean isBuiltInTag(String template) {
        return this.getBuiltInName(template) != null;
    }

    private String getBuiltInName(String template) {
        String abrvTemplate;
        String abrvTemplate2;
        int cftagloc = template.indexOf("cftags");
        if (cftagloc != -1 && builtInTags.containsKey(abrvTemplate2 = template.substring(cftagloc))) {
            return (String)builtInTags.get(abrvTemplate2);
        }
        int comLoc = template.indexOf("com");
        if (comLoc != -1 && builtInCFCs.containsKey(abrvTemplate = template.substring(comLoc))) {
            return (String)builtInCFCs.get(abrvTemplate);
        }
        return null;
    }

    public String getTemplate() {
        Object o;
        if (this.elementCount > 0 && (o = this.elementAt(0)) instanceof Map) {
            Map m = (Map)o;
            return m.get("TEMPLATE").toString();
        }
        return "";
    }

    public int getLine() {
        Object o;
        if (this.elementCount > 0 && (o = this.elementAt(0)) instanceof Map) {
            Map m = (Map)o;
            Integer i = (Integer)m.get("LINE");
            return i;
        }
        return -1;
    }

    static {
        String prefix = "cftags/";
        builtInTags.put(prefix + "cache.cfm", "CFCACHE");
        builtInTags.put(prefix + "dump.cfm", "CFDUMP");
        builtInTags.put(prefix + "form.cfm", "CFFORM");
        builtInTags.put(prefix + "grid.cfm", "CFGRID");
        builtInTags.put(prefix + "gridcolumn.cfm", "CFGRIDCOLUMN");
        builtInTags.put(prefix + "gridrow.cfm", "CFGRIDROW");
        builtInTags.put(prefix + "savecontent.cfm", "CFSAVECONTENT");
        builtInTags.put(prefix + "select.cfm", "CFSELECT");
        builtInTags.put(prefix + "slider.cfm", "CFSLIDER");
        builtInTags.put(prefix + "textinput.cfm", "CFTEXTINPUT");
        builtInTags.put(prefix + "trace.cfm", "CFTRACE");
        builtInTags.put(prefix + "tree.cfm", "CFTREE");
        builtInTags.put(prefix + "treeitem.cfm", "CFTREEITEM");
        builtInCFCs.put("com\\adobe\\coldfusion\\system.cfc", "SYSTEM");
    }

    public class ExceptionTraceElement
    extends FastHashtable {
        private boolean readonly = false;

        public ExceptionTraceElement(String traceLine) {
            this.decodeTraceEntry(traceLine);
        }

        public void setAsReadOnly() {
            this.readonly = true;
        }

        private void decodeTraceEntry(String traceLine) {
            this.put("RAW_TRACE", (Object)traceLine);
            int iStart = traceLine.indexOf(40);
            if (iStart != -1) {
                block10: {
                    try {
                        int lineNumber;
                        ++iStart;
                        int iEnd = traceLine.lastIndexOf(58);
                        if (!traceLine.startsWith("\tat")) {
                            iEnd = -1;
                        }
                        if (iEnd == -1) {
                            String sType = "UNKOWN";
                            int lineNumber2 = -1;
                            String sourceFile = traceLine.substring(iStart, traceLine.indexOf(41, 0));
                            int compStart = sourceFile.indexOf(40);
                            if (compStart != -1) {
                                sType = (sourceFile = sourceFile.substring(0, compStart)).indexOf(".java") == -1 ? "CFML" : "JAVA";
                            } else {
                                sourceFile = "??";
                            }
                            this.put("TEMPLATE", (Object)sourceFile);
                            this.put("LINE", (Object)new Integer(lineNumber2));
                            this.put("TYPE", (Object)sType);
                            break block10;
                        }
                        int iLineNumberPos = iEnd + 1;
                        int iLineNumberEnd = traceLine.indexOf(41, iLineNumberPos);
                        String strLine = traceLine.substring(iLineNumberPos, iLineNumberEnd);
                        try {
                            lineNumber = Integer.parseInt(strLine);
                        }
                        catch (IllegalArgumentException ex) {
                            lineNumber = -1;
                        }
                        String sourceFile = traceLine.substring(iStart, iEnd);
                        this.put("TEMPLATE", (Object)sourceFile);
                        this.put("LINE", (Object)new Integer(lineNumber));
                        this.put("TYPE", (Object)(sourceFile.indexOf(".java") == -1 ? "CFML" : "JAVA"));
                    }
                    catch (Exception ex) {
                        this.put("TYPE", (Object)"UNKNOWN");
                        this.put("TEMPLATE", (Object)"??");
                        this.put("LINE", (Object)new Integer(0));
                    }
                }
                ExceptionInformation.this.initialized = true;
            } else {
                this.put("TYPE", (Object)"UNKNOWN");
                this.put("TEMPLATE", (Object)"??");
                this.put("LINE", (Object)new Integer(0));
            }
            this.put("COLUMN", (Object)new Integer(0));
        }

        @Override
        public Object put(Object key, Object obj) {
            if (this.readonly) {
                throw new UnsupportedOperationException();
            }
            return super.put(key, obj);
        }

        @Override
        public Object remove(Object key) {
            if (this.readonly) {
                throw new UnsupportedOperationException();
            }
            return super.remove(key);
        }
    }
}

