/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.ImplementationProcessor;
import coldfusion.runtime.JavaImplementationProcessor;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.implementation.exceptions.java.ImplementationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImplementationUtil {
    public static final String COLON = ":";
    public static final String IMPLEMENTS = "implements";
    public static final String EXTENDS = "extends";
    public static List<String> supportedType = Arrays.asList("java");

    private static ImplementationProcessor getImplementationProcessor(String type) {
        switch (type) {
            case "java": {
                return JavaImplementationProcessor.getInstance();
            }
        }
        throw new ImplementationException.UnSupportedImplementationProcessorException(type);
    }

    public static Map<String, Set<String>> extractImplementingInterface(TemplateProxy cfc, boolean validate) throws Throwable {
        HashMap<String, Set<String>> interfaces = new HashMap<String, Set<String>>();
        for (String type : supportedType) {
            interfaces.put(type, ImplementationUtil.getImplementationProcessor(type).getInterfaces(cfc, validate));
        }
        return interfaces;
    }

    public static Map<String, Object> getDynamicProxies(TemplateProxy cfc) {
        HashMap<String, Object> dynamicProxies = new HashMap<String, Object>(1);
        for (String s : supportedType) {
            dynamicProxies.put(s, ImplementationUtil.getImplementationProcessor(s).getDynamicProxy(cfc));
        }
        return dynamicProxies;
    }

    public static Map<String, Map<String, List<String>>> extractOtherImplementations(CfJspPage page) {
        HashMap<String, Map<String, List<String>>> map = new HashMap<String, Map<String, List<String>>>(2);
        map.put(EXTENDS, ImplementationUtil.extractOtherImplementations(page.getOtherExtends(), false));
        map.put(IMPLEMENTS, ImplementationUtil.extractOtherImplementations(page.getOtherImplementations(), false));
        return map;
    }

    public static Map<String, List<String>> extractOtherImplementations(String value, boolean preserveType) {
        String[] split;
        if (value == null) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(1);
        for (String s : split = value.split(",", -1)) {
            s = s.trim();
            String[] interfaceString = s.split(COLON);
            String type = interfaceString[0].trim();
            if (interfaceString.length > 1) {
                String val = interfaceString[1].trim();
                if (type.equalsIgnoreCase("java")) {
                    if (preserveType) {
                        map.computeIfAbsent("java", k -> new ArrayList()).add(type + COLON + val);
                        continue;
                    }
                    map.computeIfAbsent("java", k -> new ArrayList()).add(val);
                    continue;
                }
                if (type.equalsIgnoreCase("cfc")) {
                    map.computeIfAbsent("cfc", k -> new ArrayList()).add(val);
                    continue;
                }
                throw new RuntimeException("Unknown implementation type " + type);
            }
            if (s.indexOf(COLON) != -1) {
                throw new RuntimeException("Implementing Interface of type " + type + " cannot be empty");
            }
            map.computeIfAbsent("cfc", k -> new ArrayList()).add(s);
        }
        map.computeIfAbsent("cfc", k -> Collections.EMPTY_LIST);
        return map;
    }

    public static class SupportedType {
        public static final String JAVA = "java";
        public static final String CFC = "cfc";
    }
}

