/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ImplicitUDFMethod;
import coldfusion.runtime.MissingArgumentException;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.Variable;
import coldfusion.runtime.VariableScope;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.validation.CFCTypeValidationException;
import coldfusion.tagext.validation.CFCTypeValidator;
import coldfusion.tagext.validation.CFIntegerValidator;
import coldfusion.tagext.validation.CFNumberValidator;
import coldfusion.tagext.validation.CFStringValidator;
import coldfusion.tagext.validation.CFTypeValidator;
import coldfusion.tagext.validation.CFTypeValidatorFactory;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.Key;
import coldfusion.util.Utils;
import java.util.Map;

public class ImplicitSetter
extends ImplicitUDFMethod {
    private String propertyName;
    private String pagePath;
    private String name;
    private String validate;
    private String validateOptionStr;
    private AttributeCollection metadata;
    private CFTypeValidator validator;
    private Key propertyNameKey;
    private String cfcType;
    private static Map primitives = new CaseInsensitiveMap();
    private static Map cftypes = new CaseInsensitiveMap();

    public ImplicitSetter(String propertyName, String type, String validate, String validateOptions, String pagePath, String cfcName) {
        this.propertyName = propertyName;
        this.propertyNameKey = Key.getInstance(propertyName);
        this.pagePath = pagePath;
        this.name = "SET" + propertyName.toUpperCase();
        if (validate != null) {
            this.validate = validate;
        } else {
            if (type == null || type.length() == 0) {
                this.validate = type = "any";
            } else if (cftypes.containsKey(type)) {
                this.validate = type;
            } else if (!type.equalsIgnoreCase("any") && !primitives.containsKey(type)) {
                this.cfcType = type;
            }
            validateOptions = null;
        }
        this.validateOptionStr = validateOptions;
        this.metadata = new AttributeCollection();
        this.metadata.put("name", (Object)this.name);
        AttributeCollection param = new AttributeCollection();
        param.put("NAME", (Object)propertyName);
        param.put("TYPE", (Object)type);
        param.put("REQUIRED", (Object)true);
        this.metadata.put("Parameters", (Object)new Object[]{param});
        this.metadata.put("returntype", (Object)cfcName);
        this.metadata.put("access", (Object)"public");
        this.returnType = cfcName;
        this.validator = this.getValidator(validate != null);
        this.init();
    }

    @Override
    public Object invoke(Object instance, String calledName, Object parent, Object[] args) throws Throwable {
        if (args == null || args.length == 0) {
            throw new MissingArgumentException(this.propertyName, calledName, false);
        }
        Object argument = args[0];
        return this.runFunction(instance, (CFPage)parent, argument);
    }

    @Override
    protected Object runFunction(Object instance, CFPage parent, ArgumentCollection args) {
        Object value = null;
        if (args != null) {
            value = args.get(this.propertyNameKey);
        }
        if (value == null) {
            throw new MissingArgumentException(this.propertyName, this.name, false);
        }
        if (value instanceof Variable) {
            value = ((Variable)value).getValue();
        }
        return this.runFunction(instance, parent, value);
    }

    private Object runFunction(Object instance, CFPage parent, Object argValue) {
        VariableScope varScope;
        TemplateProxy cfc = (TemplateProxy)instance;
        VariableScope variableScope = varScope = cfc != null ? cfc.getVariableScope() : parent.pageContext.getVariableScope();
        if (argValue != null) {
            if (this.validator != null) {
                this.validator.validate(argValue);
            } else if (ServiceFactory.getRuntimeService().isCFCTypeCheckEnabled() && this.cfcType != null) {
                try {
                    CFCTypeValidator.validate(this.cfcType, argValue, this.pagePath, this);
                }
                catch (CFCTypeValidationException e) {
                    throw new UDFMethod.InvalidArgumentTypeException(this.propertyName, this.getName(), this.cfcType);
                }
            }
        }
        varScope.bindInternal(this.propertyName, argValue);
        return instance;
    }

    private CFTypeValidator getValidator(boolean throwError) {
        Map<String, String> validateOptions;
        if (this.validateOptionStr == null || this.validateOptionStr.length() == 0) {
            validateOptions = null;
        } else {
            try {
                validateOptions = Utils.parseStructString(this.validateOptionStr);
            }
            catch (Exception e) {
                throw new ValidateOptionParseException(this.validateOptionStr, this.propertyName);
            }
        }
        CFTypeValidator validator = CFTypeValidatorFactory.getExtendedValidator(this.validate);
        if (throwError && validator == null) {
            throw new InvalidValidateTypeException(this.validate, this.propertyName);
        }
        if (this.validate == null) {
            return null;
        }
        if (validateOptions == null) {
            if (this.validate.equalsIgnoreCase("regex")) {
                throw new RegexPatternNotFoundException(this.propertyName);
            }
            return validator;
        }
        if (this.validate.equalsIgnoreCase("numeric")) {
            String min = validateOptions.get("min");
            String max = validateOptions.get("max");
            if (min != null || max != null) {
                validator = new CFNumberValidator();
            }
            if (min != null) {
                ((CFNumberValidator)validator).setLowerBound(false, Cast._double(min));
            }
            if (max != null) {
                ((CFNumberValidator)validator).setUpperBound(false, Cast._double(max));
            }
        } else if (this.validate.equalsIgnoreCase("integer")) {
            String min = validateOptions.get("min");
            String max = validateOptions.get("max");
            if (min != null || max != null) {
                validator = new CFIntegerValidator();
            }
            if (min != null) {
                ((CFIntegerValidator)validator).setLowerBound(false, Cast._double(min));
            }
            if (max != null) {
                ((CFIntegerValidator)validator).setUpperBound(false, Cast._double(max));
            }
        } else if (this.validate.equalsIgnoreCase("string")) {
            String min = validateOptions.get("minLength");
            String max = validateOptions.get("maxLength");
            if (min != null || max != null) {
                validator = new CFStringValidator();
            }
            if (min != null) {
                ((CFStringValidator)validator).setLowerBound(Cast._int(min));
            }
            if (max != null) {
                ((CFStringValidator)validator).setUpperBound(Cast._int(max));
            }
        } else if (this.validate.equalsIgnoreCase("regex")) {
            String pattern = validateOptions.get("pattern");
            if (pattern == null) {
                throw new RegexPatternNotFoundException(this.propertyName);
            }
            validator = CFTypeValidatorFactory.getRegExValidator(pattern);
        }
        return validator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected String[] getParamList() {
        return new String[]{this.propertyName};
    }

    @Override
    public Object getMetadata() {
        return this.metadata;
    }

    @Override
    public String getPagePath() {
        return this.pagePath;
    }

    static {
        primitives.put("byte", "");
        primitives.put("char", "");
        primitives.put("short", "");
        primitives.put("int", "");
        primitives.put("long", "");
        primitives.put("float", "");
        primitives.put("double", "");
        primitives.put("boolean", "");
        cftypes.put("boolean", "");
        cftypes.put("string", "");
        cftypes.put("numeric", "");
        cftypes.put("date", "");
        cftypes.put("array", "");
        cftypes.put("struct", "");
        cftypes.put("query", "");
        cftypes.put("binary", "");
        cftypes.put("xml", "");
        cftypes.put("guid", "");
        cftypes.put("uuid", "");
    }

    public static class ValidateOptionParseException
    extends ApplicationException {
        public String param;
        public String property;

        public ValidateOptionParseException(String param, String propertyName) {
            this.param = param;
            this.property = propertyName;
        }
    }

    public static class InvalidValidateTypeException
    extends ApplicationException {
        public String validate;
        public String property;

        public InvalidValidateTypeException(String validate, String propertyName) {
            this.validate = validate;
            this.property = propertyName;
        }
    }

    public static class RegexPatternNotFoundException
    extends ApplicationException {
        public String property;

        public RegexPatternNotFoundException(String property) {
            this.property = property;
        }
    }
}

