/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.HashMapBasedInterfaceProxyCache;
import coldfusion.runtime.InterfaceRuntimeExceptions;
import coldfusion.runtime.InterfaceTemplateProxyCacheType;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.SoftCacheBasedInterfaceProxyCache;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyDependencyCache;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.server.ServiceFactory;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;

public class InterfaceTemplateProxyCache {
    private InterfaceTemplateProxyCacheType proxyCache;
    private static InterfaceTemplateProxyCache theInstance = new InterfaceTemplateProxyCache();

    private InterfaceTemplateProxyCache() {
        String proxyType = System.getProperty("IProxyCacheType");
        this.proxyCache = proxyType != null && proxyType.equals("2") ? new HashMapBasedInterfaceProxyCache() : new SoftCacheBasedInterfaceProxyCache();
    }

    public static InterfaceTemplateProxyCache getInstance() {
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTemplateChanged(String interfacePath) {
        HashMap tmpObj = null;
        InterfaceTemplateProxyCacheType interfaceTemplateProxyCacheType = this.proxyCache;
        synchronized (interfaceTemplateProxyCacheType) {
            tmpObj = this.proxyCache.get(interfacePath);
        }
        if (tmpObj != null) {
            HashMap info = tmpObj;
            long creationTime = 0L;
            HashMap hashMap = info;
            synchronized (hashMap) {
                creationTime = (Long)info.get("CreationTime");
            }
            long fileLastModified = TemplateClassLoader.getLastModifiedTime(interfacePath);
            return fileLastModified <= 0L || fileLastModified > creationTime;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateProxy getTemplateProxyFromPath(String interfacePath, NeoPageContext pageContext, HashSet parentClasses) throws Throwable {
        HashMap tmpObj;
        TemplateProxy proxy = null;
        if (parentClasses == null) {
            parentClasses = new HashSet();
        }
        if ((tmpObj = this.proxyCache.get(interfacePath)) != null && !ServiceFactory.getRuntimeService().isTrustedCache()) {
            HashMap info = tmpObj;
            long creationTime = 0L;
            HashMap hashMap = info;
            synchronized (hashMap) {
                creationTime = (Long)info.get("CreationTime");
            }
            long fileLastModified = TemplateClassLoader.getLastModifiedTime(interfacePath);
            if (fileLastModified > 0L && fileLastModified <= creationTime && (proxy = this.proxyCache.getProxyFromInfoMap(info)) != null && proxy.isParentInterfaceChanged(pageContext, parentClasses)) {
                proxy = null;
                parentClasses = null;
            }
        }
        if (proxy == null) {
            proxy = TemplateProxyFactory.resolveName(pageContext, VFSFileFactory.getFileObject(interfacePath), null, true, parentClasses);
            long creationTime = Calendar.getInstance().getTime().getTime();
            this.setTemplateProxy(interfacePath, proxy, creationTime);
            TemplateProxyDependencyCache.getInstance().markDependencyVerified(proxy.page.getPagePath());
        }
        return proxy;
    }

    private String getSiteNamePrefixedKey(String path) {
        Object prefixedPath = path;
        FusionContext.getCurrent();
        String siteName = FusionContext.getSiteName();
        if (siteName != null) {
            siteName = siteName.trim();
            prefixedPath = siteName + path;
        }
        return prefixedPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateProxy getTemplateProxyFromChildPath(TemplateProxy childProxy, String parent, String childFullName, NeoPageContext pageContext, HashSet parentClasses, boolean hasParentChanged) throws Throwable {
        HashMap tmpObj;
        TemplateProxy proxy = null;
        String parentKey = this.getSiteNamePrefixedKey(parent);
        if (parentClasses == null) {
            parentClasses = new HashSet();
        }
        if ((tmpObj = this.proxyCache.get(parentKey)) != null) {
            HashMap info = tmpObj;
            if (ServiceFactory.getRuntimeService().isTrustedCache()) {
                proxy = this.proxyCache.getProxyFromInfoMap(info);
            } else {
                long creationTime = 0L;
                HashMap hashMap = info;
                synchronized (hashMap) {
                    creationTime = (Long)info.get("CreationTime");
                }
                long fileLastModified = TemplateClassLoader.getLastModifiedTime(this.proxyCache.getProxyFromInfoMap((HashMap)info).page.getPagePath());
                if (fileLastModified <= creationTime && (proxy = this.proxyCache.getProxyFromInfoMap(info)) != null && hasParentChanged) {
                    proxy = null;
                    parentClasses = null;
                }
            }
        }
        if (proxy == null) {
            File resolvedChildFile = new File(childProxy.page.getPagePath());
            Object[] superInfo = null;
            try {
                superInfo = TemplateProxyFactory.resolveSuperPath(resolvedChildFile, parent, childFullName, pageContext);
            }
            catch (TemplateProxyFactory.InvalidComponentNameException e) {
                InterfaceRuntimeExceptions.throwInvalidSuperNameException(parent, childFullName);
            }
            File superFile = (File)superInfo[0];
            String superName = superInfo[1] == null ? parent : (String)superInfo[1];
            proxy = TemplateProxyFactory.resolveName(proxy, FusionContext.getCurrent().pageContext, Utils.getCanonicalFile(superFile.getPath()), superName, true, null, null, false);
            long creationTime = Calendar.getInstance().getTime().getTime();
            this.setTemplateProxy(parentKey, proxy, creationTime);
        }
        return proxy;
    }

    public TemplateProxy setTemplateProxy(String interfaceFilePath, TemplateProxy proxy, long creationTime) {
        proxy.setProxyCreationTime(creationTime);
        if (!proxy.isInterface()) {
            return null;
        }
        HashMap<String, Serializable> info = new HashMap<String, Serializable>();
        info.put("proxy", proxy);
        info.put("CreationTime", new Long(creationTime));
        this.proxyCache.put(interfaceFilePath, info);
        return proxy;
    }

    public boolean containsProxy(String templatePath) {
        return this.getTemplateProxy(templatePath) != null;
    }

    public TemplateProxy getTemplateProxy(String interfacePath) {
        HashMap obj = this.proxyCache.get(interfacePath);
        if (obj == null) {
            return null;
        }
        HashMap info = obj;
        return this.proxyCache.getProxyFromInfoMap(info);
    }
}

