/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.J2eeSessionScopeStub;
import coldfusion.runtime.SessionScope;
import coldfusion.runtime.SessionTracker;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class J2eeSessionScope
extends SessionScope {
    private static final long serialVersionUID = 1L;
    private transient HttpSession mHttpServletSession;
    private transient J2eeSessionScopeStub stub;

    J2eeSessionScope(HttpSession session, String appName) {
        super(appName);
        this.mHttpServletSession = session;
        this.stub = new J2eeSessionScopeStub((Map)this);
        session.setAttribute(this.mAppName, (Object)this.stub);
    }

    public void setJ2eeSessionScopeStub(J2eeSessionScopeStub stub) {
        this.stub = stub;
    }

    @Override
    public void CleanUp() {
        try {
            this.clearCSRFMap();
            this.mHttpServletSession.removeAttribute(this.mAppName);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public boolean IsJ2eeSession() {
        return true;
    }

    @Override
    public String getSessionId() {
        return this.mHttpServletSession.getId();
    }

    @Override
    protected void bind(String name, Object value) {
        this.mLastAccess = System.currentTimeMillis();
        this.mTable.put(name, value);
    }

    @Override
    protected void unbind(String name) {
        this.mLastAccess = System.currentTimeMillis();
        this.mTable.remove(name);
    }

    @Override
    protected Object resolve(String name) {
        this.mLastAccess = System.currentTimeMillis();
        return this.mTable.get(name);
    }

    @Override
    public Object put(Object key, Object value) {
        this.mHttpServletSession.setAttribute(this.mAppName, (Object)this.stub);
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        this.mHttpServletSession.setAttribute(this.mAppName, (Object)this.stub);
        return super.remove(key);
    }

    @Override
    public Iterator getNames() {
        return this.mTable.keySet().iterator();
    }

    @Override
    public void SetMaxInactiveInterval(long max) {
        super.SetMaxInactiveInterval(max);
        if (this.mHttpServletSession != null && max > (long)this.mHttpServletSession.getMaxInactiveInterval()) {
            this.mHttpServletSession.setMaxInactiveInterval((int)(max + (long)(SessionTracker.mSweepInterval / 1000)));
        }
    }

    public void setHttpServletSession(HttpSession httpServletSession) {
        this.mHttpServletSession = httpServletSession;
    }

    @Override
    protected void setSessionData(HttpSession session, HashMap<String, Object> attributes) {
        this.mHttpServletSession = session;
        this.stub = new J2eeSessionScopeStub((Map)this);
        this.mHttpServletSession.setAttribute(this.mAppName, (Object)this.stub);
    }
}

