/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.log.Logger;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.ClientScope;
import coldfusion.runtime.ClientScopeDBException;
import coldfusion.runtime.ClientScopeKey;
import coldfusion.runtime.ClientUtil;
import coldfusion.runtime.LockManager;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.PersistenceHelperInterface;
import coldfusion.server.LoggingService;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.CFDataSource;
import coldfusion.sql.DataSrcImpl;
import coldfusion.util.RB;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.sql.DataSource;

final class JDBCHelper
implements PersistenceHelperInterface {
    static final int CFID_FIELD_LENGTH = 64;
    static final int RETRY_ON_DEAD_LOCK_COUNT = 4;
    static final int RETRY_INTERVAL = 250;
    private static final long LOCK_TIMEOUT = 60000L;
    private String mDSName = null;

    public JDBCHelper(String dsname) {
        this.mDSName = dsname;
    }

    private Logger getLogger() {
        LoggingService s = ServiceFactory.getLoggingService();
        return s.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ClientScope Get(NeoPageContext pageContext, ClientScopeKey key) {
        ClientScope retval = null;
        Connection connection = null;
        boolean trans_supported = true;
        String lockName = Integer.toString(key.hashCode()) + "Client";
        for (int retryCount = 0; retryCount < 4; ++retryCount) {
            if (retryCount > 0) {
                this.getLogger().info("client variable JDBC GET - retry " + retryCount);
            }
            boolean lockObtained = false;
            try {
                connection = this.createConnection(connection);
                trans_supported = connection.getMetaData().supportsTransactions();
                if (trans_supported) {
                    connection.setAutoCommit(false);
                }
                LockManager.get().requestNamedLock(lockName, true, 60000L);
                lockObtained = true;
                retval = this._Get(pageContext, connection, key);
                if (!trans_supported) break;
                connection.commit();
                break;
            }
            catch (Exception e) {
                try {
                    if (trans_supported) {
                        connection.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.getLogger().info(e.getMessage());
                if (retryCount == 3) {
                    this.getLogger().warn("Failed to load CLIENT variables from datasource " + this.mDSName + " - " + e.getMessage());
                    throw new ClientScopeDBException(this.mDSName, e.toString());
                }
                try {
                    Thread.sleep(Math.round(250.0 * (1.0 + Math.random())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
            finally {
                try {
                    if (lockObtained) {
                        LockManager.get().releaseNamedLock(lockName, true);
                    }
                }
                catch (Exception exception) {}
                this.close(connection);
            }
        }
        return retval;
    }

    private void close(Connection connection) {
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Connection createConnection(Connection connection) throws SQLException {
        DataSrcImpl ds = new DataSrcImpl();
        ds.setDatasrc(this.mDSName);
        ds.validate();
        DataSource datasrc = (DataSource)ds.getDatasrc();
        String u = ds.getUsername();
        String p = ds.getPassword();
        if (datasrc instanceof CFDataSource && ServiceFactory.getDataSourceService().disableConnection(ds.getName())) {
            throw new SQLException(RB.getString(this, "DataSrcImpl.2"));
        }
        connection = u == null || u.length() == 0 ? datasrc.getConnection() : datasrc.getConnection(u, p);
        return connection;
    }

    private ClientScope _Get(NeoPageContext pageContext, Connection DBConnection, ClientScopeKey key) throws Exception {
        String CData = null;
        String CGlobal = null;
        PreparedStatement ps = DBConnection.prepareStatement("select cfid,app,data from CDATA where cfid = ? and app = ?", 1004, 1007);
        StringBuffer strbuf1 = new StringBuffer(key.mCFID);
        strbuf1.append(':');
        strbuf1.append(key.mCFToken);
        StringBuffer strbuf2 = new StringBuffer(key.mApplicationName);
        while (strbuf1.length() < 64) {
            strbuf1.append(' ');
        }
        while (strbuf2.length() < 64) {
            strbuf2.append(' ');
        }
        ps.setString(1, strbuf1.toString());
        ps.setString(2, strbuf2.toString());
        ResultSet dbResultSet = ps.executeQuery();
        while (dbResultSet.next()) {
            CData = dbResultSet.getString(3);
        }
        dbResultSet.close();
        ps.close();
        ps = DBConnection.prepareStatement("select data from CGLOBAL where cfid = ?", 1004, 1007);
        ps.setString(1, strbuf1.toString());
        dbResultSet = ps.executeQuery();
        while (dbResultSet.next()) {
            CGlobal = dbResultSet.getString(1);
        }
        dbResultSet.close();
        ps.close();
        Hashtable ClientData = ClientUtil.UnPack(CData);
        Hashtable ClientGlobal = ClientUtil.UnPack(CGlobal);
        if (ClientGlobal.size() < 5) {
            OleDateTime now = new OleDateTime(new Date());
            ClientGlobal.put("timecreated", now);
            ClientGlobal.put("lastvisit", now);
            ClientGlobal.put("hitcount", new Integer(1));
            ClientGlobal.put("cfid", key.mCFID);
            ClientGlobal.put("cftoken", key.mCFToken);
        }
        ClientData.putAll(ClientGlobal);
        ClientScope retval = new ClientScope(pageContext, key, ClientData);
        retval.setIsNew(CData == null && CGlobal == null);
        return retval;
    }

    private Timestamp EscapeJavaDate(Object o) {
        Timestamp retval = null;
        if (o instanceof String) {
            Date date = CFPage.ParseDateTime((String)o);
            retval = new Timestamp(date.getTime());
        }
        if (o instanceof Date) {
            retval = new Timestamp(((Date)o).getTime());
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void Store(NeoPageContext pageContext, ClientScope clientScope, boolean globalUpdateDisabled) {
        Connection connection = null;
        boolean trans_supported = true;
        String lockName = Integer.toString(clientScope.getKey().hashCode()) + "Client";
        for (int retryCount = 0; retryCount < 4; ++retryCount) {
            if (retryCount > 0) {
                this.getLogger().info("client variable JDBC STORE - retry " + retryCount);
            }
            boolean lockObtained = false;
            try {
                connection = this.createConnection(connection);
                trans_supported = connection.getMetaData().supportsTransactions();
                if (trans_supported) {
                    connection.setAutoCommit(false);
                }
                LockManager.get().requestNamedLock(lockName, false, 60000L);
                lockObtained = true;
                this._Store(pageContext, connection, clientScope, globalUpdateDisabled);
                if (!trans_supported) break;
                connection.commit();
                break;
            }
            catch (Exception e) {
                this.getLogger().info(e.getMessage());
                try {
                    if (trans_supported) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (retryCount == 3) {
                    this.getLogger().warn("Failed to store CLIENT variables to datasource " + this.mDSName + " - " + e.getMessage());
                    throw new ClientScopeDBException(this.mDSName, e.getMessage());
                }
                try {
                    Thread.sleep(Math.round(250.0 * (1.0 + Math.random())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
            finally {
                try {
                    if (lockObtained) {
                        LockManager.get().releaseNamedLock(lockName, false);
                    }
                }
                catch (Exception exception) {}
                this.close(connection);
            }
        }
    }

    private void _Store(NeoPageContext pageContext, Connection DBConnection, ClientScope clientScope, boolean globalUpdateDisabled) throws Exception {
        ClientScopeKey key = clientScope.getKey();
        StringBuffer strbuf1 = new StringBuffer(key.mCFID);
        strbuf1.append(':');
        strbuf1.append(key.mCFToken);
        StringBuffer strbuf2 = new StringBuffer(key.mApplicationName);
        while (strbuf1.length() < 64) {
            strbuf1.append(' ');
        }
        while (strbuf2.length() < 64) {
            strbuf2.append(' ');
        }
        String CFID_PADDED = strbuf1.toString();
        String APPNAME_PADDED = strbuf2.toString();
        if (clientScope.isDirty()) {
            this.storeClientVars(DBConnection, clientScope, CFID_PADDED, APPNAME_PADDED);
        }
        if (!globalUpdateDisabled || clientScope.isDirty()) {
            this.storeGlobalVars(DBConnection, CFID_PADDED, clientScope);
        }
    }

    private void storeClientVars(Connection DBConnection, ClientScope clientScope, String cfId, String appName) throws SQLException {
        Hashtable clientVars = clientScope.getClientVars();
        String clientStr = ClientUtil.Pack(clientVars);
        if (clientStr.length() == 0) {
            clientStr = " ";
        }
        String query = "select cfid from CDATA where cfid = ? and app = ?";
        PreparedStatement ps = DBConnection.prepareStatement(query);
        ps.setString(1, cfId);
        ps.setString(2, appName);
        ResultSet dbResultSet = ps.executeQuery();
        boolean rowExists = false;
        boolean rowUpdated = false;
        if (dbResultSet.next()) {
            rowExists = true;
        }
        dbResultSet.close();
        ps.close();
        if (!rowExists) {
            ps = DBConnection.prepareStatement("insert into CDATA (cfid,app,data) values (?,?,?)");
            ps.setString(1, cfId);
            ps.setString(2, appName);
            ps.setString(3, clientStr);
            ps.executeUpdate();
            ps.close();
        } else if (!rowUpdated) {
            ps = DBConnection.prepareStatement("update CDATA set data = ? where cfid = ? and app = ?");
            ps.setString(1, clientStr);
            ps.setString(2, cfId);
            ps.setString(3, appName);
            ps.executeUpdate();
            ps.close();
        }
    }

    private void storeGlobalVars(Connection DBConnection, String CFID_PADDED, ClientScope clientScope) throws SQLException {
        Hashtable globalVars = clientScope.getGlobalVars();
        String globalStr = ClientUtil.Pack(globalVars);
        if (globalStr.length() == 0) {
            globalStr = " ";
        }
        DatabaseMetaData dbmd = DBConnection.getMetaData();
        String query = "select cfid from CGLOBAL where cfid = ?";
        PreparedStatement ps = DBConnection.prepareStatement(query);
        ps.setString(1, CFID_PADDED);
        ResultSet dbResultSet = ps.executeQuery();
        boolean rowExists = false;
        boolean rowUpdated = false;
        if (dbResultSet.next()) {
            rowExists = true;
        }
        dbResultSet.close();
        ps.close();
        if (!rowExists) {
            ps = DBConnection.prepareStatement("insert into CGLOBAL (cfid,data,lvisit) values (?,?,?)");
            ps.setString(1, CFID_PADDED);
            ps.setString(2, globalStr);
            ps.setTimestamp(3, this.EscapeJavaDate(globalVars.get("lastvisit")));
            ps.executeUpdate();
            ps.close();
        } else if (!rowUpdated) {
            ps = DBConnection.prepareStatement("update CGLOBAL set data =?,lvisit =? where cfid =?");
            ps.setString(1, globalStr);
            ps.setTimestamp(2, this.EscapeJavaDate(globalVars.get("lastvisit")));
            ps.setString(3, CFID_PADDED);
            ps.executeUpdate();
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(LinkedList<ClientScopeKey> clientScopeKeyList) {
        Connection connection = null;
        boolean trans_supported = true;
        String lockName = Integer.toString(clientScopeKeyList.getFirst().hashCode()) + "Client";
        for (int retryCount = 0; retryCount < 4; ++retryCount) {
            if (retryCount > 0) {
                this.getLogger().info("client variable JDBC STORE - retry " + retryCount);
            }
            boolean lockObtained = false;
            try {
                connection = this.createConnection(connection);
                trans_supported = connection.getMetaData().supportsTransactions();
                if (trans_supported) {
                    connection.setAutoCommit(false);
                }
                LockManager.get().requestNamedLock(lockName, false, 60000L);
                lockObtained = true;
                this._remove(connection, clientScopeKeyList);
                if (!trans_supported) break;
                connection.commit();
                break;
            }
            catch (Exception e) {
                this.getLogger().info(e.getMessage());
                try {
                    if (trans_supported) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (retryCount == 3) {
                    this.getLogger().warn("Failed to store CLIENT variables to datasource " + this.mDSName + " - " + e.getMessage());
                    throw new ClientScopeDBException(this.mDSName, e.getMessage());
                }
                try {
                    Thread.sleep(Math.round(250.0 * (1.0 + Math.random())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
            finally {
                try {
                    if (lockObtained) {
                        LockManager.get().releaseNamedLock(lockName, false);
                    }
                }
                catch (Exception exception) {}
                this.close(connection);
            }
        }
    }

    private void _remove(Connection DBConnection, LinkedList<ClientScopeKey> clientScopeKeyList) throws Exception {
        ListIterator listIterator = clientScopeKeyList.listIterator();
        while (listIterator.hasNext()) {
            ClientScopeKey key = (ClientScopeKey)listIterator.next();
            StringBuffer strbuf1 = new StringBuffer(key.mCFID);
            strbuf1.append(':');
            strbuf1.append(key.mCFToken);
            StringBuffer strbuf2 = new StringBuffer(key.mApplicationName);
            while (strbuf1.length() < 64) {
                strbuf1.append(' ');
            }
            while (strbuf2.length() < 64) {
                strbuf2.append(' ');
            }
            String CFID_PADDED = strbuf1.toString();
            String APPNAME_PADDED = strbuf2.toString();
            try {
                this.removeClientVars(DBConnection, CFID_PADDED, APPNAME_PADDED);
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
            }
            try {
                this.removeGlobalVars(DBConnection, CFID_PADDED);
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
            }
            listIterator.remove();
        }
    }

    private void removeClientVars(Connection DBConnection, String cfId, String appName) throws SQLException {
        String query = "delete FROM CDATA WHERE CFID = ? and app = ?";
        PreparedStatement ps = DBConnection.prepareStatement(query);
        ps.setString(1, cfId);
        ps.setString(2, appName);
        ps.executeUpdate();
        ps.close();
    }

    private void removeGlobalVars(Connection DBConnection, String cfid) throws SQLException {
        String query = "delete FROM CGLOBAL WHERE cfid = ?";
        PreparedStatement ps = DBConnection.prepareStatement(query);
        ps.setString(1, cfid);
        ps.executeUpdate();
        ps.close();
    }
}

