/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Array;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.InvalidListIndexException;
import coldfusion.runtime.ListQualifyElementsException;
import coldfusion.runtime.UDFMethod;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.ListTokenizer;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.StringTokenizer;

public class ListFunc {
    public static final String defaultDelim = ",";

    public static String ListAppend(String s, String val, String delim) {
        int delimLen = delim.length();
        if (s.length() == 0) {
            return val;
        }
        if (delimLen > 1) {
            return s + delim.charAt(0) + val;
        }
        return s + delim + val;
    }

    public static String ListAppend(String s, String val, String delim, boolean includeEmptyFields) {
        int delimLen = delim.length();
        if (!includeEmptyFields) {
            if (val.length() == 0) {
                return s;
            }
            val = Utils.hasSurrogateCharacters(delim) ? new ListTokenizer(val, delim).removeEmptyFields() : ListFunc.filterEmptyFields(val, delim);
            if (val.length() == 0) {
                return s;
            }
        }
        if (s.length() == 0) {
            return val;
        }
        if (delimLen > 1) {
            return s + delim.charAt(0) + val;
        }
        return s + delim + val;
    }

    public static String ListChangeDelims(String s, String delim) {
        return ListFunc.ListChangeDelims(s, delim, defaultDelim, false);
    }

    public static String ListChangeDelims(String s, String newd, String oldd, boolean includeEmptyFields) {
        StringBuffer strbuf = new StringBuffer(s.length());
        if (!includeEmptyFields) {
            StringTokenizer t = new StringTokenizer(s, oldd);
            int i = 0;
            while (t.hasMoreTokens()) {
                if (i != 0) {
                    strbuf.append(newd);
                }
                strbuf.append(t.nextToken());
                ++i;
            }
        } else {
            oldd = ListFunc.escapeDelim(oldd, false);
            String[] tokens = s.split(oldd, -1);
            for (int i = 0; i < tokens.length; ++i) {
                if (i != 0) {
                    strbuf.append(newd);
                }
                strbuf.append(tokens[i]);
            }
        }
        return strbuf.toString();
    }

    public static int ListContains(String s, String subs, String delim, boolean includeEmptyFields) {
        boolean singleDelim;
        if (subs.length() == 0) {
            return 0;
        }
        if (delim.isEmpty()) {
            if (includeEmptyFields) {
                int index;
                if (subs.length() == 1 && (index = s.indexOf(subs.charAt(0))) != -1) {
                    return index + 1;
                }
                return 0;
            }
            return s.contains(subs) ? 1 : 0;
        }
        char c = '\u0000';
        if (delim.length() == 1) {
            singleDelim = true;
            c = delim.charAt(0);
            if (subs.indexOf(c) != -1) {
                return 0;
            }
        } else {
            if (Utils.hasSurrogateCharacters(delim)) {
                return new ListTokenizer(s, delim).containsToken(subs, includeEmptyFields);
            }
            singleDelim = false;
            for (int i = 0; i < subs.length(); ++i) {
                if (delim.indexOf(subs.charAt(i)) <= -1) continue;
                return 0;
            }
        }
        int len = s.length();
        int lastDelimiter = -1;
        int count = 0;
        int vLen = subs.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) continue;
            if (lastDelimiter + 1 == i) {
                if (includeEmptyFields) {
                    ++count;
                }
                lastDelimiter = i;
                continue;
            }
            if (vLen <= i - lastDelimiter - 1 && Utils.contains(s, subs, lastDelimiter == -1 ? 0 : lastDelimiter + 1, i - 1) != -1) {
                return ++count;
            }
            lastDelimiter = i;
            ++count;
        }
        if (lastDelimiter < len - 1 && vLen <= (lastDelimiter == -1 ? len : len - lastDelimiter) && s.indexOf(subs, lastDelimiter == -1 ? 0 : lastDelimiter + 1) > -1) {
            return ++count;
        }
        return 0;
    }

    public static int ListContainsNoCase(String s, String subs, String d, boolean includeEmptyFields) {
        return ListFunc.ListContains(s.toUpperCase(), subs.toUpperCase(), d, includeEmptyFields);
    }

    public static String ListDeleteAt(String s, int pos, String delim, boolean includeEmptyFields) {
        boolean singleDelim;
        int len = s.length();
        if (len == 0) {
            if (includeEmptyFields && pos == 1) {
                return "";
            }
            throw new InvalidListIndexException("ListDeleteAt", pos, 0);
        }
        char c = '\u0000';
        if (delim.length() == 1) {
            singleDelim = true;
            c = delim.charAt(0);
        } else {
            if (Utils.hasSurrogateCharacters(delim)) {
                return new ListTokenizer(s, delim).deleteToken(pos, includeEmptyFields);
            }
            singleDelim = false;
        }
        int lastDelimiter = -1;
        int firstDelimiterOfItem = -1;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) continue;
            if (!includeEmptyFields && lastDelimiter + 1 == i) {
                lastDelimiter = i;
                continue;
            }
            if (++count == pos) {
                if (!includeEmptyFields) {
                    while (i + 1 < len) {
                        ch = s.charAt(i + 1);
                        if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) break;
                        ++i;
                    }
                }
                if (lastDelimiter == -1) {
                    if (i >= len - 1) {
                        return "";
                    }
                    return s.substring(i + 1);
                }
                if (i >= len - 1) {
                    if (includeEmptyFields) {
                        return s.substring(0, lastDelimiter + 1);
                    }
                    if (pos == 1) {
                        return "";
                    }
                    return s.substring(0, firstDelimiterOfItem);
                }
                return s.substring(0, lastDelimiter + 1) + s.substring(i + 1);
            }
            lastDelimiter = firstDelimiterOfItem = i;
        }
        if (lastDelimiter == -1) {
            if (pos == 1) {
                return "";
            }
        } else if (lastDelimiter < len - 1) {
            if (pos == 1 && !includeEmptyFields) {
                return "";
            }
            if (++count == pos) {
                if (!includeEmptyFields) {
                    return s.substring(0, firstDelimiterOfItem);
                }
                return s.substring(0, lastDelimiter);
            }
        } else if (includeEmptyFields && pos == ++count) {
            return s.substring(0, len - 1);
        }
        throw new InvalidListIndexException("ListDeleteAt", pos, count);
    }

    public static int ListFind(String s, String val, String delim, boolean includeEmptyFields) {
        boolean singleDelim;
        int len = s.length();
        if (delim.length() == 0) {
            if (!includeEmptyFields) {
                if (s.equals(val)) {
                    return 1;
                }
                return 0;
            }
            if (val.isEmpty()) {
                return len + 1;
            }
            if (val.length() == 1) {
                char ch = val.charAt(0);
                for (int i = 0; i < len; ++i) {
                    if (ch != s.charAt(i)) continue;
                    return i + 1;
                }
            }
            return 0;
        }
        char c = '\u0000';
        if (delim.length() == 1) {
            singleDelim = true;
            c = delim.charAt(0);
        } else {
            if (Utils.hasSurrogateCharacters(delim)) {
                return new ListTokenizer(s, delim).findToken(val, includeEmptyFields);
            }
            singleDelim = false;
        }
        int lastDelimiter = -1;
        int count = 0;
        int vLen = val.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) continue;
            if (!includeEmptyFields && lastDelimiter + 1 == i) {
                lastDelimiter = i;
                continue;
            }
            if (vLen == i - lastDelimiter - 1 && s.regionMatches(lastDelimiter == -1 ? 0 : lastDelimiter + 1, val, 0, vLen)) {
                return ++count;
            }
            lastDelimiter = i;
            ++count;
        }
        if (lastDelimiter < len - 1 ? vLen == (lastDelimiter == -1 ? len : len - 1 - lastDelimiter) && s.regionMatches(lastDelimiter == -1 ? 0 : lastDelimiter + 1, val, 0, vLen) : includeEmptyFields && "".equals(val)) {
            return ++count;
        }
        return 0;
    }

    public static String ListRemoveDuplicates(String s, String d, boolean ignoreCase) {
        StringBuilder sb = new StringBuilder();
        Map map = ignoreCase ? new CaseInsensitiveMap() : new HashMap();
        StringTokenizer t = new StringTokenizer(s, d);
        boolean first = true;
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (map.get(token) != null) continue;
            if (!first) {
                sb.append(d);
            } else {
                first = false;
            }
            sb.append(token);
            map.put(token, "");
        }
        return sb.toString();
    }

    public static String ListGetDuplicates(String list, String delimiter, boolean ignoreCase, boolean includeEmptyFields) {
        StringJoiner result = new StringJoiner(delimiter);
        Map map = ignoreCase ? new CaseInsensitiveMap() : new HashMap();
        String[] tokens = list.split(delimiter);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
            if (!includeEmptyFields && "".equals(tokens[i])) continue;
            int tokenCount = map.getOrDefault(tokens[i], 0) + 1;
            map.put(tokens[i], tokenCount);
            if (tokenCount != 2) continue;
            result.add(tokens[i]);
        }
        return result.toString();
    }

    public static int ListFindNoCase(String s, String val, String d, boolean includeEmptyFields) {
        return ListFunc.ListFind(s.toUpperCase(), val.toUpperCase(), d.toUpperCase(), includeEmptyFields);
    }

    public static String ListFirst(String s, String delim, boolean includeEmptyFields) {
        boolean singleDelim;
        int len = s.length();
        if (len == 0) {
            return s;
        }
        if (delim.length() == 0) {
            char firstChar = s.charAt(0);
            return Character.toString(firstChar);
        }
        char c = '\u0000';
        if (delim.length() == 1) {
            singleDelim = true;
            c = delim.charAt(0);
        } else {
            if (Utils.hasSurrogateCharacters(delim)) {
                return new ListTokenizer(s, delim).first(includeEmptyFields);
            }
            singleDelim = false;
        }
        int lastDelimiter = -1;
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) continue;
            if (!includeEmptyFields && lastDelimiter + 1 == i) {
                lastDelimiter = i;
                continue;
            }
            return s.substring(lastDelimiter + 1, i);
        }
        if (lastDelimiter < len - 1) {
            return s.substring(lastDelimiter + 1);
        }
        return "";
    }

    public static String ListGetAt(String s, int p, String delim, boolean includeEmptyFields) {
        boolean singleDelim;
        if (p < 1) {
            throw new InvalidListIndexException("ListGetAt", p, new ListTokenizer(s, delim).count(includeEmptyFields));
        }
        int len = s.length();
        if (delim.length() == 0) {
            if (includeEmptyFields) {
                if (p > len + 1) {
                    throw new InvalidListIndexException("ListGetAt", p, len + 1);
                }
                if (p == len + 1) {
                    return "";
                }
                return String.valueOf(s.charAt(p - 1));
            }
            if (p == 1) {
                return s;
            }
            throw new InvalidListIndexException("ListGetAt", p, 1);
        }
        char c = '\u0000';
        if (delim.length() == 1) {
            singleDelim = true;
            c = delim.charAt(0);
        } else {
            if (Utils.hasSurrogateCharacters(delim)) {
                return new ListTokenizer(s, delim).getToken(p, includeEmptyFields);
            }
            singleDelim = false;
        }
        int lastDelimiter = -1;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) continue;
            if (!includeEmptyFields && lastDelimiter + 1 == i) {
                lastDelimiter = i;
                continue;
            }
            if (++count == p) {
                return s.substring(lastDelimiter + 1, i);
            }
            lastDelimiter = i;
        }
        if (lastDelimiter < len - 1) {
            if (p == ++count) {
                return s.substring(lastDelimiter + 1);
            }
        } else if (includeEmptyFields && p == ++count) {
            return "";
        }
        throw new InvalidListIndexException("ListGetAt", p, count);
    }

    public static String ListInsertAt(String s, int pos, String val, String delim, boolean includeEmptyFields) {
        boolean singleDelim;
        if (pos < 1) {
            throw new InvalidListIndexException("ListInsertAt", pos, new ListTokenizer(s, delim).count(includeEmptyFields));
        }
        int len = s.length();
        if (delim.isEmpty()) {
            if (includeEmptyFields) {
                if (pos > len + 1) {
                    throw new InvalidListIndexException("ListInsertAt", pos, len + 1);
                }
                if (pos == len + 1) {
                    return s + val;
                }
                return s.substring(0, pos - 1) + val + s.substring(pos - 1);
            }
            throw new InvalidListIndexException("ListInsertAt", pos, 0);
        }
        char c = '\u0000';
        if (delim.length() == 1) {
            singleDelim = true;
            c = delim.charAt(0);
        } else {
            if (Utils.hasSurrogateCharacters(delim)) {
                return new ListTokenizer(s, delim).insertToken(pos, val, includeEmptyFields);
            }
            singleDelim = false;
        }
        int lastDelimiter = -1;
        if (pos == 1) {
            if (includeEmptyFields) {
                return val + delim.charAt(0) + s;
            }
            if ("".equals(s)) {
                return "";
            }
            int i = 0;
            while (i < len) {
                char ch = s.charAt(i);
                if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) break;
                lastDelimiter = i++;
            }
            if (lastDelimiter == len - 1) {
                return s;
            }
            return s.substring(0, lastDelimiter + 1) + val + delim.charAt(0) + (lastDelimiter == len - 1 ? "" : s.substring(lastDelimiter + 1));
        }
        int count = 0;
        int insertionPoint = 0;
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) continue;
            if (!includeEmptyFields && lastDelimiter + 1 == i) {
                lastDelimiter = i;
                insertionPoint = i + 1;
                continue;
            }
            if (++count == pos) {
                return s.substring(0, insertionPoint) + val + delim.charAt(0) + s.substring(insertionPoint);
            }
            insertionPoint = i + 1;
            lastDelimiter = i;
        }
        if (lastDelimiter > -1 && lastDelimiter < len - 1) {
            if (++count == pos) {
                return s.substring(0, insertionPoint) + val + delim.charAt(0) + s.substring(insertionPoint);
            }
        } else if (includeEmptyFields && ++count == pos) {
            return s + val + delim.charAt(0);
        }
        throw new InvalidListIndexException("ListInsertAt", pos, count);
    }

    public static String ListLast(String s, String delim, boolean includeEmptyFields) {
        boolean singleDelim;
        int len = s.length();
        if (len == 0) {
            return "";
        }
        if (delim.length() == 0) {
            if (!includeEmptyFields) {
                char lastChar = s.charAt(s.length() - 1);
                return Character.toString(lastChar);
            }
            return "";
        }
        char c = '\u0000';
        if (delim.length() == 1) {
            singleDelim = true;
            c = delim.charAt(0);
        } else {
            if (Utils.hasSurrogateCharacters(delim)) {
                return new ListTokenizer(s, delim).lastToken(includeEmptyFields);
            }
            singleDelim = false;
        }
        if (!includeEmptyFields) {
            while (len > 0) {
                ch = s.charAt(len - 1);
                if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) break;
                --len;
            }
            if (len == 0) {
                return "";
            }
        } else {
            ch = s.charAt(len - 1);
            if (singleDelim && ch == c || !singleDelim && delim.indexOf(ch) > -1) {
                return "";
            }
        }
        int lastDelimiter = len;
        for (int i = len - 1; i > -1; --i) {
            char ch = s.charAt(i);
            if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) continue;
            lastDelimiter = i;
            break;
        }
        if (lastDelimiter == len) {
            return s.substring(0, len);
        }
        return s.substring(lastDelimiter + 1, len);
    }

    public static int ListLen(String s, String delim) {
        return ListFunc.ListLen(s, delim, false);
    }

    public static int ListLen(String s, String delim, boolean includeEmptyFields) {
        boolean singleDelim;
        char c = '\u0000';
        int len = s.length();
        if (delim.length() == 1) {
            singleDelim = true;
            c = delim.charAt(0);
        } else {
            if (Utils.hasSurrogateCharacters(delim)) {
                return new ListTokenizer(s, delim).count(includeEmptyFields);
            }
            singleDelim = false;
        }
        int lastDelimiter = -1;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) continue;
            if (!includeEmptyFields && lastDelimiter + 1 == i) {
                lastDelimiter = i;
                continue;
            }
            ++count;
            lastDelimiter = i;
        }
        if (lastDelimiter < len - 1 || includeEmptyFields) {
            return count + 1;
        }
        return count;
    }

    public static String ListPrepend(String s, String val, String delim) {
        if (delim.length() > 1) {
            delim = delim.substring(0, 1);
        }
        if (s.length() == 0) {
            delim = "";
        }
        return val + delim + s;
    }

    public static String ListPrepend(String s, String val, String delim, boolean includeEmptyFields) {
        if (!includeEmptyFields) {
            if (val.length() == 0) {
                return s;
            }
            val = Utils.hasSurrogateCharacters(delim) ? new ListTokenizer(val, delim).removeEmptyFields() : ListFunc.filterEmptyFields(val, delim);
            if (val.length() == 0) {
                return s;
            }
        }
        if (delim.length() > 1) {
            delim = delim.substring(0, 1);
        }
        if (s.length() == 0) {
            delim = "";
        }
        return val + delim + s;
    }

    public static String ListQualify(String list, String qual, String d, String elements, boolean includeEmptyFields) {
        if (elements.equalsIgnoreCase("char")) {
            return ListFunc.ListQualifyStrings(list, qual, d, includeEmptyFields);
        }
        if (elements.equalsIgnoreCase("all")) {
            return ListFunc.ListQualifyAll(list, qual, d, includeEmptyFields);
        }
        throw new ListQualifyElementsException(elements);
    }

    public static String ListQualifyAll(String list, String qual, String d, boolean includeEmptyField) {
        String reald = d.substring(0, 1);
        StringBuffer result = new StringBuffer(list.length() * 3 / 2);
        if (qual.length() == 0) {
            return list;
        }
        if (!includeEmptyField) {
            StringTokenizer t = new StringTokenizer(list, d);
            boolean started = false;
            while (t.hasMoreTokens()) {
                String token = t.nextToken();
                if (started) {
                    result.append(reald);
                }
                result.append(qual).append(token).append(qual);
                started = true;
            }
        } else {
            reald = ListFunc.escapeDelim(reald, false);
            String[] tokens = list.split(reald, -1);
            boolean started = false;
            for (int i = 0; i < tokens.length; ++i) {
                if (started) {
                    result.append(d);
                }
                result.append(qual).append(tokens[i]).append(qual);
                started = true;
            }
        }
        return result.toString();
    }

    static String ListQualifyStrings(String list, String qual, String d, boolean includeEmptyField) {
        String reald = d.substring(0, 1);
        StringBuffer result = new StringBuffer(list.length() * 3 / 2);
        if (qual.length() == 0) {
            return list;
        }
        if (!includeEmptyField) {
            StringTokenizer t = new StringTokenizer(list, d);
            while (t.hasMoreTokens()) {
                String token = t.nextToken();
                if (result.length() > 0) {
                    result.append(reald);
                }
                try {
                    Double.parseDouble(token);
                    result.append(token);
                }
                catch (IllegalArgumentException ex) {
                    result.append(qual).append(token).append(qual);
                }
            }
        } else {
            reald = ListFunc.escapeDelim(reald, false);
            String[] tokens = list.split(reald, -1);
            for (int i = 0; i < tokens.length; ++i) {
                if (result.length() > 0) {
                    result.append(d);
                }
                try {
                    Double.parseDouble(tokens[i]);
                    result.append(tokens[i]);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    result.append(qual).append(tokens[i]).append(qual);
                }
            }
        }
        return result.toString();
    }

    public static String ListRest(String s, String delim, boolean includeEmptyFields) {
        boolean singleDelim;
        char c = '\u0000';
        int len = s.length();
        if (delim.length() == 1) {
            singleDelim = true;
            c = delim.charAt(0);
        } else {
            if (Utils.hasSurrogateCharacters(delim)) {
                return new ListTokenizer(s, delim).restOfList(includeEmptyFields);
            }
            singleDelim = false;
        }
        int lastDelimiter = -1;
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) continue;
            if (!includeEmptyFields && lastDelimiter + 1 == i) {
                lastDelimiter = i;
                continue;
            }
            if (!includeEmptyFields) {
                while (i + 1 < len) {
                    ch = s.charAt(i + 1);
                    if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) break;
                    ++i;
                }
            }
            if (i >= len) continue;
            return s.substring(i + 1);
        }
        return "";
    }

    public static String ListFilter(String list, UDFMethod filterFunc, String delim, boolean includeEmptyFields) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        StringBuilder result_list = new StringBuilder();
        List tokens = ListFunc.getList(list, delim, includeEmptyFields);
        boolean started = false;
        for (int i = 0; i < tokens.size(); ++i) {
            String token = (String)tokens.get(i);
            if (!includeEmptyFields && "".equals(token.trim())) continue;
            try {
                Object[] args = new Object[]{token, i + 1, list, delim, includeEmptyFields};
                Object retVal = CFPage._invokeUDF((Object)filterFunc, filterFunc.getName(), cfpage, args);
                if (retVal == null) {
                    throw new InvalidReturnTypeForListFilterException();
                }
                if (!Cast._boolean(retVal)) continue;
                if (started && !token.equals(delim)) {
                    result_list.append(delim.substring(0, 1));
                }
                result_list.append(token);
                started = true;
                continue;
            }
            catch (Cast.BooleanConversionException ex) {
                throw new InvalidReturnTypeForListFilterException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new InvalidReturnTypeForListFilterException();
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return result_list.toString();
    }

    private static boolean isValidToken(String token, String delim) {
        return token.length() != 1 || delim.indexOf(token) <= -1;
    }

    public static String ListSetAt(String s, int pos, String val, String delim, boolean includeEmptyFields) {
        boolean singleDelim;
        int len = s.length();
        if (delim.isEmpty()) {
            if (includeEmptyFields) {
                if (pos > len + 1) {
                    throw new InvalidListIndexException("ListSetAt", pos, len + 1);
                }
                if (pos == len + 1) {
                    return s + val;
                }
                return s.substring(0, pos - 1) + val + s.substring(pos);
            }
            if (pos == 1 && len > 0) {
                return s;
            }
            throw new InvalidListIndexException("ListSetAt", pos, len > 0 ? 1 : 0);
        }
        char c = '\u0000';
        if (delim.length() == 1) {
            singleDelim = true;
            c = delim.charAt(0);
        } else {
            if (Utils.hasSurrogateCharacters(delim)) {
                return new ListTokenizer(s, delim).setToken(pos, val, includeEmptyFields);
            }
            singleDelim = false;
        }
        if (len == 0) {
            if (includeEmptyFields && pos == 1) {
                return val + delim.charAt(0);
            }
            throw new InvalidListIndexException("ListSetAt", pos, 0);
        }
        int lastDelimiter = -1;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) continue;
            if (!includeEmptyFields && lastDelimiter + 1 == i) {
                lastDelimiter = i;
                continue;
            }
            if (++count == pos) {
                if (!includeEmptyFields) {
                    int k = i;
                    for (int j = i + 1; j < len; ++j) {
                        char ch1 = s.charAt(j);
                        if ((!singleDelim || ch1 != c) && (singleDelim || delim.indexOf(ch1) <= -1)) break;
                        ++i;
                    }
                    return s.substring(0, lastDelimiter + 1) + val + (String)(i == len - 1 ? "" : delim.charAt(0) + s.substring(i + 1));
                }
                return s.substring(0, lastDelimiter + 1) + val + s.substring(i);
            }
            lastDelimiter = i;
        }
        if (lastDelimiter == -1) {
            if (len > 0 && ++count == pos) {
                return val;
            }
        } else {
            if (lastDelimiter < len - 1 && ++count == pos) {
                return s.substring(0, lastDelimiter + 1) + val;
            }
            if (includeEmptyFields && ++count == pos) {
                return s + val + delim.charAt(0);
            }
        }
        throw new InvalidListIndexException("ListSetAt", pos, count);
    }

    public static String ListSort(String list, String type, String order, String delimiter, boolean includeEmptyField, boolean localeSensitive) {
        List array = ListFunc.getList(list, delimiter, includeEmptyField);
        ArrayUtil.ArraySort(array, type, order, localeSensitive);
        if (delimiter.length() > 1) {
            delimiter = delimiter.substring(0, 1);
        }
        return ArrayUtil.ArrayToList(array, delimiter);
    }

    public static String ListSort(String list, Object sortFunc, String delimiter, boolean includeEmptyField) {
        List array = ListFunc.getList(list, delimiter, includeEmptyField);
        ArrayUtil.ArraySort(array, sortFunc);
        if (delimiter.length() > 1) {
            delimiter = delimiter.substring(0, 1);
        }
        return ArrayUtil.ArrayToList(array, delimiter);
    }

    public static void ListEach(String list, UDFMethod closureFunc, String delimiter, boolean includeEmptyField) {
        List array = ListFunc.getList(list, delimiter, includeEmptyField);
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (int i = 0; i < array.size(); ++i) {
            Object item = array.get(i);
            try {
                CFPage._invokeUDF((Object)closureFunc, closureFunc.getName(), cfpage, new Object[]{item, i + 1, list, delimiter, includeEmptyField});
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
    }

    public static String ListMap(String list, UDFMethod callbackFunc, String delimiter, boolean includeEmptyField) {
        List array = ListFunc.getList(list, delimiter, includeEmptyField);
        FusionContext fusionContext = FusionContext.getCurrent();
        Array result = new Array(1, array.size());
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (int i = 0; i < array.size(); ++i) {
            Object item = array.get(i);
            try {
                Object[] args = new Object[]{item, i + 1, list, delimiter, includeEmptyField};
                Object retVal = CFPage._invokeUDF((Object)callbackFunc, callbackFunc.getName(), cfpage, args);
                result.add(retVal);
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return ArrayUtil.ArrayToList(result, delimiter);
    }

    public static Object ListReduce(String list, UDFMethod reduceFunc, Object initialValue, String delimiter, boolean includeEmptyField, boolean reverseOrder) {
        List array = ListFunc.getList(list, delimiter, includeEmptyField);
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        Object result = initialValue;
        int begin = reverseOrder ? array.size() - 1 : 0;
        int end = reverseOrder ? -1 : array.size();
        int increment = reverseOrder ? -1 : 1;
        for (int i = begin; i != end; i += increment) {
            Object item = array.get(i);
            try {
                Object[] args = new Object[]{result, item, i + 1, list, delimiter, includeEmptyField};
                result = CFPage._invokeUDF((Object)reduceFunc, reduceFunc.getName(), cfpage, args);
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return result;
    }

    public static String ListTrim(String s, String delim) {
        StringTokenizer tokenizer = new StringTokenizer(s, delim);
        StringBuffer buff = new StringBuffer(s.length());
        boolean start = false;
        char delimChar = delim.charAt(0);
        while (tokenizer.hasMoreTokens()) {
            if (start) {
                buff.append(delimChar);
            }
            buff.append(tokenizer.nextToken().trim());
            start = true;
        }
        return buff.toString();
    }

    public static Array ListToArray(String s, String delimiter) {
        return ListFunc.ListToArray(s, delimiter, false);
    }

    public static Array ListToArray(String s, String delimiter, boolean includeEmptyFields) {
        return ListFunc.ListToArray(s, delimiter, includeEmptyFields, false);
    }

    public static Array ListToArray(String s, String delimiter, boolean includeEmptyFields, boolean multiCharDelim) {
        Array a = new Array(1);
        delimiter = ListFunc.escapeDelim(delimiter, multiCharDelim);
        String[] tokens = s.split(delimiter, -1);
        if (includeEmptyFields && "".equals(delimiter) && !"".equals(tokens[0])) {
            a.add("");
        }
        for (int i = 0; i < tokens.length; ++i) {
            if (!includeEmptyFields && "".equals(tokens[i])) continue;
            a.add(tokens[i]);
        }
        return a;
    }

    static String escapeDelim(String delim, boolean multiCharDelim) {
        Object escapedDelim = "";
        int size = delim.length();
        for (int i = 0; i < size; ++i) {
            Object escapedChar;
            char delimChar = delim.charAt(i);
            Object object = escapedChar = ListFunc.isRegexChar(delimChar) ? "\\" + delimChar : String.valueOf(delimChar);
            escapedDelim = i == 0 ? escapedChar : (multiCharDelim ? (String)escapedDelim + (String)escapedChar : (String)escapedDelim + "|" + (String)escapedChar);
        }
        return escapedDelim;
    }

    private static boolean isRegexChar(char delimChar) {
        return delimChar == '|' || delimChar == '$' || delimChar == '^' || delimChar == '+' || delimChar == '?' || delimChar == '{' || delimChar == '}' || delimChar == '*' || delimChar == '.' || delimChar == '[' || delimChar == ']' || delimChar == '(' || delimChar == ')' || delimChar == '\\';
    }

    public static List getList(String s, String delimiters) {
        return ListFunc.getList(s, delimiters, false);
    }

    public static List getList(String s, String delimiters, boolean includeEmptyFields) {
        ArrayList<String> list = new ArrayList<String>();
        if (!includeEmptyFields) {
            StringTokenizer t = new StringTokenizer(s, delimiters);
            while (t.hasMoreTokens()) {
                list.add(t.nextToken());
            }
        } else {
            delimiters = ListFunc.escapeDelim(delimiters, false);
            String[] tokens = s.split(delimiters, -1);
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i] != null) {
                    list.add(tokens[i]);
                    continue;
                }
                list.add("");
            }
        }
        return list;
    }

    public static int ListValueCount(String s, String val, String delim) {
        boolean singleDelim;
        int vLen = val.length();
        if (vLen == 0 || delim.length() == 0) {
            return 0;
        }
        char c = '\u0000';
        if (delim.length() == 1) {
            singleDelim = true;
            c = delim.charAt(0);
        } else {
            if (Utils.hasSurrogateCharacters(delim)) {
                return new ListTokenizer(s, delim).valueCount(val);
            }
            singleDelim = false;
        }
        int lastDelimiter = -1;
        int count = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ((!singleDelim || ch != c) && (singleDelim || delim.indexOf(ch) <= -1)) continue;
            if (lastDelimiter + 1 == i) {
                lastDelimiter = i;
                continue;
            }
            if (vLen == i - lastDelimiter - 1 && s.regionMatches(lastDelimiter == -1 ? 0 : lastDelimiter + 1, val, 0, vLen)) {
                ++count;
            }
            lastDelimiter = i;
        }
        if (lastDelimiter < len - 1 && vLen == (lastDelimiter == -1 ? len : len - lastDelimiter - 1) && s.regionMatches(lastDelimiter == -1 ? 0 : lastDelimiter + 1, val, 0, vLen)) {
            return count + 1;
        }
        return count;
    }

    public static int ListValueCountNoCase(String s, String subs, String d) {
        return ListFunc.ListValueCount(s.toUpperCase(), subs.toUpperCase(), d);
    }

    private static String filterEmptyFields(String val, String delim) {
        StringBuilder builder = new StringBuilder();
        int lastDelimiter = -1;
        int valLength = val.length();
        for (int i = 0; i < valLength; ++i) {
            char c = val.charAt(i);
            if (delim.indexOf(c) > -1) {
                if (!ListFunc.isEmptyField(lastDelimiter, i)) {
                    builder.append(c);
                }
                lastDelimiter = i;
                continue;
            }
            builder.append(c);
        }
        if (builder.length() > 0 && delim.indexOf(val.charAt(valLength - 1)) > -1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private static boolean isEmptyField(int lastDelimiterPosition, int currentDelimPosition) {
        if (lastDelimiterPosition == -1) {
            return currentDelimPosition == 0;
        }
        return lastDelimiterPosition + 1 == currentDelimPosition;
    }

    public static class InvalidReturnTypeForListFilterException
    extends ApplicationException {
    }
}

