/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.debug.core.DebuggerExceptionWrapper;
import coldfusion.runtime.AdvancedCFException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CustomException;
import coldfusion.runtime.DatabaseException;
import coldfusion.runtime.LockException;
import coldfusion.runtime.MissingIncludeException;
import coldfusion.runtime.ObjectException;
import coldfusion.runtime.SearchEngineException;
import coldfusion.runtime.StructBean;
import coldfusion.runtime.TemplateException;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import coldfusion.util.WrappedException;
import jakarta.servlet.ServletException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class NeoException
extends RuntimeException
implements WrappedException {
    private static ExceptionDescriptor[] vExceptions = new ExceptionDescriptor[9];
    protected Throwable rootCause;
    protected Locale locale;
    protected String msg;
    private String lmsg;
    protected String detail;

    private static String exceptionType(Throwable e) {
        Class<?> exceptionClass = NeoException.unwrap(e).getClass();
        String result = null;
        if (e instanceof CustomException) {
            result = ((CustomException)e).getType();
        } else if (e instanceof AdvancedCFException) {
            result = ((AdvancedCFException)e).getType();
        } else {
            int bestDiff = Integer.MAX_VALUE;
            for (int i = 0; i < vExceptions.length; ++i) {
                int thisDiff = NeoException.diffClassTypes(exceptionClass, vExceptions[i].getExceptionClass());
                if (thisDiff >= bestDiff) continue;
                bestDiff = thisDiff;
                result = vExceptions[i].getType();
            }
        }
        if (result == null) {
            result = e.getClass().getName();
        }
        return result;
    }

    public static int findThrowableTarget(Throwable throwable, String[] targets) {
        DebuggingService ds;
        DebuggerExceptionWrapper.throwDebuggerWrapperException(throwable);
        if (throwable instanceof CustomException) {
            return NeoException.findCustomTarget((CustomException)throwable, targets);
        }
        if (throwable instanceof AdvancedCFException) {
            return NeoException.findAdvancedCFTarget((AdvancedCFException)throwable, targets);
        }
        int result = -1;
        int bestDiff = Integer.MAX_VALUE;
        Class<?> exceptionClass = throwable.getClass();
        for (int index = 0; index < targets.length; ++index) {
            String strTarget = targets[index];
            if ("any".equalsIgnoreCase(strTarget)) {
                strTarget = "java.lang.Exception";
            } else if ("expression".equalsIgnoreCase(strTarget) && throwable instanceof AccessControlException) continue;
            int thisDiff = Integer.MAX_VALUE;
            Class targetClass = NeoException.getTargetClass(strTarget);
            if (targetClass == null || (thisDiff = NeoException.diffClassTypes(exceptionClass, targetClass)) >= bestDiff) continue;
            bestDiff = thisDiff;
            result = index;
        }
        if (result != -1 && (ds = ServiceFactory.getDebuggingService()) != null) {
            if (ds.check(8) && ds.getDebugger() != null) {
                ds.getDebugger().exception(throwable);
            }
        }
        return result;
    }

    public static int findAdvancedCFTarget(AdvancedCFException ex, String[] targets) {
        int result = -1;
        String exceptionType = ex.getType();
        for (int i = 0; i < targets.length; ++i) {
            if (exceptionType.equalsIgnoreCase(targets[i])) {
                return i;
            }
            if (!targets[i].equalsIgnoreCase("ANY")) continue;
            result = i;
        }
        return result;
    }

    public static int findCustomTarget(CustomException ex, String[] targets) {
        int result = -1;
        int bestDiff = Integer.MAX_VALUE;
        String exceptionType = ex.getType();
        for (int i = 0; i < targets.length; ++i) {
            String targetElement;
            String cfmlElement;
            int thisDiff = Integer.MAX_VALUE;
            String strTarget = targets[i];
            if (exceptionType.equalsIgnoreCase(strTarget)) {
                return i;
            }
            StringTokenizer cfmlTokens = new StringTokenizer(exceptionType, ".");
            StringTokenizer targetTokens = new StringTokenizer(targets[i], ".");
            int partialMatchDiff = cfmlTokens.countTokens() - targetTokens.countTokens();
            boolean b1 = partialMatchDiff > 0;
            boolean b2 = partialMatchDiff <= 0;
            int j = 0;
            while (partialMatchDiff > 0 && (b1 = cfmlTokens.hasMoreTokens()) && (b2 = targetTokens.hasMoreTokens()) && (cfmlElement = cfmlTokens.nextToken()).equalsIgnoreCase(targetElement = targetTokens.nextToken())) {
                ++j;
            }
            if (!b2 && b1) {
                thisDiff = partialMatchDiff;
            } else if (strTarget.equalsIgnoreCase("ANY")) {
                --thisDiff;
            }
            if (thisDiff >= bestDiff) continue;
            result = i;
            bestDiff = thisDiff;
        }
        return result;
    }

    private static Class getTargetClass(final String strTarget) {
        for (int i = 0; i < vExceptions.length; ++i) {
            if (!vExceptions[i].getType().equalsIgnoreCase(strTarget)) continue;
            return vExceptions[i].getExceptionClass();
        }
        try {
            Class c = null;
            if (System.getSecurityManager() == null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                c = cl.loadClass(strTarget);
            } else {
                c = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return Thread.currentThread().getContextClassLoader().loadClass(strTarget);
                    }
                });
            }
            return c;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Throwable unwrap(Throwable wrapper) {
        Object result = wrapper;
        while ((result = (wrapper = result) instanceof CustomException ? null : (wrapper instanceof TemplateException ? null : (wrapper instanceof DatabaseException ? null : (wrapper instanceof ObjectException ? null : (wrapper instanceof LockException ? null : (wrapper instanceof ApplicationException ? null : (wrapper instanceof ServletException ? ((ServletException)wrapper).getRootCause() : (wrapper instanceof WrappedException ? ((WrappedException)((Object)wrapper)).getRootCause() : null)))))))) != null) {
        }
        return wrapper;
    }

    private static int diffClassTypes(Class exceptionType, Class targetType) {
        int result = Integer.MAX_VALUE;
        int nTransitions = 0;
        while (exceptionType != null && result == Integer.MAX_VALUE) {
            if (targetType == exceptionType) {
                result = nTransitions;
            } else {
                exceptionType = exceptionType.getSuperclass();
            }
            ++nTransitions;
        }
        return result;
    }

    public NeoException(Throwable ex) {
        super(ex);
        this.rootCause = ex;
    }

    @Override
    public Throwable getRootCause() {
        return this.rootCause;
    }

    public NeoException() {
    }

    public final void setLocale(Locale l) {
        this.locale = l;
    }

    @Override
    public String getMessage() {
        if (this.msg == null) {
            this.msg = NeoException.getString(this, "message", this.locale);
        }
        return this.msg;
    }

    @Override
    public final String getLocalizedMessage() {
        if (this.locale == null && this.lmsg == null) {
            this.lmsg = this.getMessage();
        } else if (this.lmsg == null) {
            this.lmsg = NeoException.getString(this, "message", this.locale);
        }
        return this.lmsg;
    }

    public String getDetail() {
        if (this.detail == null) {
            this.detail = NeoException.getString(this, "detail", this.locale);
        }
        return this.detail;
    }

    public static String getString(Throwable instance, String key, Locale locale) {
        String classname = instance.getClass().getName();
        int count = classname.lastIndexOf(46);
        String base = count != -1 ? classname.substring(count + 1) : classname;
        char dollar = '$';
        char period = '.';
        base = base.replace(dollar, period);
        return StructBean.replaceVars(instance, RB.getMessage(instance, base, locale, key, null));
    }

    public String getType() {
        return NeoException.exceptionType(this);
    }

    static {
        NeoException.vExceptions[0] = new ExceptionDescriptor("Database", DatabaseException.class);
        NeoException.vExceptions[1] = new ExceptionDescriptor("Template", TemplateException.class);
        NeoException.vExceptions[2] = new ExceptionDescriptor("Security", AccessControlException.class);
        NeoException.vExceptions[3] = new ExceptionDescriptor("Object", ObjectException.class);
        NeoException.vExceptions[4] = new ExceptionDescriptor("MissingInclude", MissingIncludeException.class);
        NeoException.vExceptions[5] = new ExceptionDescriptor("Expression", RuntimeException.class);
        NeoException.vExceptions[6] = new ExceptionDescriptor("Lock", LockException.class);
        NeoException.vExceptions[7] = new ExceptionDescriptor("Application", ApplicationException.class);
        NeoException.vExceptions[8] = new ExceptionDescriptor("SearchEngine", SearchEngineException.class);
    }

    private static class ExceptionDescriptor {
        String type;
        Class clazz;

        ExceptionDescriptor(String type, Class exceptionClass) {
            this.type = type;
            this.clazz = exceptionClass;
        }

        public Class getExceptionClass() {
            return this.clazz;
        }

        public String getType() {
            return this.type;
        }

        public boolean matches(String strType) {
            return this.type.equalsIgnoreCase(strType);
        }

        public boolean matches(Throwable t) {
            Class<?> src;
            for (src = t.getClass(); src != null && this.clazz != src; src = src.getSuperclass()) {
            }
            return src != null;
        }
    }
}

