/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.Cast;
import coldfusion.runtime.Invokable;
import jakarta.servlet.jsp.PageContext;

public interface ObjectHandledInvokable
extends Invokable {
    public static final Object OBJECT_METHOD_NOT_FOUND = new Object();
    public static final String GET_CLASS = "getclass";
    public static final String TO_STRING = "tostring";
    public static final String EQUALS = "equals";
    public static final String HASHCODE = "hashcode";
    public static final String WAIT = "wait";
    public static final String NOTIFY = "notify";
    public static final String NOTIFY_ALL = "notifyall";

    @Override
    default public Object invoke(String methodName, Object[] args, PageContext pageContext) throws Throwable {
        switch (methodName.toLowerCase()) {
            case "getclass": {
                return this.getClass();
            }
            case "tostring": {
                return this.toString();
            }
            case "equals": {
                if (args == null || args.length != 1) break;
                return this.equals(args[0]);
            }
            case "hashcode": {
                if (args != null && args.length != 0) break;
                return this.hashCode();
            }
            case "wait": {
                if (args == null || args.length == 0) {
                    this.wait();
                    return null;
                }
                if (args.length == 1) {
                    this.wait(Cast._long(args[0], false));
                    return null;
                }
                if (args.length != 2) break;
                this.wait(Cast._long(args[0], false), Cast._int(args[1], false));
                return null;
            }
            case "notify": {
                if (args != null && args.length != 0) break;
                this.notify();
                return null;
            }
            case "notifyall": {
                if (args != null && args.length != 0) break;
                this.notifyAll();
                return null;
            }
        }
        return OBJECT_METHOD_NOT_FOUND;
    }
}

