/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.cfc.ComponentProxyFactory;
import coldfusion.runtime.Invokable;
import coldfusion.runtime.UnknownObjectTypeException;
import coldfusion.runtime.java.JavaProxyFactory;
import coldfusion.server.CorbaService;
import coldfusion.server.DotNetService;
import coldfusion.server.ServiceFactory;
import coldfusion.xml.rpc.WebServiceProxyFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public abstract class ProxyFactory {
    public static final String PAGE_CONTEXT = "pageContext";
    public static final String CONTEXT = "context";
    public static final String SERVER = "server";
    public static final String DOMAIN = "domain";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String PORT = "port";
    public static final String ACTION = "action";
    public static final String PROTOCOL = "protocol";
    public static final String LOCALE = "protocol";
    public static final String COM = "COM";
    public static final String COMPONENT = "COMPONENT";
    public static final String CORBA = "CORBA";
    public static final String JAVA = "JAVA";
    public static final String DOTNET = "DOTNET";
    public static final String DOTNET_ALIAS = ".NET";
    public static final String WEBSERVICE = "webservice";
    public static final String CLASS_PATH = "classpath";
    private static Map factoryMap = new HashMap(5);

    public static Invokable getProxy(String type, String name, Map propertyMap) throws Throwable {
        ProxyFactory factory = (ProxyFactory)factoryMap.get(type.toUpperCase());
        if (factory == null) {
            throw new UnknownObjectTypeException(type);
        }
        return factory.getProxy(name, propertyMap);
    }

    public abstract Invokable getProxy(String var1, Map var2) throws Throwable;

    public static void registerFactory(String type, String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ProxyFactory factory = (ProxyFactory)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        factoryMap.put(type.toUpperCase(), factory);
    }

    public static void registerFactory(String type, ProxyFactory factory) {
        factoryMap.put(type.toUpperCase(), factory);
    }

    public static void unregisterFactory(String type) {
        factoryMap.remove(type.toUpperCase());
    }

    static {
        DotNetService dotNetService = ServiceFactory.getDotNetService(false);
        ProxyFactory.registerFactory(COMPONENT, new ComponentProxyFactory());
        CorbaService corbaService = ServiceFactory.getCorbaService();
        if (corbaService != null) {
            ProxyFactory.registerFactory(CORBA, corbaService.getCorbaProxyFactory());
        }
        ProxyFactory.registerFactory(JAVA, new JavaProxyFactory());
        if (dotNetService != null) {
            ProxyFactory factory = dotNetService.getDotNetProxyFactory();
            ProxyFactory.registerFactory(DOTNET, factory);
            ProxyFactory.registerFactory(DOTNET_ALIAS, factory);
        }
        ProxyFactory.registerFactory(WEBSERVICE, new WebServiceProxyFactory());
    }
}

