/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Array;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.ObjectDuplicator;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.CallableCompletionService;
import coldfusion.runtime.async.CallableResult;
import coldfusion.runtime.async.ColdfusionFuture;
import coldfusion.runtime.async.Future;
import coldfusion.runtime.parallel.ParallelCallUtil;
import coldfusion.sql.Parameter;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.sql.Table;
import coldfusion.sql.imq.Row;
import coldfusion.sql.imq.imqTable;
import coldfusion.sql.imq.rttExpr;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.RuntimeWrapper;
import com.allaire.cfx.Query;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ExecutorService;

public final class QueryFunction {
    public static final String TOTAL_ROW_COUNT = "TOTALROWCOUNT";
    public static final String QUERY = "QUERY";
    public static final boolean MUTATE_INPUT_QUERY = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("coldfusion.query.filter.mutateinputquery");
        }
    });

    public static boolean IsQuery(Object q) {
        return q instanceof Query || q instanceof QueryTable;
    }

    public static QueryTable QueryNew(String colList) {
        String[] names = QueryFunction.tokenize(colList, ",");
        QueryFunction.validateColumnNames(names);
        return new QueryTable(0, names);
    }

    public static void QueryEach(Object queryObj, UDFMethod closureFunc) {
        if (!(queryObj instanceof Table)) {
            throw new QueryTypeException(queryObj);
        }
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        Table query = (Table)queryObj;
        for (int i = 1; i <= query.getRowCount(); ++i) {
            Struct rowData = QueryFunction.QueryGetRow(query, i);
            try {
                CFPage._invokeUDF((Object)closureFunc, closureFunc.getName(), cfpage, new Object[]{rowData, i, query});
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
    }

    public static void QueryEach(Object queryObj, UDFMethod closureFunc, int maxThreads) {
        if (!(queryObj instanceof Table)) {
            throw new QueryTypeException(queryObj);
        }
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            List<Future> futures = ParallelCallUtil.submitParallelTaskForQuery(queryObj, closureFunc, executor);
            FusionContext fusionContext = FusionContext.getCurrent();
            CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
            Table query = (Table)queryObj;
            for (int i = 0; i < futures.size(); ++i) {
                Future resFut = futures.get(i);
                Object res = resFut.get();
                ParallelCallUtil.printOutput(resFut.getUdfMethodRef().getOutput());
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof NeoException) {
                throw (NeoException)throwable;
            }
            throw new RuntimeWrapper(throwable);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    public static boolean QuerySome(Object queryObj, UDFMethod closureFunc) {
        if (!(queryObj instanceof Table)) {
            throw new QueryTypeException(queryObj);
        }
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        Table query = (Table)queryObj;
        for (int i = 1; i <= query.getRowCount(); ++i) {
            Struct rowData = QueryFunction.QueryGetRow(query, i);
            try {
                Object retVal = CFPage._invokeUDF((Object)closureFunc, closureFunc.getName(), cfpage, new Object[]{rowData, i, query});
                if (retVal == null) {
                    throw new InvalidReturnTypeForQuerySomeException();
                }
                if (!Cast._boolean(retVal)) continue;
                return true;
            }
            catch (Cast.BooleanConversionException ex) {
                throw new InvalidReturnTypeForQuerySomeException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new InvalidReturnTypeForQuerySomeException();
            }
            catch (Throwable throwable) {
                if (throwable instanceof NeoException) {
                    throw (NeoException)throwable;
                }
                throw new RuntimeWrapper(throwable);
            }
        }
        return false;
    }

    public static boolean QuerySome(Object queryObj, UDFMethod closureFunc, int maxThreads) {
        if (!(queryObj instanceof Table)) {
            throw new QueryTypeException(queryObj);
        }
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            CallableCompletionService completionService = new CallableCompletionService(executor);
            ParallelCallUtil.submitCallablesForQuery(queryObj, closureFunc, completionService);
            FusionContext fusionContext = FusionContext.getCurrent();
            Table query = (Table)queryObj;
            for (int i = 1; i <= query.getRowCount(); ++i) {
                ColdfusionFuture resFut = (ColdfusionFuture)completionService.take();
                Object res = resFut.get();
                CallableResult result = (CallableResult)res;
                ParallelCallUtil.printOutput(result.getOutput());
                try {
                    if (result.getResult() == null) {
                        throw new InvalidReturnTypeForQuerySomeException();
                    }
                    ParallelCallUtil.printOutput(result.getOutput());
                    if (!Cast._boolean(result.getResult())) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Cast.BooleanConversionException | Cast.BooleanStringConversionException ex) {
                    throw new InvalidReturnTypeForQuerySomeException();
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof NeoException) {
                throw (NeoException)throwable;
            }
            throw new RuntimeWrapper(throwable);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
        return false;
    }

    public static boolean QueryEvery(Object queryObj, UDFMethod closureFunc) {
        if (!(queryObj instanceof Table)) {
            throw new QueryTypeException(queryObj);
        }
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        Table query = (Table)queryObj;
        for (int i = 1; i <= query.getRowCount(); ++i) {
            Struct rowData = QueryFunction.QueryGetRow(query, i);
            try {
                Object retVal = CFPage._invokeUDF((Object)closureFunc, closureFunc.getName(), cfpage, new Object[]{rowData, i, query});
                if (retVal == null) {
                    throw new InvalidReturnTypeForQueryEveryException();
                }
                if (Cast._boolean(retVal)) continue;
                return false;
            }
            catch (Cast.BooleanConversionException ex) {
                throw new InvalidReturnTypeForQueryEveryException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new InvalidReturnTypeForQueryEveryException();
            }
            catch (Throwable throwable) {
                if (throwable instanceof NeoException) {
                    throw (NeoException)throwable;
                }
                throw new RuntimeWrapper(throwable);
            }
        }
        return true;
    }

    public static boolean QueryEvery(Object queryObj, UDFMethod closureFunc, int maxThreads) {
        if (!(queryObj instanceof Table)) {
            throw new QueryTypeException(queryObj);
        }
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            CallableCompletionService completionService = new CallableCompletionService(executor);
            ParallelCallUtil.submitCallablesForQuery(queryObj, closureFunc, completionService);
            FusionContext fusionContext = FusionContext.getCurrent();
            CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
            Table query = (Table)queryObj;
            for (int i = 1; i <= query.getRowCount(); ++i) {
                ColdfusionFuture resFut = (ColdfusionFuture)completionService.take();
                Object res = resFut.get();
                CallableResult result = (CallableResult)res;
                ParallelCallUtil.printOutput(result.getOutput());
                try {
                    if (result.getResult() == null) {
                        throw new InvalidReturnTypeForQueryEveryException();
                    }
                    ParallelCallUtil.printOutput(result.getOutput());
                    if (Cast._boolean(result.getResult())) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (Cast.BooleanConversionException | Cast.BooleanStringConversionException ex) {
                    throw new InvalidReturnTypeForQueryEveryException();
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof NeoException) {
                throw (NeoException)throwable;
            }
            throw new RuntimeWrapper(throwable);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
        return true;
    }

    public static Object QueryMap(Object queryObj, UDFMethod mapFunc) {
        return QueryFunction.QueryMap(queryObj, mapFunc, null);
    }

    public static Object QueryMap(Object queryObj, UDFMethod mapFunc, Object schema) {
        if (!(queryObj instanceof Table)) {
            throw new QueryTypeException(queryObj);
        }
        if (schema != null && !(schema instanceof Table)) {
            throw new QueryTypeException(schema);
        }
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        Table query = (Table)queryObj;
        Table resQuery = (Table)schema;
        if (resQuery == null) {
            resQuery = query;
        }
        List<Row> row_List = Collections.synchronizedList(new ArrayList(query.getRowCount()));
        QueryTable dupQuery = new QueryTable(query.getRowCount());
        dupQuery.setMeta(resQuery.getMeta());
        dupQuery.setCol_count(resQuery.getCol_count());
        dupQuery.setColumnNames(resQuery.getColumnNames(), false);
        String[] columns = resQuery.getColumnNames();
        CaseInsensitiveMap columnNamesIndexesMap = new CaseInsensitiveMap();
        for (int j = 0; j < columns.length; ++j) {
            columnNamesIndexesMap.put(columns[j], j);
        }
        for (int i = 1; i <= query.getRowCount(); ++i) {
            Struct rowData = QueryFunction.QueryGetRow(query, i);
            try {
                Object retVal = CFPage._invokeUDF((Object)mapFunc, mapFunc.getName(), cfpage, new Object[]{rowData, i, query});
                Object[] rowValues = new Object[columns.length];
                for (Map.Entry e : ((Struct)retVal).entrySet()) {
                    String keyname = (String)e.getKey();
                    if (columnNamesIndexesMap.containsKey(keyname)) {
                        rowValues[((Integer)columnNamesIndexesMap.get((Object)keyname)).intValue()] = e.getValue();
                        continue;
                    }
                    throw new NoColumnInQueryException(keyname);
                }
                row_List.add(new Row(rowValues));
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        dupQuery.setRowVector(row_List);
        return dupQuery;
    }

    public static Object QueryMap(Object queryObj, UDFMethod mapFunc, Object schema, int maxThreads) {
        List<Row> row_List;
        if (!(queryObj instanceof Table)) {
            throw new QueryTypeException(queryObj);
        }
        if (schema != null && !(schema instanceof Table)) {
            throw new QueryTypeException(schema);
        }
        Table query = (Table)queryObj;
        Table resQuery = (Table)schema;
        if (resQuery == null) {
            resQuery = query;
        }
        QueryTable dupQuery = new QueryTable(query.getRowCount());
        dupQuery.setMeta(resQuery.getMeta());
        dupQuery.setCol_count(resQuery.getCol_count());
        dupQuery.setColumnNames(resQuery.getColumnNames(), false);
        String[] columns = resQuery.getColumnNames();
        CaseInsensitiveMap columnNamesIndexesMap = new CaseInsensitiveMap();
        for (int j = 0; j < columns.length; ++j) {
            columnNamesIndexesMap.put(columns[j], j);
        }
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            List<Future> futures = ParallelCallUtil.submitParallelTaskForQuery(queryObj, mapFunc, executor);
            row_List = Collections.synchronizedList(new ArrayList(futures.size()));
            for (int i = 0; i < futures.size(); ++i) {
                Future resFut = futures.get(i);
                Object res = resFut.get();
                ParallelCallUtil.printOutput(resFut.getUdfMethodRef().getOutput());
                Map retVal = Cast._Map(res);
                Object[] rowValues = new Object[columns.length];
                for (Map.Entry e : ((Struct)retVal).entrySet()) {
                    String keyname = (String)e.getKey();
                    if (columnNamesIndexesMap.containsKey(keyname)) {
                        rowValues[((Integer)columnNamesIndexesMap.get((Object)keyname)).intValue()] = e.getValue();
                        continue;
                    }
                    throw new NoColumnInQueryException(keyname);
                }
                row_List.add(new Row(rowValues));
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof NeoException) {
                throw (NeoException)throwable;
            }
            throw new RuntimeWrapper(throwable);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
        dupQuery.setRowVector(row_List);
        return dupQuery;
    }

    public static Object QueryReduce(Object queryObj, UDFMethod reduceFunc, Object initialValue) {
        if (!(queryObj instanceof Table)) {
            throw new QueryTypeException(queryObj);
        }
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        Table query = (Table)queryObj;
        Object result = initialValue;
        for (int i = 1; i <= query.getRowCount(); ++i) {
            Struct rowData = QueryFunction.QueryGetRow(query, i);
            try {
                result = CFPage._invokeUDF((Object)reduceFunc, reduceFunc.getName(), cfpage, new Object[]{result, rowData, i, query});
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return result;
    }

    public static Object QuerySort(Object queryObj, UDFMethod sortFunc) {
        if (!(queryObj instanceof Table)) {
            throw new QueryTypeException(queryObj);
        }
        QueryTable query = null;
        query = (QueryTable)queryObj;
        List<Struct> rowList = Collections.synchronizedList(new ArrayList(query.getRowCount()));
        List sortedRowList = Collections.synchronizedList(new ArrayList(query.getRowCount()));
        HashMap<Struct, Row> rowIndexes = new HashMap<Struct, Row>();
        for (int i = 1; i <= query.getRowCount(); ++i) {
            Struct rowData = QueryFunction.QueryGetRow(query, i);
            rowList.add(rowData);
            rowIndexes.put(rowData, query.getRow(i - 1));
        }
        Collections.sort(rowList, new ArrayUtil.FunctionBasedComparator(sortFunc, "QUERY_COMPARATOR"));
        for (Struct rowData : rowList) {
            sortedRowList.add(rowIndexes.get(rowData));
        }
        query.setRowVector(sortedRowList);
        return query;
    }

    public static Object QueryFilter(Object queryObj, UDFMethod filterFunc) {
        if (!(queryObj instanceof Table)) {
            throw new QueryTypeException(queryObj);
        }
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        Table query = null;
        if (!MUTATE_INPUT_QUERY) {
            try {
                query = ObjectDuplicator.duplicateQueryTable((QueryTable)queryObj);
            }
            catch (IllegalAccessException | SQLException ex) {
                throw new RuntimeWrapper(ex);
            }
        } else {
            query = (Table)queryObj;
        }
        int rowNum = 0;
        for (int i = 1; i <= query.getRowCount(); ++i) {
            Struct rowData = QueryFunction.QueryGetRow(query, i);
            try {
                Object retVal = CFPage._invokeUDF((Object)filterFunc, filterFunc.getName(), cfpage, new Object[]{rowData, ++rowNum, query});
                if (retVal == null) {
                    throw new InvalidReturnTypeForQueryFilterException();
                }
                if (Cast._boolean(retVal)) continue;
                query.removeRows(--i, 1);
                continue;
            }
            catch (Cast.BooleanConversionException ex) {
                throw new InvalidReturnTypeForQueryFilterException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new InvalidReturnTypeForQueryFilterException();
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return query;
    }

    public static Object QueryFilter(Object queryObj, UDFMethod filterFunc, int maxThreads) {
        if (!(queryObj instanceof Table)) {
            throw new QueryTypeException(queryObj);
        }
        Table queryRes = null;
        if (!MUTATE_INPUT_QUERY) {
            try {
                queryRes = ObjectDuplicator.duplicateQueryTable((QueryTable)queryObj);
            }
            catch (IllegalAccessException | SQLException ex) {
                throw new RuntimeWrapper(ex);
            }
        } else {
            queryRes = (Table)queryObj;
        }
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            List<Future> futures = ParallelCallUtil.submitParallelTaskForQuery(queryObj, filterFunc, executor);
            int removedCounter = 0;
            for (int i = 0; i < futures.size(); ++i) {
                Future resFut = futures.get(i);
                Object res = resFut.get();
                try {
                    if (res == null) {
                        throw new InvalidReturnTypeForQueryFilterException();
                    }
                    ParallelCallUtil.printOutput(resFut.getUdfMethodRef().getOutput());
                    if (Cast._boolean(res)) continue;
                    queryRes.removeRows(i - removedCounter++, 1);
                    continue;
                }
                catch (Cast.BooleanConversionException | Cast.BooleanStringConversionException ex) {
                    throw new InvalidReturnTypeForQuerySomeException();
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof NeoException) {
                throw (NeoException)throwable;
            }
            throw new RuntimeWrapper(throwable);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
        return queryRes;
    }

    public static Object QueryDeleteRow(Object query, int rowNum) {
        if (rowNum <= 0) {
            throw new InvalidRowNumberException(2, rowNum, "QueryDeleteRow");
        }
        if (query instanceof QueryTable) {
            QueryTable queryTable = (QueryTable)query;
            return queryTable.deleteRow(rowNum);
        }
        throw new QueryTypeException(query);
    }

    public static Struct QueryGetRow(Object query, int rowNum) {
        if (rowNum <= 0) {
            throw new InvalidRowNumberException(2, rowNum, "QueryGetRow");
        }
        Struct rowData = new Struct();
        if (query instanceof QueryTable) {
            QueryTable queryTable = (QueryTable)query;
            QueryTableMetaData meta = null;
            try {
                meta = new QueryTableMetaData(queryTable.getMetaData());
            }
            catch (Exception exception) {
                // empty catch block
            }
            int count = queryTable.getRowCount();
            if (rowNum > count) {
                throw new RowNumberOutOfBoundException(rowNum);
            }
            Row row = queryTable.getRow(rowNum - 1);
            if (row != null) {
                Object[] data = row.getRowData();
                String[] columns = queryTable.getColumnNames();
                for (int i = 0; i < columns.length; ++i) {
                    Object columnVal = data[i];
                    try {
                        if (columnVal == null) {
                            columnVal = FusionContext.isPreserveNullValues() ? null : "";
                        } else if (meta != null && meta.getColumnType(i + 1) == 2005 && columnVal instanceof char[]) {
                            columnVal = new String((char[])columnVal);
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    rowData.put(columns[i], columnVal);
                }
            }
        } else {
            throw new QueryTypeException(query);
        }
        return rowData;
    }

    public static Struct QueryGetResult(Object q) {
        if (q instanceof imqTable) {
            return ((imqTable)q).getResult();
        }
        throw new QueryTypeException(q);
    }

    private static String[] tokenize(String str, String separator) {
        StringTokenizer t = new StringTokenizer(str, separator);
        String[] tokens = new String[t.countTokens()];
        int k = 0;
        while (t.hasMoreTokens()) {
            tokens[k++] = t.nextToken().trim();
        }
        return tokens;
    }

    private static void validateColumnNames(String[] colNames) {
        for (int i = 0; i < colNames.length; ++i) {
            QueryFunction.validateColumnName(colNames[i]);
        }
    }

    private static int[] validateColumnTypes(String[] colTypeNames) {
        int[] sqlColTypes = new int[colTypeNames.length];
        for (int i = 0; i < colTypeNames.length; ++i) {
            sqlColTypes[i] = QueryFunction.isValidColumnType(colTypeNames[i]);
        }
        return sqlColTypes;
    }

    public static QueryTable QueryNew(String colnames, String coltypes) {
        String[] colTypes;
        String[] colNames = QueryFunction.tokenize(colnames, ",");
        if (colNames.length != (colTypes = QueryFunction.tokenize(coltypes, ",")).length) {
            throw new QueryNewException(colNames.length, colTypes.length);
        }
        QueryFunction.validateColumnNames(colNames);
        int[] sqlColTypes = QueryFunction.validateColumnTypes(colTypes);
        for (int i = 0; i < colTypes.length; ++i) {
            colTypes[i] = rttExpr.getSqlTypeName(sqlColTypes[i]);
        }
        return new QueryTable(0, colNames, colTypes, sqlColTypes);
    }

    public static QueryTable QuerySlice(Object query, int offset, int length) {
        if (query instanceof QueryTable) {
            QueryTable qt = (QueryTable)query;
            String[] colNames = qt.getColumnNames();
            StringBuilder sb = new StringBuilder();
            for (String column : colNames) {
                sb.append(column).append(",");
            }
            QueryTable result = QueryFunction.QueryNew(sb.toString().substring(0, sb.toString().lastIndexOf(",")));
            int endIndex = 0;
            int queryRecordCount = QueryFunction.RowCount(query);
            if (offset <= 0) {
                throw new QuerySliceOutOfBoundException("offset", offset);
            }
            if (length < -1) {
                throw new QuerySliceOutOfBoundException("length", length);
            }
            if (offset > queryRecordCount) {
                throw new QuerySliceOutOfBoundException("offset", offset);
            }
            if (length == -1) {
                endIndex = queryRecordCount + 1;
            } else {
                if (offset + length - 1 > queryRecordCount) {
                    throw new QuerySliceOutOfBoundException("length", length);
                }
                endIndex = offset + length;
            }
            for (int rowNum = offset; rowNum < endIndex; ++rowNum) {
                QueryFunction.QueryAddRow((Object)result, QueryFunction.QueryGetRow(qt, rowNum));
            }
            return result;
        }
        throw new QueryTypeException(query);
    }

    public static QueryTable QueryClear(Object query) throws QueryTypeException {
        if (query instanceof QueryTable) {
            QueryTable qt = (QueryTable)query;
            int numRows = qt.getRecordCount();
            for (int i = 1; i <= numRows; ++i) {
                qt.deleteRow(1);
            }
            return qt;
        }
        throw new QueryTypeException(query);
    }

    private static int QuerySchemaMatch(QueryTable query, QueryTable newQuery) {
        Object[] queryColNames = query.getColumnList();
        Object[] newQueryColNames = newQuery.getColumnList();
        Arrays.sort(queryColNames);
        Arrays.sort(newQueryColNames);
        if (queryColNames.length != newQueryColNames.length) {
            return -2;
        }
        for (int i = 0; i < queryColNames.length; ++i) {
            if (((String)queryColNames[i]).equalsIgnoreCase((String)newQueryColNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static QueryTable RowSwap(Object query, int rowIndex, int swapIndex) throws QueryTypeException {
        if (rowIndex <= 0) {
            throw new InvalidRowNumberException(1, rowIndex, "RowSwap");
        }
        if (swapIndex <= 0) {
            throw new InvalidRowNumberException(2, swapIndex, "RowSwap");
        }
        if (rowIndex == swapIndex) {
            return (QueryTable)query;
        }
        if (rowIndex < swapIndex) {
            int temp = rowIndex;
            rowIndex = swapIndex;
            swapIndex = temp;
        }
        if (query instanceof QueryTable) {
            QueryTable queryTable = (QueryTable)query;
            int recordCount = queryTable.getRecordCount();
            if (rowIndex > recordCount) {
                throw new RowNumberOutOfBoundException(rowIndex);
            }
            if (swapIndex > recordCount) {
                throw new RowNumberOutOfBoundException(swapIndex);
            }
            QueryTable row = QueryFunction.QuerySlice(query, rowIndex, 1);
            QueryTable swapRow = QueryFunction.QuerySlice(queryTable, swapIndex, 1);
            QueryFunction.QueryDeleteRow(queryTable, rowIndex);
            QueryFunction.QueryDeleteRow(queryTable, swapIndex);
            if (swapIndex < rowIndex) {
                QueryFunction.QueryInsertAt(query, row, swapIndex);
                QueryFunction.QueryInsertAt(query, swapRow, rowIndex);
            } else {
                QueryFunction.QueryInsertAt(query, swapRow, rowIndex);
                QueryFunction.QueryInsertAt(query, row, swapIndex);
            }
            return queryTable;
        }
        throw new QueryTypeException(query);
    }

    public static QueryTable QueryAppend(Object query, Object newQuery) throws QueryTypeException {
        if (query instanceof QueryTable) {
            QueryTable queryTable = (QueryTable)query;
            QueryTable newQueryTable = (QueryTable)newQuery;
            int schemaMatchErrorCode = QueryFunction.QuerySchemaMatch(queryTable, newQueryTable);
            if (schemaMatchErrorCode > 0 || schemaMatchErrorCode == -2) {
                throw new QuerySchemaMismatch(String.join((CharSequence)",", queryTable.getColumnList()), String.join((CharSequence)",", newQueryTable.getColumnList()), "QueryAppend");
            }
            for (int i = 1; i < newQueryTable.getRecordCount() + 1; ++i) {
                QueryFunction.QueryAddRow(query, QueryFunction.QueryGetRow(newQueryTable, i));
            }
        } else {
            throw new QueryTypeException(query);
        }
        return (QueryTable)query;
    }

    public static QueryTable QueryPrepend(Object query, Object newQuery) throws QueryTypeException {
        if (query instanceof QueryTable) {
            QueryTable queryTable = (QueryTable)query;
            QueryTable newQueryTable = (QueryTable)newQuery;
            int schemaMatchErrorCode = QueryFunction.QuerySchemaMatch(queryTable, newQueryTable);
            if (schemaMatchErrorCode > 0 || schemaMatchErrorCode == -2) {
                throw new QuerySchemaMismatch(String.join((CharSequence)",", queryTable.getColumnList()), String.join((CharSequence)",", newQueryTable.getColumnList()), "QueryPrepend");
            }
            QueryTable tempQueryTable = null;
            if (queryTable.getRecordCount() != 0) {
                tempQueryTable = QueryFunction.QuerySlice(query, 1, queryTable.getRecordCount());
            }
            query = QueryFunction.QueryClear(query);
            query = QueryFunction.QueryAppend(query, newQuery);
            if (tempQueryTable != null) {
                query = QueryFunction.QueryAppend(query, tempQueryTable);
            }
        } else {
            throw new QueryTypeException(query);
        }
        return (QueryTable)query;
    }

    public static QueryTable QueryReverse(Object query) throws QueryTypeException {
        if (query instanceof QueryTable) {
            QueryTable qtable = (QueryTable)query;
            QueryTable newqTable = new QueryTable();
            newqTable.setMetaData(qtable.getMeta());
            newqTable.setCol_count(qtable.getCol_count());
            newqTable.setColumnNames(qtable.getColumnNames(), true);
            Collections.reverse(qtable.getRowVector());
            List newRowVector = Collections.synchronizedList(new ArrayList(qtable.getRowVector().size()));
            for (Object row : qtable.getRowVector()) {
                newRowVector.add(row);
            }
            newqTable.setRowVector(newRowVector);
            newqTable.setRow_count(qtable.getRow_count());
            Collections.reverse(qtable.getRowVector());
            return newqTable;
        }
        throw new QueryTypeException(query);
    }

    public static Object QueryInsertAt(Object baseQuery, Object query, int pos) throws QueryTypeException {
        if (baseQuery instanceof QueryTable && query instanceof QueryTable) {
            int recordCount = ((QueryTable)baseQuery).getRecordCount();
            if (pos <= 0 || pos > recordCount + 1) {
                throw new RowNumberOutOfBoundException(pos);
            }
            if (pos == recordCount + 1) {
                QueryFunction.QueryAppend(baseQuery, query);
                return baseQuery;
            }
            QueryTable baseQueryTable = (QueryTable)baseQuery;
            QueryTable newQueryTable = (QueryTable)query;
            int schemaMatchErrorCode = QueryFunction.QuerySchemaMatch(baseQueryTable, newQueryTable);
            if (schemaMatchErrorCode > 0 || schemaMatchErrorCode == -2) {
                throw new QuerySchemaMismatch(String.join((CharSequence)",", baseQueryTable.getColumnList()), String.join((CharSequence)",", newQueryTable.getColumnList()), "QueryInsertAt");
            }
            QueryTable preQuery = QueryFunction.QuerySlice(baseQueryTable, 1, pos - 1);
            QueryTable postQuery = QueryFunction.QuerySlice(baseQueryTable, pos, recordCount - pos + 1);
            int numRecords = baseQueryTable.getRecordCount();
            for (int rowIndex = 0; rowIndex < numRecords; ++rowIndex) {
                baseQueryTable.deleteRow(1);
            }
            baseQueryTable = QueryFunction.QueryAppend(baseQueryTable, preQuery);
            baseQueryTable = QueryFunction.QueryAppend(baseQueryTable, query);
            baseQueryTable = QueryFunction.QueryAppend(baseQueryTable, postQuery);
            return baseQueryTable;
        }
        throw new QueryTypeException(baseQuery);
    }

    public static Object QueryDeleteColumn(Object query, String columnName) throws QueryTypeException {
        if (query instanceof QueryTable) {
            QueryTable qt = (QueryTable)query;
            return qt.deleteColumn(columnName);
        }
        throw new QueryTypeException(query);
    }

    public static int QueryAddColumn(Object query, String columnName, List elements) throws ArrayDimensionException, QueryTypeException, QueryColumnNameException, DuplicateColumnNameException {
        return QueryFunction.QueryAddColumn(query, columnName, null, elements);
    }

    public static int QueryAddColumn(Object query, String columnName, String columnType, List elements) throws ArrayDimensionException, QueryTypeException, QueryColumnNameException, DuplicateColumnNameException {
        int d;
        if (elements instanceof Array && (d = ((Array)elements).getDimension()) != 1) {
            throw new ArrayDimensionException(d);
        }
        if (query instanceof QueryTable) {
            QueryTable qt = (QueryTable)query;
            columnName = columnName.trim();
            QueryFunction.validateColumnName(columnName);
            int col_num = qt.addColumn(columnName, columnType, new Vector(elements));
            if (col_num == 0) {
                throw new DuplicateColumnNameException(columnName);
            }
            return col_num;
        }
        throw new QueryTypeException(query);
    }

    public static int QueryAddRow(Object query) {
        return QueryFunction.QueryAddRow(query, 1);
    }

    public static int QueryAddRow(Object query, int n) throws QueryTypeException, InvalidRowNumberException {
        int count;
        if (n <= 0) {
            throw new InvalidRowNumberException(2, n, "QueryAddRow");
        }
        if (query instanceof Query) {
            count = ((Query)query).getRowCount();
            for (int i = 0; i < n; ++i) {
                count = ((Query)query).addRow();
            }
        } else if (query instanceof QueryTable) {
            QueryTable qt = (QueryTable)query;
            count = qt.addRows(n);
            ((QueryTableMetaData)qt.getMetaData()).resetTypes();
        } else {
            throw new QueryTypeException(query);
        }
        return count;
    }

    public static int RowCount(Object query) {
        if (query instanceof Query) {
            return ((Query)query).getRowCount();
        }
        if (query instanceof QueryTable) {
            QueryTable qt = (QueryTable)query;
            return qt.getRecordCount();
        }
        throw new QueryTypeException(query);
    }

    public static boolean QuerySetCell(Object query, String column_name, Object value) throws QueryTypeException, NoColumnInQueryException, RowNumberOutOfBoundException, QueryColumnNameException {
        if (query instanceof QueryTable) {
            return QueryFunction.QuerySetCell(query, column_name, value, ((QueryTable)query).getRowCount());
        }
        if (query instanceof Query) {
            return QueryFunction.QuerySetCell(query, column_name, value, ((Query)query).getRowCount());
        }
        throw new QueryTypeException(query);
    }

    public static String getColumnNames(Object data) {
        int lastIndex;
        StringBuilder sb = new StringBuilder();
        if (data instanceof Struct) {
            Struct row = (Struct)data;
            Set colNames = row.keySet();
            for (Object column : colNames) {
                sb.append(column.toString());
                sb.append(",");
            }
        } else if (data instanceof List) {
            List rowData = (List)data;
            HashSet<String> distinctColNames = new HashSet<String>();
            for (Object rowItr : rowData) {
                Struct row = (Struct)rowItr;
                Set colNames = row.keySet();
                for (Object column : colNames) {
                    if (distinctColNames.contains(column.toString())) continue;
                    distinctColNames.add(column.toString());
                    sb.append(column.toString());
                    sb.append(",");
                }
            }
        }
        if ((lastIndex = sb.toString().lastIndexOf(",")) != -1) {
            return sb.substring(0, lastIndex);
        }
        return sb.toString();
    }

    public static int QueryAddRow(Object query, Object row) {
        if (query instanceof QueryTable || query instanceof Query) {
            int rowCount = -1;
            if (row instanceof List) {
                int elementIndex = 0;
                List tempRow = (List)row;
                for (Object rowObj : tempRow) {
                    ++elementIndex;
                    if (rowObj instanceof Struct) {
                        QueryFunction.addCollectionInRow(query, (Map)rowObj);
                        continue;
                    }
                    if (rowObj instanceof List) {
                        List rowStr = (List)rowObj;
                        QueryFunction.addListInRow(query, rowStr);
                        continue;
                    }
                    if (elementIndex == 1) {
                        rowCount = QueryFunction.QueryAddRow(query, 1);
                    }
                    QueryFunction.addSimpleValueInRow(query, rowObj, elementIndex, rowCount);
                }
            } else {
                if (row instanceof Struct || row instanceof ArgumentCollection) {
                    return QueryFunction.addCollectionInRow(query, (Map)row);
                }
                throw new QueryRowTypeException();
            }
            if (query instanceof QueryTable) {
                return ((QueryTable)query).getRowCount();
            }
            if (query instanceof Query) {
                return ((Query)query).getRowCount();
            }
        } else {
            throw new QueryTypeException(query);
        }
        return -1;
    }

    private static int addCollectionInRow(Object query, Map rowObj) {
        int rowCount = QueryFunction.QueryAddRow(query, 1);
        if (rowObj.size() > 0) {
            boolean added = true;
            for (Object keyObj : rowObj.keySet()) {
                String key = (String)keyObj;
                if (!added) break;
                added = QueryFunction.QuerySetCell(query, key, rowObj.get(key), rowCount);
            }
            if (!added) {
                throw new AddRowFailedException();
            }
        }
        return rowCount;
    }

    private static int addListInRow(Object query, List rowStr) {
        int rowCount = QueryFunction.QueryAddRow(query, 1);
        int colCount = -1;
        if (query instanceof QueryTable) {
            q = (QueryTable)query;
            colCount = q.getColumnCount();
        } else if (query instanceof Query) {
            q = (Query)query;
            colCount = q.getColumns().length;
        } else {
            throw new QueryTypeException(query);
        }
        if (colCount < rowStr.size()) {
            throw new ColumnNumberOutOfBoundException(colCount + 1);
        }
        if (rowStr.size() > 0) {
            boolean added = true;
            for (int i = 0; i < rowStr.size() && added; ++i) {
                added = QueryFunction.QuerySetCell(query, i + 1, rowStr.get(i), rowCount);
            }
            if (!added) {
                throw new AddRowFailedException();
            }
        }
        return rowCount;
    }

    private static int addSimpleValueInRow(Object query, Object rowStr, int colIndex, int rowCount) {
        QueryFunction.QuerySetCell(query, colIndex, rowStr, rowCount);
        return rowCount;
    }

    public static boolean QuerySetCell(Object query, String column_name, Object value, int row_number) throws QueryTypeException, NoColumnInQueryException, RowNumberOutOfBoundException, QueryColumnNameException {
        if (query instanceof QueryTable) {
            QueryTable q = (QueryTable)query;
            column_name = column_name.trim();
            QueryFunction.validateColumnName(column_name);
            int col = q.findColumn(column_name);
            int row = q.getRowCount();
            if (col == 0) {
                throw new NoColumnInQueryException(column_name);
            }
            if (row_number <= 0 || row_number > row) {
                throw new RowNumberOutOfBoundException(row_number);
            }
            q.setField(row_number, col, value, true);
            return true;
        }
        if (query instanceof Query) {
            Query q = (Query)query;
            column_name = column_name.trim();
            QueryFunction.validateColumnName(column_name);
            int col = q.getColumnIndex(column_name);
            int row = q.getRowCount();
            if (col == -1) {
                throw new NoColumnInQueryException(column_name);
            }
            if (row_number <= 0 && row_number > row) {
                throw new RowNumberOutOfBoundException(row_number);
            }
            q.setData(row_number, col, value.toString());
            return true;
        }
        throw new QueryTypeException(query);
    }

    public static boolean QuerySetCell(Object query, int colNum, Object value, int row_number) throws QueryTypeException, NoColumnInQueryException, RowNumberOutOfBoundException, QueryColumnNameException {
        if (query instanceof QueryTable) {
            QueryTable q = (QueryTable)query;
            int row = q.getRowCount();
            int colCount = q.getCol_count();
            if (colNum <= 0 || colNum > colCount) {
                throw new ColumnNumberOutOfBoundException(colNum);
            }
            if (row_number <= 0 || row_number > row) {
                throw new RowNumberOutOfBoundException(row_number);
            }
            q.setField(row_number, colNum, value, true);
            return true;
        }
        if (query instanceof Query) {
            Query q = (Query)query;
            int row = q.getRowCount();
            int colCount = q.getColumns().length;
            if (colNum == -1 || colNum > colCount) {
                throw new ColumnNumberOutOfBoundException(colNum);
            }
            if (row_number <= 0 && row_number > row) {
                throw new RowNumberOutOfBoundException(row_number);
            }
            q.setData(row_number, colNum, value.toString());
            return true;
        }
        throw new QueryTypeException(query);
    }

    public static Struct QueryConvertForGrid(Object query, double pageNum, double pageSize) {
        QueryTable trimmedQuery;
        int totalRowCount;
        int startRow = (int)((pageNum - 1.0) * pageSize);
        int endRow = (int)((double)startRow + pageSize);
        int actualRowCount = 0;
        if (query instanceof Query) {
            totalRowCount = ((Query)query).getRowCount();
            columns = ((Query)query).getColumns();
            actualRowCount = totalRowCount - startRow;
            if ((double)actualRowCount > pageSize) {
                actualRowCount = (int)pageSize;
            }
            trimmedQuery = new QueryTable(actualRowCount, columns);
            int trimmedQueryRow = 0;
            for (int i = startRow; i < endRow && i < totalRowCount; ++i) {
                Row row = trimmedQuery.getRow(trimmedQueryRow++);
                for (int j = 0; j < columns.length; ++j) {
                    String value = ((Query)query).getData(i, j);
                    row.setColumn(j, value);
                }
            }
        } else if (query instanceof imqTable) {
            totalRowCount = ((imqTable)query).getRowCount();
            columns = ((imqTable)query).getColumnNames();
            actualRowCount = totalRowCount - startRow;
            if ((double)actualRowCount > pageSize) {
                actualRowCount = (int)pageSize;
            }
            trimmedQuery = new QueryTable(actualRowCount, columns);
            int trimmedQueryRow = 0;
            for (int i = startRow; i < endRow && i < totalRowCount; ++i) {
                Row row = trimmedQuery.getRow(trimmedQueryRow++);
                for (int j = 0; j < columns.length; ++j) {
                    Object value = ((imqTable)query).getRow(i).getColumn(j);
                    row.setColumn(j, value);
                }
            }
        } else {
            throw new QueryTypeException(query);
        }
        Struct s = new Struct();
        s.put(TOTAL_ROW_COUNT, (Object)new Integer(totalRowCount));
        s.put(QUERY, (Object)trimmedQuery);
        return s;
    }

    private static String validateColumnName(String c) {
        int len = c.length();
        for (int i = 0; i < len; ++i) {
            char ch = c.charAt(i);
            if (!(i == 0 ? !Character.isLetter(ch) && ch != '_' : !Character.isLetter(ch) && !Character.isDigit(ch) && !Character.isSpaceChar(ch) && ch != '_')) continue;
            throw new QueryColumnNameException(c);
        }
        return c;
    }

    public static Object validateDataType(QueryTable query, int columnIndex, Object value) {
        QueryTableMetaData metadata = (QueryTableMetaData)query.getMetaData();
        try {
            if (metadata != null && metadata.isTypeKnown(columnIndex)) {
                int sqlType = metadata.getColumnType(columnIndex);
                value = value != null && value instanceof String && value.equals("") && sqlType != 1 && sqlType != 12 && sqlType != -1 && sqlType != -15 && sqlType != -9 && sqlType != -16 ? null : Parameter.getMappingValue(value, sqlType, metadata.getColumnTypeName(columnIndex));
            }
        }
        catch (Parameter.DataTypeMismatchException dtex) {
            throw dtex;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return value;
    }

    public static int isValidColumnType(String type) {
        Integer itype;
        String Type2 = null;
        if (type != null) {
            Type2 = type.toUpperCase();
        }
        if ((itype = (Integer)rttExpr.supportedSqlTypes.get(Type2)) != null) {
            return itype;
        }
        throw new QueryColumnTypeException(type);
    }

    public static class QueryTypeException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String classname;

        public QueryTypeException(Object query) {
            this.classname = query.getClass().getName();
        }
    }

    public static class InvalidReturnTypeForQuerySomeException
    extends ApplicationException {
    }

    public static class InvalidReturnTypeForQueryEveryException
    extends ApplicationException {
    }

    public static class NoColumnInQueryException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String col_name;

        public NoColumnInQueryException(String col) {
            this.col_name = col;
        }
    }

    public static class InvalidReturnTypeForQueryFilterException
    extends ApplicationException {
    }

    public static class InvalidRowNumberException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String row_num;
        public String functionName;
        public String param_index;

        public InvalidRowNumberException(int paramIndex, int row, String functionName) {
            this.row_num = "" + row;
            this.functionName = functionName;
            this.param_index = "" + paramIndex;
        }
    }

    public static class RowNumberOutOfBoundException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String row_num;

        public RowNumberOutOfBoundException(int row) {
            this.row_num = "" + row;
        }
    }

    public static class QueryNewException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public int colNameSize;
        public int colTypeSize;

        public QueryNewException(int colNameSize, int colTypeSize) {
            this.colNameSize = colNameSize;
            this.colTypeSize = colTypeSize;
        }
    }

    public static class QuerySliceOutOfBoundException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String span;
        public String indexName;

        public QuerySliceOutOfBoundException(String index, int length) {
            this.indexName = index;
            this.span = "" + length;
        }
    }

    public static class QuerySchemaMismatch
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String col_name;
        public String functionName;
        public String newQueryCol_name;

        public QuerySchemaMismatch(String columnName, String newQueryColumnName, String funcName) {
            this.col_name = columnName;
            this.newQueryCol_name = newQueryColumnName;
            this.functionName = funcName;
        }
    }

    public static class ArrayDimensionException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String size;

        public ArrayDimensionException(int s) {
            this.size = "" + s;
        }
    }

    public static class DuplicateColumnNameException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String col_name;

        public DuplicateColumnNameException(String col) {
            this.col_name = col;
        }
    }

    public static class QueryRowTypeException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
    }

    public static class AddRowFailedException
    extends ExpressionException {
    }

    public static class ColumnNumberOutOfBoundException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String col_num;

        public ColumnNumberOutOfBoundException(int col) {
            this.col_num = "" + col;
        }
    }

    public static class QueryColumnNameException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String col_name;

        public QueryColumnNameException(String columnName) {
            this.col_name = columnName;
        }
    }

    public static class QueryColumnTypeException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String col_type;

        public QueryColumnTypeException(String coltype) {
            this.col_type = coltype;
        }
    }

    public static class InvalidReturnTypeForQuerySortException
    extends ApplicationException {
    }

    public static class QueryModificationException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
    }
}

