/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

public class RWLock {
    protected int n_readers;
    protected int n_writers;
    protected int n_pending;
    protected Thread writerThread;

    public synchronized int referenceCount() {
        return this.n_readers + this.n_writers + this.n_pending;
    }

    public synchronized void setPending(boolean startPending) {
        this.n_pending += startPending ? 1 : -1;
    }

    public void requestLock(boolean readonly, long timeout) throws InterruptedException {
        if (readonly) {
            this.requestReadLock(timeout);
        } else {
            this.requestWriteLock(timeout);
        }
    }

    public void releaseLock(boolean readonly) {
        if (readonly) {
            this.releaseReadLock();
        } else {
            this.releaseWriteLock();
        }
    }

    public synchronized void requestReadLock(long timeout) throws InterruptedException {
        long deadline = System.currentTimeMillis() + timeout;
        while (!this.allowReadAccess()) {
            this.waitForLock(timeout, deadline);
        }
        this.registerRead();
    }

    public synchronized void releaseReadLock() {
        this.unregisterRead();
        this.notifyAll();
    }

    protected boolean allowReadAccess() {
        return this.writerThread == null || Thread.currentThread() == this.writerThread;
    }

    protected void registerRead() {
        ++this.n_readers;
    }

    protected void unregisterRead() {
        --this.n_readers;
    }

    protected boolean allowWrite() {
        return this.allowReadAccess() && this.n_readers == 0;
    }

    protected void registerWrite() {
        ++this.n_writers;
        this.writerThread = Thread.currentThread();
    }

    protected void unregisterWrite() {
        if (--this.n_writers == 0) {
            this.writerThread = null;
        }
    }

    public synchronized void requestWriteLock(long timeout) throws InterruptedException {
        long deadline = System.currentTimeMillis() + timeout;
        while (!this.allowWrite()) {
            this.waitForLock(timeout, deadline);
        }
        this.registerWrite();
    }

    public synchronized void releaseWriteLock() {
        this.unregisterWrite();
        this.notifyAll();
    }

    protected final void waitForLock(long timeout, long deadline) throws InterruptedException {
        if (System.currentTimeMillis() > deadline) {
            throw new InterruptedException();
        }
        long timeToWait = deadline - System.currentTimeMillis();
        if (timeToWait == 0L) {
            throw new InterruptedException();
        }
        try {
            this.wait(timeToWait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

