/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.log.Logger;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ClientScope;
import coldfusion.runtime.ClientScopeKey;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.PersistenceHelperInterface;
import coldfusion.runtime.RegistryTagInternal;
import coldfusion.server.LoggingService;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.lang.RegistryException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;

final class RegistryHelper
implements PersistenceHelperInterface {
    public static String CLIENTS_ROOT = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Macromedia\\ColdFusion\\CurrentVersion\\Clients";
    public static final int ENTRY_INDEX = 1;
    public static final int TYPE_INDEX = 2;
    public static final int VALUE_INDEX = 3;

    RegistryHelper() {
    }

    private Logger getLogger() {
        LoggingService s = ServiceFactory.getLoggingService();
        return s.getLogger(this.getClass().getName());
    }

    public static final boolean IsApplicationVariable(String variable) {
        boolean rc = false;
        boolean foundColon = false;
        int length = variable.length();
        for (int i = 0; i < length; ++i) {
            char c = variable.charAt(i);
            if (foundColon) {
                if (c == ':') {
                    rc = true;
                    break;
                }
                foundColon = false;
                continue;
            }
            if (c != ':') continue;
            foundColon = true;
        }
        return rc;
    }

    public static final String ExtractVariableName(String variable, String AppName) {
        String App;
        int i;
        boolean foundColon = false;
        int length = variable.length();
        for (i = 0; i < length; ++i) {
            char c = variable.charAt(i);
            if (foundColon) {
                if (c == ':') break;
                foundColon = false;
                continue;
            }
            if (c != ':') continue;
            foundColon = true;
        }
        if ((App = variable.substring(0, i - 1)).equalsIgnoreCase(AppName)) {
            return variable.substring(i + 1, variable.length());
        }
        return null;
    }

    @Override
    public final ClientScope Get(NeoPageContext pageContext, ClientScopeKey key) {
        Hashtable<String, String> clientData = new Hashtable<String, String>();
        Hashtable<String, Object> clientGlobal = new Hashtable<String, Object>();
        StringBuffer branchStrBuf = new StringBuffer();
        branchStrBuf.append(CLIENTS_ROOT);
        branchStrBuf.append("\\");
        branchStrBuf.append(key.mCFID);
        branchStrBuf.append("-");
        branchStrBuf.append(key.mCFToken);
        String Branch2 = branchStrBuf.toString();
        RegistryTagInternal tag = new RegistryTagInternal();
        tag.setPageContext(pageContext);
        tag.setAction("getall");
        tag.setBranch(Branch2);
        tag.setType("any");
        tag.setName("_ClientVars_");
        boolean branchExists = true;
        try {
            tag.doStartTag();
        }
        catch (RegistryException re) {
            branchExists = false;
        }
        catch (Exception e) {
            this.getLogger().info(e.getMessage());
        }
        if (branchExists) {
            try {
                QueryTable table = (QueryTable)tag.getVariable("_ClientVars_");
                if (table != null) {
                    while (table.next()) {
                        String entry = table.getString(1).toLowerCase();
                        String value = table.getString(3);
                        if (RegistryHelper.IsApplicationVariable(entry)) {
                            if ((entry = RegistryHelper.ExtractVariableName(entry, key.mApplicationName)) == null) continue;
                            clientData.put(entry, value);
                            continue;
                        }
                        clientGlobal.put(entry, value);
                    }
                }
            }
            catch (Exception ce) {
                this.getLogger().info(ce.getMessage());
            }
        }
        if (clientGlobal.size() < 5) {
            OleDateTime now = new OleDateTime(new Date());
            clientGlobal.put("timecreated", now);
            clientGlobal.put("lastvisit", now);
            clientGlobal.put("hitcount", new Integer(1));
            clientGlobal.put("cfid", key.mCFID);
            clientGlobal.put("cftoken", key.mCFToken);
        }
        clientData.putAll(clientGlobal);
        ClientScope retval = new ClientScope(pageContext, key, clientData);
        retval.setIsNew(!branchExists);
        return retval;
    }

    @Override
    public final void Store(NeoPageContext pageContext, ClientScope clientScope, boolean globalUpdateDisabled) {
        String value;
        Object o;
        String entry;
        Hashtable clientVars = clientScope.getClientVars();
        Hashtable globalVars = clientScope.getGlobalVars();
        ClientScopeKey key = clientScope.getKey();
        StringBuffer branchStrBuf = new StringBuffer();
        branchStrBuf.append(CLIENTS_ROOT);
        branchStrBuf.append("\\");
        branchStrBuf.append(key.mCFID);
        branchStrBuf.append("-");
        branchStrBuf.append(key.mCFToken);
        String branch = branchStrBuf.toString();
        RegistryTagInternal tag = new RegistryTagInternal();
        tag.setPageContext(pageContext);
        tag.setAction("getall");
        tag.setBranch(branch);
        tag.setType("any");
        tag.setName("_ClientVars_");
        boolean branchExist = true;
        try {
            tag.doStartTag();
        }
        catch (RegistryException re) {
            branchExist = false;
        }
        catch (Exception e) {
            this.getLogger().info(e.getMessage());
        }
        if (branchExist) {
            try {
                QueryTable table = (QueryTable)tag.getVariable("_ClientVars_");
                if (table != null) {
                    while (table.next()) {
                        String variableName;
                        entry = table.getString(1);
                        if (!RegistryHelper.IsApplicationVariable(entry) || (variableName = RegistryHelper.ExtractVariableName(entry, key.mApplicationName)) == null) continue;
                        tag.setAction("delete");
                        tag.setBranch(branch);
                        tag.setEntry(entry);
                        tag.doStartTag();
                    }
                }
            }
            catch (Exception ce) {
                this.getLogger().info(ce.getMessage());
            }
        }
        tag.setPageContext(pageContext);
        tag.setAction("set");
        tag.setBranch(branch);
        tag.setType("string");
        Enumeration e = clientVars.keys();
        while (e.hasMoreElements()) {
            entry = (String)e.nextElement();
            o = clientVars.get(entry);
            value = Cast._String(o);
            tag.setEntry(key.mApplicationName + "::" + entry);
            tag.setValue(value);
            try {
                tag.doStartTag();
            }
            catch (Exception ce) {
                this.getLogger().info(ce.getMessage());
            }
        }
        e = globalVars.keys();
        while (e.hasMoreElements()) {
            entry = (String)e.nextElement();
            o = globalVars.get(entry);
            value = Cast._String(o);
            tag.setEntry(entry);
            tag.setValue(value);
            try {
                tag.doStartTag();
            }
            catch (Exception ge) {
                this.getLogger().info(ge.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void remove(LinkedList<ClientScopeKey> clientScopeKeyList) {
        ListIterator listIterator = clientScopeKeyList.listIterator();
        while (listIterator.hasNext()) {
            ClientScopeKey key = (ClientScopeKey)listIterator.next();
            StringBuffer branchStrBuf = new StringBuffer();
            branchStrBuf.append(CLIENTS_ROOT);
            branchStrBuf.append("\\");
            branchStrBuf.append(key.mCFID);
            branchStrBuf.append("-");
            branchStrBuf.append(key.mCFToken);
            String branch = branchStrBuf.toString();
            RegistryTagInternal tag = new RegistryTagInternal();
            tag.setAction("delete");
            tag.setType("any");
            tag.setBranch(branch);
            try {
                tag.doStartTag();
                continue;
            }
            catch (RegistryException registryException) {
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                listIterator.remove();
                continue;
            }
            break;
        }
        return;
    }
}

