/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.CfmServletHelper;
import coldfusion.Version;
import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.compiler.CustomTagTable;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.monitor.active.TemplateCacheMonitor;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.ProtectedScope;
import coldfusion.runtime.RealPathCache;
import coldfusion.runtime.Scope;
import coldfusion.runtime.SessionTracker;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.async.AsyncExecutorThreadPoolMetrics;
import coldfusion.runtime.async.Executor;
import coldfusion.runtime.locale.CFLocaleMgr;
import coldfusion.runtime.session.InMemorySessionStorage;
import coldfusion.runtime.session.SessionStorage;
import coldfusion.security.ESAPIUtils;
import coldfusion.server.ConfigMap;
import coldfusion.server.CorbaService;
import coldfusion.server.DebuggingService;
import coldfusion.server.LicenseService;
import coldfusion.server.RuntimeService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.server.SystemInfo;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import coldfusion.tagext.net.CookieTag;
import coldfusion.util.FastHashtable;
import coldfusion.util.PasswordUtils;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.util.WebEntityResolver;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFSFileSystemOptionFactory;
import coldfusion.xml.rpc.CFCServletHelper;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class RuntimeServiceImpl
extends ServiceBase
implements RuntimeService,
Observer {
    private File file;
    private String neoRoot;
    protected Boolean whitespace;
    protected ConfigMap locking;
    protected ConfigMap cfx_tags;
    protected ConfigMap custom_tags;
    protected ConfigMap corba;
    protected ConfigMap variables;
    protected ConfigMap errors;
    protected ConfigMap applications = new ConfigMap();
    protected ConfigMap mappings;
    protected ConfigMap request_settings;
    protected ConfigMap template_settings;
    protected ConfigMap charset_settings;
    protected ConfigMap form_settings;
    protected ConfigMap misc_settings;
    protected ConfigMap report_settings;
    protected ConfigMap requestThrottleSettings;
    protected ConfigMap apiManagerSettings;
    protected ConfigMap httpPoolingSettings;
    protected static String defaultMailCharset = "UTF-8";
    protected static String defaultCharset = "UTF-8";
    protected ConfigMap CF5Compatibility;
    protected String CFFormScriptSrc;
    protected Boolean loadRSLLibraries = Boolean.TRUE;
    protected String CFFormCodeBaseUrl = "http://java.sun.com/products/plugin/1.3/jinstall-13-win32.cab#Version=1,3,0,0";
    protected int numSimultaneousReports = 1;
    protected String scriptProtect = "";
    protected static boolean defaultLongIntegerFormat = false;
    private String comMapperDir;
    private String registryDir;
    public static final int APPLICATION_CFC_DEFAULT = 1;
    public static final int APPLICATION_CFC_TILL_WWWROOT = 2;
    public static final int APPLICATION_CFC_IN_WWWROOT = 3;
    protected static final String CACHE_REAL_PATH = "cache.webserver.paths";
    private int applicationCFCSearchCondition = 1;
    private String googleMapKey = null;
    private long appTimeout;
    private long appMaxTimeout;
    private long sessionTimeout;
    private long sessionMaxTimeout;
    private String sessionStorage;
    private String sessionStorageHost;
    private String redisCacheStorageHost;
    private boolean redisCacheStorageIsSSL;
    private int sessionStoragePort = 6379;
    private int sessionStorageTimeout = 2000;
    private int redisCacheStoragePort;
    private boolean sessionStorageCluster;
    private SessionStorage sessionStore;
    private static final String IN_MEMORY_STORAGE = "memory";
    private static final String REDIS_STORAGE = "redis";
    private Boolean isAppEnabled;
    private Boolean isSessionEnabled;
    private Boolean useJ2eeSession;
    private float postSizeLimit = 500.0f;
    private int postParametersLimit = 100;
    private boolean isSecureJSON;
    private boolean preserveCaseForSerialize;
    private boolean mutateObject;
    private String secureJSONPrefix;
    private String serverCFC;
    private boolean enableInMemoryFileSystem;
    private int inMemoryFileSystemLimit;
    private int inMemoryFileSystemAppLimit;
    private boolean httpOnlySessionCookie;
    private boolean secureSessionCookie;
    private int sessionCookieTimeout;
    private String sessionCookieDomain;
    private boolean internalCookiesDisableUpdate;
    private String sessionCookieSamesite;
    private int maxUnzipRatio;
    private boolean isPureJavaKit = false;
    private long requestTimeoutLimit;
    private boolean timeoutRequestsEnabled = true;
    private boolean logSlowRequestsEnabled = false;
    private long slowRequestTimeLimit;
    private boolean trustedCacheEnabled = false;
    private boolean inRequestTemplateCacheEnabled = true;
    private boolean componentCacheEnabled = true;
    private boolean internalCacheForQueryEnabled = false;
    private int cfthread_pool = 10;
    private boolean cfcTypeCheckEnabled = true;
    private int imageExpiryTime = 300;
    private boolean isPerAppSettingsEnabled = true;
    private boolean disableServiceFactory = false;
    private boolean allowExtraAttributesInAttrColl = true;
    private boolean enableServerCFC = false;
    private boolean disableUnnamedAppScopeDump = false;
    private boolean allowAppVarInContext = false;
    private String compileExtForInclude = "";
    private String blockedExtForFileUpload = "AS,ASP,ASPX,BIN,CFC,CFM,CFML,CFR,CFSWF,DMG,EXE,HBXML,JSP,JSPX,JWS,MXML,PHP,SWC,SWS,CLASS,JAR,ASMX,ASHX";
    private boolean enableCspNonceForScript = false;
    private String ORMSearchIndexDirectory;
    private static final int DEFAULT_REQUEST_LIMIT = 8;
    private static final int DEFAULT_CFC_LIMIT = 5;
    private static final int DEFAULT_WEBSERVICE_LIMIT = 5;
    private static final int DEFAULT_REPORT_LIMIT = 8;
    private static final int DEFAULT_QUEUE_TIMEOUT = 60;
    private static final int DEFAUTL_POST_PARAM_LIMIT = 100;
    private static final boolean DEFAULT_ISPERAPPSETTINGSENABLED = true;
    private static final boolean DEFAULT_DISABLE_SERVICE_FACTORY = false;
    private static final boolean DEFAULT_ALLOW_EXTRA_ATTRS_ATTRCOLL = true;
    private static final boolean DEFAULT_ENABLE_SERVER_CFC = false;
    private static final long DEFAULT_CFaaS_GENERATEDFILES_EXPIRY_TIME = 30L;
    private static final boolean DEFAULT_DISABLE_DUMP_UNNAMED_APPSCOPE = false;
    private static final boolean DEFAULT_ALLOW_APPVAR_INSERVCONTEXT = false;
    public static final String DEFAULT_COMPILE_EXT_INCLUDE = "";
    private static final boolean DEFAULT_ALLOW_REST_DISCOVERY = false;
    private static final String START_API_MANAGER = "startAPIManager";
    private static final String ALLOW_REST_DISCOVERY = "allowRestDiscovery";
    private static final boolean DEFAULT_ENABLE_NULL_SUPPORT = false;
    private static final boolean DEFAULT_USE_JAVA_AS_REGEX_ENGINE = false;
    private static final String ENABLE_NULL_SUPPORT = "enableNullSupport";
    private static final String USE_JAVA_AS_REGEX_ENGINE = "useJavaAsRegexEngine";
    private static final String MAX_THREAD_COUNT_FOR_PARALLEL_CALLS = "maxThreadCountForParallelCalls";
    private static final int DEFAULT_CORE_POOL_SIZE = 0;
    private static final int DEFAULT_CORE_POOL_SIZE_CLOUD_SERVICES = 0;
    private static final int DEFAULT_CORE_POOL_SIZE_GRAPHQL_CLIENT = 0;
    private static final int MAX_THREAD_LIMIT = 50;
    private static final int DEFAULT_MAX_UNZIP_RATIO = 100;
    private static final int DEFAULT_MAX_PARALLEL_THREAD_COUNT = Math.min(Runtime.getRuntime().availableProcessors(), 10);
    private static final int DEFAULT_MAX_POOL_SIZE = 0;
    private static final int DEFAULT_MAX_POOL_SIZE_CLOUD_SERVICES = 0;
    private static final int DEFAULT_MAX_POOL_SIZE_GRAPHQL_CLIENT = 0;
    private static final long DEFAULT_KEEP_ALIVE_TIME = 6000L;
    private static final long DEFAULT_KEEP_ALIVE_TIME_GRAPHQL_CLIENT = 6000L;
    private static final long DEFAULT_KEEP_ALIVE_TIME_CLOUD_SERVICES = 6000L;
    private boolean isCommandLineCompile = false;
    private String workingDir;
    private boolean isFileLockEnabled = true;
    private String tmpCacheDir;
    private Boolean startAPIManager = null;
    private boolean allowRestDiscovery = false;
    private boolean enableNullSupport = false;
    private boolean useJavaAsRegexEngine = false;
    private int maxThreadCountForParallelCalls = DEFAULT_MAX_PARALLEL_THREAD_COUNT;
    private int corePoolSize = 0;
    private int maxPoolSize = 0;
    private long keepAliveTime = 6000L;
    private CloudServicesThreadPoolConfiguration configuration = new CloudServicesThreadPoolConfiguration();
    private GraphQLClientThreadPoolConfiguration gqlThreadPoolConfig = new GraphQLClientThreadPoolConfiguration();
    public static final String OLDSEEDVAL = "0yJ!@1&r%gG^?az=|J!@1r7@";
    private String seed;
    private String webroot;
    private String CFIDE;
    private String WEBINF;
    private static final String ALLOWED_EXT_FOR_HANDLERS = "cfm,cfml,htm,html";
    private static final String ALLOWED_EXT_FOR_TIMEOUT_HANDLERS = "htm,html";
    public static final String MAX_TOTAL_HTTP_CONNECTIONS = "maxTotal";
    public static final String MAX_HTTP_CONNECTIONSPER_ROUTE = "maxPerRoute";
    public static final String HTTP_POOL_SOCKET_IDLE_TIMEOUT = "maxIdleTimeout";
    public static final String HTTP_POOL_SOCKET_TIMEOUT = "timeout";
    public static final String USE_HTTP_POOLING = "usepooling";
    public static final boolean DEFAULT_HTTP_POOLING = Boolean.valueOf(System.getProperty("coldfusion.http.usepooling", "true"));
    public static final String CORE_POOL_SIZE = "corePoolSize";
    public static final String MAX_POOL_SIZE = "maxPoolSize";
    public static final String KEEP_ALIVE_TIME = "keepAliveTime";
    public static final String CORE_POOL_SIZE_CLOUD_SERVICES = "corePoolSizeCloudServices";
    public static final String MAX_POOL_SIZE_CLOUD_SERVICES = "maxPoolSizeCloudServices";
    public static final String KEEP_ALIVE_TIME_CLOUD_SERVICES = "keepAliveTimeCloudServices";
    public static final String CORE_POOL_SIZE_GRAPHQL_CLIENT = "corePoolSizeGraphQLClient";
    public static final String MAX_POOL_SIZE_GRAPHQL_CLIENT = "maxPoolSizeGraphQLClient";
    public static final String KEEP_ALIVE_TIME_GRAPHQL_CLIENT = "keepAliveTimeGraphQLClient";
    public static final String DEFAULT_BLOCKED_EXT_FOR_FILEUPLOAD = "AS,ASP,ASPX,BIN,CFC,CFM,CFML,CFR,CFSWF,DMG,EXE,HBXML,JSP,JSPX,JWS,MXML,PHP,SWC,SWS,CLASS,JAR,ASMX,ASHX";
    private CustomTagTable tagTable;
    private Map resolvedCustomTags;
    private Map evaluateScope;
    private ProtectedScope serverScope;
    private String appServer = "Tomcat";
    private int maxOutputBufferSize;
    private FilePermission webInfClassesReadPermission;
    private List<String> ejbNames = Collections.emptyList();
    private static String webInfPath;

    public RuntimeServiceImpl(File file, String neoRoot) {
        this.file = file;
        this.neoRoot = neoRoot;
        this.setupServerScope(neoRoot);
        this.setEnableWatch(true);
        this.setWatchFile(file);
    }

    public RuntimeServiceImpl(File file, String neoRoot, String appServer, String context_root) {
        this.file = file;
        this.neoRoot = neoRoot;
        this.setAppServer(appServer);
        this.setupServerScope(neoRoot);
        this.CFFormScriptSrc = context_root + "/cf_scripts/scripts";
        this.setEnableWatch(true);
        this.setWatchFile(file);
    }

    public RuntimeServiceImpl(File file, String neoRoot, boolean isCommandLineCompile) {
        this(file, neoRoot);
        this.isCommandLineCompile = isCommandLineCompile;
    }

    public RuntimeServiceImpl(File file, String neoRoot, String workingDir, boolean isCommandLineCompile) {
        this(file, neoRoot);
        this.isCommandLineCompile = isCommandLineCompile;
        this.workingDir = workingDir;
    }

    @Override
    public Map getApplications() {
        return this.applications;
    }

    @Override
    public Map getErrors() {
        return this.errors;
    }

    @Override
    public String getCFIDE() {
        return this.CFIDE;
    }

    public void setCFIDE(String CFIDE) {
        this.CFIDE = CFIDE;
    }

    @Override
    public String getWEBINF() {
        return this.WEBINF;
    }

    public void setWEBINF(String WEBINF) {
        this.WEBINF = WEBINF;
    }

    @Override
    public String getSiteWideErrorHandler() {
        if (this.errors != null) {
            return this.errors.get("site_wide").toString();
        }
        return null;
    }

    @Override
    public void setSiteWideErrorHandler(String handler) {
        if (handler != null) {
            RuntimeServiceImpl.validateFileExtension(handler, ALLOWED_EXT_FOR_HANDLERS);
            this.errors.put("site_wide", (Object)handler);
        }
    }

    @Override
    public String getTimeoutErrorHandler() {
        if (this.errors != null) {
            return this.errors.get("queue_timeout").toString();
        }
        return null;
    }

    @Override
    public void setTimeoutErrorHandler(String handler) {
        if (handler != null) {
            RuntimeServiceImpl.validateFileExtension(handler, ALLOWED_EXT_FOR_TIMEOUT_HANDLERS);
            this.errors.put("queue_timeout", (Object)handler);
        }
    }

    @Override
    public String getMissingTemplateErrorHandler() {
        if (this.errors != null) {
            return this.errors.get("missing_template").toString();
        }
        return null;
    }

    @Override
    public void setMissingTemplateErrorHandler(String handler) {
        if (handler != null) {
            RuntimeServiceImpl.validateFileExtension(handler, ALLOWED_EXT_FOR_HANDLERS);
            this.errors.put("missing_template", (Object)handler);
        }
    }

    @Override
    public Map getMappings() {
        return this.mappings;
    }

    public void setMappingsCFIDEPath(String cfidePath) {
        this.mappings.put("/CFIDE", (Object)cfidePath);
        try {
            this.store();
        }
        catch (ServiceException e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public Boolean getWhitespace() {
        return this.whitespace;
    }

    @Override
    public void setWhitespace(String setting) {
        this.whitespace = Cast._int(setting) > 0;
        try {
            this.store();
        }
        catch (ServiceException e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public Map getLocking() {
        return this.locking;
    }

    @Override
    public Map getCfxtags() {
        return this.cfx_tags;
    }

    @Override
    public Map getCustomtags() {
        return this.custom_tags;
    }

    @Override
    public Map getCorba() {
        return this.corba;
    }

    @Override
    public Map getVariables() {
        return this.variables;
    }

    @Override
    public String getRootDir() {
        return this.neoRoot;
    }

    @Override
    public String getLibDir() {
        return this.neoRoot + File.separator + "lib";
    }

    public void setComMapperDir(String dir) {
        this.comMapperDir = dir;
    }

    public String getComMapperDir() {
        return this.comMapperDir;
    }

    public void setRegistryDir(String dir) {
        this.registryDir = dir;
    }

    @Override
    public String getRegistryDir() {
        return this.registryDir;
    }

    @Override
    public Map getRequestSettings() {
        return this.request_settings;
    }

    @Override
    public Map getCharsetSettings() {
        return this.charset_settings;
    }

    @Override
    public Map getRequestThrottleSettings() {
        return this.requestThrottleSettings;
    }

    @Override
    public String getScriptProtect() {
        return this.scriptProtect;
    }

    @Override
    public void setScriptProtect(String scriptProtect) {
        this.scriptProtect = scriptProtect;
        try {
            this.store();
        }
        catch (ServiceException e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public boolean isFileLockEnabled() {
        return this.isFileLockEnabled;
    }

    @Override
    public Map getMiscSettings() {
        return this.misc_settings;
    }

    @Override
    public Map getReportSettings() {
        return this.report_settings;
    }

    @Override
    public void setApiManagerSettings(ConfigMap apiManagerSettings) {
        this.apiManagerSettings = apiManagerSettings;
    }

    @Override
    public Map getApiManagerSettings() {
        return this.apiManagerSettings;
    }

    @Override
    public ConfigMap getHttpPoolingSettings() {
        return this.httpPoolingSettings;
    }

    @Override
    public void setHttpPoolingSettings(ConfigMap httpPoolingSettings) {
        this.httpPoolingSettings = httpPoolingSettings;
    }

    @Override
    public int getMaxUnzipRatio() {
        return this.maxUnzipRatio;
    }

    @Override
    public void setMaxUnzipRatio(int ratio) {
        this.maxUnzipRatio = ratio;
        this.misc_settings.put("maxUnzip", (Object)ratio);
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        PasswordUtils.getInstance(this.neoRoot).addObserver(this);
        this.initSessionStore(false);
    }

    @Override
    public void load() throws ServiceException {
        try {
            Vector v = this.loadSettings();
            Vector localv = (Vector)this.deserialize(this.file, true);
            this.whitespace = (Boolean)v.elementAt(0);
            this.locking = (ConfigMap)v.elementAt(1);
            this.cfx_tags = (ConfigMap)v.elementAt(2);
            this.custom_tags = (ConfigMap)localv.elementAt(3);
            this.corba = (ConfigMap)v.elementAt(4);
            this.variables = (ConfigMap)v.elementAt(5);
            this.errors = (ConfigMap)v.elementAt(6);
            this.initMissingSetting(this.errors, "queue_timeout", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.errors, "missing_template", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.errors, "site_wide", DEFAULT_COMPILE_EXT_INCLUDE);
            this.mappings = (ConfigMap)localv.elementAt(7);
            this.request_settings = (ConfigMap)v.elementAt(8);
            this.initMissingSetting(this.request_settings, "requestLimit", new Integer(8));
            this.initMissingSetting(this.request_settings, "webserviceLimit", new Integer(5));
            this.initMissingSetting(this.request_settings, "CFCLimit", new Integer(5));
            this.initMissingSetting(this.request_settings, "queueTimeout", new Integer(60));
            this.initMissingSetting(this.request_settings, "cacheWebServerPath", Boolean.FALSE);
            this.initMissingSetting(this.request_settings, "postParametersLimit", new Integer(100));
            System.setProperty(CACHE_REAL_PATH, this.request_settings.get("cacheWebServerPath").toString());
            this.template_settings = (ConfigMap)v.elementAt(9);
            this.initMissingSetting(this.template_settings, "componentCacheEnabled", new Boolean(true));
            this.charset_settings = v.size() > 10 ? (ConfigMap)v.elementAt(10) : new ConfigMap();
            this.initMissingSetting(this.charset_settings, "defaultCharset", defaultCharset);
            this.initMissingSetting(this.charset_settings, "defaultMailCharset", defaultMailCharset);
            this.CF5Compatibility = v.size() > 11 ? (ConfigMap)v.elementAt(11) : new ConfigMap();
            this.initMissingSetting(this.CF5Compatibility, "longIntegerFormat", defaultLongIntegerFormat);
            ConfigMap local_form_settings = null;
            if (v.size() > 12) {
                this.form_settings = (ConfigMap)v.elementAt(12);
                local_form_settings = (ConfigMap)localv.elementAt(12);
            } else {
                this.form_settings = new ConfigMap();
                local_form_settings = new ConfigMap();
            }
            this.initMissingSetting(local_form_settings, "CFFormScriptSrc", this.CFFormScriptSrc);
            this.form_settings.put("CFFormScriptSrc", local_form_settings.get("CFFormScriptSrc"), false);
            this.initMissingSetting(this.form_settings, "loadRSLLibraries", this.loadRSLLibraries);
            this.initMissingSetting(this.form_settings, "CFFormCodeBaseUrl", this.CFFormCodeBaseUrl);
            this.scriptProtect = v.size() > 13 ? (String)v.elementAt(13) : DEFAULT_COMPILE_EXT_INCLUDE;
            this.misc_settings = v.size() > 14 ? (ConfigMap)v.elementAt(14) : new ConfigMap();
            ConfigMap local_misc_settings = (ConfigMap)localv.elementAt(14);
            this.misc_settings.put("ORMSearchIndexDirectory", local_misc_settings.get("ORMSearchIndexDirectory"));
            this.initMissingSetting(this.misc_settings, "fileLockEnabled", this.isFileLockEnabled);
            this.initMissingSetting(this.misc_settings, "cfthreadpool", new Integer(10));
            this.initMissingSetting(this.misc_settings, "isPerAppSettingsEnabled", true);
            this.initMissingSetting(this.misc_settings, "disableServiceFactory", false);
            this.initMissingSetting(this.misc_settings, "cfcTypeCheckEnabled", Boolean.TRUE);
            this.initMissingSetting(this.misc_settings, "imageExpiryTime", new Integer(300));
            this.initMissingSetting(this.misc_settings, "preserveCaseForSerialize", Boolean.FALSE);
            this.initMissingSetting(this.misc_settings, "secureJSON", Boolean.FALSE);
            this.initMissingSetting(this.misc_settings, "secureJSONPrefix", "//");
            this.initMissingSetting(this.misc_settings, "secureJSON", Boolean.TRUE);
            this.initMissingSetting(this.misc_settings, "enableInMemoryFileSystem", Boolean.TRUE);
            this.initMissingSetting(this.misc_settings, "inMemoryFileSystemLimit", new Integer(100));
            this.initMissingSetting(this.misc_settings, "inMemoryFileSystemAppLimit", new Integer(20));
            this.initMissingSetting(this.misc_settings, "inMemoryFileSystemAppLimit", new Integer(20));
            this.initMissingSetting(this.misc_settings, "allowExtraAttributesInAttrColl", true);
            this.initMissingSetting(this.misc_settings, "maxOutputBufferSize", new Integer(1024));
            this.initMissingSetting(this.misc_settings, "enableServerCFC", false);
            this.initMissingSetting(this.misc_settings, "serverCFC", "Server");
            this.initMissingSetting(this.misc_settings, "googleMapKey", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "ORMSearchIndexDirectory", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "applicationCFCSearchLimit", "1");
            this.initMissingSetting(this.misc_settings, "httpOnlySessionCookie", Boolean.TRUE);
            this.initMissingSetting(this.misc_settings, "secureSessionCookie", Boolean.FALSE);
            this.initMissingSetting(this.misc_settings, "sessionCookieTimeout", CookieTag.Max_Cookie_Age);
            this.initMissingSetting(this.misc_settings, "sessionCookieDomain", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "internalCookiesDisableUpdate", Boolean.FALSE);
            this.initMissingSetting(this.misc_settings, "sessionCookieSamesite", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "dumpunnamedappscope", new Boolean(false));
            this.initMissingSetting(this.misc_settings, "allowappvarincontext", new Boolean(false));
            this.initMissingSetting(this.misc_settings, "compileextforinclude", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "maxUnzip", 100);
            if (this.misc_settings.containsKey("maxUnzipRatio")) {
                this.misc_settings.remove("maxUnzipRatio");
            }
            this.initMissingSetting(this.misc_settings, "sessionStorage", IN_MEMORY_STORAGE);
            this.initMissingSetting(this.misc_settings, "sessionStorageHost", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "sessionStoragePort", 6379);
            this.initMissingSetting(local_misc_settings, "sessionStoragePassword", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "sessionStorageTimeout", 2000);
            this.initMissingSetting(this.template_settings, "redisCacheStorageHost", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.template_settings, "redisCacheStoragePort", 0);
            this.initMissingSetting(this.template_settings, "redisCacheStoragePassword", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.template_settings, "redisCacheStorageIsSSL", false);
            this.initMissingSetting(this.template_settings, "sessionStorageCluster", false);
            this.initMissingSetting(this.misc_settings, ENABLE_NULL_SUPPORT, false);
            this.enableNullSupport = (Boolean)this.misc_settings.get(ENABLE_NULL_SUPPORT);
            this.initMissingSetting(this.misc_settings, USE_JAVA_AS_REGEX_ENGINE, false);
            this.useJavaAsRegexEngine = (Boolean)this.misc_settings.get(USE_JAVA_AS_REGEX_ENGINE);
            this.initMissingSetting(this.misc_settings, MAX_THREAD_COUNT_FOR_PARALLEL_CALLS, DEFAULT_MAX_PARALLEL_THREAD_COUNT);
            this.maxThreadCountForParallelCalls = Math.min(50, Cast._int(this.misc_settings.get(MAX_THREAD_COUNT_FOR_PARALLEL_CALLS)));
            this.initMissingSetting(this.misc_settings, CORE_POOL_SIZE, 0);
            this.initMissingSetting(this.misc_settings, MAX_POOL_SIZE, 0);
            this.initMissingSetting(this.misc_settings, KEEP_ALIVE_TIME, 6000L);
            this.initMissingSetting(this.misc_settings, CORE_POOL_SIZE_CLOUD_SERVICES, 0);
            this.initMissingSetting(this.misc_settings, MAX_POOL_SIZE_CLOUD_SERVICES, 0);
            this.initMissingSetting(this.misc_settings, KEEP_ALIVE_TIME_CLOUD_SERVICES, 6000L);
            this.initMissingSetting(this.misc_settings, CORE_POOL_SIZE_GRAPHQL_CLIENT, 0);
            this.initMissingSetting(this.misc_settings, MAX_POOL_SIZE_GRAPHQL_CLIENT, 0);
            this.initMissingSetting(this.misc_settings, KEEP_ALIVE_TIME_GRAPHQL_CLIENT, 6000L);
            this.report_settings = v.size() > 16 ? (ConfigMap)v.elementAt(15) : new ConfigMap();
            this.initMissingSetting(this.report_settings, "numSimultaneousReports", new Integer(8));
            this.requestThrottleSettings = v.size() > 16 ? (ConfigMap)v.elementAt(16) : new ConfigMap();
            if (v.size() > 17) {
                this.apiManagerSettings = (ConfigMap)v.elementAt(17);
                if (this.apiManagerSettings.containsKey(START_API_MANAGER)) {
                    this.startAPIManager = (Boolean)this.apiManagerSettings.get(START_API_MANAGER);
                }
                if (this.apiManagerSettings.containsKey(ALLOW_REST_DISCOVERY)) {
                    this.allowRestDiscovery = (Boolean)this.apiManagerSettings.get(ALLOW_REST_DISCOVERY);
                }
            } else {
                this.apiManagerSettings = new ConfigMap();
            }
            this.httpPoolingSettings = v.size() > 18 ? (ConfigMap)v.elementAt(18) : new ConfigMap();
            this.initMissingSetting(this.httpPoolingSettings, USE_HTTP_POOLING, DEFAULT_HTTP_POOLING);
            this.initMissingSetting(this.httpPoolingSettings, MAX_TOTAL_HTTP_CONNECTIONS, 200);
            this.initMissingSetting(this.httpPoolingSettings, MAX_HTTP_CONNECTIONSPER_ROUTE, 20);
            this.initMissingSetting(this.httpPoolingSettings, HTTP_POOL_SOCKET_TIMEOUT, -1);
            this.initMissingSetting(this.httpPoolingSettings, HTTP_POOL_SOCKET_IDLE_TIMEOUT, 30000);
            this.initMissingSetting(this.misc_settings, "blockedExtForFileUpload", DEFAULT_BLOCKED_EXT_FOR_FILEUPLOAD);
            this.initMissingSetting(this.misc_settings, "enableCspNonceForScript", false);
            if (CentralConfigClientUtil.isCCSAvailaible()) {
                GenericCacheFactory.resetCache(2);
                GenericCacheFactory.resetCache(0);
                GenericCacheFactory.resetCache(3);
                GenericCacheFactory.resetCache(1);
                GenericCacheFactory.setCacheType(this.getServerCacheType());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException(ex);
        }
        this.updateCustomTags();
        this.locking.init(this, "locking");
        this.cfx_tags.init(this, "cfx_tags");
        this.initMap(this.cfx_tags, "cfx");
        this.custom_tags.init(this, "custom_tags");
        this.corba.init(this, "corba");
        if (this.corba.containsKey("orbs")) {
            ((ConfigMap)this.corba.get("orbs")).init(this, "orbs");
        }
        this.variables.init(this, "variables");
        ((ConfigMap)this.variables.get("application")).init(this, "application");
        ((ConfigMap)this.variables.get("session")).init(this, "session");
        this.mappings.init(this, "mappings");
        this.request_settings.init(this, "request_settings");
        this.errors.init(this, "errors");
        if (!RuntimeServiceImpl.isValidFileExtension(this.getMissingTemplateErrorHandler(), ALLOWED_EXT_FOR_HANDLERS)) {
            CFLogs.SERVER_LOG.error(RB.getString(this, "RuntimeServiceImpl.invalid_missing_template_file_extension"));
            this.setMissingTemplateErrorHandler(DEFAULT_COMPILE_EXT_INCLUDE);
        }
        if (!RuntimeServiceImpl.isValidFileExtension(this.getSiteWideErrorHandler(), ALLOWED_EXT_FOR_HANDLERS)) {
            CFLogs.SERVER_LOG.error(RB.getString(this, "RuntimeServiceImpl.invalid_sitewide_error_file_extension"));
            this.setSiteWideErrorHandler(DEFAULT_COMPILE_EXT_INCLUDE);
        }
        if (!RuntimeServiceImpl.isValidFileExtension(this.getTimeoutErrorHandler(), ALLOWED_EXT_FOR_TIMEOUT_HANDLERS)) {
            CFLogs.SERVER_LOG.error(RB.getString(this, "RuntimeServiceImpl.invalid_queue_timeout_file_extension"));
            this.setTimeoutErrorHandler(DEFAULT_COMPILE_EXT_INCLUDE);
        }
        this.applications.init(this, "applications");
        this.initMap(this.applications, "application");
        this.misc_settings.init(this, "misc");
        this.locking.setConfigMapListener(this);
        this.cfx_tags.setConfigMapListener(this);
        this.custom_tags.setConfigMapListener(this);
        this.corba.setConfigMapListener(this);
        ((ConfigMap)this.variables.get("session")).setConfigMapListener(this);
        ((ConfigMap)this.variables.get("application")).setConfigMapListener(this);
        this.mappings.setConfigMapListener(this);
        this.errors.setConfigMapListener(this);
        this.applications.setConfigMapListener(this);
        this.request_settings.setConfigMapListener(this);
        this.template_settings.setConfigMapListener(this);
        this.charset_settings.setConfigMapListener(this);
        this.form_settings.setConfigMapListener(this);
        this.CF5Compatibility.setConfigMapListener(this);
        this.misc_settings.setConfigMapListener(this);
        this.report_settings.setConfigMapListener(this);
        this.requestThrottleSettings.setConfigMapListener(this);
        this.apiManagerSettings.setConfigMapListener(this);
        this.httpPoolingSettings.setConfigMapListener(this);
        this.ParseVariableSettings();
        TemplateClassLoader.setCacheSize(this.getTemplateCacheSize());
        TemplateClassLoader.setSaveClasses(this.getSaveClassFiles());
        System.setProperty("jasper.reports.compile.xml.validation", "false");
    }

    @Override
    public void loadCorba() throws ServiceException {
        try {
            CorbaService corbaService;
            if (!this.isCommandLineCompile && (corbaService = ServiceFactory.getCorbaService()) != null) {
                corbaService.initialize(this.corba);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    Vector loadSettings() {
        return (Vector)this.deserialize(this.file);
    }

    @Override
    public void store() throws ServiceException {
        this.store(null, null, null, true);
    }

    @Override
    public void store(boolean broadcast) throws ServiceException {
        this.store(null, null, null, broadcast);
    }

    @Override
    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.store(key, value, oldValue, true);
    }

    @Override
    public void store(Object key, Object value, Object oldValue, boolean broadcast) throws ServiceException {
        Vector<Object> v = new Vector<Object>();
        v.addElement(this.whitespace);
        v.addElement(this.locking);
        v.addElement(this.cfx_tags);
        v.addElement(this.custom_tags);
        v.addElement(this.corba);
        v.addElement(this.variables);
        v.addElement(this.errors);
        v.addElement(this.mappings);
        v.addElement(this.request_settings);
        v.addElement(this.template_settings);
        v.addElement(this.charset_settings);
        v.addElement(this.CF5Compatibility);
        v.addElement(this.form_settings);
        v.addElement(this.scriptProtect);
        v.addElement(this.misc_settings);
        v.addElement(this.report_settings);
        v.addElement(this.requestThrottleSettings);
        v.addElement(this.apiManagerSettings);
        this.serialize(v, this.file, broadcast, key, value, oldValue);
        this.updateCustomTags();
        this.ParseVariableSettings();
        this.notifyServiceListeners();
    }

    private void updateCustomTags() {
        this.resolvedCustomTags = new FastHashtable();
        this.tagTable = null;
        for (Map.Entry entry : this.custom_tags.entrySet()) {
            String path = (String)entry.getKey();
            String valueExpr = (String)entry.getValue();
            this.resolvedCustomTags.put(path, valueExpr != null ? this.evaluate(valueExpr) : null);
        }
    }

    @Override
    public final File resolveTemplateName(String name, String ext) {
        File app_f;
        ApplicationScope appScope;
        FusionContext ctx;
        if (this.isPerAppSettingsEnabled && (ctx = FusionContext.getCurrent()) != null && ctx.hiddenScope != null && this.isApplicationEnabled() && (appScope = (ApplicationScope)ctx.hiddenScope.get("Application")) != null && (app_f = appScope.resolveTemplateName((String)name, ext)) != null) {
            return app_f;
        }
        if (this.tagTable == null) {
            this.tagTable = new CustomTagTable(this.resolvedCustomTags);
        }
        if (((String)name).indexOf(46) != -1 && ((String)(name = ((String)name).replace('.', '/'))).charAt(0) != '/') {
            name = "/" + (String)name;
        }
        String origName = name;
        File f = this.tagTable.findTemplate((String)(name = ((String)name).toLowerCase()) + ext);
        if (f == null && !SystemInfo.isWindows()) {
            f = this.tagTable.findTemplate(origName + ext);
        }
        if (f == null && !this.isTrustedCache()) {
            CustomTagTable newTable = new CustomTagTable(this.resolvedCustomTags);
            f = newTable.findTemplate((String)name + ext);
            if (f == null && !SystemInfo.isWindows()) {
                f = newTable.findTemplate(origName + ext);
            }
            if (f != null) {
                this.tagTable = newTable;
            }
        }
        return f;
    }

    @Override
    public String getFullTagName(ServletContext servletContext, String canonicalPath) throws IOException {
        String fullTagName = null;
        if (this.isPerAppSettingsEnabled) {
            ApplicationScope appScope;
            CustomTagTable app_tagTable = null;
            FusionContext ctx = FusionContext.getCurrent();
            if (ctx != null && ctx.hiddenScope != null && (appScope = (ApplicationScope)ctx.hiddenScope.get("Application")) != null) {
                app_tagTable = appScope.getApplicationTagTable();
            }
            if (app_tagTable != null) {
                fullTagName = app_tagTable.getFullTagName(canonicalPath);
            }
        }
        if (fullTagName == null) {
            if (this.tagTable == null) {
                this.tagTable = new CustomTagTable(this.resolvedCustomTags);
            }
            fullTagName = this.tagTable.getFullTagName(canonicalPath);
        }
        return fullTagName;
    }

    @Override
    public final File resolveTemplatePath(String relativePath) {
        File file;
        if (File.separatorChar == '\\') {
            relativePath = ((String)relativePath).replace('\\', '/');
        }
        String origPath = relativePath;
        if (!SystemInfo.isWindows()) {
            int pos = ((String)relativePath).lastIndexOf(47);
            relativePath = pos == -1 ? ((String)relativePath).toLowerCase() : ((String)relativePath).substring(0, pos + 1) + ((String)relativePath).substring(pos + 1).toLowerCase();
        }
        FusionContext context = FusionContext.getCurrent();
        if (((String)relativePath).length() != 0 && ((String)relativePath).charAt(0) == '/') {
            File canonicalFile = Utils.getCanonicalFile(context.getRealPath(origPath));
            file = this.getFile(context, canonicalFile);
            if (file == null && !SystemInfo.isWindows()) {
                canonicalFile = Utils.getCanonicalFile(context.getRealPath((String)relativePath));
                file = this.getFile(context, canonicalFile);
            }
            if (file == null && this.isCommandLineCompile()) {
                canonicalFile = Utils.getCanonicalFile(this.getWebRoot() + File.separatorChar + (String)relativePath);
                file = this.getFile(context, canonicalFile);
            }
            if (file == null && this.isCommandLineCompile() && this.workingDir != null) {
                canonicalFile = Utils.getCanonicalFile(this.workingDir + File.separatorChar + (String)relativePath);
                file = this.getFile(context, canonicalFile);
            }
        } else {
            int slash;
            String path = context.getPagePath();
            String fullPath = path.substring(0, (slash = path.lastIndexOf(File.separatorChar)) + 1) + (String)relativePath;
            File canonicalFile = Utils.getCanonicalFile(fullPath);
            file = this.getFile(context, canonicalFile);
            if (file == null && !SystemInfo.isWindows()) {
                fullPath = path.substring(0, slash + 1) + origPath;
                canonicalFile = Utils.getCanonicalFile(fullPath);
                file = this.getFile(context, canonicalFile);
            }
        }
        return file;
    }

    private File getFile(FusionContext context, File f) {
        block3: {
            try {
                if (TemplateClassLoader.findClass(context.getServletContext(), f.getPath()) != null) {
                    return f;
                }
            }
            catch (IOException e) {
                if (!f.isFile()) break block3;
                return f;
            }
        }
        return null;
    }

    private String evalDottedVariable(Map scope, String key) {
        int dot = key.indexOf(46);
        if (dot == -1) {
            return String.valueOf(scope.get(key));
        }
        try {
            scope = (Map)scope.get(key.substring(0, dot));
            int dot2 = key.indexOf(46, dot + 1);
            while (dot2 != -1) {
                String stem = key.substring(dot + 1, dot2);
                if ((scope = Cast._Map(scope.get(stem))) == null) {
                    return null;
                }
                dot = dot2;
                dot2 = key.indexOf(46, dot + 1);
            }
            return String.valueOf(scope.get(key.substring(dot + 1)));
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public String evaluate(String s) {
        if (this.evaluateScope == null) {
            this.evaluateScope = new FastHashtable();
            this.evaluateScope.put("server", this.serverScope);
        }
        StringBuffer out = new StringBuffer(2 * s.length());
        int i = 0;
        int len = s.length();
        do {
            int j;
            if ((j = s.indexOf(35, i)) == -1) {
                j = len;
                out.append(s.substring(i, j));
                break;
            }
            if (j > i) {
                out.append(s.substring(i, j));
            }
            if ((i = s.indexOf(35, j + 1)) == -1) {
                i = len;
                out.append(s.substring(j, i));
                break;
            }
            String name = s.substring(j + 1, i);
            String value = this.evalDottedVariable(this.evaluateScope, name.trim());
            if (value != null) {
                out.append(value);
                continue;
            }
            out.append('#').append(name).append('#');
        } while (++i < len);
        return out.toString();
    }

    private boolean checkFileExists(final String filePath) {
        if (System.getSecurityManager() == null) {
            return this._checkFileExists(filePath);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return RuntimeServiceImpl.this._checkFileExists(filePath);
            }
        });
    }

    private boolean _checkFileExists(String filePath) {
        return filePath != null && VFSFileFactory.getFileObject(filePath).exists();
    }

    private Struct getMappingsFromAppScope(FusionContext ctx) {
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(ctx.getApplicationName());
        Struct app_mappings = null;
        if (appScope != null) {
            Object o;
            appScope.getApplicationSettingsMap();
            Map appSpecificSettings = appScope.getApplicationSettingsMap();
            if (appSpecificSettings != null && (o = appSpecificSettings.get("mappings")) instanceof Struct) {
                app_mappings = (Struct)o;
            }
        }
        return app_mappings;
    }

    public String getRealPath(ServletContext application, String uripath, boolean resolveUsingRealPath) {
        Map app_resolvedCustomTags;
        FusionContext ctx;
        Struct app_mappings = null;
        ApplicationScope appScope = null;
        if (this.isPerAppSettingsEnabled && (ctx = FusionContext.getCurrent()) != null && this.isApplicationEnabled()) {
            AppHelper appHelper = ctx.getAppHelper();
            if (appHelper != null) {
                app_mappings = appHelper.getApplicationMappings();
                if (app_mappings == null || app_mappings.size() == 0) {
                    app_mappings = this.getMappingsFromAppScope(ctx);
                }
            } else {
                app_mappings = this.getMappingsFromAppScope(ctx);
            }
        }
        String path = null;
        if (app_mappings != null) {
            path = this.mapVirtualToReal(uripath, app_mappings);
        }
        boolean mappedFileExists = false;
        String mappedFilePath = null;
        if (path != null && this.checkFileExists(path)) {
            mappedFileExists = true;
        }
        mappedFilePath = path;
        if (path == null || !mappedFileExists) {
            path = this.mapVirtualToReal(uripath, this.mappings);
            if (path != null && this.checkFileExists(path)) {
                mappedFileExists = true;
                mappedFilePath = path;
            } else if (mappedFilePath == null) {
                mappedFilePath = path;
            }
        }
        if (this.isPerAppSettingsEnabled && path == null | !mappedFileExists && appScope != null && (app_resolvedCustomTags = appScope.getAppResolvedCustomTags()) != null) {
            path = this.mapVirtualToReal(uripath, app_resolvedCustomTags);
            if (path != null && this.checkFileExists(path)) {
                mappedFileExists = true;
                mappedFilePath = path;
            } else if (mappedFilePath == null) {
                mappedFilePath = path;
            }
        }
        if (path == null | !mappedFileExists) {
            path = this.mapVirtualToReal(uripath, this.resolvedCustomTags);
            if (mappedFilePath == null && !resolveUsingRealPath) {
                mappedFilePath = path;
            } else if (path != null && this.checkFileExists(path)) {
                mappedFileExists = true;
                mappedFilePath = path;
            } else if (mappedFilePath == null) {
                mappedFilePath = path;
            }
        }
        if (!resolveUsingRealPath) {
            return mappedFilePath;
        }
        if (path == null | !mappedFileExists) {
            uripath = Utils.normalizeSeparator(uripath);
            path = application.getRealPath(uripath);
            if (mappedFilePath == null) {
                mappedFilePath = path;
            } else if (path != null && this.checkFileExists(path)) {
                mappedFileExists = true;
                mappedFilePath = path;
            }
        }
        return mappedFilePath;
    }

    @Override
    public String getRealPath(ServletContext application, String uripath) {
        return this.getRealPath(application, uripath, true);
    }

    private String mapVirtualToReal(String virtual, Map mappings) {
        String v = virtual;
        Object real = (String)mappings.get(virtual);
        while (real == null) {
            int slash = v.lastIndexOf(47);
            if (slash == -1) {
                return null;
            }
            if (slash != 0) {
                v = v.substring(0, slash);
                real = (String)mappings.get(v);
            } else {
                real = (String)mappings.get("/");
                v = DEFAULT_COMPILE_EXT_INCLUDE;
            }
            if (real == null) continue;
            real = (String)real + virtual.substring(slash);
        }
        real = Utils.getCanonicalPath((String)real);
        return real;
    }

    public void setAppServer(String app) {
        this.appServer = app;
    }

    public String getAppServer() {
        return this.appServer;
    }

    @Override
    public Scope getServerScope() {
        return this.serverScope;
    }

    private void setupServerScope(String rootDir) {
        String CFXNeolibName;
        this.serverScope = new ProtectedScope();
        this.serverScope.setScopeType(8);
        ProtectedScope os = new ProtectedScope();
        os.putReadOnly("additionalinformation", DEFAULT_COMPILE_EXT_INCLUDE);
        os.putReadOnly("buildnumber", DEFAULT_COMPILE_EXT_INCLUDE);
        Enumeration<Object> e = System.getProperties().keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.toLowerCase().startsWith("os.")) continue;
            os.putReadOnly(name.substring(3), System.getProperty(name));
        }
        try {
            String osName = (String)os.get("name");
            if (SystemInfo.isMac()) {
                os.putReadOnly("additionalinformation", osName);
            }
            if (!SystemInfo.isWindows() && !SystemInfo.isMac()) {
                os.putReadOnly("name", "UNIX");
                os.putReadOnly("additionalinformation", osName);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        this.serverScope.putReadOnly("os", os);
        LicenseService ls = ServiceFactory.getLicenseService();
        final ProtectedScope coldfusion = new ProtectedScope();
        new Thread(){

            @Override
            public void run() {
                coldfusion.putReadOnly("supportedlocales", CFLocaleMgr.getMgr().getLocaleList());
            }
        }.start();
        coldfusion.putReadOnly("productname", Version.getProductName());
        coldfusion.putReadOnly("productversion", Version.getVersionString(rootDir));
        coldfusion.putReadOnly("updatelevel", Version.getUpdateLevel(rootDir));
        if (ls != null) {
            coldfusion.put("productlevel", (Object)ls.getEdition());
            coldfusion.put("expiration", (Object)ls.getExpirationDate());
        }
        coldfusion.putReadOnly("rootdir", this.neoRoot);
        coldfusion.putReadOnly("appserver", this.getAppServer());
        this.serverScope.put("coldfusion", (Object)coldfusion);
        String libdir = this.neoRoot + File.separator + "lib" + File.separator;
        String osname = (String)os.get("name");
        String osaddinfo = (String)os.get("additionalinformation");
        if (!SystemInfo.isWindows()) {
            String arch = System.getProperty("os.arch");
            CFXNeolibName = SystemInfo.isMac() ? "libCFXNeo.jnilib" : (osaddinfo.indexOf("HP-UX") != -1 ? "libCFXNeo.sl" : (arch.indexOf("ppc") != -1 && SystemInfo.isLinux() ? "libCFXNeo_ppclinux64.so" : "libCFXNeo.so"));
        } else {
            CFXNeolibName = "CFXNeo.dll";
        }
        File file = new File(libdir + CFXNeolibName);
        boolean bl = this.isPureJavaKit = !file.exists();
        if (this.isPureJavaKit) {
            coldfusion.putReadOnly("InstallKit", "Pure Java");
        } else if (osname.indexOf("Windows") == -1) {
            coldfusion.putReadOnly("InstallKit", "Native UNIX");
        } else {
            coldfusion.putReadOnly("InstallKit", "Native Windows");
        }
        if (!ServiceFactory.isFiddleServiceEnabled()) {
            ProtectedScope systemScope = new ProtectedScope();
            ProtectedScope properties = new ProtectedScope();
            Enumeration<Object> e2 = System.getProperties().keys();
            while (e2.hasMoreElements()) {
                String name = (String)e2.nextElement();
                properties.putReadOnly(name, System.getProperty(name));
            }
            systemScope.putReadOnly("properties", properties);
            ProtectedScope environment = new ProtectedScope();
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                environment.putReadOnly(entry.getKey(), entry.getValue());
            }
            systemScope.putReadOnly("environment", environment);
            this.serverScope.putReadOnly("system", systemScope);
        }
    }

    public void setupServiceTagAttributesSubScope(String webInfPath) {
        if (this.serverScope.get("coldfusion.serviceTagAttributes") != null) {
            return;
        }
        if (!webInfPath.endsWith(File.separator)) {
            webInfPath = webInfPath.concat(File.separator);
        }
        RuntimeServiceImpl.webInfPath = webInfPath;
        String cftldPath = webInfPath + "cftags" + File.separator + "META-INF" + File.separator + "taglib.cftld";
        File cftldFile = new File(cftldPath);
        if (cftldFile.exists()) {
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Properties p = new Properties();
                p.setProperty("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", webInfPath.concat("web-jsptaglibrary_1_1.dtd"));
                p.setProperty("web-jsptaglibrary_1_1.dtd", webInfPath.concat("web-jsptaglibrary_1_1.dtd"));
                docBuilder.setEntityResolver(new WebEntityResolver(p));
                Document document = docBuilder.parse(cftldFile);
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                ProtectedScope coldFusion = (ProtectedScope)this.serverScope.get("coldfusion");
                ProtectedScope serviceTagAttributesScope = new ProtectedScope();
                if (!serviceTagAttributesScope.isEmpty()) {
                    coldFusion.putReadOnly("serviceTagAttributes", serviceTagAttributesScope);
                }
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
        this.webInfClassesReadPermission = new FilePermission(webInfPath + "classes" + File.separator + "-", "read");
    }

    public static boolean isWebInfPath(String pagepath) {
        return webInfPath != null && pagepath.startsWith(SystemInfo.isWindows() ? webInfPath.toUpperCase() : webInfPath);
    }

    @Override
    public boolean isPureJavaKit() {
        return this.isPureJavaKit;
    }

    @Override
    public float getPostSizeLimit() {
        return this.postSizeLimit;
    }

    @Override
    public void setPostSizeLimit(float maxPostSize) {
        this.postSizeLimit = maxPostSize;
        this.request_settings.put("postSizeLimit", (Object)Float.valueOf(maxPostSize));
    }

    @Override
    public int getPostParametersLimit() {
        return this.postParametersLimit;
    }

    void ParseVariableSettings() {
        ConfigMap scopeSettingsMap = (ConfigMap)this.getVariables();
        ConfigMap appSettingsMap = (ConfigMap)scopeSettingsMap.get("application");
        appSettingsMap.init(this, "application");
        String timeout = (String)appSettingsMap.get(HTTP_POOL_SOCKET_TIMEOUT);
        StringTokenizer t = new StringTokenizer(timeout, ",");
        int day = Integer.parseInt(t.nextToken());
        int hours = Integer.parseInt(t.nextToken());
        int mins = Integer.parseInt(t.nextToken());
        int secs = Integer.parseInt(t.nextToken());
        this.appTimeout = day * 86400 + hours * 60 * 60 + mins * 60 + secs;
        timeout = (String)appSettingsMap.get("maximum_timeout");
        t = new StringTokenizer(timeout, ",");
        day = Integer.parseInt(t.nextToken());
        hours = Integer.parseInt(t.nextToken());
        mins = Integer.parseInt(t.nextToken());
        secs = Integer.parseInt(t.nextToken());
        this.appMaxTimeout = day * 86400 + hours * 60 * 60 + mins * 60 + secs;
        ConfigMap sessionSettingsMap = (ConfigMap)scopeSettingsMap.get("session");
        sessionSettingsMap.init(this, "session");
        timeout = (String)sessionSettingsMap.get(HTTP_POOL_SOCKET_TIMEOUT);
        t = new StringTokenizer(timeout, ",");
        day = Integer.parseInt(t.nextToken());
        hours = Integer.parseInt(t.nextToken());
        mins = Integer.parseInt(t.nextToken());
        secs = Integer.parseInt(t.nextToken());
        this.sessionTimeout = day * 86400 + hours * 60 * 60 + mins * 60 + secs;
        timeout = (String)sessionSettingsMap.get("maximum_timeout");
        t = new StringTokenizer(timeout, ",");
        day = Integer.parseInt(t.nextToken());
        hours = Integer.parseInt(t.nextToken());
        mins = Integer.parseInt(t.nextToken());
        secs = Integer.parseInt(t.nextToken());
        this.sessionMaxTimeout = day * 86400 + hours * 60 * 60 + mins * 60 + secs;
        this.isAppEnabled = (Boolean)appSettingsMap.get("enable");
        this.isSessionEnabled = (Boolean)sessionSettingsMap.get("enable");
        this.useJ2eeSession = (Boolean)sessionSettingsMap.get("usej2eesession");
        this.sessionStorage = (String)this.misc_settings.get("sessionStorage");
        this.sessionStorageHost = (String)this.misc_settings.get("sessionStorageHost");
        if (this.misc_settings.get("sessionStoragePort") != null) {
            this.sessionStoragePort = ((Number)this.misc_settings.get("sessionStoragePort")).intValue();
        }
        if (this.misc_settings.get("sessionStorageTimeout") != null) {
            this.sessionStorageTimeout = ((Number)this.misc_settings.get("sessionStorageTimeout")).intValue();
        }
        this.redisCacheStorageHost = (String)this.template_settings.get("redisCacheStorageHost");
        if (this.template_settings.get("redisCacheStoragePort") != null) {
            this.redisCacheStoragePort = ((Number)this.template_settings.get("redisCacheStoragePort")).intValue();
        }
        if (this.template_settings.get("redisCacheStorageIsSSL") != null) {
            this.redisCacheStorageIsSSL = (Boolean)this.template_settings.get("redisCacheStorageIsSSL");
        }
        if (this.template_settings.get("sessionStorageCluster") != null) {
            this.sessionStorageCluster = (Boolean)this.template_settings.get("sessionStorageCluster");
        }
        this.requestTimeoutLimit = ((Number)this.request_settings.get("timeoutRequestTimeLimit")).longValue();
        this.timeoutRequestsEnabled = (Boolean)this.request_settings.get("timeoutRequests");
        this.slowRequestTimeLimit = ((Number)this.request_settings.get("slowRequestTimeLimit")).longValue();
        this.logSlowRequestsEnabled = (Boolean)this.request_settings.get("logSlowRequests");
        Number maxPostSize = (Number)this.request_settings.get("postSizeLimit");
        maxPostSize = maxPostSize == null ? (Number)new Float(500.0f) : (Number)maxPostSize;
        this.postSizeLimit = maxPostSize.floatValue();
        this.request_settings.put("postSizeLimit", (Object)maxPostSize);
        Number maxPostCount = (Number)this.request_settings.get("postParametersLimit");
        maxPostCount = maxPostCount == null ? (Number)new Integer(100) : (Number)maxPostCount;
        this.postParametersLimit = maxPostCount.intValue();
        this.request_settings.put("postParametersLimit", (Object)maxPostCount);
        this.trustedCacheEnabled = (Boolean)this.template_settings.get("trustedCacheEnabled");
        Object cacheEnabled = this.template_settings.get("inRequestTemplateCacheEnabled");
        if (cacheEnabled != null) {
            this.inRequestTemplateCacheEnabled = (Boolean)cacheEnabled;
        }
        this.componentCacheEnabled = (Boolean)this.template_settings.get("componentCacheEnabled");
        this.internalCacheForQueryEnabled = (Boolean)this.template_settings.get("enableInternalQueryCache");
        defaultCharset = (String)this.charset_settings.get("defaultCharset");
        defaultMailCharset = (String)this.charset_settings.get("defaultMailCharset");
        defaultLongIntegerFormat = (Boolean)this.CF5Compatibility.get("longIntegerFormat");
        this.CFFormScriptSrc = (String)this.form_settings.get("CFFormScriptSrc");
        this.loadRSLLibraries = (Boolean)this.form_settings.get("loadRSLLibraries");
        this.CFFormCodeBaseUrl = (String)this.form_settings.get("CFFormCodeBaseUrl");
        this.isFileLockEnabled = (Boolean)this.misc_settings.get("fileLockEnabled");
        this.cfthread_pool = ((Number)this.misc_settings.get("cfthreadpool")).intValue();
        this.cfcTypeCheckEnabled = (Boolean)this.misc_settings.get("cfcTypeCheckEnabled");
        this.imageExpiryTime = ((Number)this.misc_settings.get("imageExpiryTime")).intValue();
        this.isPerAppSettingsEnabled = (Boolean)this.misc_settings.get("isPerAppSettingsEnabled");
        this.disableServiceFactory = (Boolean)this.misc_settings.get("disableServiceFactory");
        this.allowExtraAttributesInAttrColl = (Boolean)this.misc_settings.get("allowExtraAttributesInAttrColl");
        this.enableServerCFC = (Boolean)this.misc_settings.get("enableServerCFC");
        this.googleMapKey = (String)this.misc_settings.get("googleMapKey");
        this.applicationCFCSearchCondition = Integer.parseInt((String)this.misc_settings.get("applicationCFCSearchLimit"));
        this.disableUnnamedAppScopeDump = (Boolean)this.misc_settings.get("dumpunnamedappscope");
        this.allowAppVarInContext = (Boolean)this.misc_settings.get("allowappvarincontext");
        this.compileExtForInclude = (String)this.misc_settings.get("compileextforinclude");
        this.blockedExtForFileUpload = (String)this.misc_settings.get("blockedExtForFileUpload");
        this.enableCspNonceForScript = (Boolean)this.misc_settings.get("enableCspNonceForScript");
        this.isSecureJSON = (Boolean)this.misc_settings.get("secureJSON");
        this.preserveCaseForSerialize = (Boolean)this.misc_settings.get("preserveCaseForSerialize");
        this.secureJSONPrefix = (String)this.misc_settings.get("secureJSONPrefix");
        this.enableInMemoryFileSystem = (Boolean)this.misc_settings.get("enableInMemoryFileSystem");
        this.inMemoryFileSystemLimit = ((Number)this.misc_settings.get("inMemoryFileSystemLimit")).intValue();
        this.inMemoryFileSystemAppLimit = ((Number)this.misc_settings.get("inMemoryFileSystemAppLimit")).intValue();
        this.maxOutputBufferSize = ((Number)this.misc_settings.get("maxOutputBufferSize")).intValue();
        this.httpOnlySessionCookie = (Boolean)this.misc_settings.get("httpOnlySessionCookie");
        this.secureSessionCookie = (Boolean)this.misc_settings.get("secureSessionCookie");
        this.sessionCookieTimeout = ((Number)this.misc_settings.get("sessionCookieTimeout")).intValue();
        this.sessionCookieDomain = (String)this.misc_settings.get("sessionCookieDomain");
        this.internalCookiesDisableUpdate = (Boolean)this.misc_settings.get("internalCookiesDisableUpdate");
        this.sessionCookieSamesite = (String)this.misc_settings.get("sessionCookieSamesite");
        this.maxUnzipRatio = ((Number)this.misc_settings.get("maxUnzip")).intValue();
        this.serverCFC = (String)this.misc_settings.get("serverCFC");
        this.ORMSearchIndexDirectory = (String)this.misc_settings.get("ORMSearchIndexDirectory");
        LicenseService licenseService = ServiceFactory.getLicenseService();
        this.numSimultaneousReports = licenseService != null && licenseService.isStandard() ? 1 : ((Number)this.report_settings.get("numSimultaneousReports")).intValue();
        this.enableNullSupport = (Boolean)this.misc_settings.get(ENABLE_NULL_SUPPORT);
        this.useJavaAsRegexEngine = (Boolean)this.misc_settings.get(USE_JAVA_AS_REGEX_ENGINE);
        this.corePoolSize = ((Number)this.misc_settings.get(CORE_POOL_SIZE)).intValue();
        this.maxPoolSize = ((Number)this.misc_settings.get(MAX_POOL_SIZE)).intValue();
        this.keepAliveTime = ((Number)this.misc_settings.get(KEEP_ALIVE_TIME)).longValue();
        this.configuration.setCorePoolSize(((Number)this.misc_settings.get(CORE_POOL_SIZE_CLOUD_SERVICES)).intValue());
        this.configuration.setMaxPoolSize(((Number)this.misc_settings.get(MAX_POOL_SIZE_CLOUD_SERVICES)).intValue());
        this.configuration.setKeepAliveTime(((Number)this.misc_settings.get(KEEP_ALIVE_TIME_CLOUD_SERVICES)).longValue());
    }

    @Override
    public long getApplicationTimeout() {
        return this.appTimeout;
    }

    @Override
    public long getApplicationMaxTimeout() {
        return this.appMaxTimeout;
    }

    @Override
    public boolean isApplicationEnabled() {
        return this.isAppEnabled;
    }

    @Override
    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public long getSessionMaxTimeout() {
        return this.sessionMaxTimeout;
    }

    @Override
    public boolean isSessionEnabled() {
        if (!this.isSessionEnabled.booleanValue()) {
            return false;
        }
        return !this.getSessionStorage().equals(REDIS_STORAGE) || ServiceFactory.getSessionStorageService(true) != null;
    }

    @Override
    public boolean useJ2eeSession() {
        return this.useJ2eeSession;
    }

    @Override
    public boolean isPerAppSettingsEnabled() {
        return this.isPerAppSettingsEnabled;
    }

    public void setIsPerAppSettingsEnabled(boolean b) {
        this.isPerAppSettingsEnabled = b;
        this.misc_settings.put("isPerAppSettingsEnabled", (Object)b);
    }

    @Override
    public boolean isAllowExtraAttributesInAttrColl() {
        return this.allowExtraAttributesInAttrColl;
    }

    public void setAllowExtraAttributesInAttrColl(boolean b) {
        this.allowExtraAttributesInAttrColl = b;
        this.misc_settings.put("allowExtraAttributesInAttrColl", (Object)b);
    }

    @Override
    public boolean isDisableUnnamedApplication() {
        return this.disableUnnamedAppScopeDump;
    }

    public void setDisableUnnamedApplicationCreation(boolean disable) {
        this.disableUnnamedAppScopeDump = disable;
        this.misc_settings.put("dumpunnamedappscope", (Object)this.disableUnnamedAppScopeDump);
    }

    @Override
    public void setAllowAppVarInServContext(boolean disable) {
        this.allowAppVarInContext = disable;
        this.misc_settings.put("allowappvarincontext", (Object)this.allowAppVarInContext);
    }

    @Override
    public boolean isAllowAppVarInServContext() {
        return this.allowAppVarInContext;
    }

    @Override
    public String getCompileExtForInclude() {
        return this.compileExtForInclude;
    }

    public void setCompileExtForInclude(String compileExtForInclude) {
        this.compileExtForInclude = Utils.removeDuplicates(compileExtForInclude.toUpperCase(), ",");
        this.misc_settings.put("compileextforinclude", (Object)this.compileExtForInclude);
    }

    @Override
    public String getBlockedExtForFileUpload() {
        return this.blockedExtForFileUpload;
    }

    @Override
    public void setBlockedExtForFileUpload(String blockedExtForFileUpload) {
        this.blockedExtForFileUpload = Utils.removeDuplicates(blockedExtForFileUpload.toUpperCase(), ",");
        this.misc_settings.put("blockedExtForFileUpload", (Object)this.blockedExtForFileUpload);
    }

    @Override
    public boolean isEnableCspNonceForScript() {
        return this.enableCspNonceForScript;
    }

    @Override
    public void setEnableCspNonceForScript(boolean enable) {
        this.enableCspNonceForScript = enable;
        this.misc_settings.put("enableCspNonceForScript", (Object)this.enableCspNonceForScript);
    }

    @Override
    public void resetBlockedExtForFileUpload() {
        this.blockedExtForFileUpload = DEFAULT_BLOCKED_EXT_FOR_FILEUPLOAD;
        this.misc_settings.put("blockedExtForFileUpload", (Object)this.blockedExtForFileUpload);
    }

    @Override
    public boolean isServerCFCEnabled() {
        return this.enableServerCFC;
    }

    public void enableServerCFC(boolean b) {
        this.enableServerCFC = b;
        this.misc_settings.put("enableServerCFC", (Object)b);
    }

    @Override
    public void setApplicationCFCSearchCondition(int condition) {
        this.applicationCFCSearchCondition = condition;
        this.misc_settings.put("applicationCFCSearchLimit", (Object)(DEFAULT_COMPILE_EXT_INCLUDE + condition));
    }

    @Override
    public int getApplicationCFCSearchCondition() {
        return this.applicationCFCSearchCondition;
    }

    @Override
    public String getGoogleMapKey() {
        return this.googleMapKey;
    }

    @Override
    public void setGoogleMapKey(String key) {
        if (key != null && key.length() > 0) {
            key = ESAPIUtils.getValidateInput(key, "GOOGLEMAPAPI", 300);
        }
        this.googleMapKey = key;
        this.misc_settings.put("googleMapKey", (Object)key);
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("applications.keys", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("applications.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("applications.formats", "coldfusion.server.MapFormatter");
            this.rb.put("applications.value", "application");
            this.rb.put("application.keys", "rootdir,description,display");
            this.rb.put("application.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("application.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter");
            this.rb.put("errors.keys", "missing_template,site_wide,EnableHTTPStatus,queue_timeout");
            this.rb.put("errors.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("errors.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter");
            this.rb.put("mappings.keys", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("mappings.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("mappings.formats", "coldfusion.server.StringFormatter");
            this.rb.put("locking.keys", "single_threaded,server_variables,application_variables,session_variables");
            this.rb.put("locking.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("locking.formats", "coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter");
            this.rb.put("cfx_tags.keys", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("cfx_tags.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("cfx_tags.formats", "coldfusion.server.MapFormatter");
            this.rb.put("cfx_tags.value", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("cfx.keys", "name,type,library,procedure,cache,description,classname");
            this.rb.put("cfx.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("cfx.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter");
            this.rb.put("custom_tags.keys", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("custom_tags.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("custom_tags.formats", "coldfusion.server.StringFormatter");
            this.rb.put("corba.keys", "orbs,logging,useorb");
            this.rb.put("corba.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("corba.formats", "coldfusion.server.MapFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter");
            this.rb.put("orbs.keys", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("orbs.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("orbs.formats", "coldfusion.server.MapFormatter");
            this.rb.put("orbs.value", "orb");
            this.rb.put("orb.keys", "name,path,options");
            this.rb.put("orb.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("rb.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter");
            this.rb.put("parameters.keys", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("parameters.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("parameters.formats", "coldfusion.server.MapFormatter");
            this.rb.put("parameters.value", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("client_stores.keys", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("client_stores.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("client_stores.formats", "coldfusion.server.MapFormatter");
            this.rb.put("client_stores.value", "client_store");
            this.rb.put("client_store.keys", "name,type,purge,description,timeout,disable_globals");
            this.rb.put("client_store.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("client_store.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter");
            this.rb.put("variables.keys", "application,session");
            this.rb.put("variables.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("variables.formats", "coldfusion.server.MapFormatter,coldfusion.server.MapFormatter");
            this.rb.put("application.keys", "enable,timeout,maximum_timeout");
            this.rb.put("application.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("application.formats", "coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter");
            this.rb.put("session.keys", "enable,timeout,maximum_timeout,usej2eesession");
            this.rb.put("session.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("session.formats", "coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter");
            this.rb.put("request_settings.keys", "logSlowRequests,slowRequestTimeLimit,timeoutRequests,timeoutRequestTimeLimit,postSizeLimit,requestLimit,webserviceLimit,CFCLimit,queueTimeout,cacheWebServerPath,postParametersLimit");
            this.rb.put("request_settings.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("request_settings.formats", "coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter");
            this.rb.put("charset.keys", "defaultMailCharset,defaultCharset");
            this.rb.put("charset.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("charset.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter");
            this.rb.put("CF5Compatibility.keys", "longIntegerFormat");
            this.rb.put("CF5Compatibility.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("CF5Compatibility.formats", "coldfusion.server.NumberFormatter");
            this.rb.put("form.keys", "CFFormScriptSrc,loadRSLLibraries,CFFormCodeBaseUrl");
            this.rb.put("form.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("form.formats", "coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter");
            this.rb.put("misc.keys", "enableMeasureFeatures,cfthreadpool,fileLockEnabled,isPerAppSettingsEnabled,disableServiceFactory,cfcTypeCheckEnabled,imageExpiryTime,secureJSON,secureJSONPrefix,enableInMemoryFileSystem,serverCFC,allowExtraAttributesInAttrColl,enableServerCFC,googleMapKey,applicationCFCSearchLimit,inMemoryFileSystemLimit,inMemoryFileSystemAppLimit,CFaaSGeneratedFilesExpiryTime,ORMSearchIndexDirectory,httpOnlySessionCookie,secureSessionCookie,sessionCookieTimeout,sessionCookieDomain,internalCookiesDisableUpdate,sessionCookieSamesite,maxUnzip,dumpunnamedappscope,maxOutputBufferSize,allowappvarincontext,preserveCaseForSerialize,compileextforinclude,sessionStorage,sessionStorageHost,sessionStoragePort,sessionStoragePassword,redisCacheStorageHost,redisCacheStoragePort,redisCacheStoragePassword,enableNullSupport,corePoolSize,maxPoolSize,keepAliveTime,useJavaAsRegexEngine,maxThreadCountForParallelCalls,sessionStorageTimeout,blockedExtForFileUpload,maxPoolSizeCloudServices,corePoolSizeCloudServices,keepAliveTimeCloudServices,redisCacheStorageIsSSL,enableCspNonceForScript");
            this.rb.put("misc.types", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("misc.formats", "coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter");
            this.rb.put("report.keys", "numSimultaneousReports");
            this.rb.put("report.keys", DEFAULT_COMPILE_EXT_INCLUDE);
            this.rb.put("report.formats", "coldfusion.server.NumberFormatter");
        }
        return this.rb;
    }

    @Override
    public final long getSlowRequestLimit() {
        return this.slowRequestTimeLimit;
    }

    @Override
    public final boolean logSlowRequests() {
        return this.logSlowRequestsEnabled;
    }

    @Override
    public final long getRequestTimeoutLimit() {
        return this.requestTimeoutLimit;
    }

    @Override
    public final boolean timeoutRequests() {
        return this.timeoutRequestsEnabled;
    }

    public final float getMaxPostSize() {
        return this.postSizeLimit;
    }

    public final int getMaxPostParametersCount() {
        return this.postParametersLimit;
    }

    @Override
    public boolean isCFCTypeCheckEnabled() {
        return this.cfcTypeCheckEnabled;
    }

    @Override
    public void setCFCTypeCheckEnabled(boolean enable) {
        this.cfcTypeCheckEnabled = enable;
        this.misc_settings.put("cfcTypeCheckEnabled", (Object)enable);
    }

    @Override
    public int getCFImageExpiryTime() {
        return this.imageExpiryTime;
    }

    @Override
    public void setCFImageExpiryTime(int second) {
        this.imageExpiryTime = second;
        this.misc_settings.put("imageExpiryTime", (Object)new Integer(second));
    }

    @Override
    public final boolean isTrustedCache() {
        return this.trustedCacheEnabled;
    }

    @Override
    public void setTrustedCache(boolean b) {
        this.template_settings.put("trustedCacheEnabled", (Object)b);
        this.trustedCacheEnabled = b;
    }

    @Override
    public boolean isInRequestTemplateCacheEnabled() {
        return this.inRequestTemplateCacheEnabled;
    }

    @Override
    public void setInRequestTemplateCacheEnabled(boolean b) {
        this.template_settings.put("inRequestTemplateCacheEnabled", (Object)b);
        this.inRequestTemplateCacheEnabled = b;
    }

    @Override
    public final boolean isComponentCache() {
        return this.componentCacheEnabled;
    }

    @Override
    public void setComponentCache(boolean b) {
        this.template_settings.put("componentCacheEnabled", (Object)b);
        this.componentCacheEnabled = b;
    }

    @Override
    public boolean isInternalCacheForQueryEnabled() {
        return this.internalCacheForQueryEnabled;
    }

    @Override
    public void setInternalCacheForQueryEnabled(boolean enableInternalCacheForQuery) {
        this.template_settings.put("enableInternalQueryCache", (Object)enableInternalCacheForQuery);
        this.internalCacheForQueryEnabled = enableInternalCacheForQuery;
    }

    @Override
    public void clearTrustedCache() {
        this.clearTrustedCache(true);
    }

    @Override
    public void clearTrustedCache(boolean broadcast) {
        ServiceFactory.getSecurityService().authenticateAdmin();
        TemplateClassLoader.clearClassCache();
        if (broadcast) {
            try {
                CentralConfigClientUtil.pushActionToCCS("cleartrustedcache", DEFAULT_COMPILE_EXT_INCLUDE);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
    }

    @Override
    public void clearComponentCache() {
        this.clearComponentCache(true);
    }

    @Override
    public void clearComponentCache(boolean broadcast) {
        ServiceFactory.getSecurityService().authenticateAdmin();
        TemplateProxyFactory.clearComponentCache();
        TemplateCacheMonitor.clearComponentCache();
        if (broadcast) {
            try {
                CentralConfigClientUtil.pushActionToCCS("clearcomponentcache", DEFAULT_COMPILE_EXT_INCLUDE);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
    }

    @Override
    public void clearTemplateFolderFromCache(String folderpath, boolean broadcast) {
        File folder = VFSFileFactory.getFileObject(folderpath);
        File[] files = folder.listFiles();
        if (null == files) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                this.clearTemplateFolderFromCache(f.getAbsolutePath());
                continue;
            }
            this.clearTemplateFileFromCache(f.getAbsolutePath());
        }
        if (broadcast) {
            try {
                CentralConfigClientUtil.pushActionToCCS("clearfoldercache", folderpath);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
    }

    @Override
    public void clearTemplateFolderFromCache(String folderpath) {
        this.clearTemplateFolderFromCache(folderpath, true);
    }

    @Override
    public void clearTemplateListFromCache(String fullPathList) {
        ServiceFactory.getSecurityService().authenticateAdmin();
        StringTokenizer tokens = new StringTokenizer(fullPathList, ",");
        while (tokens.hasMoreTokens()) {
            String filePath = tokens.nextToken().trim();
            this.clearTemplateFileFromCache(filePath);
        }
    }

    private void clearTemplateFileFromCache(String filePath) {
        File f = VFSFileFactory.getFileObject(filePath);
        try {
            TemplateClassLoader.removeClassCache(f.getCanonicalPath());
        }
        catch (IOException ioe) {
            TemplateClassLoader.removeClassCache(f.getAbsolutePath());
        }
    }

    @Override
    public int getTemplateCacheSize() {
        return ((Number)this.template_settings.get("templateCacheSize")).intValue();
    }

    @Override
    public void setTemplateCacheSize(int i) {
        this.template_settings.put("templateCacheSize", (Object)new Integer(i));
        TemplateClassLoader.setCacheSize(i);
    }

    public void setServerCacheType(int i) {
        int cType = this.getServerCacheType();
        if (i == cType) {
            return;
        }
        GenericCacheFactory.setCacheType(i);
        this.template_settings.put("serverCacheType", (Object)i);
        this.resetQueryCaches();
    }

    public Map getCachingEngines() throws IOException {
        return CacheTagHelper.getCachingEngines();
    }

    private void resetQueryCaches() {
        Enumeration appKeys = ApplicationScopeTracker.getApplicationKeys();
        while (appKeys.hasMoreElements()) {
            String appkey = (String)appKeys.nextElement();
            ApplicationScope scope = ApplicationScopeTracker.getApplicationScope(appkey);
            scope.resetDefaultQueryCache();
        }
        AppHelper.resetDefaultQueryCache();
    }

    public String getJCSClusterDsnName() {
        return (String)this.template_settings.get("JCSClusterDsnName");
    }

    public void setJCSClusterDsnName(String dsn, boolean createTables) throws Exception {
        this.template_settings.put("JCSClusterDsnName", (Object)dsn);
        CacheTagHelper.setJCSClusterDsnName(dsn, createTables);
    }

    public void setReuseRedisCachingForSessionStorage(boolean use) throws ServiceException {
        if (use && this.getSessionStorageIsCluster()) {
            throw new ServiceException(RB.getString(RuntimeServiceImpl.class, "RuntimeServiceImpl.SessionStorageClusterNotSupported"));
        }
        this.template_settings.put("reuseRedisCachingForSessionStorage", (Object)use);
        if (use) {
            this.setSessionStorageHost(this.getRedisCacheStorageHost());
            this.setSessionStoragePort(this.getRedisCacheStoragePort());
            String password = this.getRedisCacheStoragePassword();
            if (password != null && password.length() > 0) {
                password = PasswordUtils.decryptPassword(this.getRedisCacheStoragePassword(), this.seed);
            }
            this.setSessionStoragePassword(password);
        }
    }

    @Override
    public void setSessionStorageSSLEnabled(boolean ssl) throws ServiceException {
        this.template_settings.put("sslSessionStorage", (Object)ssl);
    }

    @Override
    public void setCFLoginUseSessionStorageRedis(boolean b) {
        this.template_settings.put("CFLoginUseSessionStorageRedis", (Object)b);
    }

    @Override
    public boolean getCFLoginUseSessionStorageRedis() {
        if (null == this.template_settings.get("CFLoginUseSessionStorageRedis")) {
            return false;
        }
        return Cast._boolean(this.template_settings.get("CFLoginUseSessionStorageRedis"));
    }

    @Override
    public boolean getSessionStorageSSLEnabled() {
        if (null == this.template_settings.get("sslSessionStorage")) {
            return false;
        }
        return Cast._boolean(this.template_settings.get("sslSessionStorage"));
    }

    public boolean getReuseRedisCachingForSessionStorage() {
        if (null == this.template_settings.get("reuseRedisCachingForSessionStorage")) {
            return false;
        }
        return Cast._boolean(this.template_settings.get("reuseRedisCachingForSessionStorage"));
    }

    public String getMemcachedServer() {
        String server = (String)this.template_settings.get("MemcachedServer");
        if (null == server) {
            server = DEFAULT_COMPILE_EXT_INCLUDE;
        }
        return server;
    }

    public Struct getCacheServerSettings(String engine) {
        return CacheTagHelper.getCacheServerSettings(engine);
    }

    public void setMemcachedServer(String server) throws Exception {
        if (server.equals(this.getMemcachedServer())) {
            return;
        }
        this.template_settings.put("MemcachedServer", (Object)server);
        this.resetQueryCaches();
        GenericCacheFactory.resetCache(3);
    }

    public void setMemcachedServerMaxIdle(long time) throws Exception {
        this.template_settings.put("memcachedTimeToIdleSeconds", (Object)time);
        CacheTagHelper.setServerSetting("timeToIdleSeconds", "memcached", time);
    }

    public long getMemcachedServerMaxIdle() throws Exception {
        if (CacheTagHelper.getServerSetting("timeToIdleSeconds", "memcached") == null) {
            return 86400L;
        }
        return Long.valueOf(CacheTagHelper.getServerSetting("timeToIdleSeconds", "memcached"));
    }

    public long getMemcachedServerMaxLife() throws Exception {
        if (CacheTagHelper.getServerSetting("timeToLiveSeconds", "memcached") == null) {
            return 86400L;
        }
        return Long.valueOf(CacheTagHelper.getServerSetting("timeToLiveSeconds", "memcached"));
    }

    public void setMemcachedServerMaxLife(long time) throws Exception {
        this.template_settings.put("memcachedTimeToLiveSeconds", (Object)time);
        CacheTagHelper.setServerSetting("timeToLiveSeconds", "memcached", time);
    }

    public String getMemcachedServerEternal() throws Exception {
        if (null == CacheTagHelper.getServerSetting("eternal", "memcached")) {
            return DEFAULT_COMPILE_EXT_INCLUDE;
        }
        return CacheTagHelper.getServerSetting("eternal", "memcached");
    }

    public void setMemcachedServerEternal(String eternal) throws Exception {
        eternal = DEFAULT_COMPILE_EXT_INCLUDE + Cast._boolean((String)eternal);
        this.template_settings.put("memcachedEternal", eternal);
        CacheTagHelper.setServerSetting("eternal", "memcached", eternal);
    }

    public String getRedisServerEternal() throws Exception {
        if (null == CacheTagHelper.getServerSetting("eternal", REDIS_STORAGE)) {
            return DEFAULT_COMPILE_EXT_INCLUDE;
        }
        return CacheTagHelper.getServerSetting("eternal", REDIS_STORAGE);
    }

    public void setRedisServerEternal(String eternal) throws Exception {
        eternal = DEFAULT_COMPILE_EXT_INCLUDE + Cast._boolean((String)eternal);
        CacheTagHelper.setServerSetting("eternal", REDIS_STORAGE, eternal);
    }

    public long getMemcachedServerMaxObjects() throws Exception {
        if (CacheTagHelper.getServerSetting("maxElementsInMemory", "memcached") == null) {
            return 10000L;
        }
        return Long.valueOf(CacheTagHelper.getServerSetting("maxElementsInMemory", "memcached"));
    }

    public void setMemcachedServerMaxObjects(long time) throws Exception {
        this.template_settings.put("memcachedMaxElementsInMemory", (Object)time);
        CacheTagHelper.setServerSetting("maxElementsInMemory", "memcached", time);
    }

    public void setJCSServerMaxIdle(long time) throws Exception {
        CacheTagHelper.setServerSetting("timeToIdleSeconds", "jcs", time);
    }

    public long getJCSServerMaxIdle() throws Exception {
        if (CacheTagHelper.getServerSetting("timeToIdleSeconds", "jcs") == null) {
            return 86400L;
        }
        return Long.valueOf(CacheTagHelper.getServerSetting("timeToIdleSeconds", "jcs"));
    }

    public long getJCSServerMaxLife() throws Exception {
        if (CacheTagHelper.getServerSetting("timeToLiveSeconds", "jcs") == null) {
            return 86400L;
        }
        return Long.valueOf(CacheTagHelper.getServerSetting("timeToLiveSeconds", "jcs"));
    }

    public void setJCSServerMaxLife(long time) throws Exception {
        CacheTagHelper.setServerSetting("timeToLiveSeconds", "jcs", time);
    }

    public String getJCSServerEternal() throws Exception {
        if (null == CacheTagHelper.getServerSetting("eternal", "jcs")) {
            return DEFAULT_COMPILE_EXT_INCLUDE;
        }
        return CacheTagHelper.getServerSetting("eternal", "jcs");
    }

    public void setJCSServerEternal(String eternal) throws Exception {
        eternal = DEFAULT_COMPILE_EXT_INCLUDE + Cast._boolean((String)eternal);
        CacheTagHelper.setServerSetting("eternal", "jcs", eternal);
    }

    public long getJCSServerMaxObjects() throws Exception {
        if (CacheTagHelper.getServerSetting("maxElementsInMemory", "jcs") == null) {
            return 10000L;
        }
        return Long.valueOf(CacheTagHelper.getServerSetting("maxElementsInMemory", "jcs"));
    }

    public void setJCSServerMaxObjects(long time) throws Exception {
        CacheTagHelper.setServerSetting("maxElementsInMemory", "jcs", time);
    }

    public void setredisServerMaxIdle(long time) throws Exception {
        CacheTagHelper.setServerSetting("timeToIdleSeconds", REDIS_STORAGE, time);
    }

    public long getredisServerMaxIdle() throws Exception {
        if (CacheTagHelper.getServerSetting("timeToIdleSeconds", REDIS_STORAGE) == null) {
            return 86400L;
        }
        return Long.valueOf(CacheTagHelper.getServerSetting("timeToIdleSeconds", REDIS_STORAGE));
    }

    public long getredisServerMaxLife() throws Exception {
        if (CacheTagHelper.getServerSetting("timeToLiveSeconds", REDIS_STORAGE) == null) {
            return 86400L;
        }
        return Long.valueOf(CacheTagHelper.getServerSetting("timeToLiveSeconds", REDIS_STORAGE));
    }

    public void setredisServerMaxLife(long time) throws Exception {
        CacheTagHelper.setServerSetting("timeToLiveSeconds", REDIS_STORAGE, time);
    }

    public long getredisServerMaxObjects() throws Exception {
        if (CacheTagHelper.getServerSetting("maxElementsInMemory", REDIS_STORAGE) == null) {
            return 10000L;
        }
        return Long.valueOf(CacheTagHelper.getServerSetting("maxElementsInMemory", REDIS_STORAGE));
    }

    public void setredisServerMaxObjects(long time) throws Exception {
        CacheTagHelper.setServerSetting("maxElementsInMemory", REDIS_STORAGE, time);
    }

    public String verifyMemcachedConnection(String server) {
        return CacheTagHelper.verifyMemcachedConnection(server);
    }

    public boolean isJCSClusterTablesCreated() {
        return CacheTagHelper.isJCSClusterTablesCreated();
    }

    public int getServerCacheType() {
        Object value = this.template_settings.get("serverCacheType");
        if (null == value) {
            this.template_settings.put("serverCacheType", (Object)0);
            GenericCacheFactory.setCacheType(0);
            return 0;
        }
        return ((Number)this.template_settings.get("serverCacheType")).intValue();
    }

    @Override
    public int getNumberSimultaneousRequests() {
        return this.getQueueLimit("request");
    }

    @Override
    public void setNumberSimultaneousRequests(int numRequests) {
        this.setQueueLimit("request", numRequests);
    }

    @Override
    public final int getNumberSimultaneousReports() {
        return this.numSimultaneousReports;
    }

    @Override
    public final void setNumberSimultaneousReports(int i) {
        if (!ServiceFactory.getLicenseService().isStandard()) {
            this.numSimultaneousReports = i;
            this.report_settings.put("numSimultaneousReports", (Object)new Integer(this.numSimultaneousReports));
        }
    }

    @Override
    public void setSaveClassFiles(boolean b) {
        this.template_settings.put("saveClassFiles", (Object)b);
        TemplateClassLoader.setSaveClasses(b);
    }

    @Override
    public boolean getSaveClassFiles() {
        Object b = this.template_settings.get("saveClassFiles");
        if (b instanceof Boolean) {
            return (Boolean)b;
        }
        return true;
    }

    @Override
    public void setCFThreadPoolSize(int size) {
        this.misc_settings.put("cfthreadpool", (Object)new Integer(size));
    }

    @Override
    public int getCFThreadPoolSize() {
        return this.cfthread_pool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setQueueLimit(String queue, int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException(Integer.toString(limit));
        }
        if (!ServiceFactory.getLicenseService().isStandard()) {
            if ("request".equalsIgnoreCase(queue)) {
                this.request_settings.put("requestLimit", (Object)new Integer(limit));
                CfmServletInnerHelper.setRequestLimit(limit);
                return;
            } else if ("webservice".equalsIgnoreCase(queue)) {
                this.request_settings.put("webserviceLimit", (Object)new Integer(limit));
                CFCServletInnerHelper.setWebServiceRequestLimit(limit);
                return;
            } else {
                if (!"cfc".equalsIgnoreCase(queue)) throw new IllegalArgumentException(queue);
                this.request_settings.put("CFCLimit", (Object)new Integer(limit));
                CFCServletInnerHelper.setCFCRequestLimit(limit);
            }
            return;
        } else {
            if (!"request".equalsIgnoreCase(queue)) return;
            this.setActiveHandlers(limit);
        }
    }

    @Override
    public int getQueueLimit(String queue) {
        if (!ServiceFactory.getLicenseService().isStandard()) {
            if ("request".equalsIgnoreCase(queue)) {
                return this.getRequestSetting("requestLimit", 8);
            }
            if ("webservice".equalsIgnoreCase(queue)) {
                return this.getRequestSetting("webserviceLimit", 5);
            }
            if ("cfc".equalsIgnoreCase(queue)) {
                return this.getRequestSetting("CFCLimit", 5);
            }
        } else {
            int c = this.getActiveHandlers();
            if ("request".equalsIgnoreCase(queue) && 0 == c) {
                c = 150;
                this.setActiveHandlers(c);
            }
            return c;
        }
        throw new IllegalArgumentException(queue);
    }

    @Override
    public long getQueueTimeout() {
        return this.getRequestSetting("queueTimeout", 60);
    }

    @Override
    public int getActiveHandlers() {
        throw new UnsupportedOperationException("getActiveHandlers");
    }

    @Override
    public void setActiveHandlers(int maxRequests) {
        throw new UnsupportedOperationException("setActiveHandlers");
    }

    @Override
    public int getMaxQueued() {
        throw new UnsupportedOperationException("getMaxQueued");
    }

    @Override
    public void setMaxQueued(int maxRequests) {
        throw new UnsupportedOperationException("setMaxQueued");
    }

    @Override
    public int getMinRequests() {
        throw new UnsupportedOperationException("getMinRequests");
    }

    @Override
    public void setMinRequests(int minRequests) {
        throw new UnsupportedOperationException("setMinRequests");
    }

    @Override
    public boolean isCachePaths() {
        return (Boolean)this.request_settings.get("cacheWebServerPath");
    }

    @Override
    public void setCachePaths(boolean isCachedPath) {
        Boolean value = isCachedPath;
        System.setProperty(CACHE_REAL_PATH, value.toString());
        this.request_settings.put("cacheWebServerPath", (Object)value);
        if (!isCachedPath) {
            RealPathCache.clearAll();
        }
    }

    public static String getDefaultMailCharset() {
        return defaultMailCharset;
    }

    public void setDefaultMailCharset(String charset) {
        defaultMailCharset = charset;
        this.charset_settings.put("defaultMailCharset", (Object)charset);
    }

    public static String getDefaultCharset() {
        return defaultCharset;
    }

    public void setDefaultCharset(String charset) {
        defaultCharset = charset;
        this.charset_settings.put("defaultCharset", (Object)charset);
    }

    public static boolean getDefaultLongIntegerFormat() {
        return defaultLongIntegerFormat;
    }

    public void setDefaultLongIntegerFormat(boolean defaultIntegerFormat) {
        defaultLongIntegerFormat = defaultIntegerFormat;
        this.CF5Compatibility.put("longIntegerFormat", (Object)(defaultIntegerFormat ? Boolean.TRUE : Boolean.FALSE));
    }

    public String getCFFormScriptSrc() {
        return this.CFFormScriptSrc;
    }

    public String getCFFormCodeBaseUrl() {
        return this.CFFormCodeBaseUrl;
    }

    public Boolean getLoadRSLLibraries() {
        return this.loadRSLLibraries;
    }

    public void setCFFormScriptSrc(String CFFormScriptSrc) {
        if (CFFormScriptSrc != null && ((String)CFFormScriptSrc).length() > 0) {
            CFFormScriptSrc = ESAPIUtils.getValidateInput((String)CFFormScriptSrc, "CFFORMSCRIPTSRC", 1000);
        }
        if (((String)CFFormScriptSrc).charAt(((String)CFFormScriptSrc).length() - 1) != '/') {
            CFFormScriptSrc = (String)CFFormScriptSrc + "/";
        }
        this.CFFormScriptSrc = CFFormScriptSrc;
        this.form_settings.put("CFFormScriptSrc", this.CFFormScriptSrc, false);
    }

    public void setCFFormCodeBaseUrl(String CFFormCodeBaseUrl) {
        this.CFFormCodeBaseUrl = CFFormCodeBaseUrl;
        this.form_settings.put("CFFormCodeBaseUrl", (Object)this.CFFormCodeBaseUrl);
    }

    public void setLoadRSLLibraries(Boolean b) {
        this.loadRSLLibraries = b;
        this.form_settings.put("loadRSLLibraries", (Object)this.loadRSLLibraries);
    }

    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            this.reEncryptPassword(oldSeed);
        }
    }

    private void reEncryptPassword(String oldSeed) {
        if (oldSeed.equalsIgnoreCase(this.seed)) {
            return;
        }
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        this._reEncryptPassword(this.getSessionStoragePassword(), oldSeed, "sessionStoragePassword");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _reEncryptPassword(String oldPassword, String oldSeed, String key) {
        if (oldPassword != null && oldPassword.length() > 0) {
            ConfigMap configMap = this.misc_settings;
            synchronized (configMap) {
                try {
                    String newPassword = PasswordUtils.reEncryptWithNewSeed(oldPassword, oldSeed, this.seed);
                    this.misc_settings.put(key, (Object)newPassword);
                }
                catch (Exception e) {
                    CFLogs.SERVER_LOG.error(e);
                }
            }
        }
    }

    private String encryptPassword(String p) {
        return PasswordUtils.encryptPassword(p, this.seed);
    }

    @Override
    public boolean isServiceFactoryDisabled() {
        return this.disableServiceFactory;
    }

    @Override
    public void setServiceFactoryDisabled(boolean flag) {
        this.disableServiceFactory = flag;
        this.misc_settings.put("disableServiceFactory", (Object)flag);
    }

    @Override
    public void setSecureJSON(boolean isSecure) {
        this.isSecureJSON = isSecure;
        this.misc_settings.put("secureJSON", (Object)(isSecure ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public boolean isSecureJSON() {
        return this.isSecureJSON;
    }

    @Override
    public void setSecureJSONPrefix(String prefix) {
        this.secureJSONPrefix = prefix;
        this.misc_settings.put("secureJSONPrefix", (Object)prefix);
    }

    @Override
    public boolean getPreserveCaseForSerialize() {
        return this.preserveCaseForSerialize;
    }

    @Override
    public void setPreserveCaseForSerialize(boolean preserveCaseForSerialize) {
        this.preserveCaseForSerialize = preserveCaseForSerialize;
        this.misc_settings.put("preserveCaseForSerialize", (Object)(preserveCaseForSerialize ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public String getSecureJSONPrefix() {
        return this.secureJSONPrefix;
    }

    @Override
    public void setEnableInMemoryFileSystem(boolean enableInMemoryFileSystem) {
        boolean oldVal = this.enableInMemoryFileSystem;
        this.enableInMemoryFileSystem = enableInMemoryFileSystem;
        this.misc_settings.put("enableInMemoryFileSystem", (Object)(enableInMemoryFileSystem ? Boolean.TRUE : Boolean.FALSE));
        if (oldVal != enableInMemoryFileSystem && !enableInMemoryFileSystem) {
            VFSFileSystemOptionFactory.cleanRAMFileSystem(DEFAULT_COMPILE_EXT_INCLUDE, true);
            Enumeration appKeys = ApplicationScopeTracker.getApplicationKeys();
            if (appKeys != null) {
                while (appKeys.hasMoreElements()) {
                    VFSFileSystemOptionFactory.cleanRAMFileSystem((String)appKeys.nextElement(), true);
                }
            }
        }
    }

    @Override
    public boolean isInMemoryFileSystemEnabled() {
        return this.enableInMemoryFileSystem;
    }

    @Override
    public int getInMemoryFileSystemLimit() {
        return this.inMemoryFileSystemLimit;
    }

    @Override
    public void setInMemoryFileSystemLimit(int inMemoryFileSystemLimit) throws ServiceException {
        if (inMemoryFileSystemLimit != 0) {
            if (inMemoryFileSystemLimit < this.inMemoryFileSystemAppLimit) {
                throw new ServiceException(RB.getString(RuntimeServiceImpl.class, "RuntimeServiceImpl.MinInMemoryFileSystemLimit"));
            }
            if ((long)inMemoryFileSystemLimit > Utils.getMaxHeapSize()) {
                throw new ServiceException(RB.getString(RuntimeServiceImpl.class, "RuntimeServiceImpl.MaxInMemoryFileSystemLimit"));
            }
            this.inMemoryFileSystemLimit = inMemoryFileSystemLimit;
            this.misc_settings.put("inMemoryFileSystemLimit", (Object)new Integer(inMemoryFileSystemLimit));
        }
    }

    @Override
    public void setMaxOutputBufferSize(int maxOutputBufferSize) throws ServiceException {
        if (maxOutputBufferSize != 0) {
            this.maxOutputBufferSize = maxOutputBufferSize;
            this.misc_settings.put("maxOutputBufferSize", (Object)new Integer(maxOutputBufferSize));
        }
    }

    @Override
    public int getMaxOutputBufferSize() {
        return this.maxOutputBufferSize;
    }

    @Override
    public int getInMemoryFileSystemAppLimit() {
        return this.inMemoryFileSystemAppLimit;
    }

    @Override
    public void setInMemoryFileSystemAppLimit(int inMemoryFileSystemAppLimit) throws ServiceException {
        if (inMemoryFileSystemAppLimit != 0 && inMemoryFileSystemAppLimit <= this.inMemoryFileSystemLimit) {
            this.inMemoryFileSystemAppLimit = inMemoryFileSystemAppLimit;
            this.misc_settings.put("inMemoryFileSystemAppLimit", (Object)new Integer(inMemoryFileSystemAppLimit));
            VFSFileSystemOptionFactory.updatAppspecificMemory();
        } else if ((long)this.inMemoryFileSystemLimit > Utils.getMaxHeapSize()) {
            throw new ServiceException(RB.getString(RuntimeServiceImpl.class, "RuntimeServiceImpl.MaxInMemoryFileSystemAppLimit"));
        }
    }

    @Override
    public void setHttpOnlySessionCookie(boolean httpOnlySessionCookie) {
        this.httpOnlySessionCookie = httpOnlySessionCookie;
        this.misc_settings.put("httpOnlySessionCookie", (Object)(httpOnlySessionCookie ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public boolean isHttpOnlySessionCookie() {
        return this.httpOnlySessionCookie;
    }

    @Override
    public void setSecureSessionCookie(boolean secureSessionCookie) {
        this.secureSessionCookie = secureSessionCookie;
        this.misc_settings.put("secureSessionCookie", (Object)(secureSessionCookie ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public boolean isSecureSessionCookie() {
        return this.secureSessionCookie;
    }

    @Override
    public int getSessionCookieTimeout() {
        return this.sessionCookieTimeout;
    }

    @Override
    public void setSessionCookieTimeout(int sessionCookieTimeout) {
        this.sessionCookieTimeout = sessionCookieTimeout;
        this.misc_settings.put("sessionCookieTimeout", (Object)new Integer(sessionCookieTimeout));
    }

    @Override
    public String getSessionCookieDomain() {
        return this.sessionCookieDomain;
    }

    @Override
    public void setSessionCookieDomain(String sessionCookieDomain) {
        this.sessionCookieDomain = sessionCookieDomain;
        this.misc_settings.put("sessionCookieDomain", (Object)sessionCookieDomain);
    }

    @Override
    public boolean isCFInternalCookiesDisableUpdate() {
        return this.internalCookiesDisableUpdate;
    }

    @Override
    public void setCFInternalCookiesDisableUpdate(boolean disableupdate) {
        this.internalCookiesDisableUpdate = disableupdate;
        this.misc_settings.put("internalCookiesDisableUpdate", (Object)(this.internalCookiesDisableUpdate ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public String getSessionCookieSamesite() {
        return this.sessionCookieSamesite;
    }

    @Override
    public void setSessionCookieSamesite(String samesite) {
        this.sessionCookieSamesite = samesite;
        this.misc_settings.put("sessionCookieSamesite", (Object)samesite);
    }

    @Override
    public void setServerCFC(String cfcName) {
        this.serverCFC = cfcName;
        this.misc_settings.put("serverCFC", (Object)cfcName);
    }

    @Override
    public String getServerCFC() {
        return this.serverCFC;
    }

    @Override
    public void setStartAPIManager(boolean start) {
        this.startAPIManager = start;
        this.apiManagerSettings.put(START_API_MANAGER, (Object)start);
    }

    @Override
    public Boolean getStartAPIManager() {
        return (Boolean)this.apiManagerSettings.get(START_API_MANAGER);
    }

    @Override
    public void setAllowRestDiscovery(boolean allow) {
        this.allowRestDiscovery = allow;
        this.apiManagerSettings.put(ALLOW_REST_DISCOVERY, (Object)allow);
    }

    @Override
    public boolean isAllowRestPlayAccess() {
        DebuggingService debuggingService = ServiceFactory.getDebuggingService();
        return debuggingService != null && debuggingService.isDeveloperEnabled();
    }

    @Override
    public boolean isAllowRestDiscovery() {
        return (Boolean)this.apiManagerSettings.get(ALLOW_REST_DISCOVERY);
    }

    @Override
    public boolean isEnableNullSupport() {
        return this.enableNullSupport;
    }

    @Override
    public void setEnableNullSupport(boolean enableNullSupport) {
        this.enableNullSupport = enableNullSupport;
        this.misc_settings.put(ENABLE_NULL_SUPPORT, (Object)enableNullSupport);
    }

    @Override
    public boolean isJavaRegexEngineEnabled() {
        Boolean regexEngine;
        FusionContext.getCurrent();
        ApplicationSettings appSettings = FusionContext.getApplicationSettings();
        if (appSettings != null && (regexEngine = appSettings.isJavaRegexEngine()) != null) {
            return regexEngine;
        }
        return this.useJavaAsRegexEngine;
    }

    @Override
    public boolean isJavaRegexEngine() {
        return this.useJavaAsRegexEngine;
    }

    @Override
    public void setJavaAsRegexEngine(boolean useJavaRegexEngine) {
        this.useJavaAsRegexEngine = useJavaRegexEngine;
        this.misc_settings.put(USE_JAVA_AS_REGEX_ENGINE, (Object)useJavaRegexEngine);
    }

    @Override
    public int getMaxThreadCountForParallelCalls() {
        return this.maxThreadCountForParallelCalls;
    }

    @Override
    public void setMaxThreadCountForParallelCalls(int maxThreadCountForParallelCalls) {
        this.maxThreadCountForParallelCalls = maxThreadCountForParallelCalls = Math.min(maxThreadCountForParallelCalls, 50);
        this.misc_settings.put(MAX_THREAD_COUNT_FOR_PARALLEL_CALLS, (Object)new Integer(maxThreadCountForParallelCalls));
    }

    @Override
    public boolean isPreserveNullValues() {
        return this.enableNullSupport;
    }

    @Override
    public void setORMSearchIndexDirectory(String indexDirPath) {
        if (indexDirPath != null && indexDirPath.length() > 0) {
            indexDirPath = ESAPIUtils.getValidateInput(indexDirPath, "ORMSEARCHDIR", 1000);
        }
        this.ORMSearchIndexDirectory = indexDirPath;
        this.misc_settings.put("ORMSearchIndexDirectory", (Object)indexDirPath);
    }

    @Override
    public String getORMSearchIndexDirectory() {
        return this.ORMSearchIndexDirectory;
    }

    private String _getTempCacheDirectory() {
        String tmpRoot = System.getProperty("coldfusion.temp.dir", this.neoRoot);
        String tmpCacheDir = tmpRoot + File.separator + "tmpCache";
        File cacheDir = new File(tmpCacheDir);
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        return tmpCacheDir;
    }

    @Override
    public String getTempCacheDirectory() {
        if (this.tmpCacheDir == null) {
            this.tmpCacheDir = System.getSecurityManager() == null ? this._getTempCacheDirectory() : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return RuntimeServiceImpl.this._getTempCacheDirectory();
                }
            });
        }
        return this.tmpCacheDir;
    }

    public void setDataServiceId(String id) {
        this.misc_settings.put("DataServiceId", (Object)id);
    }

    public void stopApplication(String appName) {
        ApplicationScopeTracker.stopApplication(appName);
    }

    private int getRequestSetting(String setting, int def) {
        Object l = this.request_settings.get(setting);
        if (l != null) {
            return ((Number)l).intValue();
        }
        return def;
    }

    @Override
    public String getWebRoot() {
        return this.webroot;
    }

    @Override
    public void setWebRoot(String webroot) {
        this.webroot = webroot;
        RealPathCache.setWebRoot(webroot);
    }

    private void initMissingSetting(Map map, String setting, Object def) {
        if (map.containsKey(setting)) {
            return;
        }
        map.put(setting, def);
    }

    @Override
    public boolean isCommandLineCompile() {
        return this.isCommandLineCompile;
    }

    @Override
    public String getSessionStorage() {
        return this.sessionStorage;
    }

    @Override
    public String getSessionStorageHost() {
        return this.sessionStorageHost;
    }

    @Override
    public int getSessionStoragePort() {
        return this.sessionStoragePort;
    }

    @Override
    public int getSessionStorageTimeout() {
        return this.sessionStorageTimeout;
    }

    @Override
    public void setSessionStorageTimeout(int timeout) {
        this.sessionStorageTimeout = timeout;
        this.misc_settings.put("sessionStorageTimeout", (Object)new Integer(this.sessionStorageTimeout));
    }

    @Override
    public Boolean getRedisCacheStorageIsSSL() {
        return this.redisCacheStorageIsSSL;
    }

    public boolean getRedisCacheStorageIsCluster() {
        return this.sessionStorageCluster;
    }

    @Override
    public String getRedisCacheStorageHost() {
        return this.redisCacheStorageHost;
    }

    @Override
    public int getRedisCacheStoragePort() {
        return this.redisCacheStoragePort;
    }

    @Override
    public void setSessionStorage(String storage) {
        this.sessionStorage = storage;
        this.misc_settings.put("sessionStorage", (Object)this.sessionStorage);
    }

    @Override
    public void setSessionStorageHost(String host) {
        if (null == host || host.length() < 1) {
            return;
        }
        this.sessionStorageHost = host;
        this.misc_settings.put("sessionStorageHost", (Object)this.sessionStorageHost);
    }

    @Override
    public void setSessionStoragePort(int port) {
        this.sessionStoragePort = port;
        this.misc_settings.put("sessionStoragePort", (Object)new Integer(this.sessionStoragePort));
    }

    @Override
    public void setRedisCacheStorageHost(String host) {
        if (host != null && host.equals(this.getRedisCacheStorageHost())) {
            return;
        }
        this.redisCacheStorageHost = host;
        this.template_settings.put("redisCacheStorageHost", (Object)this.redisCacheStorageHost);
        GenericCacheFactory.resetCache(2);
    }

    @Override
    public void setRedisCacheStorageIsSSL(Boolean isSSL) {
        if (isSSL != null && isSSL.equals(this.getRedisCacheStorageIsSSL())) {
            return;
        }
        this.redisCacheStorageIsSSL = isSSL;
        this.template_settings.put("redisCacheStorageIsSSL", (Object)this.redisCacheStorageIsSSL);
        GenericCacheFactory.resetCache(2);
    }

    @Override
    public void setRedisCacheStoragePort(int port) {
        if (port == this.getRedisCacheStoragePort()) {
            return;
        }
        this.redisCacheStoragePort = port;
        this.template_settings.put("redisCacheStoragePort", (Object)new Integer(this.redisCacheStoragePort));
        GenericCacheFactory.resetCache(2);
    }

    @Override
    public String getSessionStoragePassword() {
        return (String)this.misc_settings.get("sessionStoragePassword");
    }

    @Override
    public void setSessionStoragePassword(String password) {
        this.misc_settings.put("sessionStoragePassword", (Object)this.encryptPassword(password));
    }

    @Override
    public String getRedisCacheStoragePassword() {
        return (String)this.template_settings.get("redisCacheStoragePassword");
    }

    @Override
    public void setRedisCacheStoragePassword(String password) {
        this.template_settings.put("redisCacheStoragePassword", (Object)this.encryptPassword(password));
    }

    public void setSessionStorageCluster(boolean bool) {
        boolean cCluster = this.getSessionStorageIsCluster();
        if (bool == cCluster) {
            return;
        }
        this.template_settings.put("sessionStorageCluster", (Object)bool);
        this.resetQueryCaches();
        GenericCacheFactory.resetCache(2);
    }

    public boolean getSessionStorageIsCluster() {
        Boolean bool = (Boolean)this.template_settings.get("sessionStorageCluster");
        if (null == bool) {
            return false;
        }
        return bool;
    }

    @Override
    public void verifySessionStorageConnection(String host, int port, String password, boolean ssl, String ... args) {
        if (host == null || host.trim().equalsIgnoreCase(DEFAULT_COMPILE_EXT_INCLUDE)) {
            host = this.getSessionStorageHost();
        }
        if (password == null && this.getSessionStoragePassword() != null) {
            password = PasswordUtils.decryptPassword(this.getSessionStoragePassword(), this.seed);
        }
        ServiceFactory.getSessionStorageService(true).testConnection(host, port, password, false, ssl, null);
    }

    public void verifyRedisCacheStorageConnection(String host, int port, String password, boolean isCluster, boolean isSSL) {
        if (host == null || host.trim().equalsIgnoreCase(DEFAULT_COMPILE_EXT_INCLUDE)) {
            host = this.getRedisCacheStorageHost();
        }
        if (password == null && this.getRedisCacheStoragePassword() != null) {
            password = PasswordUtils.decryptPassword(this.getRedisCacheStoragePassword(), this.seed);
        }
        ServiceFactory.getCachingService(true).testConnection(host, port, password, isCluster, isSSL);
    }

    @Override
    public void initSessionStore(boolean force) throws ServiceException {
        if (force || !this.isCommandLineCompile && this.sessionStore == null) {
            try {
                this.sessionStore = this.initializeSessionStorage();
            }
            catch (IOException e) {
                throw new ServiceException(e);
            }
            if (this.sessionStore != null) {
                SessionTracker.initSessionStorage(this.sessionStore);
            }
        }
    }

    private SessionStorage initializeSessionStorage() throws IOException {
        if (this.sessionStorage == null || this.sessionStorage.equalsIgnoreCase(IN_MEMORY_STORAGE)) {
            return new InMemorySessionStorage();
        }
        if (this.sessionStorage.equalsIgnoreCase(REDIS_STORAGE)) {
            if (ServiceFactory.getSessionStorageService() == null) {
                return null;
            }
            String password = this.getSessionStoragePassword();
            if (password != null && !password.trim().isEmpty()) {
                password = PasswordUtils.decryptPassword(password, this.seed);
            }
            Object o = ServiceFactory.getSessionStorageService().getRedisSessionStorage(this.getSessionStorageHost(), this.getSessionStoragePort(), password, this.getSessionStorageTimeout(), this.getLibDir());
            return (SessionStorage)o;
        }
        return new InMemorySessionStorage();
    }

    private static void validateFileExtension(String fileName, String allowedExt) {
        if (!RuntimeServiceImpl.isValidFileExtension(fileName, allowedExt)) {
            throw new InvalidFileExtensionException(fileName, allowedExt);
        }
    }

    private static boolean isValidFileExtension(String fileName, String allowedExt) {
        if (fileName != null && fileName.trim().length() > 0) {
            int index = fileName.lastIndexOf(".");
            if (index > -1) {
                String extension = fileName.substring(index + 1, fileName.length());
                for (String ext : allowedExt.split(",")) {
                    if (!ext.equalsIgnoreCase(extension)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public FilePermission getWebInfClassesReadPermission() {
        return this.webInfClassesReadPermission;
    }

    @Override
    public int getThreadLimitForAsync() {
        return FeatureRouter.getInstance().getServerEdition().getPoolSizeLimitForAsync();
    }

    @Override
    public int getThreadLimitForCloudServices() {
        return FeatureRouter.getInstance().getServerEdition().getPoolSizeLimitForCloudServices();
    }

    @Override
    public int getCorePoolSize() {
        if (this.corePoolSize == 0) {
            return FeatureRouter.getInstance().getServerEdition().getDefaultCorePoolSize();
        }
        return this.corePoolSize;
    }

    @Override
    public int getCloudServicesThreadPoolCorePoolSize() {
        if (this.configuration.getCorePoolSize() == 0) {
            return FeatureRouter.getInstance().getServerEdition().getDefaultCloudServicesCorePoolSize();
        }
        return this.configuration.getCorePoolSize();
    }

    @Override
    public int getGraphQLClientThreadPoolCorePoolSize() {
        if (this.gqlThreadPoolConfig.getCorePoolSize() == 0) {
            return FeatureRouter.getInstance().getServerEdition().getDefaultGraphQLClientCorePoolSize();
        }
        return this.gqlThreadPoolConfig.getCorePoolSize();
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        Executor.validateAsyncCorePoolSize(corePoolSize, true);
        this.corePoolSize = corePoolSize;
        this.misc_settings.put(CORE_POOL_SIZE, (Object)corePoolSize);
    }

    @Override
    public void setCloudServicesThreadPoolConfiguration(int corePoolSize, int maxPoolSize, long keepAliveTime) {
        coldfusion.cloud.Executor.validateMaxPoolSize(maxPoolSize, corePoolSize, true);
        this.configuration.setMaxPoolSize(maxPoolSize);
        coldfusion.cloud.Executor.validateCorePoolSize(corePoolSize, true);
        this.configuration.setCorePoolSize(corePoolSize);
        coldfusion.cloud.Executor.validateKeepAliveTime(keepAliveTime, true);
        this.configuration.setKeepAliveTime(keepAliveTime);
        this.misc_settings.put(CORE_POOL_SIZE_CLOUD_SERVICES, (Object)corePoolSize);
        this.misc_settings.put(MAX_POOL_SIZE_CLOUD_SERVICES, (Object)maxPoolSize);
        this.misc_settings.put(KEEP_ALIVE_TIME_CLOUD_SERVICES, (Object)keepAliveTime);
    }

    public void setGraphQLClientThreadPoolConfiguration(int corePoolSize, int maxPoolSize, long keepAliveTime) {
        coldfusion.graphql.client.Executor.validateMaxPoolSize(maxPoolSize, true);
        this.gqlThreadPoolConfig.setMaxPoolSize(maxPoolSize);
        coldfusion.graphql.client.Executor.validateCorePoolSize(corePoolSize, true);
        this.gqlThreadPoolConfig.setCorePoolSize(corePoolSize);
        coldfusion.graphql.client.Executor.validateKeepAliveTime(keepAliveTime, true);
        this.gqlThreadPoolConfig.setKeepAliveTime(keepAliveTime);
        this.misc_settings.put(CORE_POOL_SIZE_GRAPHQL_CLIENT, (Object)corePoolSize);
        this.misc_settings.put(MAX_POOL_SIZE_GRAPHQL_CLIENT, (Object)maxPoolSize);
        this.misc_settings.put(KEEP_ALIVE_TIME_GRAPHQL_CLIENT, (Object)keepAliveTime);
    }

    @Override
    public int getMaxPoolSize() {
        if (this.maxPoolSize == 0) {
            return FeatureRouter.getInstance().getServerEdition().getDefaultMaxPoolSize();
        }
        return this.maxPoolSize;
    }

    @Override
    public int getCloudServicesThreadPoolMaxPoolSize() {
        if (this.configuration.getMaxPoolSize() == 0) {
            return FeatureRouter.getInstance().getServerEdition().getDefaultCloudServicesMaxPoolSize();
        }
        return this.configuration.getMaxPoolSize();
    }

    @Override
    public int getGraphQLClientThreadPoolMaxPoolSize() {
        if (this.gqlThreadPoolConfig.getMaxPoolSize() == 0) {
            return FeatureRouter.getInstance().getServerEdition().getDefaultGraphQLClientMaxPoolSize();
        }
        return this.gqlThreadPoolConfig.getMaxPoolSize();
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) {
        Executor.validateAsyncMaxPoolSize(maxPoolSize, true);
        this.maxPoolSize = maxPoolSize;
        this.misc_settings.put(MAX_POOL_SIZE, (Object)maxPoolSize);
    }

    @Override
    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    @Override
    public long getCloudServicesThreadPoolKeepAliveTime() {
        return this.configuration.getKeepAliveTime();
    }

    @Override
    public long getGraphQLClientThreadPoolKeepAliveTime() {
        return this.gqlThreadPoolConfig.getKeepAliveTime();
    }

    @Override
    public void setKeepAliveTime(long keepAliveTime) {
        Executor.validateKeepAliveTime(keepAliveTime, true);
        this.keepAliveTime = keepAliveTime;
        this.misc_settings.put(KEEP_ALIVE_TIME, (Object)keepAliveTime);
    }

    @Override
    public AsyncExecutorThreadPoolMetrics getAsyncThreadPoolMetrics() {
        AsyncExecutorThreadPoolMetrics threadPoolmetrics = new AsyncExecutorThreadPoolMetrics(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, Executor.getActiveThreadCount(), Executor.getCurrentPoolSize(), Executor.getLargestPoolSize(), Executor.getCompletedTaskCount(), Executor.getTotalTaskCount());
        return threadPoolmetrics;
    }

    public class CloudServicesThreadPoolConfiguration {
        private int corePoolSize = 0;
        private int maxPoolSize = 0;
        private long keepAliveTime = 6000L;

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public void setKeepAliveTime(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }
    }

    public class GraphQLClientThreadPoolConfiguration {
        private int corePoolSize = 0;
        private int maxPoolSize = 0;
        private long keepAliveTime = 6000L;

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public void setKeepAliveTime(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }
    }

    private static final class CfmServletInnerHelper
    extends CfmServletHelper {
        private CfmServletInnerHelper() {
        }

        protected static void setRequestLimit(int limit) {
            CfmServletHelper.setRequestLimit(limit);
        }
    }

    private static final class CFCServletInnerHelper
    extends CFCServletHelper {
        private CFCServletInnerHelper() {
        }

        protected static void setWebServiceRequestLimit(int limit) {
            CFCServletHelper.setWebServiceRequestLimit(limit);
        }

        public static void setCFCRequestLimit(int limit) {
            CFCServletHelper.setCFCRequestLimit(limit);
        }
    }

    public static class InvalidFileExtensionException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String ext = null;
        public String fileName = null;

        InvalidFileExtensionException(String fileName, String ext) {
            this.fileName = fileName;
            this.ext = ext;
        }
    }

    public static class FileNotFoundException
    extends ApplicationException {
        public String files;

        public FileNotFoundException(List fileList) {
            StringBuffer sb = new StringBuffer();
            sb.append("<ul>");
            for (String element : fileList) {
                sb.append("<li>");
                sb.append(element);
                sb.append("</li>");
            }
            sb.append("</ul>");
            this.files = sb.toString();
        }
    }
}

