/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ScopeCastException;
import coldfusion.runtime.Variable;
import coldfusion.util.Key;
import java.util.Map;

final class ScopeSearchResult {
    private boolean found = false;
    private Object result = null;
    private Variable variable = null;
    private String canonicalUnifiedKey = null;
    private final String baseName;
    private final String[] subkeys;
    public Key baseNameAsKeyObject = null;
    public Key canonicalUnifiedKeyAsKeyObject = null;
    public static final int UNDIFFERENTIATED_SCOPE = 0;
    public static final int VARIABLES_SCOPE = 1;
    private int scope = 0;
    public static final boolean PROPAGATE_CLASS_CAST_EXCEPTION = true;
    public static final boolean CLASS_CAST_EXCEPTION_MEANS_NOT_FOUND = false;

    public ScopeSearchResult(String canonicalUnifiedKey) {
        this.canonicalUnifiedKey = canonicalUnifiedKey;
        this.subkeys = null;
        this.baseName = null;
    }

    public ScopeSearchResult(String varName, String[] subkeys) {
        this.subkeys = subkeys;
        this.baseName = varName;
    }

    public boolean search(Map m, boolean propagateScopeCastException) {
        if (this.baseName != null) {
            Object stem = m.get(this.baseName);
            if (stem != null) {
                try {
                    this.searchForSubkeys(Cast._Map(m.get(this.baseName)));
                }
                catch (ScopeCastException notAScope) {
                    if (propagateScopeCastException) {
                        throw notAScope;
                    }
                    this.searchForFlatKey(m);
                }
            }
        } else {
            this.searchForFlatKey(m);
        }
        return this.found;
    }

    private void searchForFlatKey(Map m) {
        if (m instanceof ArgumentCollection) {
            Key canonicalUnifiedKeyObject = this.getCanonicalUnifiedKeyAsKeyObject();
            this.result = m.get(canonicalUnifiedKeyObject);
            this.found = this.result != null || m.containsKey(canonicalUnifiedKeyObject);
        } else {
            this.result = m.get(this.getCanonicalUnifiedKey());
            this.found = this.result != null || m.containsKey(this.getCanonicalUnifiedKey());
        }
    }

    void searchForSubkeys(Map substruct) {
        this.result = substruct.get(this.subkeys[0]);
        this.found = this.result != null || substruct.containsKey(this.subkeys[0]);
    }

    public boolean found() {
        return this.found;
    }

    void setFound(boolean found) {
        this.found = found;
    }

    public Object get() {
        this.assertFound();
        return this.result;
    }

    void setResult(Object result) {
        this.result = result;
    }

    public int getScope() {
        this.assertFound();
        return this.scope;
    }

    public void setScope(int scope) {
        this.assertFound();
        this.scope = scope;
    }

    private void assertFound() {
        if (!this.found) {
            throw new IllegalStateException();
        }
    }

    public boolean hasDottedReferences() {
        return this.subkeys != null;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getCanonicalUnifiedKey() {
        if (this.canonicalUnifiedKey == null) {
            StringBuilder sb = new StringBuilder(this.baseName);
            sb.append('.').append(this.subkeys[0]);
            this.canonicalUnifiedKey = sb.toString();
        }
        return this.canonicalUnifiedKey;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public Key getBaseNameAsKeyObject() {
        if (this.baseNameAsKeyObject == null) {
            this.baseNameAsKeyObject = Key.getInstance(this.baseName);
        }
        return this.baseNameAsKeyObject;
    }

    public Key getCanonicalUnifiedKeyAsKeyObject() {
        if (this.canonicalUnifiedKeyAsKeyObject == null) {
            this.canonicalUnifiedKeyAsKeyObject = Key.getInstance(this.getCanonicalUnifiedKey());
        }
        return this.canonicalUnifiedKeyAsKeyObject;
    }
}

