/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.CFCookie;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.NoOperScope;
import coldfusion.runtime.Scope;
import coldfusion.runtime.SecurityCleanUpAgent;
import coldfusion.runtime.SecurityTable;
import coldfusion.runtime.SessionScope;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceFactory;
import coldfusion.wddx.Base64Encoder;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.PageContext;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class SecurityScopeTracker {
    private static SecurityScopeTracker instance = new SecurityScopeTracker();
    private SecurityCleanUpAgent msecurityCleanUpAgent;
    private SchedulerService mScheduler;
    public int mSweepInterval = 10000;
    private Hashtable<String, SecurityTable> msecurityPool = new Hashtable();
    public static final String SCOPED_SECURE_COOKIE_NAME = "COOKIE.CFAUTHORIZATION";
    public static final String SECURE_COOKIE_NAME = "CFAUTHORIZATION";
    public static final String APPLICATION_TOKEN = "_CFMX_AUTH_APPLICATION_TOKEN";
    public static final String SECURE_TABLE_NAME = "_CFMX_AUTH_";

    private SecurityScopeTracker() {
        this.msecurityCleanUpAgent = new SecurityCleanUpAgent();
        this.mScheduler = ServiceFactory.getSchedulerService();
        this.mScheduler.schedule(this.msecurityCleanUpAgent, System.currentTimeMillis() + (long)this.mSweepInterval);
    }

    public static SecurityScopeTracker getInstance() {
        return instance;
    }

    private boolean storeSecurityKeyInSession(PageContext pageContext, Scope _sessionScope) {
        Scope _applicationScope = FusionContext.getApplicationScope();
        boolean rc = false;
        if (_sessionScope instanceof SessionScope && _applicationScope instanceof ApplicationScope && ((ApplicationScope)_applicationScope).getStoreloginCredentialInSession()) {
            rc = true;
        }
        return rc;
    }

    public SecurityTable getSecurity(String key) {
        SecurityTable retval = this.msecurityPool.get(key);
        if (retval == null) {
            return retval;
        }
        String returnKey = ServiceFactory.getSecurityService().verifyAuth(key);
        if (returnKey == null) {
            this.msecurityPool.remove(key);
            retval = null;
        } else if (!returnKey.equals(key)) {
            FusionContext fContext;
            NeoPageContext pageContext = fContext.pageContext;
            fContext = FusionContext.getCurrent();
            SessionScope _sessionScope = fContext.getCurrentSession();
            if (this.storeSecurityKeyInSession(pageContext, _sessionScope)) {
                _sessionScope.put(SecurityScopeTracker.getAppSecureCookieName(), returnKey);
                retval.setMaxInactiveInterval(_sessionScope.getMaxInactiveInterval() + 1L);
            } else {
                Cookie cook = SecurityScopeTracker.createSecurityCookie(pageContext, returnKey);
                SecurityScopeTracker.setSecurityCookie(pageContext, cook);
            }
        }
        if (retval != null) {
            retval.setLastAccess(new Date());
        }
        return retval;
    }

    public int getSecurityScopeCount() {
        return this.msecurityPool.size();
    }

    public SecurityTable getSecurity(PageContext ctx) {
        String cook = this.getKey(ctx);
        if (cook == null) {
            return null;
        }
        return this.getSecurity(cook);
    }

    public void logout(PageContext context, String session) {
        FusionContext ctx = FusionContext.getCurrent();
        if (ctx.isAdminAPI()) {
            ServiceFactory.getSecurityService().removeAuthenticated();
        } else {
            SessionScope sessionScope;
            String key = this.getKey(context);
            if (key == null && (sessionScope = ctx.getCurrentSession()) instanceof SessionScope) {
                key = (String)sessionScope.get(SecurityScopeTracker.getAppSecureCookieName());
            }
            if (key != null) {
                ServiceFactory.getSecurityService().processLogoutAuth(key, session);
                if (this.msecurityPool.get(key) == null) {
                    // empty if block
                }
                if (!session.equalsIgnoreCase("others")) {
                    this.msecurityPool.remove(key);
                    this.finishLogoutProcesss(context, key);
                }
            } else {
                this.finishLogoutProcesss(context, key);
            }
        }
    }

    private void finishLogoutProcesss(PageContext context, String key) {
        FusionContext.getCurrent().setSecureTable(null);
        Cookie cookie = SecurityScopeTracker.createSecurityCookie(context, "");
        cookie.setMaxAge(0);
        SecurityScopeTracker.setSecurityCookie(context, cookie);
        SessionScope sessionScope = FusionContext.getCurrent().getCurrentSession();
        if (sessionScope instanceof SessionScope && (key = (String)sessionScope.get(SecurityScopeTracker.getAppSecureCookieName())) != null) {
            sessionScope.remove(SecurityScopeTracker.getAppSecureCookieName());
            this.msecurityPool.remove(key);
        }
    }

    public String getKey(PageContext ctx) {
        String cook = SecurityScopeTracker.getSecurityCookie(ctx);
        return cook;
    }

    public void setSecurity(String key, SecurityTable sMap) {
        if (key != null && sMap != null) {
            this.msecurityPool.put(key, sMap);
        }
    }

    public SecurityTable removeSecurity(String key) {
        if (key != null) {
            return this.msecurityPool.remove(key);
        }
        return null;
    }

    public SecurityTable getSecurityTable(String key) {
        if (key != null) {
            return this.msecurityPool.get(key);
        }
        return null;
    }

    public void copySecurityTableIfAbsent(String oldKey, String newKey) {
        SecurityTable sTab;
        if (oldKey != null && newKey != null && (sTab = this.getSecurityTable(newKey)) == null && (sTab = this.getSecurityTable(oldKey)) != null) {
            this.setSecurity(newKey, sTab);
        }
    }

    public static String getSecurityCookie(PageContext context) {
        Scope cookieScope = FusionContext.getCookieScope();
        if (cookieScope == null) {
            return null;
        }
        String authCookie = (String)cookieScope.get(SecurityScopeTracker.getAppSecureCookieName());
        authCookie = Base64Encoder.fixPadding(authCookie);
        return authCookie;
    }

    public static void setSecurityCookie(PageContext context, Cookie cook) {
        context.setAttribute(SecurityScopeTracker.getScopedAppSecureCookieName(), (Object)cook);
    }

    public static Cookie createSecurityCookie(PageContext context, String token) {
        CFCookie cook = new CFCookie(SecurityScopeTracker.getAppSecureCookieName(), token, "");
        Object path = ((HttpServletRequest)context.getRequest()).getContextPath();
        if (path != null) {
            if (((String)path).equals("") || !((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            cook.setPath((String)path);
        }
        return cook;
    }

    public static String getAppSecureCookieName() {
        StringBuilder buf = new StringBuilder(SECURE_COOKIE_NAME);
        buf.append("_");
        buf.append(FusionContext.getCurrent().getApplicationToken());
        return buf.toString();
    }

    public static String getScopedAppSecureCookieName() {
        StringBuilder buf = new StringBuilder(SCOPED_SECURE_COOKIE_NAME);
        buf.append("_");
        buf.append(FusionContext.getCurrent().getApplicationToken());
        return buf.toString();
    }

    public void cleanUp() {
        Enumeration<String> e = this.msecurityPool.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            SecurityTable s = this.msecurityPool.get(key);
            if (!s.expired()) continue;
            s.cleanUp();
            this.msecurityPool.remove(key);
        }
        this.mScheduler.schedule(this.msecurityCleanUpAgent, System.currentTimeMillis() + (long)this.mSweepInterval);
    }

    public SecurityTable getSecurityTableFromSession(PageContext pageContext) {
        String key;
        SessionScope _sessionScope = FusionContext.getCurrent().getCurrentSession();
        if (_sessionScope != null && !(_sessionScope instanceof NoOperScope) && (key = (String)_sessionScope.get(SecurityScopeTracker.getAppSecureCookieName())) != null) {
            return SecurityScopeTracker.getInstance().getSecurity(key);
        }
        return null;
    }
}

