/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.monitor.memory.MemoryTrackableRoot;
import coldfusion.monitor.memory.MemoryTracker;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.AbstractScope;
import coldfusion.runtime.LockManager;
import coldfusion.runtime.LockableScope;
import coldfusion.runtime.MD5;
import coldfusion.runtime.TimedScope;
import coldfusion.security.SecurityUtils;
import coldfusion.util.FastHashtable;
import coldfusion.util.Key;
import coldfusion.util.RB;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class SessionScope
extends AbstractScope
implements LockableScope,
Serializable,
MemoryTrackableRoot,
TimedScope {
    private static final long serialVersionUID = 1L;
    protected long mLastAccess;
    protected transient FastHashtable mTable;
    protected String mAppName;
    private boolean mIsNew = false;
    private boolean mIsIdFromUrl = false;
    private long mMaxInactiveInterval = 1800000L;
    private long mStartTime = 0L;
    private transient Object sessionLock = LockManager.get().requestNewLock();
    private String clientIp;
    private Map<String, String> csrfTokens;
    private static String DUMMY_CSRF_TOKEN = "abcdefghijklmnopqrstuvwxyz0123456789+-.;";
    private String trackerSessionId;

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    @Override
    public Object getLock() {
        return this.sessionLock;
    }

    SessionScope() {
        this.mStartTime = this.mLastAccess = System.currentTimeMillis();
        this.mTable = new FastHashtable();
        this.setScopeType(6);
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd != null && rmd.doMonitor()) {
            this.setMemoryTrackerProxy(new MemoryTrackerProxy(this));
        }
    }

    SessionScope(String appName) {
        this();
        this.mAppName = appName;
    }

    @Override
    public MemoryTracker getMemoryTracker() {
        MemoryTracker mt = null;
        MemoryTrackerProxy mtp = this.getMemoryTrackerProxy();
        if (mtp != null) {
            mt = mtp.getBuiltInMemoryTracker();
        }
        return mt;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public String getTrackerSessionId() {
        return this.trackerSessionId;
    }

    public void setTrackerSessionId(String id) {
        this.trackerSessionId = id;
    }

    public abstract String getSessionId();

    @Override
    protected void bind(String name, Object value) {
        this.mLastAccess = System.currentTimeMillis();
        this.mTable.put(name, value);
    }

    @Override
    protected void bind_Final(String name, Object value) {
        this.bind(name, value);
    }

    @Override
    protected void unbind(String name) {
        this.mLastAccess = System.currentTimeMillis();
        this.mTable.remove(name);
    }

    @Override
    protected Object resolve(String name) {
        this.mLastAccess = System.currentTimeMillis();
        return this.mTable.get(name);
    }

    @Override
    public boolean containsKey(Object key) {
        String lower;
        if (FusionContext.isPreserveNullValues()) {
            Key keyObj = key instanceof Key ? (Key)key : Key.getInstance(key.toString());
            boolean hasKey = this.mTable._containsKey(keyObj);
            if (!hasKey) {
                keyObj = Key.getInstance(key.toString().toLowerCase());
                hasKey = this.mTable._containsKey(keyObj);
            }
            return hasKey;
        }
        String strKey = (String)key;
        Object o = this.resolve(strKey);
        if (o == null && !(lower = strKey.toLowerCase()).equals(strKey)) {
            o = this.resolve(lower);
        }
        return o != null;
    }

    @Override
    public Object getValueWIthoutChange(String name) {
        return this.mTable.get(name);
    }

    @Override
    public Iterator getNames() {
        return this.mTable.keySet().iterator();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.mLastAccess > this.mMaxInactiveInterval;
    }

    public long getCreatedTime() {
        return this.mStartTime;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.mStartTime;
    }

    public long getTimeSinceLastAccess() {
        return System.currentTimeMillis() - this.mLastAccess;
    }

    public long getMaxInactiveInterval() {
        return this.mMaxInactiveInterval / 1000L;
    }

    public void SetMaxInactiveInterval(long max) {
        this.mMaxInactiveInterval = max * 1000L;
    }

    public abstract void CleanUp();

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.cloneAsStruct();
    }

    public boolean isNew() {
        return this.mIsNew;
    }

    public void setIsNew(boolean status) {
        this.mIsNew = status;
    }

    public boolean isIdFromURL() {
        return this.mIsIdFromUrl;
    }

    public void setIsIdFromURL(boolean status) {
        this.mIsIdFromUrl = status;
    }

    public void setLastAccess() {
        this.mLastAccess = System.currentTimeMillis();
    }

    public abstract boolean IsJ2eeSession();

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        int n = (Integer)in.readObject();
        this.mTable = new FastHashtable(n * 2);
        for (int i = 0; i < n; ++i) {
            Object name = in.readObject();
            Object value = null;
            try {
                value = in.readObject();
            }
            catch (Exception e) {
                value = new SerializationProblem(RB.getString(SessionScope.class, "SessionScope.SerializationError", (Object)e.toString()));
            }
            this.mTable.put(name, value);
        }
        this.sessionLock = LockManager.get().requestNewLock();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(new Integer(this.mTable.size()));
        Enumeration keysEnum = this.mTable.keys();
        while (keysEnum.hasMoreElements()) {
            Object key = keysEnum.nextElement();
            out.writeObject(key);
            Object value = this.mTable.get(key);
            if (value instanceof Serializable) {
                try {
                    out.writeObject(value);
                }
                catch (Exception e) {
                    out.writeObject(new SerializationProblem(RB.getString(SessionScope.class, "SessionScope.SerializationError", (Object)e.toString())));
                }
                continue;
            }
            out.writeObject(new SerializationProblem(RB.getString(SessionScope.class, "SessionScope.NotSerializable")));
        }
    }

    public String generateCSRFToken(String key, boolean random) {
        if (this.csrfTokens == null) {
            this.csrfTokens = new HashMap<String, String>();
        }
        String mapKey = this.getMapKey(key);
        String token = this.csrfTokens.get(mapKey);
        if (random || token == null) {
            byte[] tokenBytes = SecurityUtils.generateRandom();
            token = MD5.stringify(tokenBytes);
        }
        this.csrfTokens.put(mapKey, token);
        return token;
    }

    public boolean verifyCSRFToken(String token, String key) {
        String token1;
        if (token != null && this.csrfTokens != null && (token1 = this.csrfTokens.get(this.getMapKey(key))) != null) {
            token = token.length() >= 40 ? SessionScope.substring(token, 40) : SessionScope.substring(DUMMY_CSRF_TOKEN, 40);
            return MessageDigest.isEqual(token1.getBytes(), token.getBytes());
        }
        return false;
    }

    private static String substring(String s, int length) {
        char[] string = new char[length];
        for (int i = 0; i < length; ++i) {
            string[i] = s.charAt(i);
        }
        return new String(string);
    }

    private String getMapKey(String key) {
        Object mapKey = this.mAppName != null && this.mAppName.length() > 0 ? this.mAppName : "_";
        if (key != null && key.length() > 0) {
            mapKey = (String)mapKey + "_" + key;
        }
        return mapKey;
    }

    protected void clearCSRFMap() {
        if (this.csrfTokens != null) {
            this.csrfTokens.clear();
        }
        this.csrfTokens = null;
    }

    protected HashMap<String, Object> getSessionData() {
        return null;
    }

    protected void setSessionData(HttpSession session, HashMap<String, Object> attributes) {
    }

    static class SerializationProblem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String mesg;

        SerializationProblem(String msg) {
            this.mesg = msg;
        }

        public String toString() {
            return this.mesg;
        }
    }
}

