/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.monitor.memory.MemoryTrackable;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.CFComparable;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.CloneableMap;
import coldfusion.runtime.ObjectDuplicator;
import coldfusion.runtime.StructWrapper;
import coldfusion.runtime.java.AbstractMethodHandleMapper;
import coldfusion.runtime.java.StructHandleMapper;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.Key;
import com.google.common.collect.MapMaker;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Struct
extends CaseInsensitiveMap
implements CloneableMap,
MemoryTrackable,
CFComparable {
    private static final String UNORDERED = "unordered";
    private static final String KEYS = "keys";
    protected static final String ORDERED = "ordered";
    protected static final String CASESENSITIVE = "casesensistive";
    protected boolean initialized = true;
    private static Map structWrapperMap = new MapMaker().weakKeys().makeMap();
    public Map metadata;

    public Struct() {
        super(true);
    }

    @Override
    public Object put(Key key, Object value) {
        return super.put(key, value);
    }

    @Override
    public void putAll(Map map) {
        super.putAll(map);
    }

    public Struct(boolean threadsafe) {
        super(threadsafe);
    }

    public Struct(int capacity) {
        super(true, capacity);
    }

    public Struct(StructWrapper wrapper) {
        super(true);
        this.initialized = false;
        this.initFromWrapper(wrapper);
    }

    public Struct getNewStructObject() {
        return new Struct();
    }

    public Struct getNewStructObject(int capacity) {
        return new Struct(capacity);
    }

    public Map getNewMapObject() {
        return new ConcurrentHashMap();
    }

    protected void initFromWrapper(StructWrapper wrapper) {
        this.putAll(wrapper.getMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        if (!this.initialized) {
            Struct struct = this;
            synchronized (struct) {
                if (!this.initialized) {
                    this.resolveCircularReference();
                    this.initialized = true;
                }
            }
        }
        return super.get(key);
    }

    public static Map getStructWrapperMap() {
        return structWrapperMap;
    }

    private void resolveCircularReference() {
        if (this.initialized) {
            return;
        }
        for (Map.Entry entry : this.map.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof StructWrapper)) continue;
            Struct ref = (Struct)structWrapperMap.get(value);
            ref.resolveCircularReference();
            ref.initialized = true;
            entry.setValue(ref);
        }
    }

    public Object writeReplace() {
        StructWrapper wrapper = new StructWrapper();
        Map result = this.filterKeyValue();
        wrapper.setMap(result);
        wrapper.setStructClassName(this.getClass().getName());
        return wrapper;
    }

    private Map filterKeyValue() {
        Map result = this.getNewMapObject();
        for (Map.Entry entry : this.map.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Serializable)) continue;
            result.put(((Key)entry.getKey()).getKeyString(), value);
        }
        return result;
    }

    public boolean keyExists(Object key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        if (FusionContext.isPreserveNullValues()) {
            return super.containsKey(key);
        }
        return this.get(Key.getInstance(key.toString())) != null;
    }

    @Override
    public synchronized Map duplicate(IdentityHashMap refCache) throws IllegalAccessException {
        Struct result = this.getNewStructObject(this.size());
        if (refCache == null) {
            refCache = new IdentityHashMap<Struct, Struct>();
        }
        refCache.put(this, result);
        for (Map.Entry entry : this.map.entrySet()) {
            result.put((Key)entry.getKey(), ObjectDuplicator.duplicate(entry.getValue(), refCache));
        }
        result.metadata = this.metadata;
        return result;
    }

    @Override
    public Object clone() {
        return this.deepClone(false);
    }

    public Object deepClone(boolean deepClone) {
        Struct copy = this.getNewStructObject();
        for (Map.Entry e : this.entrySet()) {
            Object val = e.getValue();
            if (CFPage.IsArray(val) && !val.getClass().isArray()) {
                copy.put(e.getKey(), ArrayUtil.copy((List)val));
                continue;
            }
            if (deepClone && val instanceof Struct) {
                copy.put(e.getKey(), ((Struct)val).deepClone(deepClone));
                continue;
            }
            copy.put(e.getKey(), val);
        }
        return copy;
    }

    @Override
    public int getScopeType() {
        return -1;
    }

    @Override
    public MemoryTrackerProxy getMemoryTrackerProxy() {
        return this.mtProxy;
    }

    @Override
    public void setMemoryTrackerProxy(MemoryTrackerProxy mtp) {
        this.mtProxy = mtp;
    }

    @Override
    public Iterator valuesIterator() {
        return this.values().iterator();
    }

    @Override
    public boolean objectEquals(Object o, IdentityHashMap<Object, Map> circularReferenceMap) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry e : this.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                Object otherVal = t.get(key);
                if (value == null) {
                    if (otherVal == null && t.containsKey(key)) continue;
                    return false;
                }
                if (otherVal == null) {
                    return false;
                }
                if (!(value instanceof String && otherVal instanceof String ? !value.toString().equalsIgnoreCase(otherVal.toString()) : (value instanceof CFComparable ? !((CFComparable)value).objectEquals(otherVal, circularReferenceMap) : !value.equals(otherVal)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    public final Map getMetaData() {
        Map copy = this.getAdditionalMetadata();
        if (this.metadata != null) {
            if (copy == null) {
                copy = new CaseInsensitiveMap();
            }
            copy.put(KEYS, this.metadata);
        }
        return copy;
    }

    public Map setMetaData(Map metadata) {
        this.metadata = metadata != null && metadata.containsKey(KEYS) && metadata.get(KEYS) instanceof Map ? (Map)metadata.get(KEYS) : metadata;
        Map copy = this.getAdditionalMetadata();
        if (copy == null) {
            copy = new CaseInsensitiveMap();
        }
        copy.put(KEYS, metadata);
        return copy;
    }

    protected Map getAdditionalMetadata() {
        CaseInsensitiveMap metadata = new CaseInsensitiveMap();
        metadata.put(ORDERED, UNORDERED);
        metadata.put(CASESENSITIVE, false);
        return metadata;
    }

    public static class InvalidReturnTypeForStructFilterException
    extends ApplicationException {
        public String functionName = "StructFilter";
        static AbstractMethodHandleMapper methodMapper = new StructHandleMapper();

        public InvalidReturnTypeForStructFilterException() {
            if (FusionContext.getCurrent().isMemberFuncCallInProcess()) {
                this.functionName = methodMapper.getMemberFuncForCFFunc(this.functionName);
            }
        }
    }
}

