/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.Scope;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UninitializedValueException;
import coldfusion.runtime.java.ClassUtility;
import coldfusion.runtime.java.ExceptionCache;
import coldfusion.runtime.java.Introspectable;
import coldfusion.runtime.java.JavaProxy;
import coldfusion.runtime.java.MethodExecutionException;
import coldfusion.runtime.java.ObjectHandler;
import coldfusion.runtime.java.ReflectionCache;
import coldfusion.security.SecurityManager;
import coldfusion.server.DotNetService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTagPermission;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StructBean
extends Scope {
    private Object instance = null;
    private Class type = null;
    private Introspectable reflector = null;
    private JavaProxy ProxyHandle = null;
    private static final Object[] noParams = new Object[0];
    private static final int MAX_MESSAGE_VALUE_LENGTH = 1024;

    public StructBean(Object o) {
        if (o == null) {
            throw new UninitializedValueException();
        }
        if (o instanceof JavaProxy) {
            this.ProxyHandle = (JavaProxy)o;
            this.type = this.ProxyHandle.getClazz();
            this.instance = this.ProxyHandle.getObject();
        } else {
            this.instance = o;
            this.type = o.getClass();
        }
        this.reflector = ReflectionCache.get(this.type);
    }

    private void checkPermission(String methodname) throws SecurityException {
        boolean cfobjectenabled;
        boolean createobjectenabled;
        if (((Class)this.instance).getName().startsWith("coldfusion.") && ServiceFactory.getRuntimeService().isServiceFactoryDisabled() && !methodname.equals("getClass")) {
            throw new SecurityException(methodname);
        }
        SecurityService SecurityServiceimpl = ServiceFactory.getSecurityService();
        if (!SecurityServiceimpl.isJvmSecurityEnabled()) {
            return;
        }
        if (!SecurityServiceimpl.isSandboxSecurityEnabled()) {
            return;
        }
        try {
            SecurityServiceimpl.checkPermission(SecurityManager.CREATE_OBJECT);
            SecurityServiceimpl.checkPermission(SecurityManager.CREATE_JAVA_OBJECT);
            createobjectenabled = true;
        }
        catch (AccessControlException ae) {
            createobjectenabled = false;
        }
        try {
            SecurityServiceimpl.checkPermission(new GenericTagPermission("cfobject"));
            cfobjectenabled = true;
        }
        catch (AccessControlException ae) {
            cfobjectenabled = false;
        }
        if (!cfobjectenabled || !createobjectenabled) {
            throw new SecurityException(methodname);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Object resolveName(String name) {
        Field f;
        Thread currThread = Thread.currentThread();
        ClassLoader origLoader = currThread.getContextClassLoader();
        DotNetService dotNetServ = null;
        try {
            dotNetServ = ServiceFactory.getDotNetService();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dotNetServ != null && dotNetServ.isDotNetClass(this.type)) {
            currThread.setContextClassLoader(this.type.getClassLoader());
        }
        if ((f = this.reflector.getField(name)) != null) {
            if (this.instance == null && !Modifier.isStatic(f.getModifiers())) {
                this.instance = this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (this.ProxyHandle != null) {
                    this.ProxyHandle.setInstance(this.instance);
                }
            }
            Object object = f.get(this.instance);
            return object;
        }
        Method get = this.reflector.findMethod("get".concat(name), noParams);
        if (get == null && (get = this.reflector.findMethod("is".concat(name), noParams)) == null) {
            Object var7_10 = null;
            return var7_10;
        }
        Object object = get.invoke(this.instance, noParams);
        return object;
        {
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | java.lang.SecurityException | InvocationTargetException ex) {
                throw new FieldAccessException(name, ex);
            }
        }
        finally {
            currThread.setContextClassLoader(origLoader);
        }
    }

    @Override
    public boolean containsName(String name) {
        return this.reflector.findMethod("get".concat(name), noParams) != null || this.reflector.findMethod("is".concat(name), noParams) != null || this.reflector.getField(name) != null;
    }

    @Override
    public void bindName_Final(String name, Object value) {
        this.bindName(name, value);
    }

    @Override
    public void bindName(String name, Object value) {
        Object obj = ClassUtility.UnWrap(this.type, value);
        ArrayList methList = this.reflector.getMethodList("set".concat(name));
        Method set = null;
        if (methList != null) {
            for (Method setter : methList) {
                Class<?>[] paramTypes = setter.getParameterTypes();
                if (paramTypes.length != 1) continue;
                set = setter;
                break;
            }
        }
        if (set == null) {
            try {
                Field f = this.reflector.getField(name);
                if (f == null) {
                    throw new FieldAccessException(name, new NoSuchFieldException(name));
                }
                if (this.instance == null && !Modifier.isStatic(f.getModifiers())) {
                    this.instance = this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (this.ProxyHandle != null) {
                        this.ProxyHandle.setInstance(this.instance);
                    }
                }
                try {
                    f.setAccessible(true);
                }
                catch (java.lang.SecurityException setter) {
                    // empty catch block
                }
                f.set(this.instance, ClassUtility.cast(obj, f.getType()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | java.lang.SecurityException | InvocationTargetException x) {
                throw new FieldAccessException(name, x);
            }
        }
        Thread currThread = Thread.currentThread();
        ClassLoader origLoader = currThread.getContextClassLoader();
        try {
            if (ServiceFactory.getDotNetService(false) != null && ServiceFactory.getDotNetService().isDotNetClass(this.type)) {
                currThread.setContextClassLoader(this.type.getClassLoader());
            }
            Class<?> paramType = set.getParameterTypes()[0];
            set.invoke(this.instance, Cast._cast(obj, paramType));
        }
        catch (IllegalAccessException ex) {
            throw new FieldAccessException(name, ex);
        }
        catch (InvocationTargetException wrapper) {
            Throwable ex = wrapper.getTargetException();
            throw new FieldAccessException(name, ex);
        }
        finally {
            currThread.setContextClassLoader(origLoader);
        }
    }

    @Override
    public void unbindName(String name) {
        throw new UnsupportedOperationException("cannot remove properties from a java object");
    }

    @Override
    public Iterator getNames() {
        AccessibleObject next;
        int i;
        Hashtable<String, AccessibleObject> table = new Hashtable<String, AccessibleObject>();
        if (this.shouldConvertMethodsToFields()) {
            Method[] methods = this.type.getMethods();
            block4: for (i = 0; i < methods.length; ++i) {
                next = methods[i];
                String name = ((Method)next).getName();
                switch (((Method)next).getParameterTypes().length) {
                    case 0: {
                        if (name.startsWith("get") && !name.equals("getClass")) {
                            name = name.substring(3);
                            table.put(name, next);
                        }
                        if (!name.startsWith("is")) continue block4;
                        name = name.substring(2);
                        table.put(name, next);
                        continue block4;
                    }
                    case 1: {
                        if (!name.startsWith("set")) continue block4;
                        name = name.substring(3);
                        table.put(name, next);
                    }
                }
            }
        }
        Field[] fields = this.type.getFields();
        for (i = 0; i < fields.length; ++i) {
            next = fields[i];
            Class<?> declaringClass = ((Field)next).getDeclaringClass();
            if (ServiceFactory.getDotNetService(false) != null && ServiceFactory.getDotNetService().isProxyParent(declaringClass)) continue;
            String name = ((Field)next).getName();
            table.put(name, next);
        }
        return table.keySet().iterator();
    }

    private boolean shouldConvertMethodsToFields() {
        if (this.instance == null) {
            return false;
        }
        DotNetService dotNetService = ServiceFactory.getDotNetService(false);
        return !(this.instance instanceof Class) && (dotNetService == null || !dotNetService.isDotNetObject(this.instance)) && (dotNetService == null || !dotNetService.isDotNetProxy(this.instance));
    }

    public static String replaceVars(Object instance, String s) {
        StructBean scope = new StructBean(instance);
        StringBuffer out = new StringBuffer(2 * s.length());
        int i = 0;
        int len = s.length();
        do {
            int j;
            if ((j = s.indexOf(123, i)) == -1) {
                j = len;
                out.append(s.substring(i, j));
                break;
            }
            if (j > i) {
                out.append(s.substring(i, j));
            }
            if ((i = s.indexOf(125, j)) == -1) {
                i = len;
                out.append(s.substring(j, i));
                break;
            }
            String name = s.substring(j + 1, i);
            Object value = "";
            if (scope.containsName(name)) {
                SecurityService secSvc;
                try {
                    Object val = scope.get(name);
                    if (val != null) {
                        value = val.toString();
                    }
                }
                catch (RuntimeException val) {
                    // empty catch block
                }
                if (((String)value).length() > 1024) {
                    value = ((String)value).substring(0, 1024) + "...";
                }
                try {
                    secSvc = ServiceFactory.getSecurityService();
                }
                catch (ServiceFactory.ServiceNotAvailableException ex) {
                    secSvc = null;
                }
                String safeValue = value;
                if (secSvc != null) {
                    safeValue = secSvc.crossSiteProtectString((String)value);
                }
                if (safeValue.length() == 0) {
                    safeValue = "''";
                }
                out.append(safeValue);
                continue;
            }
            out.append('{').append(name).append('}');
        } while (++i < len);
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String methodName, Object[] args) throws Throwable {
        Object result;
        if (this.instance != null && this.instance instanceof Class) {
            this.checkPermission(methodName);
        }
        Thread currThread = Thread.currentThread();
        ClassLoader origLoader = currThread.getContextClassLoader();
        try {
            if (ServiceFactory.getDotNetService(false) != null && ServiceFactory.getDotNetService().isDotNetClass(this.type)) {
                currThread.setContextClassLoader(this.instance.getClass().getClassLoader());
            }
            Object[] UnwrappedArgs = ClassUtility.UnWrap(this.type, args);
            ObjectHandler o = (ObjectHandler)ReflectionCache.get(this.type);
            Method m = o.findMethod(methodName, UnwrappedArgs);
            if (m != null) {
                if (this.instance == null && !Modifier.isStatic(m.getModifiers())) {
                    this.instance = this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (this.ProxyHandle != null) {
                        this.ProxyHandle.setInstance(this.instance);
                    }
                }
                try {
                    result = m.invoke(this.instance, UnwrappedArgs);
                }
                catch (InvocationTargetException ie) {
                    Throwable ex = ie.getTargetException();
                    ExceptionCache.push(this.instance, ex);
                    throw ex;
                }
                catch (Exception e) {
                    ExceptionCache.push(this.instance, e);
                    throw new MethodExecutionException(methodName, e);
                }
            }
            m = o.findMethodUsingCFMLRules(methodName, UnwrappedArgs);
            if (this.instance == null) {
                if (!Modifier.isStatic(m.getModifiers())) {
                    this.instance = this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if (this.ProxyHandle != null) {
                    this.ProxyHandle.setInstance(this.instance);
                }
            }
            try {
                Object[] cfargs = ClassUtility.ReInterpret(UnwrappedArgs, m.getParameterTypes());
                result = m.invoke(this.instance, cfargs);
            }
            catch (InvocationTargetException ie) {
                Throwable ex = ie.getTargetException();
                ExceptionCache.push(this.instance, ex);
                throw ex;
            }
            catch (Exception e) {
                ExceptionCache.push(this.instance, e);
                throw new MethodExecutionException(methodName, e);
            }
            result = ClassUtility.wrapCustom(result);
        }
        finally {
            if (ServiceFactory.getDotNetService(false) != null && ServiceFactory.getDotNetService().isDotNetClass(this.type)) {
                currThread.setContextClassLoader(origLoader);
            }
        }
        return result;
    }

    @Override
    public Object clone() {
        Struct copyStruct = new Struct();
        for (Map.Entry entry : this.entrySet()) {
            Object val = entry.getValue();
            if (CFPage.IsArray(val) && !val.getClass().isArray()) {
                copyStruct.put(entry.getKey(), ArrayUtil.copy((List)val));
                continue;
            }
            copyStruct.put(entry.getKey(), val);
        }
        return copyStruct;
    }

    public Object getInstance() {
        return this.instance;
    }

    @Override
    public void setupMemoryTracking() {
    }

    @Override
    public void setMemoryTrackerProxy(MemoryTrackerProxy mtp) {
        super.setMemoryTrackerProxy(null);
    }

    public static class SecurityException
    extends ExpressionException {
        public String MethodName;

        public SecurityException(String MethodName) {
            this.MethodName = MethodName;
        }
    }

    public static class FieldAccessException
    extends ExpressionException {
        public String FieldName;
        public String ErrorMessage;

        public FieldAccessException(String fieldName, Throwable x) {
            super(x);
            this.FieldName = fieldName;
            this.ErrorMessage = x.getLocalizedMessage();
        }
    }
}

