/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.compiler.ClassReader;
import coldfusion.compiler.NeoTranslator;
import coldfusion.filter.FusionContext;
import coldfusion.monitor.active.TemplateCacheMonitor;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.osgi.scanner.ModulesCodeScannerValidator;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.TemplateChecker;
import coldfusion.runtime.TemplateNotFoundException;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.VariableScope;
import coldfusion.security.BasicPolicy;
import coldfusion.server.RuntimeService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.LruCache;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.SoftCache;
import coldfusion.vfs.VFSFileFactory;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;

public class TemplateClassLoader
extends SecureClassLoader {
    private CodeSource cs;
    private Map classBytes;
    private String pagePath;
    private boolean pathsValid;
    private String applicationPath;
    private String applicationRootPath;
    private String applicationEndPath;
    private boolean applicationEndSearched;
    private static final String ADMIN_APPLICATION_CHECK = File.separator + "cfide" + File.separator;
    private static volatile NeoTranslator translator;
    private static RuntimeService runtimeService;
    private static File classDir;
    private static final TemplateCache classCache;
    static BasicPolicy policy;
    private static boolean saveClassFiles;

    public TemplateClassLoader(Map classBytes, CodeSource cs, String pagePath) {
        super(Thread.currentThread().getContextClassLoader());
        this.classBytes = classBytes;
        this.cs = cs;
        this.pagePath = pagePath;
    }

    String getPagePath() {
        return this.pagePath;
    }

    public static File findApplicationFile(TemplateClassLoader loader, String contextOrRootDir) {
        if (loader != null && loader.pathsValid && runtimeService.isTrustedCache()) {
            return loader.applicationPath != null ? new File(loader.applicationPath) : null;
        }
        File appRootDir = null;
        int applicationCFCSearchCondition = ServiceFactory.getRuntimeService().getApplicationCFCSearchCondition();
        switch (applicationCFCSearchCondition) {
            case 3: {
                int indexOfAdminApplication = appRootDir.getAbsolutePath().toLowerCase().indexOf(ADMIN_APPLICATION_CHECK);
                if (indexOfAdminApplication < 0) {
                    File applicationPath = TemplateClassLoader.getApplicationPathInDir(loader, appRootDir.getPath());
                    if (applicationPath != null) {
                        return applicationPath;
                    }
                    return TemplateClassLoader.getApplicationPathInDir(loader, TemplateClassLoader.getContextRootDir(contextOrRootDir));
                }
                applicationCFCSearchCondition = 2;
            }
            case 2: {
                File contextRootParent = new File(TemplateClassLoader.getContextRootDir(contextOrRootDir)).getParentFile();
                File applicationPath = null;
                while (appRootDir != null && !appRootDir.equals(contextRootParent)) {
                    applicationPath = TemplateClassLoader.getApplicationPathInDir(loader, appRootDir.getPath());
                    if (applicationPath == null) {
                        appRootDir = appRootDir.getParentFile();
                        continue;
                    }
                    return applicationPath;
                }
                if (loader != null) {
                    loader.pathsValid = true;
                }
                return null;
            }
            case 1: {
                File applicationPath = null;
                for (appRootDir = loader == null ? new File(FusionContext.getCurrent().getPagePath()).getParentFile() : new File(loader.getPagePath()).getParentFile(); appRootDir != null; appRootDir = appRootDir.getParentFile()) {
                    applicationPath = TemplateClassLoader.getApplicationPathInDir(loader, appRootDir.getPath());
                    if (applicationPath == null) {
                        continue;
                    }
                    return applicationPath;
                }
                if (loader != null) {
                    loader.pathsValid = true;
                }
                return null;
            }
        }
        return null;
    }

    private static String getContextRootDir(String contextRootDir) {
        if (contextRootDir == null) {
            contextRootDir = FusionContext.getCurrent().getWebRoot();
        }
        return contextRootDir;
    }

    public static File getApplicationPathInDir(TemplateClassLoader loader, String appRootDir) {
        File applicationCfcFile = new File(appRootDir + File.separator + "Application.cfc");
        if (applicationCfcFile.isFile()) {
            if (loader != null) {
                TemplateClassLoader._setAppPathInLoader(loader, applicationCfcFile);
            }
            return applicationCfcFile;
        }
        File applicationFile = new File(appRootDir + File.separator + "Application.cfm");
        if (applicationFile.isFile()) {
            if (loader != null) {
                TemplateClassLoader._setAppPathInLoader(loader, applicationFile);
            }
            return applicationFile;
        }
        return null;
    }

    public static void setAppPathInLoader(TemplateClassLoader loader, File applicationPath) {
        if (applicationPath.isFile() && loader != null) {
            TemplateClassLoader._setAppPathInLoader(loader, applicationPath);
        }
    }

    public static void _setAppPathInLoader(TemplateClassLoader loader, File applicationPath) {
        loader.applicationPath = applicationPath.getPath();
        loader.pathsValid = true;
        loader.applicationRootPath = applicationPath.getParent();
    }

    public static String findApplicationEnd(TemplateClassLoader loader) {
        if (loader.applicationEndSearched && runtimeService.isTrustedCache()) {
            return loader.applicationEndPath;
        }
        File onRequestEndFile = new File(loader.applicationRootPath, "OnRequestEnd.cfm");
        if (onRequestEndFile.isFile()) {
            loader.applicationEndPath = onRequestEndFile.getPath();
        }
        loader.applicationEndSearched = true;
        return loader.applicationEndPath;
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        byte[] b = this.classBytes != null ? this.classBytes.get(className) : null;
        if (b != null) {
            try {
                className = new ClassReader(b).getClassName();
            }
            catch (IOException ex) {
                throw new ClassNotFoundException(className);
            }
            return this.defineClass(className, b, 0, b.length, this.cs);
        }
        try {
            b = TemplateClassLoader.getClassBytes(className);
            className = new ClassReader(b).getClassName();
            return this.defineClass(className, b, 0, b.length, this.cs);
        }
        catch (IOException ex) {
            if (className.endsWith("Tag")) {
                String[] splits = className.split("\\.");
                String cls = splits[splits.length - 1];
                if ((cls = cls.substring(0, cls.indexOf("Tag"))).startsWith("exchange")) {
                    cls = "exchange";
                }
                throw new ServiceFactory.ModuleNotAvailableException(ModulesCodeScannerValidator.tags.get(cls.toLowerCase()));
            }
            throw new ClassNotFoundException(className);
        }
    }

    private static FileInputStream _getFileInputStream(final File classFile) throws IOException {
        if (System.getSecurityManager() == null) {
            return new FileInputStream(classFile);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws IOException {
                    return new FileInputStream(classFile);
                }
            });
        }
        catch (PrivilegedActionException exception) {
            throw new IOException(exception);
        }
    }

    private static long _getFileLength(final File classFile) throws IOException {
        if (System.getSecurityManager() == null) {
            return classFile.length();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() {
                    long len = classFile.length();
                    return len;
                }
            });
        }
        catch (PrivilegedActionException exception) {
            throw new IOException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getClassBytes(String className) throws IOException {
        File classFile = new File(classDir, className + ".class");
        byte[] b = null;
        try (FileInputStream fin = null;){
            int n;
            fin = TemplateClassLoader._getFileInputStream(classFile);
            int len = (int)TemplateClassLoader._getFileLength(classFile);
            b = new byte[len];
            for (int off = 0; off < len; off += n, len -= n) {
                n = fin.read(b, off, len);
                if (n >= 1) continue;
                System.out.println("early eof " + n + " " + classFile);
                throw new IOException("Error reading class file");
            }
        }
        return b;
    }

    public static long getLastModifiedTime(String canonicalPath) {
        if (translator == null) {
            return 0L;
        }
        return translator.getLastModifiedTime(canonicalPath);
    }

    public static long getLastCompiledTime(String canonicalPath) {
        if (translator == null || !new File(canonicalPath).exists()) {
            return 0L;
        }
        return translator.getLastCompiledTime(canonicalPath);
    }

    public static long getCompiledTime(String canonicalPath) {
        if (translator == null) {
            return 0L;
        }
        return translator.getLastCompiledTime(canonicalPath);
    }

    static void clearClassCache() {
        classCache.clear();
    }

    public static void removeClassCache(Object path) {
        classCache.remove(path);
    }

    public static double getClassCacheHitRatio() {
        return classCache.getHitRatio();
    }

    public static CfJspPage newInstance(ServletContext application, String realPath, VariableScope vs) throws Exception {
        return TemplateClassLoader.newInstance(application, realPath, vs, null);
    }

    public static CfJspPage newInstance(ServletContext application, String realPath, VariableScope vs, LocalScope ls) throws Exception {
        Class c = TemplateClassLoader.findClass(application, realPath);
        if (c == null) {
            String upperFilePath = realPath.toUpperCase();
            if (upperFilePath.endsWith(".CFC")) {
                throw new CfJspPage.NoSuchTemplateException(realPath);
            }
            throw new TemplateNotFoundException(realPath);
        }
        Object obj = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (!(obj instanceof CfJspPage)) {
            throw new TemplateProxyFactory.InvalidComponentException(realPath);
        }
        CfJspPage page = (CfJspPage)obj;
        if (vs != null) {
            page.bindPageVariables(vs, ls);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Class findClass(ServletContext application, String realPath) throws IOException {
        long lastModTime;
        long compiledTime;
        if (translator == null) {
            Class<TemplateClassLoader> clazz = TemplateClassLoader.class;
            // MONITORENTER : coldfusion.runtime.TemplateClassLoader.class
            if (translator == null) {
                translator = new NeoTranslator(application);
                translator.setSaveClasses(saveClassFiles);
                runtimeService = ServiceFactory.getRuntimeService();
                classCache.setSize(runtimeService.getTemplateCacheSize());
                classDir = new File(TemplateClassLoader.translator.outputDir);
            }
            // MONITOREXIT : clazz
        }
        if (runtimeService.isCommandLineCompile() && (compiledTime = TemplateClassLoader.getLastCompiledTime(realPath)) != (lastModTime = TemplateClassLoader.getLastModifiedTime(realPath))) {
            classCache.remove(realPath);
        }
        Class c = (Class)classCache.get(realPath);
        if (runtimeService.isTrustedCache()) return c;
        if (c == null) {
            classCache.remove(realPath);
            return (Class)classCache.get(realPath);
        }
        if (!translator.needsTranslating(realPath)) return c;
        classCache.remove(realPath);
        RequestMonitorEventProcessor.onTemplateChanged(realPath);
        return (Class)classCache.get(realPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Class findClassFromCache(String realPath) {
        if (runtimeService == null) {
            Class<TemplateClassLoader> clazz = TemplateClassLoader.class;
            // MONITORENTER : coldfusion.runtime.TemplateClassLoader.class
            if (runtimeService == null) {
                runtimeService = ServiceFactory.getRuntimeService();
            }
            // MONITOREXIT : clazz
        }
        if (!runtimeService.isTrustedCache()) return null;
        if (runtimeService.isCommandLineCompile()) return null;
        return (Class)classCache.getNoFetch(realPath);
    }

    public static void setCacheSize(int size) {
        classCache.setSize(size);
    }

    public static synchronized void setSaveClasses(boolean saveClasses) {
        saveClassFiles = saveClasses;
        if (translator != null) {
            translator.setSaveClasses(saveClassFiles);
        }
    }

    public static synchronized boolean getSaveClasses() {
        return saveClassFiles;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        BasicPolicy bp;
        SecurityService sec = null;
        try {
            sec = ServiceFactory.getSecurityService();
        }
        catch (ServiceFactory.ServiceNotAvailableException serviceNotAvailableException) {
            // empty catch block
        }
        if (sec != null && sec.isSandboxSecurityEnabled() && (bp = ServiceFactory.getSecurityService().getBasicPolicy()) != null) {
            return bp.getPermissions(codesource);
        }
        return super.getPermissions(codesource);
    }

    public static boolean needsTranslating(String templatePath) {
        if (translator != null) {
            return translator.needsTranslating(templatePath);
        }
        return true;
    }

    static {
        classCache = new TemplateCache();
        saveClassFiles = true;
    }

    private static class TemplateCache
    extends SoftCache {
        private static TemplateChecker tc = null;
        final LruCache secondary = new LruCache(){

            @Override
            protected Object fetch(Object file) {
                try {
                    Class<?> c;
                    String name;
                    Map classBytes;
                    File canonicalFile = (File)file;
                    if (tc != null && !tc.check(canonicalFile)) {
                        return null;
                    }
                    String className = NeoTranslator.getClassName(canonicalFile);
                    byte[] bytes = null;
                    if (saveClassFiles && translator.isNewPage(canonicalFile.getPath())) {
                        long sourceModTime = -1L;
                        try {
                            if (System.getSecurityManager() == null) {
                                bytes = TemplateClassLoader.getClassBytes(className);
                            } else {
                                try {
                                    final String tempClassName = className;
                                    bytes = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                        public Object run() throws Exception {
                                            return TemplateClassLoader.getClassBytes(tempClassName);
                                        }
                                    });
                                }
                                catch (PrivilegedActionException e) {
                                    throw new IOException(e.getLocalizedMessage());
                                }
                            }
                            sourceModTime = new ClassReader(bytes).getSourceModTime();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        if (sourceModTime != -1L) {
                            translator.setSourceLastModified(canonicalFile.getPath(), sourceModTime);
                        }
                        classBytes = translator.translateJava(canonicalFile.getPath(), false);
                    } else {
                        classBytes = translator.translateJava(canonicalFile.getPath(), true);
                    }
                    if (classBytes == null && bytes != null) {
                        classBytes = new HashMap<String, byte[]>();
                        classBytes.put(className, bytes);
                    }
                    if (policy == null && (policy = ServiceFactory.getSecurityService().getBasicPolicy()) != null) {
                        policy.setClassCache(classCache);
                    }
                    CodeSource cs = new CodeSource(canonicalFile.toURL(), (Certificate[])null);
                    if (classBytes != null && (name = (String)classBytes.get("MainClassName")) != null) {
                        className = name;
                    }
                    try {
                        c = new TemplateClassLoader(classBytes, cs, canonicalFile.getPath()).loadClass(className);
                    }
                    catch (ClassNotFoundException ex) {
                        String name2;
                        classBytes = translator.translateJava(canonicalFile.getPath(), true);
                        if (classBytes != null && (name2 = (String)classBytes.get("MainClassName")) != null) {
                            className = name2;
                        }
                        c = new TemplateClassLoader(classBytes, cs, canonicalFile.getPath()).loadClass(className);
                    }
                    if (classBytes != null) {
                        String filePath = canonicalFile.getPath();
                        TemplateCacheMonitor.record(c, (byte[])classBytes.get(className), filePath);
                    }
                    return c;
                }
                catch (FileNotFoundException e) {
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeWrapper(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeWrapper(e);
                }
            }

            public String toString() {
                return "Template L2 LRU Cache";
            }
        };

        public TemplateCache() {
            super(SoftCache.Stats.RUNTIME);
        }

        @Override
        public synchronized void clear() {
            super.clear();
            this.secondary.clear();
            TemplateCacheMonitor.clear();
        }

        @Override
        protected Object fetchSerial(Object path) {
            File canonicalFile = VFSFileFactory.getFileObject((String)path);
            return this.secondary.get(canonicalFile);
        }

        @Override
        public synchronized void setSize(int capacity) {
            super.setSize(capacity);
            this.secondary.setSize(capacity);
        }

        @Override
        public synchronized void remove(Object path) {
            super.remove(path);
            this.secondary.remove(VFSFileFactory.getFileObject((String)path));
        }

        public String toString() {
            return "Template Soft Cache";
        }

        static {
            try {
                Class<?> clz = Class.forName("coldfusion.runtime.OEMUtils");
                tc = (TemplateChecker)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                tc = null;
            }
        }
    }
}

