/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFObjectIterable;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.UDFMethodIterator;
import jakarta.servlet.jsp.PageContext;
import java.util.Iterator;

public class TemplateProxyIteratorUtil {
    public static Iterator getIteratorForTemplateProxy(TemplateProxy cfc) {
        return TemplateProxyIteratorUtil.getIteratorForTemplateProxy(cfc, true);
    }

    public static Iterator getIteratorForTemplateProxy(TemplateProxy cfc, boolean throwError) {
        Iterator it;
        UDFMethod iterableMethod = cfc.getMethod("__iter__");
        if (iterableMethod != null) {
            Object invoke;
            FusionContext fusionContext = FusionContext.getCurrent();
            try {
                invoke = cfc.invoke("__iter__", new Object[]{}, (PageContext)(fusionContext != null ? fusionContext.pageContext : null));
            }
            catch (Throwable e) {
                if (throwError) {
                    throw new CFCIterableInvocationException(e);
                }
                return null;
            }
            it = TemplateProxyIteratorUtil._getIteratorForTemplateProxy(invoke);
        } else {
            Iterable iterableProxy = cfc.getDynamicProxy(Iterable.class);
            if (iterableProxy != null) {
                return iterableProxy.iterator();
            }
            it = TemplateProxyIteratorUtil._getIteratorForTemplateProxy(cfc);
        }
        if (it == null && throwError) {
            throw new CFObjectIterable.NotAnIteratorException();
        }
        return it;
    }

    private static Iterator _getIteratorForTemplateProxy(Object obj) {
        if (obj instanceof TemplateProxy) {
            TemplateProxy cfc = (TemplateProxy)obj;
            UDFMethod iterableMethod = cfc.getMethod("__next__");
            if (iterableMethod == null) {
                Iterator dynamicProxy = cfc.getDynamicProxy(Iterator.class);
                if (dynamicProxy != null) {
                    return dynamicProxy;
                }
                return null;
            }
            return new UDFMethodIterator(iterableMethod);
        }
        return CFObjectIterable.getIterator(obj);
    }

    public static class CFCIterableInvocationException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String cause;

        public CFCIterableInvocationException(Throwable e) {
            super(e);
            this.cause = e.getMessage();
        }
    }
}

