/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.UDFMethod;
import java.util.Iterator;
import java.util.Map;

public class UDFMethodIterator
implements Iterator {
    private static final String VALUE = "value";
    private static final String DONE = "done";
    private Object previousResult;
    private Object consumedResult;
    private boolean consumePending;
    private int isDone = -1;
    private UDFMethod udfMethod;
    private int count = 1;

    public UDFMethodIterator(UDFMethod udfMethod) {
        this.udfMethod = udfMethod;
    }

    @Override
    public boolean hasNext() {
        if (this.isDone == -1) {
            this.invoke(true);
            return this.hasConsumedResult();
        }
        if (this.hasConsumedResult()) {
            return true;
        }
        if (this.isDone == 1) {
            return false;
        }
        this.invoke(true);
        return this.hasConsumedResult();
    }

    public Object next() {
        if (this.hasConsumedResult()) {
            this.consumePending = false;
            ++this.count;
            return this.consumedResult;
        }
        if (this.isDone == 1) {
            throw new IteratorExhaustedException();
        }
        this.invoke(false);
        ++this.count;
        return this.consumedResult;
    }

    private boolean hasConsumedResult() {
        return this.consumePending;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invoke(boolean hasNext) {
        Object value;
        block11: {
            Object udfResult;
            FusionContext fusionContext = FusionContext.getCurrent();
            CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
            try {
                Object[] objectArray;
                String string = this.udfMethod.getName();
                if (this.count == 1) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = null;
                    objectArray = objectArray2;
                    objectArray2[1] = this.count;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = this.consumedResult;
                    objectArray = objectArray3;
                    objectArray3[1] = this.count;
                }
                udfResult = CFPage._invokeUDF((Object)this.udfMethod, string, cfpage, objectArray);
            }
            catch (Throwable e) {
                throw new IteratorRuntimeException(e);
            }
            if (!(udfResult instanceof Map)) {
                throw new IteratorInvalidReturnValueException();
            }
            Object done = ((Map)udfResult).get(DONE);
            this.isDone = done != null ? (Cast._boolean(done) ? 1 : 0) : 0;
            value = ((Map)udfResult).get(VALUE);
            if (value == null) {
                if (((Map)udfResult).containsKey(VALUE)) {
                    this.swap(null);
                    break block11;
                } else {
                    if (!hasNext) {
                        throw new IteratorEmptyValueException();
                    }
                    if (this.isDone == 0) {
                        throw new IteratorEmptyValueException();
                    }
                    return;
                }
            }
            if (hasNext) {
                this.consumePending = true;
            }
        }
        this.swap(value);
    }

    private void swap(Object newCurrent) {
        this.previousResult = this.consumedResult;
        this.consumedResult = newCurrent;
    }

    public static class IteratorExhaustedException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class IteratorRuntimeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String cause;

        public IteratorRuntimeException(Throwable e) {
            super(e);
            this.cause = e.getMessage();
        }
    }

    public static class IteratorInvalidReturnValueException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class IteratorEmptyValueException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }
}

