/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.DotResolver;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.Struct;

public class UndefinedElementException
extends ExpressionException {
    public Class objectType;
    public String element;
    private boolean isContainerStruct = false;
    private String baseName;
    private String[] keys;
    private String concatKey = "";

    UndefinedElementException(Object o, String e) {
        this.isContainerStruct = o instanceof Struct;
        this.objectType = o.getClass();
        this.element = e;
        this.baseName = null;
    }

    UndefinedElementException(Object o, String[] keys) {
        this.isContainerStruct = o instanceof Struct;
        this.objectType = o.getClass();
        this.setKeys(keys);
        this.element = this.concatKey;
        this.baseName = null;
    }

    void setKeys(String[] keys) {
        this.keys = new String[keys.length];
        System.arraycopy(keys, 0, this.keys, 0, keys.length);
        this.keys = DotResolver.revertKeys(this.keys, 0);
        for (int i = 0; i < this.keys.length; ++i) {
            this.concatKey = this.concatKey + this.keys[i];
            if (i >= this.keys.length - 1) continue;
            this.concatKey = this.concatKey + ".";
        }
    }

    void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    @Override
    public String getMessage() {
        if (this.baseName != null) {
            return UndefinedElementException.getString(this, "messageFullyResolved", this.locale);
        }
        if (this.isContainerStruct) {
            return UndefinedElementException.getString(this, "messageCFStruct", this.locale);
        }
        if (this.keys == null) {
            return UndefinedElementException.getString(this, "messageUnresolved", this.locale);
        }
        return UndefinedElementException.getString(this, "message", this.locale);
    }

    public String getResolvedname() {
        StringBuffer result = new StringBuffer();
        if (this.baseName != null) {
            result.append(this.baseName);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length && !this.element.equalsIgnoreCase(this.concatKey); ++i) {
                if (result.length() > 0) {
                    result.append(".");
                }
                result.append(this.keys[i]);
            }
        }
        return result.toString();
    }
}

