/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.async;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.CallableUDFMethod;
import coldfusion.runtime.async.EmptyFuture;
import coldfusion.runtime.async.ExecutionService;
import coldfusion.runtime.async.ExecutionServiceUtils;
import coldfusion.runtime.async.Executor;
import coldfusion.runtime.async.Future;
import coldfusion.runtime.async.TimedCallableUDFMethod;

public class ExecutionServiceImpl
implements ExecutionService {
    @Override
    public Future execute(UDFMethod method, Object[] arguments, boolean hasCustomErrorHandler) throws Exception {
        Future futureObj = null;
        try {
            FusionContext originalFusContext = FusionContext.getCurrent();
            RequestMonitorData rmd = RequestMonitorData.getCurrent();
            FusionContext newFusContext = (FusionContext)originalFusContext.clone();
            NeoPageContext newPageContext = (NeoPageContext)originalFusContext.pageContext.clone();
            CallableUDFMethod callableUDFMethod = new CallableUDFMethod(method, arguments, newFusContext, newPageContext, rmd);
            java.util.concurrent.Future<Object> future = Executor.getInstance().submit(callableUDFMethod);
            futureObj = new Future(future);
            futureObj.setHasCustomErrorHandler(hasCustomErrorHandler);
            return futureObj;
        }
        catch (Exception e) {
            if (futureObj != null) {
                futureObj.cancel();
            }
            return ExecutionServiceUtils.buildErrorPromise(e.getMessage(), hasCustomErrorHandler, e);
        }
    }

    @Override
    public Future executeErrorHandler(UDFMethod method, Future prevExecutionFuture, boolean hasCustomErrorHandler) throws Exception {
        Future futureObj = null;
        try {
            RequestMonitorData rmd = RequestMonitorData.getCurrent();
            FusionContext originalFusContext = FusionContext.getCurrent();
            FusionContext newFusContext = (FusionContext)originalFusContext.clone();
            NeoPageContext newPageContext = (NeoPageContext)originalFusContext.pageContext.clone();
            CallableUDFMethod callableUDFMethod = new CallableUDFMethod(method, prevExecutionFuture, newFusContext, newPageContext, true, rmd);
            java.util.concurrent.Future<Object> future = Executor.getInstance().submit(callableUDFMethod);
            futureObj = new Future(future);
            futureObj.setHasCustomErrorHandler(hasCustomErrorHandler);
            return futureObj;
        }
        catch (Exception e) {
            if (futureObj != null) {
                futureObj.cancel();
            }
            return ExecutionServiceUtils.buildErrorPromise(e.getMessage(), hasCustomErrorHandler, e);
        }
    }

    @Override
    public Future executeErrorHandler(UDFMethod method, Future prevExecutionFuture, long timeOut, boolean hasCustomErrorHandler) throws Exception {
        Future futureObj = null;
        try {
            FusionContext originalFusContext = FusionContext.getCurrent();
            FusionContext newFusContext = (FusionContext)originalFusContext.clone();
            NeoPageContext newPageContext = (NeoPageContext)originalFusContext.pageContext.clone();
            RequestMonitorData rmd = RequestMonitorData.getCurrent();
            TimedCallableUDFMethod callableUDFMethod = new TimedCallableUDFMethod(method, prevExecutionFuture, new Object[0], newFusContext, newPageContext, timeOut, true, rmd);
            java.util.concurrent.Future future = Executor.getInstance().submit(callableUDFMethod);
            futureObj = new Future(future);
            futureObj.setHasCustomErrorHandler(hasCustomErrorHandler);
            return futureObj;
        }
        catch (Exception e) {
            if (futureObj != null) {
                futureObj.cancel();
            }
            return ExecutionServiceUtils.buildErrorPromise(e.getMessage(), hasCustomErrorHandler, e);
        }
    }

    @Override
    public Future execute(UDFMethod method, Future prevExecutionFuture, Object[] arguments, long timeOut, boolean hasCustomErrorHandler) throws Exception {
        Future futureObj = null;
        try {
            FusionContext originalFusContext = FusionContext.getCurrent();
            FusionContext newFusContext = (FusionContext)originalFusContext.clone();
            NeoPageContext newPageContext = (NeoPageContext)originalFusContext.pageContext.clone();
            RequestMonitorData rmd = RequestMonitorData.getCurrent();
            TimedCallableUDFMethod callableUDFMethod = new TimedCallableUDFMethod(method, prevExecutionFuture, arguments, newFusContext, newPageContext, timeOut, rmd);
            java.util.concurrent.Future future = Executor.getInstance().submit(callableUDFMethod);
            futureObj = new Future(future);
            futureObj.setHasCustomErrorHandler(hasCustomErrorHandler);
            return futureObj;
        }
        catch (Exception e) {
            if (futureObj != null) {
                futureObj.cancel();
            }
            CFLogs.APPLICATION_LOG.error(e);
            return ExecutionServiceUtils.buildErrorPromise(e.getMessage(), hasCustomErrorHandler, e);
        }
    }

    @Override
    public Future execute(UDFMethod method, Future prevExecutionFuture, boolean hasCustomErrorHandler) throws Exception {
        Future futureObj = null;
        try {
            RequestMonitorData rmd = RequestMonitorData.getCurrent();
            FusionContext originalFusContext = FusionContext.getCurrent();
            FusionContext newFusContext = (FusionContext)originalFusContext.clone();
            NeoPageContext newPageContext = (NeoPageContext)originalFusContext.pageContext.clone();
            CallableUDFMethod callableUDFMethod = new CallableUDFMethod(method, prevExecutionFuture, new Object[0], newFusContext, newPageContext, rmd);
            java.util.concurrent.Future<Object> future = Executor.getInstance().submit(callableUDFMethod);
            futureObj = new Future(future);
            futureObj.setHasCustomErrorHandler(hasCustomErrorHandler);
            return futureObj;
        }
        catch (Exception e) {
            if (futureObj != null) {
                futureObj.cancel();
            }
            return ExecutionServiceUtils.buildErrorPromise(e.getMessage(), hasCustomErrorHandler, e);
        }
    }

    @Override
    public EmptyFuture execute() {
        return new EmptyFuture();
    }

    @Override
    public Future execute(UDFMethod method, long timeOut, boolean hasCustomErrorHandler) throws Exception {
        Future futureObj = null;
        try {
            FusionContext originalFusContext = FusionContext.getCurrent();
            FusionContext newFusContext = (FusionContext)originalFusContext.clone();
            RequestMonitorData rmd = RequestMonitorData.getCurrent();
            NeoPageContext newPageContext = (NeoPageContext)originalFusContext.pageContext.clone();
            TimedCallableUDFMethod callableUDFMethod = new TimedCallableUDFMethod(method, null, new Object[0], newFusContext, newPageContext, timeOut, rmd);
            java.util.concurrent.Future future = Executor.getInstance().submit(callableUDFMethod);
            futureObj = new Future(future);
            futureObj.setHasCustomErrorHandler(hasCustomErrorHandler);
            return futureObj;
        }
        catch (Exception e) {
            if (futureObj != null) {
                futureObj.cancel();
            }
            CFLogs.APPLICATION_LOG.error(e);
            return ExecutionServiceUtils.buildErrorPromise(e.getMessage(), hasCustomErrorHandler, e);
        }
    }
}

