/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.async;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.CallableUDFMethod;
import coldfusion.runtime.async.ExecutionServiceUtils;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class Future {
    private java.util.concurrent.Future future;
    private boolean hasErrror;
    private String error;
    private boolean hasCustomErrorHandler;
    private Exception exception;
    private CallableUDFMethod udfMethodRef;
    private Function typeCast;

    public Future(java.util.concurrent.Future future) {
        this.future = future;
    }

    public Future() {
    }

    public Future(java.util.concurrent.Future future, Function typeCast) {
        this.future = future;
        this.typeCast = typeCast;
    }

    public Future then(UDFMethod method) throws Exception {
        if (this.hasErrror) {
            return this;
        }
        FusionContext context = FusionContext.getCurrent();
        CFPage cfPage = (CFPage)context.pageContext.getPage();
        try {
            return ExecutionServiceUtils.getExecutionService().execute(method, this, this.hasCustomErrorHandler);
        }
        catch (InterruptedException e) {
            return this.handleExecutionError(e);
        }
        catch (ExecutionException e) {
            return this.handleExecutionError(e);
        }
    }

    private Future handleExecutionError(Exception e) throws Exception {
        this.setHasErrror(true);
        this.exception = e;
        if (!this.hasCustomErrorHandler) {
            CFLogs.APPLICATION_LOG.error(e);
            throw e;
        }
        return this;
    }

    public Future then(UDFMethod method, long timeout) throws Exception {
        if (this.hasErrror) {
            return this;
        }
        FusionContext context = FusionContext.getCurrent();
        CFPage cfPage = (CFPage)context.pageContext.getPage();
        try {
            return ExecutionServiceUtils.getExecutionService().execute(method, this, new Object[0], timeout, this.hasCustomErrorHandler);
        }
        catch (InterruptedException e) {
            return this.handleExecutionError(e);
        }
        catch (ExecutionException e) {
            return this.handleExecutionError(e);
        }
    }

    private Future executeErrorHandler(UDFMethod method, Exception exc) throws Exception {
        Future futureObj = ExecutionServiceUtils.getExecutionService().execute(method, new Object[]{exc}, this.hasCustomErrorHandler);
        return futureObj;
    }

    private Future executeErrorHandler(UDFMethod method, long timeout, Exception exc) throws Exception {
        Future futureObj = ExecutionServiceUtils.getExecutionService().execute(method, null, new Object[]{exc}, timeout, this.hasCustomErrorHandler);
        return futureObj;
    }

    public Future error(UDFMethod method) throws Exception {
        if (this.hasErrror) {
            return this.executeErrorHandler(method, this.exception);
        }
        return ExecutionServiceUtils.getExecutionService().executeErrorHandler(method, this, this.hasCustomErrorHandler);
    }

    public Future error(UDFMethod method, long timeout) throws Exception {
        if (this.hasErrror) {
            return this.executeErrorHandler(method, timeout, this.exception);
        }
        return ExecutionServiceUtils.getExecutionService().executeErrorHandler(method, this, timeout, this.hasCustomErrorHandler);
    }

    private Exception getRootException(Exception ex) {
        Exception excObj = ex;
        while (excObj.getCause() != null) {
            excObj = (Exception)excObj.getCause();
        }
        return excObj;
    }

    private Object validateAndCast(Object obj) {
        try {
            return this.typeCast.apply(obj);
        }
        catch (ClassCastException ex) {
            this.setHasErrror(true);
            CFLogs.APPLICATION_LOG.error(ex);
            throw ex;
        }
    }

    public Object get() throws InterruptedException, ExecutionException, Exception {
        try {
            Object obj = this.future.get();
            return Objects.nonNull(this.typeCast) ? this.validateAndCast(obj) : obj;
        }
        catch (InterruptedException ex) {
            this.setHasErrror(true);
            if (this.checkIfInterrupted(ex)) {
                return "Interrupted";
            }
            CFLogs.APPLICATION_LOG.error(ex);
            throw ex;
        }
        catch (ExecutionException ex) {
            this.setHasErrror(true);
            if (this.checkIfInterrupted(ex)) {
                return "Interrupted";
            }
            CFLogs.APPLICATION_LOG.error(ex);
            throw new ExecutionException(this.getRootException(ex));
        }
        catch (CancellationException cEx) {
            this.setHasErrror(true);
            if (this.checkIfInterrupted(cEx)) {
                return "Interrupted";
            }
            CFLogs.APPLICATION_LOG.error(cEx);
            throw new TaskCancelledException();
        }
    }

    public Object get(long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            Object obj = this.future.get(timeout, TimeUnit.MILLISECONDS);
            return Objects.nonNull(this.typeCast) ? this.validateAndCast(obj) : obj;
        }
        catch (InterruptedException ex) {
            this.setHasErrror(true);
            if (this.checkIfInterrupted(ex)) {
                return "Interrupted";
            }
            CFLogs.APPLICATION_LOG.error(ex);
            throw ex;
        }
        catch (ExecutionException ex) {
            this.setHasErrror(true);
            if (this.checkIfInterrupted(ex)) {
                return "Interrupted";
            }
            CFLogs.APPLICATION_LOG.error(ex);
            throw new ExecutionException(this.getRootException(ex));
        }
        catch (CancellationException cEx) {
            this.setHasErrror(true);
            if (this.checkIfInterrupted(cEx)) {
                return "Interrupted";
            }
            CFLogs.APPLICATION_LOG.error(cEx);
            throw new TaskCancelledException();
        }
    }

    private boolean checkIfInterrupted(Exception ex) {
        if (ex.getCause() instanceof InterruptedException || ex.getCause() instanceof CancellationException) {
            CFLogs.APPLICATION_LOG.error("Task cancelled");
            if (this.isDone()) {
                return true;
            }
            if (this.isCancelled()) {
                return true;
            }
            this.cancel();
            return true;
        }
        return false;
    }

    public boolean cancel() {
        return this.future.cancel(true);
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    boolean hasErrror() {
        return this.hasErrror;
    }

    void setHasErrror(boolean hasErrror) {
        this.hasErrror = hasErrror;
    }

    String getError() {
        return this.error;
    }

    void setError(String error) {
        this.error = error;
    }

    boolean hasCustomErrorHandler() {
        return this.hasCustomErrorHandler;
    }

    void setHasCustomErrorHandler(boolean hasCustomErrorHandler) {
        this.hasCustomErrorHandler = hasCustomErrorHandler;
    }

    Exception getException() {
        return this.exception;
    }

    void setException(Exception exception) {
        this.exception = exception;
    }

    public CallableUDFMethod getUdfMethodRef() {
        return this.udfMethodRef;
    }

    public void setUdfMethodRef(CallableUDFMethod udfMethodRef) {
        this.udfMethodRef = udfMethodRef;
    }

    public static class TaskCancelledException
    extends ApplicationException {
        TaskCancelledException() {
        }
    }
}

