/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.async;

import coldfusion.runtime.Cast;
import coldfusion.runtime.ValueNotNumericException;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;

public class NumericListMetricCallable
implements Callable<Number> {
    List list = null;
    String metric = null;
    boolean ignoreEmpty = false;
    final int start;
    final int end;
    final String SUM = "SUM";
    final String MIN = "MIN";
    final String MAX = "MAX";

    public NumericListMetricCallable(List inputList, int start, int end, String metric, boolean ignoreEmpty) {
        this.list = inputList;
        this.metric = metric;
        this.start = start;
        this.end = end;
        this.ignoreEmpty = ignoreEmpty;
    }

    @Override
    public Number call() throws Exception {
        double sum = 0.0;
        switch (this.metric) {
            case "SUM": {
                BigDecimal result = new BigDecimal(sum);
                for (int i = this.start; i < this.end; ++i) {
                    Object obj = this.list.get(i);
                    try {
                        if (this.ignoreEmpty && (obj == null || obj == "")) continue;
                        result = result.add(new BigDecimal(Cast._double(obj)));
                        continue;
                    }
                    catch (Exception e) {
                        throw new ValueNotNumericException(i + 1);
                    }
                }
                return result.doubleValue();
            }
            case "MAX": {
                double max = 0.0;
                for (int i = this.start; i < this.end; ++i) {
                    Object obj = this.list.get(i);
                    try {
                        if (i == this.start) {
                            max = Cast._double(obj);
                            continue;
                        }
                        double comp = Cast._double(obj);
                        if (!(comp > max)) continue;
                        max = comp;
                        continue;
                    }
                    catch (Exception e) {
                        throw new ValueNotNumericException(i + 1);
                    }
                }
                return max;
            }
            case "MIN": {
                double min = 0.0;
                for (int i = this.start; i < this.end; ++i) {
                    Object obj = this.list.get(i);
                    try {
                        if (i == this.start) {
                            min = Cast._double(this.list.get(i));
                            continue;
                        }
                        double comp = Cast._double(this.list.get(i));
                        if (!(comp < min)) continue;
                        min = comp;
                        continue;
                    }
                    catch (Exception e) {
                        throw new ValueNotNumericException(i + 1);
                    }
                }
                return min;
            }
        }
        return 0;
    }
}

