/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.dotnet;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.dotnet.AssemblyManifestReader;
import coldfusion.runtime.dotnet.DotNetDynamicClassLoader;
import coldfusion.runtime.dotnet.ProxyGenerationException;
import coldfusion.runtime.dotnet.ProxyGenerator;
import coldfusion.runtime.java.DynamicClassLoader;
import coldfusion.server.DotNetService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.util.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;

public class Assembly {
    private static final int PROXY_JAR = 0;
    private static final int DOT_NET_ASSEMBLY = 1;
    private static final String coreClassListFile = "dotnet_coreproxy.config";
    private List assemblyList = new ArrayList(2);
    private List assemblyJarList = new ArrayList(2);
    private List generatedJarList = new ArrayList(2);
    private boolean hasAssembly = false;
    private Map fileTimeStampMap = new HashMap();
    private volatile DynamicClassLoader dynamicClassLoader;
    private final Object lock = new Object();
    private final Object proxyGenLock = new Object();
    private String jarPrefix = null;
    private static File systemJar;
    private static DotNetService dotNetService;
    private static Logger logger;
    private static volatile boolean initialized;

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        ProxyGenerator proxyGenerator = (ProxyGenerator)dotNetService.getProxyGenerator();
        if (!Assembly.isValidCoreProxy()) {
            Assembly.generateDotNetCoreProxy(proxyGenerator);
        }
        if (Assembly.isValidCoreProxy()) {
            try {
                proxyGenerator.setCoreSystemClasses(ZipUtils.getClassNamesFromZip(systemJar));
            }
            catch (IOException e) {
                logger.error("Error in getting the classes from dotNetCoreProxy.jar");
            }
            try {
                proxyGenerator.setAssemblyManifestReader(new AssemblyManifestReader(systemJar));
            }
            catch (Throwable e) {
                logger.error("Error in initializing the Manifest Reader.", e);
            }
            initialized = true;
        }
    }

    private static boolean isValidCoreProxy() {
        if (systemJar.exists()) {
            try {
                JarFile jarFile = new JarFile(systemJar);
                jarFile.close();
                return true;
            }
            catch (IOException e) {
                systemJar.delete();
            }
        }
        return false;
    }

    private static void generateDotNetCoreProxy(ProxyGenerator proxyGenerator) {
        File classListFile = new File(ServiceFactory.getRuntimeService().getLibDir(), coreClassListFile);
        try {
            proxyGenerator.generateProxy(classListFile, null, null, systemJar, true);
        }
        catch (ProxyGenerationException e) {
            logger.error("Error while generating the proxy jar for .NET core jar", e);
        }
    }

    public Assembly(TreeSet fileset) {
        Object fullAssemblyStr = "";
        String comma = "";
        for (File assemblyFile : fileset) {
            int assemblyType = this.getAssemblyType(assemblyFile);
            if (assemblyType == 1) {
                this.hasAssembly = true;
                this.assemblyList.add(assemblyFile);
            } else if (assemblyType == 0) {
                this.assemblyJarList.add(assemblyFile);
            }
            this.fileTimeStampMap.put(assemblyFile, new Long(assemblyFile.lastModified()));
            fullAssemblyStr = (String)fullAssemblyStr + comma + assemblyFile.getAbsolutePath();
            comma = ",";
        }
        this.jarPrefix = ((String)fullAssemblyStr).hashCode() + "_";
    }

    public boolean hasAssembly() {
        return this.hasAssembly;
    }

    public boolean hasJars() {
        return this.assemblyJarList != null && this.assemblyJarList.size() > 0;
    }

    public List getAssemblyList() {
        return this.assemblyList;
    }

    private int getAssemblyType(File file) {
        String name = file.getName();
        int indexOfDot = name.lastIndexOf(46);
        if (indexOfDot != -1) {
            String extn = name.substring(indexOfDot + 1).toUpperCase();
            if (extn.equals("DLL") || extn.equals("EXE")) {
                return 1;
            }
            if (extn.equals("JAR")) {
                return 0;
            }
        }
        throw new InvalidAssemblyTypeException(file.getAbsolutePath());
    }

    public boolean isModifiedAtRuntime() {
        if (!dotNetService.isDynamicReloadingEnabled()) {
            return false;
        }
        for (File file : this.fileTimeStampMap.keySet()) {
            if (file.lastModified() <= (Long)this.fileTimeStampMap.get(file)) continue;
            return true;
        }
        return false;
    }

    private void resetAssemnblyTimestamp() {
        for (File assemblyFile : this.fileTimeStampMap.keySet()) {
            this.fileTimeStampMap.put(assemblyFile, new Long(assemblyFile.lastModified()));
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException, ProxyGenerationException {
        return this.loadClass(className, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String className, boolean generateProxy) throws ClassNotFoundException, ProxyGenerationException {
        if (!initialized) {
            Assembly.initialize();
        }
        if (!initialized) {
            throw new ClassNotFoundException(className);
        }
        DynamicClassLoader loader = this.getDynamicClasLoader();
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            if (generateProxy && Assembly.isProxyGenSupported()) {
                Object object = this.proxyGenLock;
                synchronized (object) {
                    try {
                        return loader.loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        File proxyJar = this.generateProxy(className, loader);
                        loader.addToClasspath(proxyJar);
                        return loader.loadClass(className);
                    }
                }
            }
            if (this.hasAssembly && generateProxy && SystemInfo.isWindows() && !dotNetService.isJNBridgeInstalled()) {
                throw new DotNetExtensionNotInstalledException();
            }
            throw new DotNetClassNotFoundException(className, cnfe);
        }
    }

    private File generateProxy(String className, DynamicClassLoader loader) throws ProxyGenerationException {
        ProxyGenerator proxyGenerator = (ProxyGenerator)dotNetService.getProxyGenerator();
        File proxyJar = this.getProxyJarFile();
        if (systemJar.exists()) {
            Set dependentClasses = proxyGenerator.getDependentClasses(className, this.assemblyList, false);
            if (dependentClasses.isEmpty()) {
                logger.error("Aborting proxy generation as no classes were found in dependent class list. This might mean that the class " + className + " was not present in the assembly");
                throw new DotNetClassNotFoundException(className);
            }
            Iterator iter = dependentClasses.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (name.equals(className)) continue;
                try {
                    loader.loadClass(name);
                    iter.remove();
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            proxyGenerator.generateProxy(dependentClasses, this.assemblyList, loader.getClassPath(), proxyJar, false);
        } else {
            proxyGenerator.generateProxy(className, this.assemblyList, loader.getClassPath(), proxyJar, true);
        }
        this.generatedJarList.add(proxyJar);
        return proxyJar;
    }

    private File getProxyJarFile() {
        String outputDir = dotNetService.getOutputDir();
        return new File(outputDir, this.jarPrefix + System.currentTimeMillis() + ".jar");
    }

    private static boolean isProxyGenSupported() {
        return SystemInfo.isWindows() && dotNetService.isJNBridgeInstalled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicClassLoader getDynamicClasLoader() {
        if (this.dynamicClassLoader != null && !this.isModifiedAtRuntime()) {
            return this.dynamicClassLoader;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dynamicClassLoader == null) {
                DynamicClassLoader loader = this.createClassLoader();
                List list = this.getOldJarList();
                if (list != null) {
                    this.generatedJarList.addAll(list);
                    this.addToClasspath(loader, list);
                }
                this.dynamicClassLoader = loader;
            } else if (this.isModifiedAtRuntime()) {
                this.dynamicClassLoader.release();
                this.dynamicClassLoader = this.createClassLoader();
                if (this.hasAssembly) {
                    this.deleteFiles(this.generatedJarList);
                }
                this.resetAssemnblyTimestamp();
            }
        }
        return this.dynamicClassLoader;
    }

    private DynamicClassLoader createClassLoader() {
        DotNetDynamicClassLoader dynamicClassLoader = new DotNetDynamicClassLoader(this.getClass().getClassLoader());
        if (systemJar.exists()) {
            dynamicClassLoader.addToClasspath(systemJar);
        }
        this.addToClasspath(dynamicClassLoader, this.assemblyJarList);
        return dynamicClassLoader;
    }

    private List getOldJarList() {
        ArrayList<File> jarList = new ArrayList<File>();
        File outputDir = new File(dotNetService.getOutputDir());
        File[] files = outputDir.listFiles();
        long jarMinTimestamp = 0L;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.getName().startsWith(this.jarPrefix)) continue;
            jarList.add(file);
            if (jarMinTimestamp == 0L) {
                jarMinTimestamp = file.lastModified();
                continue;
            }
            if (file.lastModified() >= jarMinTimestamp) continue;
            jarMinTimestamp = file.lastModified();
        }
        if (!Assembly.isProxyGenSupported() || !dotNetService.isDynamicReloadingEnabled()) {
            return jarList;
        }
        long assemblyMaxTime = 0L;
        for (int i = 0; i < this.assemblyList.size(); ++i) {
            File assembly = (File)this.assemblyList.get(i);
            long time = assembly.lastModified();
            if (time <= assemblyMaxTime) continue;
            assemblyMaxTime = time;
        }
        if (assemblyMaxTime < jarMinTimestamp) {
            return jarList;
        }
        this.deleteFiles(jarList);
        return null;
    }

    private void addToClasspath(DynamicClassLoader loader, Collection fileCol) {
        if (fileCol == null) {
            return;
        }
        File[] files = fileCol.toArray(new File[fileCol.size()]);
        for (int i = 0; i < files.length; ++i) {
            loader.addToClasspath(files[i]);
        }
    }

    private void deleteFiles(final List jars) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (jars == null) {
                    return null;
                }
                for (int i = jars.size() - 1; i >= 0; --i) {
                    File file = (File)jars.remove(i);
                    if (file.delete()) continue;
                    file.deleteOnExit();
                }
                return null;
            }
        });
    }

    static {
        dotNetService = ServiceFactory.getDotNetService();
        logger = CFLogs.DOTNET_LOG;
        initialized = false;
        systemJar = new File(dotNetService.getOutputDir(), "dotNetCoreProxy.jar");
        if (Assembly.isProxyGenSupported()) {
            Assembly.initialize();
        } else {
            initialized = true;
        }
    }

    public static class InvalidAssemblyTypeException
    extends ApplicationException {
        private String file;

        public InvalidAssemblyTypeException(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }

    public static class DotNetExtensionNotInstalledException
    extends ApplicationException {
    }

    public static class DotNetClassNotFoundException
    extends ApplicationException {
        private String className;

        public DotNetClassNotFoundException(String className) {
            this.className = className;
        }

        public DotNetClassNotFoundException(String className, Throwable e) {
            super(e);
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

