/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.dotnet;

import coldfusion.log.CFLogs;
import coldfusion.runtime.Cast;
import coldfusion.runtime.dotnet.DotNetHashtable;
import coldfusion.runtime.dotnet.DotNetList;
import coldfusion.runtime.dotnet.DotNetQueryTable;
import coldfusion.sql.QueryTable;
import com.jnbridge.jnbcore.ByValueMappedCollectionMarker;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

public class CFDotNetTranslator {
    public static Object cfToDotnet(Object cfobj) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (cfobj.getClass().isArray()) {
            Class<?> arrayType = cfobj.getClass().getComponentType();
            String dotNetArrayType = CFDotNetTranslator.getMappedDotNetClass(arrayType);
            if (dotNetArrayType == null) {
                return cfobj;
            }
            int arrLen = Array.getLength(cfobj);
            Object dotnetObj = null;
            try {
                Class<?> dotNetClass = loader.loadClass(dotNetArrayType);
                dotnetObj = Array.newInstance(dotNetClass, arrLen);
                for (int i = 0; i < arrLen; ++i) {
                    Object cfarrObj = Array.get(cfobj, i);
                    Array.set(dotnetObj, i, CFDotNetTranslator.createDotNetObject(cfarrObj, dotNetClass));
                }
            }
            catch (Throwable th) {
                CFLogs.DOTNET_LOG.error(th);
            }
            return dotnetObj;
        }
        String dotNetClassName = CFDotNetTranslator.getMappedDotNetClass(cfobj.getClass());
        if (dotNetClassName == null) {
            return cfobj;
        }
        try {
            Class<?> dotNetClass = loader.loadClass(dotNetClassName);
            return CFDotNetTranslator.createDotNetObject(cfobj, dotNetClass);
        }
        catch (Throwable th) {
            CFLogs.DOTNET_LOG.error(th);
            return cfobj;
        }
    }

    private static Object createDotNetObject(Object cfobj, Class dotNetClass) {
        try {
            if (ByValueMappedCollectionMarker.class.isAssignableFrom(dotNetClass)) {
                Object dotnetObject = dotNetClass.newInstance();
                Field field = dotNetClass.getField("NativeImpl");
                if (field == null) {
                    return cfobj;
                }
                Object objTobeSet = CFDotNetTranslator.createJavaObject(dotNetClass.getName(), cfobj);
                field.set(dotnetObject, objTobeSet);
                return dotnetObject;
            }
        }
        catch (Throwable e) {
            CFLogs.DOTNET_LOG.error(e);
        }
        return cfobj;
    }

    private static Object createJavaObject(String dotnetClassName, Object arg) {
        if (dotnetClassName.equals("System.Decimal")) {
            return Cast._BigDecimal(arg);
        }
        return arg;
    }

    private static String getMappedDotNetClass(Class clazz) {
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return "System.Decimal";
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return "System.DateTime";
        }
        return null;
    }

    public static Object autoConvertDotnetToCF(Object dotNetObj) {
        boolean disableConversion = Boolean.getBoolean("coldfusion.dotnet.disableautoconversion");
        if (disableConversion) {
            if (dotNetObj instanceof ByValueMappedCollectionMarker) {
                return CFDotNetTranslator.convertValueTypeObject(dotNetObj);
            }
            return dotNetObj;
        }
        return CFDotNetTranslator.dotnetToCF(dotNetObj);
    }

    public static Object dotnetToCF(Object dotNetObj) {
        if (dotNetObj instanceof ByValueMappedCollectionMarker) {
            return CFDotNetTranslator.convertValueTypeObject(dotNetObj);
        }
        if (CFDotNetTranslator.isInstanceOfDotNetClass(dotNetObj, "System.Data.DataTable")) {
            return CFDotNetTranslator.convertDataTable(dotNetObj);
        }
        if (CFDotNetTranslator.isInstanceOfDotNetClass(dotNetObj, "System.Collections.Hashtable")) {
            return CFDotNetTranslator.convertDotNetHashtable(dotNetObj);
        }
        if (CFDotNetTranslator.isInstanceOfDotNetClass(dotNetObj, "System.Collections.ArrayList") || CFDotNetTranslator.isInstanceOfDotNetClass(dotNetObj, "System.Collections.SortedList")) {
            return CFDotNetTranslator.convertDotNetArrayList(dotNetObj);
        }
        if (CFDotNetTranslator.isInstanceOfDotNetClass(dotNetObj, "System.BoxedValue")) {
            return CFDotNetTranslator.unboxValue(dotNetObj);
        }
        if (dotNetObj.getClass().getName().equals("System.DotNetString")) {
            return dotNetObj.toString();
        }
        if (dotNetObj.getClass().getName().equals("System.DotNetArray")) {
            return CFDotNetTranslator.unboxDotNetArray(dotNetObj);
        }
        return dotNetObj;
    }

    private static Object convertValueTypeObject(Object dotNetObj) {
        try {
            Class<?> dotNetClass = dotNetObj.getClass();
            Field field = dotNetClass.getField("NativeImpl");
            Object obj = field.get(dotNetObj);
            if (obj == null) {
                return dotNetObj;
            }
            if (obj instanceof Hashtable) {
                return CFDotNetTranslator.dotnetToCF((Hashtable)obj);
            }
            if (obj instanceof ArrayList) {
                return CFDotNetTranslator.dotnetToCF((ArrayList)obj);
            }
            return obj;
        }
        catch (Throwable e) {
            return dotNetObj;
        }
    }

    private static boolean isInstanceOfDotNetClass(Object dotNetObject, String dotNetClassName) {
        Class<?> dotNetClass = dotNetObject.getClass();
        try {
            ClassLoader loader = dotNetClass.getClassLoader();
            Class<?> dataTableClass = loader.loadClass(dotNetClassName);
            return dataTableClass.isAssignableFrom(dotNetClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Object dotnetToCF(Hashtable map) {
        Hashtable<Object, Object> returnMap = new Hashtable<Object, Object>();
        for (Map.Entry entry : map.entrySet()) {
            Object key = CFDotNetTranslator.dotnetToCF(entry.getKey());
            Object value = CFDotNetTranslator.dotnetToCF(entry.getValue());
            returnMap.put(key, value);
        }
        return returnMap;
    }

    private static Object dotnetToCF(ArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            Object cfObj = CFDotNetTranslator.dotnetToCF(obj);
            list.set(i, cfObj);
        }
        return list;
    }

    private static QueryTable convertDataTable(Object dataTableObj) {
        return new DotNetQueryTable(dataTableObj);
    }

    private static Hashtable convertDotNetHashtable(Object dotNetHashtable) {
        return new DotNetHashtable(dotNetHashtable);
    }

    private static ArrayList convertDotNetArrayList(Object dotNetArrayList) {
        return new DotNetList(dotNetArrayList);
    }

    private static Object unboxValue(Object dotNetBoxedValue) {
        try {
            Class<?> boxedClass = dotNetBoxedValue.getClass();
            Method unboxToJava = boxedClass.getMethod("unboxToJava", new Class[0]);
            return unboxToJava.invoke(dotNetBoxedValue, new Object[0]);
        }
        catch (Throwable e) {
            CFLogs.DOTNET_LOG.error(e);
            return dotNetBoxedValue;
        }
    }

    private static Object unboxDotNetArray(Object dotnetArray) {
        try {
            Class<?> dotnetArrayClass = dotnetArray.getClass();
            Method arrayValueMethod = dotnetArrayClass.getMethod("arrayValue", new Class[0]);
            return arrayValueMethod.invoke(dotnetArray, new Object[0]);
        }
        catch (Throwable e) {
            CFLogs.DOTNET_LOG.error(e);
            return dotnetArray;
        }
    }

    public static Object convertToSystemObject(Class t, Object val) {
        if (val instanceof String) {
            return CFDotNetTranslator.createSystemObject(t.getClassLoader(), "System.DotNetString", String.class, val);
        }
        if (val instanceof Short) {
            return CFDotNetTranslator.createSystemObject(t.getClassLoader(), "System.BoxedShort", Short.TYPE, val);
        }
        if (val instanceof Byte) {
            return CFDotNetTranslator.createSystemObject(t.getClassLoader(), "System.BoxedSByte", Byte.TYPE, val);
        }
        if (val instanceof Integer) {
            return CFDotNetTranslator.createSystemObject(t.getClassLoader(), "System.BoxedInt", Integer.TYPE, val);
        }
        if (val instanceof Long) {
            return CFDotNetTranslator.createSystemObject(t.getClassLoader(), "System.BoxedLong", Long.TYPE, val);
        }
        if (val instanceof Float) {
            return CFDotNetTranslator.createSystemObject(t.getClassLoader(), "System.BoxedFloat", Float.TYPE, val);
        }
        if (val instanceof Double) {
            return CFDotNetTranslator.createSystemObject(t.getClassLoader(), "System.BoxedDouble", Double.TYPE, val);
        }
        if (val instanceof Character) {
            return CFDotNetTranslator.createSystemObject(t.getClassLoader(), "System.BoxedChar", Character.TYPE, val);
        }
        if (val instanceof Boolean) {
            return CFDotNetTranslator.createSystemObject(t.getClassLoader(), "System.BoxedBoolean", Boolean.TYPE, val);
        }
        if (val.getClass().isArray()) {
            return CFDotNetTranslator.createSystemObject(t.getClassLoader(), "System.DotNetArray", Object.class, val);
        }
        return null;
    }

    private static Object createSystemObject(ClassLoader loader, String dotNetClass, Class constructorArgType, Object value) {
        try {
            Class<?> dotnetStringClass = loader.loadClass(dotNetClass);
            Constructor<?> constructor = dotnetStringClass.getConstructor(constructorArgType);
            return constructor.newInstance(value);
        }
        catch (Throwable e) {
            CFLogs.DOTNET_LOG.error("Error while creating object for " + dotNetClass, e);
            return null;
        }
    }
}

