/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.dotnet;

import coldfusion.log.CFLogs;
import coldfusion.runtime.dotnet.CFDotNetTranslator;
import coldfusion.util.SoftCache;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class DotNetList
extends ArrayList {
    private static SoftCache methodCache = new SoftCache(){

        @Override
        protected Object fetch(Object key) {
            return new ListReflectionData((Class)key);
        }
    };

    public DotNetList(Object dotNetArrayList) {
        try {
            Class<?> dotNetArrayListClass = dotNetArrayList.getClass();
            ListReflectionData reflectionData = (ListReflectionData)methodCache.get(dotNetArrayListClass);
            int count = (Integer)reflectionData.getCountMethod.invoke(dotNetArrayList, new Object[0]);
            for (int i = 0; i < count; ++i) {
                Object element = reflectionData.getItemMethod.invoke(dotNetArrayList, new Integer(i));
                element = CFDotNetTranslator.dotnetToCF(element);
                this.add(element);
            }
        }
        catch (Throwable e) {
            CFLogs.DOTNET_LOG.error(e);
        }
    }

    private static class ListReflectionData {
        Method getCountMethod;
        Method getItemMethod;

        public ListReflectionData(Class dotNetListClass) {
            try {
                this.getCountMethod = dotNetListClass.getMethod("Get_Count", new Class[0]);
                this.getItemMethod = dotNetListClass.getMethod("Get_Item", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                CFLogs.DOTNET_LOG.error(e);
            }
        }
    }
}

