/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.dotnet;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Invokable;
import coldfusion.runtime.ProxyFactory;
import coldfusion.runtime.dotnet.Assembly;
import coldfusion.runtime.dotnet.DotNetProxy;
import coldfusion.runtime.dotnet.DotNetServerAgent;
import coldfusion.security.SecurityManager;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.util.IPAddressUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class DotNetProxyFactory
extends ProxyFactory {
    public static final String ASSEMBLY = "ASSEMBLY";
    public static final String PROTOCOL = "PROTOCOL";
    public static final String SECURE = "secure";
    private Map assemblyMap = new HashMap();
    public static final String default_protocol = "tcp";
    private static final String default_host = "localhost";
    private static final TreeSet emptySet = new TreeSet();
    private static Logger logger = CFLogs.DOTNET_LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invokable getProxy(String className, Map propMap) throws Throwable {
        ServiceFactory.getSecurityService().checkPermission(SecurityManager.CREATE_DOTNET_OBJECT);
        String assemblyPath = (String)propMap.get(ASSEMBLY);
        String host = (String)propMap.get("server");
        String string = host = host == null ? default_host : host.trim();
        if (host.length() == 0) {
            throw new InvalidServerException();
        }
        String port = (String)propMap.get("port");
        Boolean secureB = (Boolean)propMap.get(SECURE);
        boolean secure = secureB != null && secureB != false;
        String protocol = (String)propMap.get(PROTOCOL);
        protocol = protocol == null ? default_protocol : protocol.toLowerCase();
        TreeSet fileset = this.getAssemblySet(assemblyPath);
        Assembly assembly = (Assembly)this.assemblyMap.get(fileset);
        if (assembly == null) {
            DotNetProxyFactory dotNetProxyFactory = this;
            synchronized (dotNetProxyFactory) {
                assembly = (Assembly)this.assemblyMap.get(fileset);
                if (assembly == null) {
                    assembly = new Assembly(fileset);
                    this.assemblyMap.put(fileset, assembly);
                }
            }
        }
        Class aClass = DotNetProxyFactory.loadClass(assembly, className);
        DotNetServerAgent.setCurrent(host, port, protocol, secure);
        if (SystemInfo.isWindows() && assembly.hasAssembly() && IPAddressUtils.isLocalHost(host)) {
            this.registerWithDotNetSide(assembly);
        }
        try {
            return new DotNetProxy(aClass);
        }
        catch (NoClassDefFoundError e) {
            throw new Assembly.DotNetClassNotFoundException(e.getMessage(), e);
        }
    }

    private static Class loadClass(final Assembly assembly, final String className) throws Throwable {
        if (System.getSecurityManager() == null) {
            return assembly.loadClass(className);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                @Override
                public Class run() throws Exception {
                    return assembly.loadClass(className);
                }
            }, null, new RuntimePermission("createClassLoader"));
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    private void registerWithDotNetSide(Assembly assembly) {
        Class assemblyClass = null;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            assemblyClass = assembly.loadClass("System.Reflection.Assembly", false);
            Method meth = assemblyClass.getMethod("LoadFrom", String.class);
            thread.setContextClassLoader(assemblyClass.getClassLoader());
            List list = assembly.getAssemblyList();
            for (int i = 0; i < list.size(); ++i) {
                File file = (File)list.get(i);
                try {
                    meth.invoke(null, file.getAbsolutePath());
                    continue;
                }
                catch (Exception e) {
                    logger.error(e);
                }
            }
        }
        catch (Exception e) {
            throw new AssemblyRegistrationException(e);
        }
        catch (Error t) {
            if (assemblyClass != null) {
                logger.error("assemblyClass = " + assemblyClass.getName());
                ClassLoader classLoader = assemblyClass.getClassLoader();
                logger.error("assemblyClass Loader = " + classLoader);
                logger.error("This class Loader = " + this.getClass().getClassLoader());
                try {
                    classLoader.loadClass("com.jnbridge.jnbcore.DotNetObjectBase");
                    logger.error("DotNetObject base got loaded by assembly classloader");
                }
                catch (Throwable e) {
                    logger.error("DotNetObjectbase can not be loaded " + e.getMessage(), e);
                }
                logger.error(t);
            }
            throw t;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private TreeSet getAssemblySet(String assemblyPath) {
        if (assemblyPath == null || assemblyPath.length() == 0) {
            return emptySet;
        }
        TreeSet<File> set = new TreeSet<File>(new Comparator(){

            public int compare(Object o1, Object o2) {
                File file1 = (File)o1;
                File file2 = (File)o2;
                return file1.getAbsolutePath().compareTo(file2.getAbsolutePath());
            }
        });
        StringTokenizer tokenizer = new StringTokenizer(assemblyPath, ",;");
        while (tokenizer.hasMoreTokens()) {
            String assembly = tokenizer.nextToken();
            File file = new File(assembly);
            if (!file.isAbsolute()) {
                file = new File(ServiceFactory.getDotNetService().getOutputDir(), assembly);
            }
            if (!file.exists()) {
                throw new AssemblyNotFoundException(file.getAbsolutePath());
            }
            try {
                set.add(file.getCanonicalFile());
            }
            catch (IOException e) {
                set.add(file.getAbsoluteFile());
            }
        }
        return set;
    }

    public static class InvalidServerException
    extends ApplicationException {
    }

    public static class AssemblyRegistrationException
    extends ApplicationException {
        public AssemblyRegistrationException(Throwable e) {
            super(e);
        }
    }

    public static class AssemblyNotFoundException
    extends ApplicationException {
        private String file;

        public AssemblyNotFoundException(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }
}

