/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.dotnet;

import coldfusion.log.CFLogs;
import coldfusion.sql.QueryTable;
import coldfusion.util.SoftCache;
import com.jnbridge.jnbcore.ByValueMappedCollectionMarker;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class DotNetQueryTable
extends QueryTable {
    private int colCount;
    private String[] colTypes;
    private static final String GET_ROWS = "Get_Rows";
    private static final String GET_COUNT = "Get_Count";
    private static final String GET_ITEM = "Get_Item";
    private static final String GET_COLUMNS = "Get_Columns";
    private static final String GET_COLUMN_NAME = "Get_ColumnName";
    private static final String GET_COLUMN_DATATYPE = "Get_DataType";
    private static final Set primitiveTypes = new HashSet();
    private static SoftCache methodCache;

    public DotNetQueryTable(Object dataTableObj) {
        try {
            Class<?> dataTableClass = dataTableObj.getClass();
            QueryReflectionData reflectionData = (QueryReflectionData)methodCache.get(dataTableClass);
            this.setColumns(dataTableObj, reflectionData);
            Object rows = reflectionData.getRowsMethod.invoke(dataTableObj, new Object[0]);
            int rowCount = (Integer)reflectionData.getRowCountMethod.invoke(rows, new Object[0]);
            for (int i = 0; i < rowCount; ++i) {
                Object dataRow = reflectionData.getRowMethod.invoke(rows, new Integer(i));
                Object[] rowData = new Object[this.colCount];
                for (int j = 0; j < this.colCount; ++j) {
                    Object rowColVal = reflectionData.getRowItemMethod.invoke(dataRow, new Integer(j));
                    rowData[j] = this.convertToCFType(rowColVal, this.colTypes[j]);
                }
                this.addRow(rowData);
            }
        }
        catch (Throwable e) {
            CFLogs.DOTNET_LOG.error(e);
        }
    }

    private void setColumns(Object dataTableObj, QueryReflectionData reflectionData) throws IllegalAccessException, InvocationTargetException {
        Object cols = reflectionData.getColumnsMethod.invoke(dataTableObj, new Object[0]);
        this.colCount = (Integer)reflectionData.getColCountMethod.invoke(cols, new Object[0]);
        String[] colNames = new String[this.colCount];
        this.colTypes = new String[this.colCount];
        for (int i = 0; i < this.colCount; ++i) {
            Object dataColumn = reflectionData.getColItemMethod.invoke(cols, new Integer(i));
            colNames[i] = (String)reflectionData.getColNameMethod.invoke(dataColumn, new Object[0]);
            this.colTypes[i] = reflectionData.getColTypeMethod.invoke(dataColumn, new Object[0]).toString();
        }
        this.setColumnNames(colNames, false);
    }

    private Object convertToCFType(Object dotNetObj, String type) {
        block5: {
            if (dotNetObj instanceof ByValueMappedCollectionMarker) {
                Class<?> clazz = dotNetObj.getClass();
                try {
                    Field field = clazz.getField("NativeImpl");
                    Object obj = field.get(dotNetObj);
                    if (obj != null) {
                        return obj;
                    }
                    break block5;
                }
                catch (Throwable th) {
                    return dotNetObj.toString();
                }
            }
            if (primitiveTypes.contains(type)) {
                return dotNetObj.toString();
            }
        }
        return dotNetObj;
    }

    static {
        primitiveTypes.add("System.Boolean");
        primitiveTypes.add("System.Byte");
        primitiveTypes.add("System.Char");
        primitiveTypes.add("System.DateTime");
        primitiveTypes.add("System.Decimal");
        primitiveTypes.add("System.Double");
        primitiveTypes.add("System.Int16");
        primitiveTypes.add("System.Int32");
        primitiveTypes.add("System.Int64");
        primitiveTypes.add("System.SByte");
        primitiveTypes.add("System.String");
        primitiveTypes.add("System.TimeSpan");
        primitiveTypes.add("System.UInt16");
        primitiveTypes.add("System.UInt32");
        primitiveTypes.add("System.UInt64");
        methodCache = new SoftCache(){

            @Override
            protected Object fetch(Object key) {
                return new QueryReflectionData((Class)key);
            }
        };
    }

    private static class QueryReflectionData {
        Method getRowsMethod;
        Method getRowCountMethod;
        Method getRowMethod;
        Method getRowItemMethod;
        Method getColumnsMethod;
        Method getColCountMethod;
        Method getColItemMethod;
        private Method getColNameMethod;
        private Method getColTypeMethod;

        public QueryReflectionData(Class dataTableClass) {
            try {
                this.getRowsMethod = dataTableClass.getMethod(DotNetQueryTable.GET_ROWS, new Class[0]);
                Class<?> dataRowCollectionClass = dataTableClass.getClassLoader().loadClass("System.Data.DataRowCollection");
                this.getRowCountMethod = dataRowCollectionClass.getMethod(DotNetQueryTable.GET_COUNT, new Class[0]);
                this.getRowMethod = dataRowCollectionClass.getMethod(DotNetQueryTable.GET_ITEM, Integer.TYPE);
                Class<?> dataRowClass = dataTableClass.getClassLoader().loadClass("System.Data.DataRow");
                this.getRowItemMethod = dataRowClass.getMethod(DotNetQueryTable.GET_ITEM, Integer.TYPE);
                this.getColumnsMethod = dataTableClass.getMethod(DotNetQueryTable.GET_COLUMNS, new Class[0]);
                Class<?> dataColumnCollectionClass = dataTableClass.getClassLoader().loadClass("System.Data.DataColumnCollection");
                this.getColCountMethod = dataColumnCollectionClass.getMethod(DotNetQueryTable.GET_COUNT, new Class[0]);
                this.getColItemMethod = dataColumnCollectionClass.getMethod(DotNetQueryTable.GET_ITEM, Integer.TYPE);
                Class<?> dataColumnClass = dataTableClass.getClassLoader().loadClass("System.Data.DataColumn");
                this.getColNameMethod = dataColumnClass.getMethod(DotNetQueryTable.GET_COLUMN_NAME, new Class[0]);
                this.getColTypeMethod = dataColumnClass.getMethod(DotNetQueryTable.GET_COLUMN_DATATYPE, new Class[0]);
            }
            catch (Throwable e) {
                CFLogs.DOTNET_LOG.error(e);
            }
        }
    }
}

