/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.implementation.exceptions.java;

import coldfusion.runtime.ApplicationException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ImplementationException {
    public static void throwInvalidJavaInterfaceException(String s) throws Throwable {
        throw new InvalidJavaInterfaceException(s);
    }

    public static void throwInvalidInterfaceImplementationException(String s) throws Throwable {
        throw new InvalidInterfaceImplementationException(s);
    }

    public static void throwExtendsJavaNotSupportedException() throws Throwable {
        throw new ExtendsJavaNotSupportedException();
    }

    public static void throwNotAnInterfaceException(Class proxyclass) throws Throwable {
        throw new NotAnInterfaceException(proxyclass);
    }

    public static void throwMethodNotImplementedException(String methodName, String templateProxyName) throws Throwable {
        throw new MethodNotImplementedException(methodName, templateProxyName);
    }

    public static void throwDifferentNumberOfArgsException(String methodName, Class[] classes) throws Throwable {
        List arr = Arrays.stream(classes).map(x -> x.getTypeName()).collect(Collectors.toList());
        throw new DifferentNumberOfArgsException(methodName, String.join((CharSequence)",", arr));
    }

    public static void throwIncompatibleReturnTypeException(String methodname, String methodReturnType, String cfcReturnType) {
        throw new IncompatibleReturnTypeException(methodname, methodReturnType, cfcReturnType);
    }

    public static void throwArgumentTypeMismatchException(String methodName, Class paramType, Class udfType) {
        throw new ArgumentTypeMismatchException(methodName, paramType.getName(), udfType.getName());
    }

    public static class InvalidJavaInterfaceException
    extends ApplicationException {
        public String invalidInterface;

        public InvalidJavaInterfaceException(String invalidInterface) {
            this.invalidInterface = invalidInterface;
        }
    }

    public static class InvalidInterfaceImplementationException
    extends ApplicationException {
        public String invalidImpl;

        public InvalidInterfaceImplementationException(String invalidImpl) {
            this.invalidImpl = invalidImpl;
        }
    }

    public static class ExtendsJavaNotSupportedException
    extends ApplicationException {
    }

    public static class NotAnInterfaceException
    extends ApplicationException {
        public String proxyclass;

        public NotAnInterfaceException(Class proxyclass) {
            this.proxyclass = proxyclass.getName();
        }
    }

    public static class MethodNotImplementedException
    extends ApplicationException {
        public String method;
        public String proxy;

        public MethodNotImplementedException(String method, String proxy) {
            this.method = method;
            this.proxy = proxy;
        }
    }

    public static class DifferentNumberOfArgsException
    extends ApplicationException {
        public String method;
        public String args;

        public DifferentNumberOfArgsException(String method, String args) {
            this.method = method;
            this.args = args;
        }
    }

    public static class IncompatibleReturnTypeException
    extends ApplicationException {
        public String methodName;
        public String methodReturnType;
        public String cfcReturnType;

        public IncompatibleReturnTypeException(String methodName, String methodReturnType, String cfcReturnType) {
            this.methodName = methodName;
            this.cfcReturnType = cfcReturnType;
            this.methodReturnType = methodReturnType;
        }
    }

    public static class ArgumentTypeMismatchException
    extends ApplicationException {
        public String methodName;
        public String paramType;
        public String udfType;

        public ArgumentTypeMismatchException(String methodName, String paramType, String udfType) {
            this.methodName = methodName;
            this.paramType = paramType;
            this.udfType = udfType;
        }
    }

    public static class UnSupportedImplementationProcessorException
    extends ApplicationException {
        public String type;

        public UnSupportedImplementationProcessorException(String type) {
            this.type = type;
        }
    }
}

