/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.java;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.java.MethodHandleData;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMethodHandleMapper {
    private Map<String, Map<Integer, MethodHandleData>> mMethodHandleMap = new HashMap<String, Map<Integer, MethodHandleData>>();
    protected HashMap<String, String> methodMapping = new HashMap(40);
    static Class targetedClazz;
    MethodHandles.Lookup lookup = MethodHandles.lookup();
    public static final String ARRAYPUSH = "arraypush";
    public static final String ARRAYUNSHIFT = "arrayunshift";
    public static final String PUSH = "push";
    public static final String UNSHIFT = "unshift";
    public static final String ARRAYPUSH_VARIADIC = "arrayPushVariadic";
    public static final String ARRAYUNSHIFT_VARIADIC = "arrayUnshiftVariadic";
    protected static HashMap<String, Object> CFMethods;

    public AbstractMethodHandleMapper() {
        this.defineGenericMethodMapping();
        this.defineMethodMapping();
        this.loadMethodHandles();
    }

    protected void defineGenericMethodMapping() {
        this.methodMapping.put("Duplicate", "duplicate");
        this.methodMapping.put("SerializeJSON", "toJSON");
    }

    public abstract void defineMethodMapping();

    public MethodHandleData getMethodHandler(String methodName, int paramCount) {
        return this.getMethodHandler(methodName, paramCount, true);
    }

    public MethodHandleData getMethodHandler(String methodName, int paramCount, boolean throwError) {
        Map<Integer, MethodHandleData> map = this.mMethodHandleMap.get(methodName = methodName.toLowerCase());
        if (map != null) {
            MethodHandleData retValue = map.get(paramCount);
            if (retValue == null && methodName.equals(PUSH) || methodName.equals(UNSHIFT)) {
                retValue = map.size() > 1 ? (paramCount > 1 ? map.get(0) : map.get(1)) : map.get(0);
            }
            if (retValue == null && throwError) {
                String validParamRangeInfo = this.ConstructValidParamRangeInfo(map.keySet());
                this.ConstructValidParamRangeInfo(map.keySet());
                throw new WrongParameterNumberException(methodName, paramCount, validParamRangeInfo);
            }
            return retValue;
        }
        return null;
    }

    protected void addMethodHandle(String methodName, MethodHandleData methodHandleData, int paramCount) {
        Map<Integer, MethodHandleData> mHandle = this.mMethodHandleMap.get(methodName);
        --paramCount;
        if (mHandle == null) {
            HashMap<Integer, MethodHandleData> map = new HashMap<Integer, MethodHandleData>(3);
            map.put(paramCount, methodHandleData);
            this.mMethodHandleMap.put(methodName, map);
        } else {
            mHandle.put(paramCount, methodHandleData);
        }
    }

    public void loadMethodHandles() {
        for (Map.Entry<String, String> methodEntry : this.methodMapping.entrySet()) {
            String cffunctionName = methodEntry.getKey().toLowerCase();
            Object methodRef = CFMethods.get(cffunctionName);
            if (methodRef instanceof List) {
                List methodList = (List)methodRef;
                for (Method method : methodList) {
                    this.createMethodHandle(method, methodEntry.getValue());
                }
                continue;
            }
            if (methodRef == null) {
                System.out.println("cffunctionName for which method is null: " + cffunctionName);
                continue;
            }
            this.createMethodHandle((Method)methodRef, methodEntry.getValue());
        }
    }

    private void createMethodHandle(Method method, String mappedFuncName) {
        MethodHandleData mData = null;
        try {
            MethodType mt = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            MethodHandle mh = isStatic ? this.lookup.findStatic(targetedClazz, method.getName(), mt) : this.lookup.findVirtual(targetedClazz, method.getName(), mt);
            mData = new MethodHandleData(mh, isStatic, mappedFuncName);
        }
        catch (Exception e) {
            System.out.println("error for method:" + method.getName());
        }
        this.addMethodHandle(mappedFuncName.toLowerCase(), mData, method.getParameterTypes().length);
    }

    public String getMemberFuncForCFFunc(String cfFunc) {
        String memFunc = this.methodMapping.get(cfFunc);
        if (memFunc == null) {
            memFunc = cfFunc;
        }
        return memFunc;
    }

    private String ConstructValidParamRangeInfo(Set paramCountSet) {
        int minParamCount;
        Iterator paramIterator = paramCountSet.iterator();
        int maxParamCount = minParamCount = ((Integer)paramIterator.next()).intValue();
        while (paramIterator.hasNext()) {
            int pCount = (Integer)paramIterator.next();
            if (minParamCount > pCount) {
                minParamCount = pCount;
                continue;
            }
            if (maxParamCount >= pCount) continue;
            maxParamCount = pCount;
        }
        String rangeString = minParamCount + " ";
        if (minParamCount != maxParamCount) {
            rangeString = rangeString + " to " + maxParamCount;
        }
        return rangeString;
    }

    static {
        Method[] cfMethods;
        targetedClazz = CFPage.class;
        CFMethods = new HashMap(300);
        for (Method cfMethod : cfMethods = CFPage.class.getMethods()) {
            Object tempMethod = CFMethods.get(cfMethod.getName().toLowerCase());
            if (tempMethod == null) {
                if (cfMethod.getName().equals(ARRAYPUSH_VARIADIC)) {
                    tempMethod = CFMethods.get(ARRAYPUSH);
                } else if (cfMethod.getName().equals(ARRAYUNSHIFT_VARIADIC)) {
                    tempMethod = CFMethods.get(ARRAYUNSHIFT);
                }
            }
            if (tempMethod == null) {
                String name = cfMethod.getName();
                if (name.equals(ARRAYPUSH_VARIADIC)) {
                    name = ARRAYPUSH;
                } else if (name.equals(ARRAYUNSHIFT_VARIADIC)) {
                    name = ARRAYUNSHIFT;
                }
                CFMethods.put(name.toLowerCase(), cfMethod);
                continue;
            }
            if (tempMethod instanceof List) {
                ((List)tempMethod).add(cfMethod);
                continue;
            }
            Method oriMethod = (Method)tempMethod;
            LinkedList<Method> methodList = new LinkedList<Method>();
            if (oriMethod.getName().equals(ARRAYPUSH_VARIADIC) || oriMethod.getName().equals(ARRAYUNSHIFT_VARIADIC)) {
                methodList.add(oriMethod);
                methodList.add(cfMethod);
            } else {
                methodList.add(cfMethod);
                methodList.add(oriMethod);
            }
            CFMethods.put(oriMethod.getName().toLowerCase(), methodList);
        }
    }

    public static class WrongParameterNumberException
    extends ApplicationException {
        public String func;
        public int paramCount;
        public String validParamInfo;

        public WrongParameterNumberException(String methodName, int pCount, String validParamInfo) {
            this.func = methodName;
            this.paramCount = pCount;
            this.validParamInfo = validParamInfo;
        }
    }
}

