/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.java;

import coldfusion.runtime.Array;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFNumber;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.Invokable;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.java.CFCDynamicProxy;
import coldfusion.runtime.java.JavaProxy;
import coldfusion.server.DotNetService;
import coldfusion.server.Service;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.imq.imqTable;
import coldfusion.util.FastHashtable;
import com.allaire.cfx.Query;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassUtility {
    private static final HashMap CompatibilityMap = new HashMap();
    private static final HashMap PrimitiveToWrapperMap = new HashMap();
    private static final HashMap WrapperToPrimitiveMap = new HashMap();
    private static final Map primitiveWideningsMap = new HashMap(11);

    static Class primitiveEquivalentOf(Class aClass) {
        return aClass.isPrimitive() ? aClass : (Class)WrapperToPrimitiveMap.get(aClass);
    }

    private static boolean IsCompatible(Class FormalParamType, Class ActualType) {
        boolean rc = false;
        if (ActualType == null || FormalParamType.equals(Void.TYPE)) {
            if (!FormalParamType.isPrimitive()) {
                rc = true;
            }
        } else if (FormalParamType.isAssignableFrom(ActualType)) {
            rc = true;
        } else {
            Class ActualPrimEquiv;
            Class FormalPrimEquiv = ClassUtility.primitiveEquivalentOf(FormalParamType);
            if (ClassUtility.primitiveIsAssignableFrom(FormalPrimEquiv, ActualPrimEquiv = ClassUtility.primitiveEquivalentOf(ActualType))) {
                rc = true;
            }
        }
        return rc;
    }

    private static boolean IsCFType_CompatibleWith_JavaType(Class FormalParamType, Class ActualType) {
        boolean rc = false;
        if (ClassUtility.IsCompatible(FormalParamType, ActualType)) {
            rc = true;
        } else {
            List list;
            Class FormalParamClass = FormalParamType;
            if (FormalParamType.isPrimitive()) {
                FormalParamClass = (Class)PrimitiveToWrapperMap.get(FormalParamType);
            }
            Class ActualTypeClass = ActualType;
            if (ActualType.isPrimitive()) {
                ActualTypeClass = (Class)PrimitiveToWrapperMap.get(ActualType);
            }
            if ((list = (List)CompatibilityMap.get(FormalParamClass.getName())) != null) {
                if (list.contains(ActualTypeClass.getName())) {
                    rc = true;
                }
            } else if (FormalParamClass.isArray() && ActualTypeClass == Array.class && !FormalParamClass.getComponentType().isPrimitive()) {
                rc = true;
            }
            if (!rc && ServiceFactory.getDotNetService(false) != null && ServiceFactory.getDotNetService().isDotNetClass(FormalParamType)) {
                if (FormalParamClass.getName().equals("System.Collections.ArrayList") && List.class.isAssignableFrom(ActualTypeClass)) {
                    rc = true;
                } else if (FormalParamType.getName().equals("System.Object") && (ActualType == String.class || ActualType.isArray() || WrapperToPrimitiveMap.containsKey(ActualType))) {
                    rc = true;
                }
            }
        }
        return rc;
    }

    static boolean primitiveIsAssignableFrom(Class lhs, Class rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (!lhs.isPrimitive() || !rhs.isPrimitive()) {
            return false;
        }
        if (lhs.equals(rhs)) {
            return true;
        }
        Set wideningSet = (Set)primitiveWideningsMap.get(rhs);
        if (wideningSet == null) {
            return false;
        }
        return wideningSet.contains(lhs);
    }

    public static boolean CompatibleClasses_using_Java_widening_rule(Class[] lhs, Class[] rhs) {
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (ClassUtility.IsCompatible(lhs[i], rhs[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean CompatibleClasses_using_Java_widening_rule(Class[] lhs, Class[] rhs, Object[] args) {
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (!ClassUtility.IsCompatible(lhs[i], rhs[i])) {
                return false;
            }
            if (lhs[i] != Map.class || !(args[i] instanceof TemplateProxy)) continue;
            TemplateProxy tp = (TemplateProxy)args[i];
            try {
                boolean anyMatch;
                Map<String, Set<String>> impls = tp.getOtherImplementingInterfaces();
                Class clazz = lhs[i];
                if (impls == null || !(anyMatch = impls.entrySet().stream().anyMatch(e -> ((Set)e.getValue()).stream().anyMatch(interfce -> {
                    try {
                        return ClassUtility.IsCompatible(clazz, CFCDynamicProxy.getJavaClass(interfce));
                    }
                    catch (ClassNotFoundException ex) {
                        throw new RuntimeException(ex);
                    }
                })))) continue;
                return false;
            }
            catch (Throwable e2) {
                throw new RuntimeException(e2);
            }
        }
        return true;
    }

    public static boolean CompatibleClasses_using_CFML_conversion_rules(Class[] lhs, Class[] rhs) {
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (ClassUtility.IsCFType_CompatibleWith_JavaType(lhs[i], rhs[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean argumentsMatchExactly(Class[] lhs, Class[] rhs) {
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (rhs[i] == null && Object.class.isAssignableFrom(lhs[i]) || lhs[i] == rhs[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean primArgumentsMatchExactly(Class[] lhs, Class[] passedType) {
        if (lhs.length != passedType.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (passedType[i] == null) {
                if (Object.class.isAssignableFrom(lhs[i])) continue;
                return false;
            }
            Class lhsPrim = ClassUtility.primitiveEquivalentOf(lhs[i]);
            Class rhsPrim = ClassUtility.primitiveEquivalentOf(passedType[i]);
            if (lhsPrim == null || rhsPrim == null) {
                return false;
            }
            if (lhsPrim == rhsPrim) continue;
            return false;
        }
        return true;
    }

    public static Object cast(Object val, Class t) {
        if (val instanceof TemplateProxy) {
            TemplateProxy tp = (TemplateProxy)val;
            try {
                Map<String, Set<String>> impls = tp.getOtherImplementingInterfaces();
                if (impls != null) {
                    for (String key : impls.keySet()) {
                        Set<String> javaImpls = impls.get(key);
                        boolean anyMatch = javaImpls.stream().anyMatch(interfce -> {
                            try {
                                return t.isAssignableFrom(CFCDynamicProxy.getJavaClass(interfce));
                            }
                            catch (ClassNotFoundException ex) {
                                throw new RuntimeException(ex);
                            }
                        });
                        if (!anyMatch) continue;
                        Map<String, Object> proxies = tp.getDynamicProxies();
                        return proxies.get(key);
                    }
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        if (val == null || t.isAssignableFrom(val.getClass())) {
            return val;
        }
        if (val instanceof Array && t.isArray()) {
            Array aval = (Array)val;
            int size = aval.size();
            Class<?> compType = t.getComponentType();
            Object retval = java.lang.reflect.Array.newInstance(compType, size);
            for (int i = 0; i < size; ++i) {
                java.lang.reflect.Array.set(retval, i, ClassUtility.cast(aval.get(i), compType));
            }
            return retval;
        }
        if (t == Byte.TYPE || t == Byte.class) {
            return new Byte(Cast._byte(val));
        }
        if (t == Character.TYPE || t == Character.class) {
            return new Character(Cast._char(val));
        }
        if (t == Short.TYPE || t == Short.class) {
            return new Short(Cast._short(val));
        }
        if (t == Long.TYPE || t == Long.class) {
            return new Long(Cast._long(val));
        }
        if (t == Integer.TYPE || t == Integer.class) {
            return new Integer(Cast._int(val));
        }
        if (t == BigInteger.class) {
            return Cast._BigInteger(val);
        }
        if (t == Double.TYPE || t == Double.class) {
            return new Double(Cast._double(val));
        }
        if (t == Float.TYPE || t == Float.class) {
            return new Float((float)Cast._double(val));
        }
        if (t == Boolean.TYPE || t == Boolean.class) {
            return Cast._boolean(val) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (t == Number.class) {
            return new Double(Cast._double(val));
        }
        if (t == String.class) {
            return Cast._String(val);
        }
        if (t.isAssignableFrom(Date.class)) {
            return Cast._Date(val);
        }
        if (t.isAssignableFrom(Map.class)) {
            return Cast._Map(val);
        }
        if (t.isAssignableFrom(List.class)) {
            return Cast._List(val);
        }
        if (t.isAssignableFrom(Array.class)) {
            return Cast._Array(val);
        }
        if (t.isAssignableFrom(Query.class)) {
            return Cast._Query(val);
        }
        DotNetService dotNetService = ServiceFactory.getDotNetService(false);
        if (dotNetService != null && dotNetService.isDotNetClass(t)) {
            if (t.getName().equals("System.Object")) {
                return dotNetService.convertToSystemObject(t, val);
            }
            if (val instanceof List) {
                return dotNetService.cfToDotnet(val);
            }
        }
        return null;
    }

    public static boolean CheckRunTimeCompatibility(Class[] types, Object[] args) {
        boolean rc = true;
        try {
            for (int i = 0; i < types.length; ++i) {
                Object o = ClassUtility.cast(args[i], types[i]);
                if (o != null) continue;
                rc = false;
                break;
            }
        }
        catch (Exception e) {
            rc = false;
        }
        return rc;
    }

    public static Object[] ReInterpret(Object[] args, Class[] types) throws ExpressionException {
        Object[] result = new Object[args.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = ClassUtility.cast(args[i], types[i]);
        }
        return result;
    }

    public static boolean IsCFNativeType(Object o) {
        if (o == null) {
            return true;
        }
        if (CompatibilityMap.get(o.getClass().getName()) != null) {
            return true;
        }
        if (o instanceof Invokable || o instanceof NamedInvokable || o instanceof CFBoolean || o instanceof CFNumber) {
            return true;
        }
        if (o instanceof Service) {
            return true;
        }
        if (o instanceof FastHashtable) {
            return true;
        }
        if (o instanceof Array) {
            return true;
        }
        if (o instanceof imqTable) {
            return true;
        }
        if (o instanceof OleDateTime) {
            return true;
        }
        return o instanceof Query;
    }

    public static Object UnWrap(Class invokedClass, Object arg) {
        Object[] obj = arg;
        if (arg == null) {
            return obj;
        }
        if (arg instanceof JavaProxy) {
            obj = ((JavaProxy)arg).getObject();
        } else if (!ClassUtility.IsCFNativeType(arg) && arg.getClass().isArray()) {
            Object[] ArrayObj = arg;
            for (int j = 0; j < ArrayObj.length; ++j) {
                if (ArrayObj[j] == null || !(ArrayObj[j] instanceof JavaProxy)) continue;
                ArrayObj[j] = ((JavaProxy)ArrayObj[j]).getObject();
            }
            obj = ArrayObj;
        }
        return ClassUtility.unwrapCustom(invokedClass, obj);
    }

    public static Object[] UnWrap(Class invokedClass, Object[] args) {
        if (args.length == 0) {
            return args;
        }
        Object[] unwrappedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object obj = args[i];
            if (obj instanceof JavaProxy) {
                obj = ((JavaProxy)obj).getObject();
                unwrappedArgs[i] = ClassUtility.unwrapCustom(invokedClass, obj);
                continue;
            }
            if (ClassUtility.IsCFNativeType(obj)) {
                if (obj instanceof Array) {
                    ArrayList v = (ArrayList)obj;
                    int size = v.size();
                    for (int j = 0; j < size; ++j) {
                        Object o = ClassUtility.UnWrap(invokedClass, v.get(j));
                        v.set(j, o);
                    }
                } else {
                    if (obj instanceof CFBoolean) {
                        unwrappedArgs[i] = ((CFBoolean)obj).value;
                        continue;
                    }
                    if (obj instanceof CFNumber) {
                        unwrappedArgs[i] = ((CFNumber)obj).unwrap();
                        continue;
                    }
                }
                unwrappedArgs[i] = ClassUtility.unwrapCustom(invokedClass, obj);
                continue;
            }
            if (obj.getClass().isArray()) {
                Object[] arrayObj = (Object[])obj;
                for (int j = 0; j < arrayObj.length; ++j) {
                    if (arrayObj[j] == null || !(arrayObj[j] instanceof JavaProxy)) continue;
                    arrayObj[j] = ((JavaProxy)arrayObj[j]).getObject();
                }
            }
            unwrappedArgs[i] = ClassUtility.unwrapCustom(invokedClass, obj);
        }
        return unwrappedArgs;
    }

    public static Object Wrap(Object val) {
        JavaProxy[] retval = val;
        if (!ClassUtility.IsCFNativeType(val)) {
            if (val.getClass().isArray()) {
                int size = ((Object[])val).length;
                JavaProxy[] ArrayObj = (JavaProxy[])java.lang.reflect.Array.newInstance(JavaProxy.class, size);
                for (int i = 0; i < size; ++i) {
                    ArrayObj[i] = new JavaProxy(((Object[])val)[i]);
                }
                retval = ArrayObj;
            } else {
                retval = new JavaProxy(val);
            }
        }
        return retval;
    }

    public static Object wrapCustom(Object val) {
        if (val == null) {
            return val;
        }
        DotNetService dotNetService = ServiceFactory.getDotNetService(false);
        if (dotNetService != null && ServiceFactory.getDotNetService().isDotNetObject(val)) {
            return dotNetService.autoConvertDotnetToCF(val);
        }
        return val;
    }

    public static Object unwrapCustom(Class clazz, Object arg) {
        DotNetService dotNetService = ServiceFactory.getDotNetService(false);
        if (dotNetService != null && ServiceFactory.getDotNetService().isDotNetClass(clazz)) {
            return dotNetService.cfToDotnet(arg);
        }
        return arg;
    }

    public static boolean CompatibleClassesUsingDynamicProxyRules(Class[] lhs, Class[] rhs, Object[] originalObject) {
        if (lhs.length != rhs.length) {
            return false;
        }
        int i = 0;
        if (i < lhs.length) {
            Set<String> o;
            Map<String, Set<String>> impls;
            ArrayList<Class> classes = new ArrayList<Class>(1);
            if (originalObject[i] instanceof TemplateProxy && (impls = ((TemplateProxy)originalObject[i]).getOtherImplementingInterfaces()) != null && (o = impls.get("java")) != null) {
                for (String key : o) {
                    try {
                        classes.add(CFCDynamicProxy.getJavaClass(key));
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
            boolean anyMatch = false;
            for (Class c : classes) {
                if (!ClassUtility.IsCFType_CompatibleWith_JavaType(lhs[i], c)) continue;
                anyMatch = true;
            }
            return anyMatch;
        }
        return false;
    }

    public static Class castCFtoJavaType(String cfType) throws Throwable {
        if (cfType == null) {
            return Void.class;
        }
        switch (cfType.toLowerCase()) {
            case "any": {
                return Object.class;
            }
            case "binary": {
                return Byte[].class;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "string": {
                return String.class;
            }
            case "numeric": {
                return Number.class;
            }
            case "double": {
                return Double.class;
            }
            case "float": {
                return Float.class;
            }
            case "int": 
            case "integer": {
                return Integer.class;
            }
            case "struct": {
                return Map.class;
            }
            case "array": {
                return List.class;
            }
            case "query": {
                return ResultSet.class;
            }
            case "date": {
                return Date.class;
            }
        }
        throw new RuntimeException("Unable to cast " + cfType + " to JAVA Equivalent");
    }

    public static Class[] castCFtoJavaType(String[] cfType) throws Throwable {
        Class[] classes = new Class[cfType.length];
        for (int i = 0; i < cfType.length; ++i) {
            classes[i] = ClassUtility.castCFtoJavaType(cfType[i]);
        }
        return classes;
    }

    static {
        HashSet<Class<Number>> set = new HashSet<Class<Number>>();
        set.add(Short.TYPE);
        set.add(Integer.TYPE);
        set.add(Long.TYPE);
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Byte.TYPE, set);
        set = new HashSet();
        set.add(Integer.TYPE);
        set.add(Long.TYPE);
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Short.TYPE, set);
        primitiveWideningsMap.put(Character.TYPE, set);
        set = new HashSet();
        set.add(Long.TYPE);
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Integer.TYPE, set);
        set = new HashSet();
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Long.TYPE, set);
        set = new HashSet();
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Float.TYPE, set);
        PrimitiveToWrapperMap.put(Boolean.TYPE, Boolean.class);
        PrimitiveToWrapperMap.put(Byte.TYPE, Byte.class);
        PrimitiveToWrapperMap.put(Character.TYPE, Character.class);
        PrimitiveToWrapperMap.put(Double.TYPE, Double.class);
        PrimitiveToWrapperMap.put(Float.TYPE, Float.class);
        PrimitiveToWrapperMap.put(Integer.TYPE, Integer.class);
        PrimitiveToWrapperMap.put(Long.TYPE, Long.class);
        PrimitiveToWrapperMap.put(Short.TYPE, Short.class);
        WrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        WrapperToPrimitiveMap.put(CFBoolean.class, Boolean.TYPE);
        WrapperToPrimitiveMap.put(Byte.class, Byte.TYPE);
        WrapperToPrimitiveMap.put(Character.class, Character.TYPE);
        WrapperToPrimitiveMap.put(Double.class, Double.TYPE);
        WrapperToPrimitiveMap.put(Float.class, Float.TYPE);
        WrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
        WrapperToPrimitiveMap.put(Long.class, Long.TYPE);
        WrapperToPrimitiveMap.put(Short.class, Short.TYPE);
        ArrayList<String> list = new ArrayList<String>();
        list.add("java.lang.Boolean");
        list.add("java.lang.String");
        list.add("java.lang.Double");
        list.add("java.lang.Long");
        list.add("java.lang.Integer");
        CompatibilityMap.put("java.lang.Boolean", list);
        list = new ArrayList();
        list.add("java.lang.Integer");
        list.add("java.lang.String");
        CompatibilityMap.put("java.lang.Byte", list);
        list = new ArrayList();
        list.add("java.lang.Integer");
        list.add("java.lang.String");
        CompatibilityMap.put("java.lang.Character", list);
        list = new ArrayList();
        list.add("java.lang.Double");
        list.add("java.lang.Long");
        list.add("java.lang.Integer");
        list.add("java.lang.String");
        CompatibilityMap.put("java.lang.Short", list);
        list = new ArrayList();
        list.add("java.lang.Double");
        list.add("java.lang.Long");
        list.add("java.lang.Integer");
        list.add("java.lang.String");
        CompatibilityMap.put("java.lang.Integer", list);
        list = new ArrayList();
        list.add("java.lang.Double");
        list.add("java.lang.Long");
        list.add("java.lang.Integer");
        list.add("java.lang.String");
        CompatibilityMap.put("java.lang.Long", list);
        list = new ArrayList();
        list.add("java.lang.Double");
        list.add("java.lang.Long");
        list.add("java.lang.Integer");
        list.add("java.lang.Float");
        list.add("java.lang.Double");
        list.add("java.lang.String");
        CompatibilityMap.put("java.lang.Float", list);
        list = new ArrayList();
        list.add("java.lang.Long");
        list.add("java.lang.Integer");
        list.add("java.lang.Float");
        list.add("java.lang.Double");
        list.add("java.lang.String");
        CompatibilityMap.put("java.lang.Double", list);
        list = new ArrayList();
        list.add("java.lang.String");
        list.add("java.util.Date");
        list.add("java.lang.Boolean");
        list.add("java.lang.Long");
        list.add("java.lang.Integer");
        list.add("java.lang.Double");
        CompatibilityMap.put("java.lang.String", list);
        list = new ArrayList();
        list.add("java.lang.String");
        list.add("java.util.Date");
        CompatibilityMap.put("java.util.Date", list);
        list = new ArrayList();
        list.add("coldfusion.runtime.Array");
        CompatibilityMap.put("[B", list);
        list = new ArrayList();
        list.add("coldfusion.runtime.Array");
        CompatibilityMap.put("[S", list);
        list = new ArrayList();
        list.add("java.lang.String");
        list.add("coldfusion.runtime.Array");
        CompatibilityMap.put("[C", list);
        list = new ArrayList();
        list.add("coldfusion.runtime.Array");
        CompatibilityMap.put("[Ljava.lang.String;", list);
        list = new ArrayList();
        list.add("coldfusion.runtime.Array");
        CompatibilityMap.put("[I", list);
        list = new ArrayList();
        list.add("coldfusion.runtime.Array");
        CompatibilityMap.put("[J", list);
        list = new ArrayList();
        list.add("coldfusion.runtime.Array");
        CompatibilityMap.put("[F", list);
        list = new ArrayList();
        list.add("coldfusion.runtime.Array");
        CompatibilityMap.put("[D", list);
        list = new ArrayList();
        list.add("coldfusion.runtime.Array");
        CompatibilityMap.put("[Z", list);
        list = new ArrayList();
        list.add("coldfusion.runtime.Array");
        CompatibilityMap.put("[Ljava.lang.Object;", list);
    }
}

