/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.java;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.java.JavaProxyFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;

public class CustomObjectInputStream
extends ObjectInputStream {
    private static final HashMap<String, Class<?>> primClasses = new HashMap(8, 1.0f);

    public CustomObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    protected CustomObjectInputStream() throws IOException, SecurityException {
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String className = desc.getName();
        try {
            ApplicationScope appScope = (ApplicationScope)FusionContext.getApplicationScope();
            ClassLoader appClassLoader = JavaProxyFactory.getAppClassLoader(appScope);
            ClassLoader classLoader = appClassLoader != null && !className.startsWith("coldfusion.") ? appClassLoader : Thread.currentThread().getContextClassLoader();
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException ex) {
            Class<?> cl = primClasses.get(className);
            if (cl != null) {
                return cl;
            }
            throw ex;
        }
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

