/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.java;

import coldfusion.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DynamicClassLoader
extends ClassLoader {
    protected List classpath;
    private boolean delegateToParent;
    private ClassLoader parentClassLoader;
    protected Map jarMap;
    private HashSet<String> parentClasses;

    public DynamicClassLoader(ClassLoader parent) {
        this(parent, false);
    }

    public DynamicClassLoader(ClassLoader parent, boolean delegateToParent) {
        super(parent);
        this.parentClassLoader = parent;
        this.classpath = new ArrayList();
        this.delegateToParent = delegateToParent;
        this.jarMap = new HashMap();
        this.parentClasses = new HashSet();
    }

    public void addToClasspath(File file) {
        if (file.exists()) {
            this.classpath.add(file);
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            return clazz;
        }
        if (this.delegateToParent) {
            try {
                clazz = this.parentClassLoader.loadClass(name);
                this.parentClasses.add(name);
            }
            catch (ClassNotFoundException e) {
                clazz = this.findClass(name);
            }
        } else if (this.parentClasses.contains(name)) {
            try {
                clazz = this.parentClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                clazz = this.findClass(name);
            }
        } else {
            try {
                clazz = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                clazz = this.parentClassLoader.loadClass(name);
                this.parentClasses.add(name);
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    try {
                        byte[] bytes;
                        InputStream in = DynamicClassLoader.this.getInputStream(path);
                        if (in != null && (bytes = IOUtils.toByteArray(in)) != null) {
                            return DynamicClassLoader.this.defineClass(name, bytes, 0, bytes.length);
                        }
                        throw new ClassNotFoundException(name);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name, e);
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    private InputStream getInputStream(String name) throws IOException {
        for (int i = 0; i < this.classpath.size(); ++i) {
            JarEntry jarEntry;
            File file = (File)this.classpath.get(i);
            if (file.isDirectory()) {
                File clazzFile = new File(file, name);
                if (!clazzFile.exists()) continue;
                return new FileInputStream(clazzFile);
            }
            String filename = file.getName().toLowerCase();
            if (!filename.endsWith(".jar") && !filename.endsWith(".zip")) continue;
            JarFile jarFile = (JarFile)this.jarMap.get(file);
            if (jarFile == null) {
                try {
                    jarFile = new JarFile(file, false);
                }
                catch (IOException e) {
                    continue;
                }
                this.jarMap.put(file, jarFile);
            }
            if ((jarEntry = jarFile.getJarEntry(name)) == null) continue;
            return jarFile.getInputStream(jarEntry);
        }
        return null;
    }

    @Override
    protected URL findResource(String name) {
        for (int i = 0; i < this.classpath.size(); ++i) {
            File file = (File)this.classpath.get(i);
            if (file.isDirectory()) {
                File clazzFile = new File(file, name);
                try {
                    if (clazzFile.exists()) {
                        return clazzFile.toURL();
                    }
                }
                catch (MalformedURLException malformedURLException) {}
                continue;
            }
            String filename = file.getName().toLowerCase();
            if (!filename.endsWith(".jar") && !filename.endsWith(".zip")) continue;
            try {
                JarEntry jarEntry;
                JarFile jarFile = (JarFile)this.jarMap.get(file);
                if (jarFile == null) {
                    jarFile = new JarFile(file, false);
                    this.jarMap.put(file, jarFile);
                }
                if ((jarEntry = jarFile.getJarEntry(name)) == null) continue;
                URL jarUrl = new URL("jar", null, file.toURL().toString() + "!/");
                return new URL(jarUrl, name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Enumeration findResources(String name) throws IOException {
        final ArrayList<URL> urlList = new ArrayList<URL>();
        for (int i = 0; i < this.classpath.size(); ++i) {
            File file = (File)this.classpath.get(i);
            if (file.isDirectory()) {
                File clazzFile = new File(file, name);
                try {
                    if (!clazzFile.exists()) continue;
                    urlList.add(clazzFile.toURL());
                }
                catch (MalformedURLException malformedURLException) {}
                continue;
            }
            String filename = file.getName().toLowerCase();
            if (!filename.endsWith(".jar") && !filename.endsWith(".zip")) continue;
            try {
                JarEntry jarEntry;
                JarFile jarFile = (JarFile)this.jarMap.get(file);
                if (jarFile == null) {
                    jarFile = new JarFile(file, false);
                    this.jarMap.put(file, jarFile);
                }
                if ((jarEntry = jarFile.getJarEntry(name)) == null) continue;
                URL jarUrl = new URL("jar", null, file.toURL().toString() + "!/");
                urlList.add(new URL(jarUrl, name));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new Enumeration(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < urlList.size();
            }

            public Object nextElement() {
                if (this.count < urlList.size()) {
                    return urlList.remove(this.count++);
                }
                throw new IllegalStateException();
            }
        };
    }

    public List getClassPath() {
        return this.classpath;
    }

    public void release() {
        this.classpath = null;
        Collection jarFiles = this.jarMap.values();
        Iterator iterator = jarFiles.iterator();
        while (iterator.hasNext()) {
            JarFile jarFile = (JarFile)iterator.next();
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            iterator.remove();
        }
        this.jarMap.clear();
        this.parentClasses.clear();
    }
}

