/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.java;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.AppClassLoaderHelper;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.Invokable;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.ObjectException;
import coldfusion.runtime.ProxyFactory;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.java.JavaObjectClassNotFoundException;
import coldfusion.runtime.java.JavaObjectInstantiationException;
import coldfusion.runtime.java.JavaProxy;
import coldfusion.security.SecurityManager;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import java.io.File;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JavaProxyFactory
extends ProxyFactory {
    @Override
    public Invokable getProxy(String className, Map propMap) throws Throwable {
        NeoPageContext pageContext = (NeoPageContext)propMap.get("pageContext");
        FusionContext fusionContext = pageContext.getFusionContext();
        String pagepath = fusionContext.getPagePath();
        if (SystemInfo.isWindows()) {
            pagepath = pagepath.toUpperCase();
        }
        Boolean isWebInfPath = null;
        if (className.startsWith("coldfusion.") && ServiceFactory.getRuntimeService().isServiceFactoryDisabled() && !className.equals("coldfusion.cfc.CFCProxy")) {
            boolean allowed = false;
            Object cfide = fusionContext.getRealPath("/CFIDE");
            if (!((String)cfide).endsWith(File.separator)) {
                cfide = (String)cfide + File.separatorChar;
            }
            if (SystemInfo.isWindows()) {
                cfide = ((String)cfide).toUpperCase();
            }
            if (pagepath.startsWith((String)cfide)) {
                allowed = true;
            }
            if (!allowed && RuntimeServiceImpl.isWebInfPath(pagepath)) {
                allowed = true;
                isWebInfPath = Boolean.TRUE;
            }
            if (!allowed && !SystemInfo.isWindows()) {
                Object cfide2 = fusionContext.getRealPath("/cfide");
                if (!((String)cfide2).endsWith(File.separator)) {
                    cfide2 = (String)cfide2 + File.separatorChar;
                }
                if (pagepath.startsWith((String)cfide2)) {
                    allowed = true;
                }
            }
            if (!allowed) {
                throw new ColdFusionJavaNotAllowedException(className);
            }
        }
        try {
            final ClassLoader cl = Thread.currentThread().getContextClassLoader();
            final String classname = className;
            ApplicationScope app = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
            ClassLoader appClassLoader = JavaProxyFactory.getAppClassLoader(app, (List)propMap.get("classpath"));
            if (System.getSecurityManager() == null) {
                if (appClassLoader != null && !classname.startsWith("coldfusion.")) {
                    return new JavaProxy(appClassLoader.loadClass(classname));
                }
                return new JavaProxy(cl.loadClass(classname));
            }
            if (isWebInfPath == null) {
                isWebInfPath = RuntimeServiceImpl.isWebInfPath(pagepath);
            }
            if (!isWebInfPath.booleanValue()) {
                ServiceFactory.getSecurityService().checkPermission(SecurityManager.CREATE_JAVA_OBJECT);
            }
            if (appClassLoader != null && !classname.startsWith("coldfusion.")) {
                return new JavaProxy(appClassLoader.loadClass(classname));
            }
            return (Invokable)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new JavaProxy(cl.loadClass(classname));
                }
            });
        }
        catch (ClassNotFoundException e1) {
            throw new JavaObjectClassNotFoundException(className, (Throwable)e1);
        }
        catch (AccessControlException ace) {
            throw ace;
        }
        catch (Exception | NoClassDefFoundError ex) {
            throw new JavaObjectInstantiationException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getAppClassLoader(ApplicationScope app, List<String> customPaths) {
        ClassLoader appClassLoader = null;
        if (app != null) {
            AppClassLoaderHelper appClassLoaderHelper = app.getAppClassLoaderHelper();
            if (appClassLoaderHelper != null) {
                Object object = appClassLoaderHelper.getLockObject();
                synchronized (object) {
                    while (appClassLoaderHelper.isRefreshing()) {
                        try {
                            appClassLoaderHelper.getLockObject().wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
                appClassLoader = appClassLoaderHelper.getClassLoader(customPaths);
            }
        } else {
            AppClassLoaderHelper appClassLoaderHelper = new AppClassLoaderHelper();
            appClassLoader = appClassLoaderHelper.getClassLoader(customPaths);
        }
        return appClassLoader;
    }

    public static ClassLoader getAppClassLoader(ApplicationScope app) {
        return JavaProxyFactory.getAppClassLoader(app, Collections.emptyList());
    }

    public static class ColdFusionJavaNotAllowedException
    extends ObjectException {
        public String classname;

        public ColdFusionJavaNotAllowedException(String classname) {
            this.classname = classname;
        }
    }
}

