/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.java;

import coldfusion.runtime.java.ClassUtility;
import coldfusion.runtime.java.Introspectable;
import coldfusion.runtime.java.MethodSelectionException;
import coldfusion.util.CaseInsensitiveMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ObjectHandler
implements Introspectable {
    private Class mClazz;
    private Map<String, List<Method>> mMethodMap;
    private Map<String, List<Method>> exactMethodMap;
    private List mCtorList;
    private Map<Member, Class[]> mParamMap;
    private Map<String, Field> mFieldMap;

    public ObjectHandler(Class cls) {
        this.mClazz = cls;
        this.exactMethodMap = new HashMap<String, List<Method>>();
        this.mMethodMap = new CaseInsensitiveMap();
        this.mCtorList = new ArrayList();
        this.mParamMap = new HashMap<Member, Class[]>();
        this.mFieldMap = new CaseInsensitiveMap();
        this.Initialize();
    }

    private void Initialize() {
        Field[] flds = this.mClazz.getFields();
        for (int i = 0; i < flds.length; ++i) {
            Field f = flds[i];
            this.mFieldMap.put(f.getName(), f);
        }
        Constructor<?>[] ctors = this.mClazz.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            Constructor<?> ctor = ctors[i];
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.mCtorList.add(ctor);
            this.mParamMap.put(ctor, ctor.getParameterTypes());
        }
        Method[] methods = this.mClazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            List<Method> methList;
            Method m = methods[i];
            try {
                m.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            String exactMethodName = m.getName();
            String methodName = exactMethodName.toUpperCase();
            Class<?>[] paramTypes = m.getParameterTypes();
            List<Method> exactMethodList = this.exactMethodMap.get(exactMethodName);
            if (exactMethodList == null) {
                exactMethodList = new ArrayList<Method>();
                this.exactMethodMap.put(exactMethodName, exactMethodList);
            }
            if ((methList = this.mMethodMap.get(methodName)) == null) {
                methList = new ArrayList<Method>();
                this.mMethodMap.put(methodName, methList);
            }
            if (!Modifier.isPublic(m.getModifiers()) || Modifier.isAbstract(m.getModifiers()) || m.getDeclaringClass().isInterface() && !m.isDefault()) continue;
            if (exactMethodList.size() == 0) {
                exactMethodList.add(m);
            } else {
                this.filterAndAddMethod(exactMethodList, m);
            }
            this.filterAndAddMethod(methList, m);
            this.mParamMap.put(m, paramTypes);
        }
    }

    private void filterAndAddMethod(List list, Method newMethod) {
        boolean isNewMethodVolatile = Modifier.isVolatile(newMethod.getModifiers());
        for (int i = 0; i < list.size(); ++i) {
            Class<?> newMethDeclaringClass;
            Method method = (Method)list.get(i);
            boolean isOldMethodVolatile = Modifier.isVolatile(method.getModifiers());
            Class[] oldMethParamTypes = method.getParameterTypes();
            Class[] newMethParamTypes = newMethod.getParameterTypes();
            if (!method.getName().equals(newMethod.getName()) || !ObjectHandler.areParametersSame(oldMethParamTypes, newMethParamTypes)) continue;
            Class<?> methDeclaringClass = method.getDeclaringClass();
            if (methDeclaringClass.isAssignableFrom(newMethDeclaringClass = newMethod.getDeclaringClass())) {
                if (isOldMethodVolatile && !isNewMethodVolatile) {
                    list.set(i, newMethod);
                }
                return;
            }
            if (!newMethDeclaringClass.isAssignableFrom(methDeclaringClass)) continue;
            return;
        }
        list.add(newMethod);
    }

    private static boolean areParametersSame(Class[] class1, Class[] class2) {
        if (class1 == null) {
            return class2 == null || class2.length == 0;
        }
        if (class2 == null) {
            return class1.length == 0;
        }
        if (class1.length != class2.length) {
            return false;
        }
        for (int i = 0; i < class1.length; ++i) {
            if (class1[i] == class2[i]) continue;
            return false;
        }
        return true;
    }

    private List findMembers(List MemberList, Object[] args) {
        if (MemberList == null) {
            return Collections.EMPTY_LIST;
        }
        Class[] CFMLArgTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            CFMLArgTypes[i] = args[i] == null ? null : args[i].getClass();
        }
        ArrayList<Member> exactArgsMatchList = null;
        ArrayList<Member> exactPrimArgsMatchList = null;
        ArrayList<Member> matchingList = null;
        int size = MemberList.size();
        for (int i = 0; i < size; ++i) {
            Member m = (Member)MemberList.get(i);
            Class[] FormalParamTypes = this.mParamMap.get(m);
            if (ClassUtility.argumentsMatchExactly(FormalParamTypes, CFMLArgTypes)) {
                if (size == 1) {
                    return MemberList;
                }
                if (exactArgsMatchList == null) {
                    exactArgsMatchList = new ArrayList<Member>(2);
                }
                exactArgsMatchList.add(m);
            }
            if (ClassUtility.primArgumentsMatchExactly(FormalParamTypes, CFMLArgTypes)) {
                if (size == 1) {
                    return MemberList;
                }
                if (exactPrimArgsMatchList == null) {
                    exactPrimArgsMatchList = new ArrayList<Member>(2);
                }
                exactPrimArgsMatchList.add(m);
            }
            if (!ClassUtility.CompatibleClasses_using_Java_widening_rule(FormalParamTypes, CFMLArgTypes, args)) continue;
            if (matchingList == null) {
                matchingList = new ArrayList<Member>();
            }
            matchingList.add(m);
            if (size != 1) continue;
            return matchingList;
        }
        if (exactArgsMatchList != null && exactArgsMatchList.size() == 1) {
            return exactArgsMatchList;
        }
        if (exactPrimArgsMatchList != null && exactPrimArgsMatchList.size() == 1) {
            return exactPrimArgsMatchList;
        }
        if (matchingList != null) {
            return matchingList;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean memberIsMoreSpecific(Member first, Member second) {
        Class[] firstParamTypes = this.mParamMap.get(first);
        Class[] secondParamTypes = this.mParamMap.get(second);
        return ClassUtility.CompatibleClasses_using_Java_widening_rule(secondParamTypes, firstParamTypes);
    }

    private ArrayList findMostSpecificMembers(List memberList) {
        ArrayList<Member> mostSpecificMembers = new ArrayList<Member>();
        int size = memberList.size();
        for (int i = 0; i < size; ++i) {
            Member member = (Member)memberList.get(i);
            if (mostSpecificMembers.isEmpty()) {
                mostSpecificMembers.add(member);
                continue;
            }
            boolean moreSpecific = true;
            boolean lessSpecific = false;
            for (int j = 0; j < mostSpecificMembers.size(); ++j) {
                Member moreSpecificMember = (Member)mostSpecificMembers.get(j);
                if (!this.memberIsMoreSpecific(member, moreSpecificMember)) {
                    moreSpecific = false;
                    lessSpecific = this.memberIsMoreSpecific(moreSpecificMember, member);
                    break;
                }
                if (!this.memberIsMoreSpecific(moreSpecificMember, member)) continue;
                moreSpecific = false;
                lessSpecific = false;
                break;
            }
            if (moreSpecific) {
                mostSpecificMembers.clear();
                mostSpecificMembers.add(member);
                continue;
            }
            if (lessSpecific) continue;
            mostSpecificMembers.add(member);
        }
        return mostSpecificMembers;
    }

    @Override
    public Field getField(String fieldname) {
        return this.mFieldMap.get(fieldname);
    }

    public Map.Entry<Method, Boolean> findDefaultMethod(String methodName, Object[] args) {
        Method retval = null;
        ArrayList<Method> eFilteredMethods = this.filterDefaultMethod((ArrayList)this.exactMethodMap.get(methodName));
        ArrayList<Method> mFilteredMethods = null;
        ArrayList<Method> t = eFilteredMethods;
        if (t != null && t.size() != 0) {
            retval = this.findMethod(t, args, methodName);
        }
        if (retval == null && (t = (mFilteredMethods = this.filterDefaultMethod((ArrayList)this.mMethodMap.get(methodName)))) != null && t.size() != 0) {
            retval = this.findMethod(t, args, methodName);
        }
        if (retval != null) {
            return new AbstractMap.SimpleEntry<Method, Boolean>(retval, false);
        }
        List list = this.findMethodUsingCFMLRules(eFilteredMethods, args);
        if (list.size() == 0) {
            t = mFilteredMethods;
            list = this.findMethodUsingCFMLRules(t, args);
        }
        if (list.size() > 1) {
            list = this.findMostSpecificMembers(list);
        }
        if (list.size() == 0) {
            throw new MethodSelectionException(methodName, list.size());
        }
        if (list.size() > 1) {
            throw new MethodSelectionException(methodName, list.size());
        }
        retval = (Method)list.get(0);
        return new AbstractMap.SimpleEntry<Method, Boolean>(retval, true);
    }

    public ArrayList<Method> filterDefaultMethod(ArrayList<Method> t) {
        if (t == null || t.size() == 0) {
            return null;
        }
        return (ArrayList)t.stream().filter(m -> m.isDefault()).collect(Collectors.toList());
    }

    @Override
    public Method findMethod(String methodName, Object[] args) throws MethodSelectionException {
        Method retval = null;
        ArrayList t = (ArrayList)this.exactMethodMap.get(methodName);
        if (t != null && t.size() != 0) {
            retval = this.findMethod(t, args, methodName);
        }
        if (retval == null && (t = (ArrayList)this.mMethodMap.get(methodName)) != null && t.size() != 0) {
            retval = this.findMethod(t, args, methodName);
        }
        return retval;
    }

    private Method findMethod(ArrayList t, Object[] args, String methodName) {
        Method retval = null;
        List list = this.findMembers(t, args);
        if (list.size() > 0) {
            if (list.size() > 1) {
                list = this.findMostSpecificMembers(list);
            }
            if (list.size() > 1) {
                throw new MethodSelectionException(methodName, list.size());
            }
            retval = (Method)list.get(0);
        }
        return retval;
    }

    @Override
    public Method findMethodUsingCFMLRules(String methodName, Object[] args) throws MethodSelectionException {
        ArrayList t = (ArrayList)this.exactMethodMap.get(methodName);
        List list = this.findMethodUsingCFMLRules(t, args);
        if (list.size() == 0) {
            t = (ArrayList)this.mMethodMap.get(methodName);
            list = this.findMethodUsingCFMLRules(t, args);
        }
        if (list.size() > 1) {
            list = this.findMostSpecificMembers(list);
        }
        if (list.size() == 0) {
            throw new MethodSelectionException(methodName, list.size());
        }
        if (list.size() > 1) {
            throw new MethodSelectionException(methodName, list.size());
        }
        Method retval = (Method)list.get(0);
        return retval;
    }

    private List findMethodUsingCFMLRules(ArrayList t, Object[] args) {
        List list = this.findMembers_with_CFMLRule(t, args);
        if (list.size() > 1) {
            this.ReduceWithRuntimeType(list, args);
        }
        if (list.size() > 1) {
            list = this.ReduceWithMatchingType(list, args);
        }
        return list;
    }

    @Override
    public Constructor findConstructor(Object[] args) throws MethodSelectionException {
        List list = this.findMembers(this.mCtorList, args);
        Constructor retval = null;
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            list = this.findMostSpecificMembers(list);
        }
        if (list.size() > 1) {
            throw new MethodSelectionException("init", list.size());
        }
        if (list.size() == 1) {
            retval = (Constructor)list.get(0);
        }
        return retval;
    }

    @Override
    public Constructor findConstructorUsingCFMLRules(Object[] args) throws MethodSelectionException {
        Constructor retval = null;
        List list = this.findMembers_with_CFMLRule(this.mCtorList, args);
        if (list.size() != 0) {
            if (list.size() > 1) {
                this.ReduceWithRuntimeType(list, args);
            }
            if (list.size() > 1) {
                list = this.ReduceWithMatchingType(list, args);
            }
            if (list.size() > 1) {
                throw new MethodSelectionException("init", list.size());
            }
            retval = (Constructor)list.get(0);
        }
        return retval;
    }

    @Override
    public ArrayList getMethodList(String methodName) {
        return (ArrayList)this.mMethodMap.get(methodName);
    }

    private List findMembers_with_CFMLRule(List MemberList, Object[] args) {
        if (MemberList == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Member> MatchingList = new ArrayList<Member>();
        ArrayList<Member> additionalMatchingList = new ArrayList<Member>(2);
        Class[] CFArgTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            CFArgTypes[i] = args[i] == null ? null : args[i].getClass();
        }
        ArrayList<Member> exactArgsMatchList = null;
        ArrayList<Member> exactPrimArgsMatchList = null;
        for (Member m : MemberList) {
            Class[] FormalParamTypes = this.mParamMap.get(m);
            if (ClassUtility.argumentsMatchExactly(FormalParamTypes, CFArgTypes)) {
                if (exactArgsMatchList == null) {
                    exactArgsMatchList = new ArrayList<Member>(2);
                }
                exactArgsMatchList.add(m);
            }
            if (ClassUtility.primArgumentsMatchExactly(FormalParamTypes, CFArgTypes)) {
                if (exactPrimArgsMatchList == null) {
                    exactPrimArgsMatchList = new ArrayList<Member>(2);
                }
                exactPrimArgsMatchList.add(m);
            }
            if (ClassUtility.CompatibleClasses_using_CFML_conversion_rules(FormalParamTypes, CFArgTypes)) {
                MatchingList.add(m);
            }
            if (!MatchingList.isEmpty() || !ClassUtility.CompatibleClassesUsingDynamicProxyRules(FormalParamTypes, CFArgTypes, args)) continue;
            additionalMatchingList.add(m);
        }
        if (exactArgsMatchList != null && exactArgsMatchList.size() == 1) {
            return exactArgsMatchList;
        }
        if (exactPrimArgsMatchList != null && exactPrimArgsMatchList.size() == 1) {
            return exactPrimArgsMatchList;
        }
        if (MatchingList != null && !MatchingList.isEmpty()) {
            return MatchingList;
        }
        return additionalMatchingList;
    }

    @Override
    public Enumeration getFieldNames() {
        return new Hashtable<String, Field>(this.mFieldMap).keys();
    }

    private void ReduceWithRuntimeType(List list, Object[] args) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Member m = (Member)it.next();
            Class[] FormalParamTypes = this.mParamMap.get(m);
            if (ClassUtility.CheckRunTimeCompatibility(FormalParamTypes, args)) continue;
            it.remove();
        }
    }

    private List ReduceWithMatchingType(List list, Object[] args) {
        ArrayList<Member> newList = new ArrayList<Member>();
        for (Member m : list) {
            Class[] FormalParamTypes = this.mParamMap.get(m);
            boolean exactlyMatch = false;
            for (int i = 0; i < FormalParamTypes.length; ++i) {
                if (!FormalParamTypes[i].getName().equals(args[i].getClass().getName())) continue;
                exactlyMatch = true;
            }
            if (!exactlyMatch) continue;
            newList.add(m);
        }
        if (newList.size() > 0) {
            return newList;
        }
        return list;
    }

    public Map getExactMethodMap() {
        return this.exactMethodMap;
    }

    public Class getmClazz() {
        return this.mClazz;
    }

    public List getConstructors() {
        return this.mCtorList;
    }

    public Map getFields() {
        return this.mFieldMap;
    }

    public Map getMethods() {
        return this.mMethodMap;
    }

    public Class[] getParams(Member member) {
        return this.mParamMap.get(member);
    }

    public List<Method> getMethods(String methodName) {
        return this.mMethodMap.get(methodName);
    }
}

