/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.locale;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.IllegalDateFormatException;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.UTCOleDateTime;
import coldfusion.runtime.locale.CFLocale;
import coldfusion.runtime.locale.CFLocaleDateFormatException;
import coldfusion.runtime.locale.CFLocaleNumberFormatException;
import coldfusion.runtime.locale.CFLocaleTimeFormatException;
import coldfusion.runtime.locale.CFNumberFormat;
import coldfusion.util.DateUtils;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class CFLocaleBase
implements CFLocale {
    Locale locale = null;
    private static final String[] AMPM = new String[]{"A", "P"};
    protected String CFString = "English (US)";
    private final ThreadLocal<DateFormat[]> arrayDTs = new ThreadLocal();
    private final ThreadLocal<DateFormat[]> arrayDs = new ThreadLocal();
    private DateFormatSymbols dfs;
    private static Object CLDRLocaleProvider = null;

    private DateFormat[] getDateTimeFormatters() {
        DateFormat[] dateFormats = this.arrayDTs.get();
        if (dateFormats == null) {
            dateFormats = this.initDateTimeFormatters();
            this.arrayDTs.set(dateFormats);
        }
        return dateFormats;
    }

    private DateFormat[] getDateAndTimeFormatters() {
        DateFormat[] dateFormats = this.arrayDs.get();
        if (dateFormats == null) {
            dateFormats = this.initDateAndTimeFormatters();
            this.arrayDs.set(dateFormats);
        }
        return dateFormats;
    }

    private DateFormat[] initDateTimeFormatters() {
        DateFormat[] arrayDTs = new DateFormat[7];
        DateFormat datetimeshort = DateFormat.getDateTimeInstance(3, 3, this.locale);
        DateFormat datetimemedium = DateFormat.getDateTimeInstance(2, 2, this.locale);
        DateFormat datetimelong = DateFormat.getDateTimeInstance(1, 1, this.locale);
        DateFormat datetimefull = DateFormat.getDateTimeInstance(0, 0, this.locale);
        SimpleDateFormat customDateTime = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", this.locale);
        SimpleDateFormat offsetDateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX", this.locale);
        SimpleDateFormat isoDateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", this.locale);
        int i = 0;
        arrayDTs[i++] = datetimeshort;
        arrayDTs[i++] = datetimemedium;
        arrayDTs[i++] = datetimelong;
        arrayDTs[i++] = datetimefull;
        arrayDTs[i++] = customDateTime;
        arrayDTs[i++] = offsetDateTime;
        arrayDTs[i++] = isoDateTime;
        datetimeshort.setLenient(false);
        datetimemedium.setLenient(false);
        datetimelong.setLenient(false);
        datetimefull.setLenient(false);
        customDateTime.setLenient(false);
        offsetDateTime.setLenient(false);
        isoDateTime.setLenient(false);
        return arrayDTs;
    }

    private DateFormat[] initDateAndTimeFormatters() {
        DateFormat[] arrayDs = new DateFormat[16];
        DateFormat dateshort = DateFormat.getDateInstance(3, this.locale);
        DateFormat datemedium = DateFormat.getDateInstance(2, this.locale);
        DateFormat datelong = DateFormat.getDateInstance(1, this.locale);
        DateFormat datefull = DateFormat.getDateInstance(0, this.locale);
        DateFormat customDate4 = DateFormat.getDateInstance(3, this.locale);
        ((SimpleDateFormat)customDate4).applyPattern("yyyy-MM-dd");
        DateFormat customDate5 = DateFormat.getDateInstance(3, this.locale);
        ((SimpleDateFormat)customDate5).applyPattern("dd.MM.yyyy");
        DateFormat customDate6 = DateFormat.getDateInstance(3, this.locale);
        ((SimpleDateFormat)customDate6).applyPattern("dd/MM/yyyy");
        DateFormat timeshort = DateFormat.getTimeInstance(3, this.locale);
        DateFormat timemedium = DateFormat.getTimeInstance(2, this.locale);
        DateFormat timelong = DateFormat.getTimeInstance(1, this.locale);
        DateFormat timefull = DateFormat.getTimeInstance(0, this.locale);
        DateFormat customTime1 = DateFormat.getTimeInstance(3, this.locale);
        ((SimpleDateFormat)customTime1).applyPattern("H:mm:ss.S");
        DateFormat customTime2 = DateFormat.getTimeInstance(3, this.locale);
        ((SimpleDateFormat)customTime2).applyPattern("h:mm:ss a");
        DateFormat customTime3 = DateFormat.getTimeInstance(3, this.locale);
        ((SimpleDateFormat)customTime3).applyPattern("H:mm:ss");
        DateFormat customTime4 = DateFormat.getTimeInstance(3, this.locale);
        ((SimpleDateFormat)customTime4).applyPattern("h:mm a");
        DateFormat customTime5 = DateFormat.getTimeInstance(3, this.locale);
        ((SimpleDateFormat)customTime5).applyPattern("H:mm");
        arrayDs[0] = dateshort;
        arrayDs[1] = datemedium;
        arrayDs[2] = datefull;
        arrayDs[3] = datelong;
        arrayDs[4] = customDate4;
        arrayDs[5] = customDate5;
        arrayDs[6] = customDate6;
        arrayDs[7] = timefull;
        arrayDs[8] = timelong;
        arrayDs[9] = customTime1;
        arrayDs[10] = customTime2;
        arrayDs[11] = customTime3;
        arrayDs[12] = customTime4;
        arrayDs[13] = customTime5;
        arrayDs[14] = timemedium;
        arrayDs[15] = timeshort;
        dateshort.setLenient(false);
        datemedium.setLenient(false);
        datelong.setLenient(false);
        datefull.setLenient(false);
        timeshort.setLenient(false);
        timemedium.setLenient(false);
        timelong.setLenient(false);
        timefull.setLenient(false);
        customDate4.setLenient(false);
        customDate5.setLenient(false);
        customDate6.setLenient(false);
        customTime1.setLenient(false);
        customTime2.setLenient(false);
        customTime3.setLenient(false);
        customTime4.setLenient(false);
        customTime5.setLenient(false);
        return arrayDs;
    }

    @Override
    public OleDateTime ParseDateTime(String indate) {
        int hour = 0;
        int min = 0;
        int sec = 0;
        int month = 0;
        int date = 0;
        int year = 0;
        int timeStartPoint = 7;
        ParsePosition pos = new ParsePosition(0);
        String stDate = indate.trim();
        Date dt = null;
        Date d = null;
        Date t = null;
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = Calendar.getInstance(tz, this.locale);
        DateFormat[] arrayDTs = this.getDateTimeFormatters();
        for (int i = 0; i < arrayDTs.length && (dt = arrayDTs[i].parse(stDate, pos)) == null; ++i) {
        }
        if (pos.getIndex() != stDate.length()) {
            int strlen;
            int posIndex;
            pos.setIndex(0);
            pos.setErrorIndex(0);
            DateFormat[] arrayDs = this.getDateAndTimeFormatters();
            for (int i = 0; i < arrayDs.length; ++i) {
                if (i < timeStartPoint && d == null) {
                    d = arrayDs[i].parse(stDate, pos);
                    if (d != null && pos.getIndex() == stDate.length() && pos.getErrorIndex() > 0) {
                        pos.setIndex(0);
                        d = null;
                    }
                    pos.setErrorIndex(0);
                } else if (i >= timeStartPoint && t == null) {
                    t = arrayDs[i].parse(stDate, pos);
                    if (t != null && pos.getIndex() == stDate.length() && pos.getErrorIndex() > 0) {
                        pos.setIndex(0);
                        t = null;
                    }
                    pos.setErrorIndex(0);
                }
                if (dt == null && d == null && t == null || pos.getIndex() < stDate.length()) continue;
                if (i != 7 && i != 8 || t == null || d == null || !tz.inDaylightTime(d)) break;
                t = new Date(t.getTime() + (long)cal.get(16));
                break;
            }
            if ((posIndex = pos.getIndex()) < (strlen = stDate.length()) && posIndex > 0) {
                String mDate = stDate.substring(posIndex).trim();
                pos.setIndex(0);
                pos.setErrorIndex(0);
                for (int i = 0; i < arrayDs.length; ++i) {
                    if (i < timeStartPoint && d == null) {
                        d = arrayDs[i].parse(mDate, pos);
                        if (d != null && pos.getIndex() == mDate.length() && pos.getErrorIndex() > 0) {
                            pos.setIndex(0);
                            d = null;
                        }
                        pos.setErrorIndex(0);
                    }
                    if (i >= timeStartPoint && t == null) {
                        t = arrayDs[i].parse(mDate, pos);
                        if (t != null && pos.getIndex() == mDate.length() && pos.getErrorIndex() > 0) {
                            pos.setIndex(0);
                            t = null;
                        }
                        pos.setErrorIndex(0);
                    }
                    if (dt == null && d == null && t == null || pos.getIndex() < mDate.length()) continue;
                    pos.setIndex(posIndex + pos.getIndex() + 1);
                    break;
                }
            }
        }
        if (pos.getIndex() != stDate.length()) {
            throw new InvalidDateTimeException(indate);
        }
        boolean bTimeSet = false;
        boolean bDateSet = false;
        if (t != null) {
            cal.setTime(t);
            hour = cal.get(11);
            min = cal.get(12);
            sec = cal.get(13);
            bTimeSet = true;
        }
        if (d != null) {
            cal.clear();
            cal.setTime(d);
            month = cal.get(2);
            date = cal.get(5);
            year = cal.get(1) - 1900;
            bDateSet = true;
        }
        if (dt != null & (!bDateSet || !bTimeSet)) {
            cal.clear();
            cal.setTime(dt);
            if (!bDateSet) {
                month = cal.get(2);
                date = cal.get(5);
                year = cal.get(1) - 1900;
                bDateSet = true;
            }
            if (!bTimeSet) {
                hour = cal.get(11);
                min = cal.get(12);
                sec = cal.get(13);
                bTimeSet = true;
            }
        }
        if (!bDateSet) {
            month = 11;
            date = 30;
            year = -1;
        }
        if (!bTimeSet) {
            hour = 0;
            min = 0;
            sec = 0;
        }
        if (!bTimeSet && !bDateSet) {
            throw new InvalidDateTimeException(indate);
        }
        return new OleDateTime(year, month, date, hour, min, sec);
    }

    @Override
    public OleDateTime ParseDateTime(String indate, String format) {
        if (indate == null) {
            throw new IllegalDateFormatException(indate);
        }
        format = format.trim();
        format = DateUtils.getEscapedMask("'\"kKfFeEwWnNHMSLTzZXhmslt: dDmMyYgG-/", format);
        String formatLcase = format.toLowerCase();
        SimpleDateFormat sdf = null;
        if (formatLcase.indexOf(116) > -1 && formatLcase.indexOf("tt") == -1) {
            DateFormatSymbols dfs = new DateFormatSymbols(this.locale);
            dfs.setAmPmStrings(AMPM);
            sdf = new SimpleDateFormat(DateUtils.replaceCharsOnDateTimeMask(format), dfs);
        } else {
            sdf = new SimpleDateFormat(DateUtils.replaceCharsOnDateTimeMask(format), this.locale);
        }
        DateUtils.updateTimeZone(sdf.getCalendar());
        if (!format.equals("")) {
            try {
                Date d = sdf.parse(indate);
                if (d != null) {
                    return new OleDateTime(d);
                }
                throw new IllegalDateFormatException(indate);
            }
            catch (ParseException e) {
                throw new IllegalDateFormatException(indate);
            }
        }
        return this.ParseDateTime(indate);
    }

    public static boolean isNumberOnly(String inpStr) {
        for (int i = 0; i < inpStr.length(); ++i) {
            if (Character.isDigit(inpStr.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public CFLocaleBase(String language, String country) {
        if (language.equalsIgnoreCase("no") && country.equalsIgnoreCase("NO@nynorsk")) {
            this.locale = new Locale("no", "NO", "Nynorsk");
            this.CFString = "Norwegian (Nynorsk)";
        } else {
            this.locale = new Locale(language, country);
            language = language.toLowerCase();
            country = country.toUpperCase();
            if (language.equals("en") && country.equals("US") || language.equals("en") && country.length() == 0) {
                this.CFString = "English (US)";
            } else if (language.equals("en") && country.equals("GB")) {
                this.CFString = "English (UK)";
            } else if (language.equals("nl") && country.equals("BE")) {
                this.CFString = "Dutch (Belgian)";
            } else if (language.equals("nl") && country.equals("NL") || language.equals("nl") && country.length() == 0) {
                this.CFString = "Dutch (Standard)";
            } else if (language.equals("en") && country.equals("AU")) {
                this.CFString = "English (Australian)";
            } else if (language.equals("en") && country.equals("CA")) {
                this.CFString = "English (Canadian)";
            } else if (language.equals("en") && country.equals("NZ")) {
                this.CFString = "English (New Zealand)";
            } else if (language.equals("fr") && country.equals("BE")) {
                this.CFString = "French (Belgian)";
            } else if (language.equals("fr") && country.equals("CA")) {
                this.CFString = "French (Canadian)";
            } else if (language.equals("fr") && country.equals("FR") || language.equals("fr") && country.length() == 0) {
                this.CFString = "French (Standard)";
            } else if (language.equals("fr") && country.equals("CH")) {
                this.CFString = "French (Swiss)";
            } else if (language.equals("de") && country.equals("AT")) {
                this.CFString = "German (Austrian)";
            } else if (language.equals("de") && country.equals("DE") || language.equals("de") && country.length() == 0) {
                this.CFString = "German (Standard)";
            } else if (language.equals("de") && country.equals("CH")) {
                this.CFString = "German (Swiss)";
            } else if (language.equals("it") && country.equals("IT") || language.equals("it") && country.length() == 0) {
                this.CFString = "Italian (Standard)";
            } else if (language.equals("it") && country.equals("CH")) {
                this.CFString = "Italian (Swiss)";
            } else if (language.equals("no") && country.equals("NO") || language.equals("no") && country.length() == 0) {
                this.CFString = "Norwegian (Bokmal)";
            } else if (language.equals("pt") && country.equals("BR")) {
                this.CFString = "Portuguese (Brazilian)";
            } else if (language.equals("pt") && country.equals("PT") || language.equals("pt") && country.length() == 0) {
                this.CFString = "Portuguese (Standard)";
            } else if (language.equals("es") && country.equals("ES") || language.equals("es") && country.length() == 0) {
                this.CFString = "Spanish (Standard)";
            } else if (language.equals("sv") && country.equals("SE") || language.equals("sv") && country.length() == 0) {
                this.CFString = "Swedish";
            } else if (language.equals("ja") && country.equals("JP") || language.equals("ja") && country.length() == 0) {
                this.CFString = "Japanese";
            } else if (language.equals("ko") && country.equals("KR") || language.equals("ko") && country.length() == 0) {
                this.CFString = "Korean";
            } else if (language.equals("zh") && country.equals("CN") || language.equals("zh") && country.length() == 0) {
                this.CFString = "Chinese (China)";
            } else if (language.equals("zh") && country.equals("HK")) {
                this.CFString = "Chinese (Hong Kong)";
            } else if (language.equals("zh") && country.equals("TW")) {
                this.CFString = "Chinese (Taiwan)";
            }
        }
    }

    public CFLocaleBase(String language, String country, String localeProvider) {
        this(language, country);
        if (localeProvider != null && localeProvider.equalsIgnoreCase("CLDR")) {
            this.dfs = CFLocaleBase.getCLDRDateFormatSymbols(this.locale);
        }
    }

    public CFLocaleBase(String java_locale) {
        this.CFString = java_locale;
        String language = java_locale;
        String country = "";
        String variation = null;
        int i = java_locale.indexOf(95);
        if (i != -1) {
            language = java_locale.substring(0, i);
            country = java_locale.substring(i + 1);
            if (country.indexOf(95) != -1) {
                variation = country.substring(i + 1);
                country = country.substring(0, i);
            }
        }
        this.locale = variation != null ? new Locale(language, country, variation) : new Locale(language, country);
    }

    public CFLocaleBase(Locale locale) {
        this.CFString = locale.toString();
        this.locale = locale;
    }

    @Override
    public String FormatNumber(double number, String mask) throws CFLocaleNumberFormatException {
        Locale loc = this.GetJavaLocaleObj();
        return CFNumberFormat.LsNumberFormat(number, mask, loc);
    }

    @Override
    public String FormatDate(Date DateInJava, String mask) throws CFLocaleDateFormatException {
        if (DateInJava == null) {
            throw new CFLocaleDateFormatException(null);
        }
        String maskLcase = mask.toLowerCase();
        DateFormat dateFormat = null;
        if (maskLcase.equals("short")) {
            dateFormat = DateFormat.getDateInstance(3, this.locale);
        }
        if (maskLcase.equals("medium")) {
            dateFormat = DateFormat.getDateInstance(2, this.locale);
        }
        if (maskLcase.equals("long")) {
            dateFormat = DateFormat.getDateInstance(1, this.locale);
        }
        if (maskLcase.equals("full")) {
            dateFormat = DateFormat.getDateInstance(0, this.locale);
        }
        if (maskLcase.equals("iso")) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd", this.locale);
        }
        if (dateFormat != null) {
            dateFormat.setCalendar(DateUtils.getDefaultCalendar());
            if (DateInJava instanceof UTCOleDateTime) {
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
            return dateFormat.format(DateInJava);
        }
        mask = DateUtils.getEscapedMask("'\"kKfFeEwWhHmMsSdDmMyYgGzzZX-/ ", mask);
        mask = DateUtils.replaceCharsOnDateMask(mask);
        SimpleDateFormat sdf = this.dfs != null ? new SimpleDateFormat(mask, this.dfs) : new SimpleDateFormat(mask, this.locale);
        sdf.setCalendar(DateUtils.getDefaultCalendar());
        if (DateInJava instanceof UTCOleDateTime) {
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return sdf.format(DateInJava);
    }

    @Override
    public String FormatDate(Date DateInJava) throws CFLocaleDateFormatException {
        return this.FormatDate(DateInJava, "medium");
    }

    @Override
    public String FormatTime(Date TimeInJava) throws CFLocaleDateFormatException {
        return this.FormatTime(TimeInJava, "medium");
    }

    @Override
    public String FormatTime(Date TimeInJava, String mask) throws CFLocaleDateFormatException {
        if (TimeInJava == null) {
            throw new CFLocaleTimeFormatException(null);
        }
        String maskLcase = mask.toLowerCase();
        DateFormat dateFormat = null;
        if (maskLcase.equals("short")) {
            dateFormat = DateFormat.getTimeInstance(3, this.locale);
        }
        if (maskLcase.equals("medium")) {
            dateFormat = DateFormat.getTimeInstance(2, this.locale);
        }
        if (maskLcase.equals("long")) {
            dateFormat = DateFormat.getTimeInstance(1, this.locale);
        }
        if (maskLcase.equals("full")) {
            dateFormat = DateFormat.getTimeInstance(0, this.locale);
        }
        if (maskLcase.equals("iso")) {
            dateFormat = new SimpleDateFormat("HH:mm:ssXXX", this.locale);
        }
        if (dateFormat != null) {
            String formattedDate;
            FusionContext fContext = FusionContext.getCurrent();
            TimeZone tz = null;
            if (fContext != null && (tz = fContext.getTimezone()) != null) {
                dateFormat.setTimeZone(tz);
            }
            if (TimeInJava instanceof UTCOleDateTime) {
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
            if ((formattedDate = dateFormat.format(TimeInJava)) != null) {
                formattedDate = formattedDate.replaceAll("[\\u202f\\u00A0]", " ");
            }
            return formattedDate;
        }
        mask = DateUtils.getEscapedMask("'\"kKfFeEwWnNHMSLTzZXhmslt: dDmMyYgG-/", mask);
        maskLcase = mask.toLowerCase();
        SimpleDateFormat sdf = null;
        if (maskLcase.indexOf(116) > -1 && maskLcase.indexOf("tt") == -1) {
            DateFormatSymbols dfs = new DateFormatSymbols(this.locale);
            dfs.setAmPmStrings(AMPM);
            sdf = new SimpleDateFormat(DateUtils.replaceCharsOnTimeMask(mask), dfs);
        } else {
            sdf = new SimpleDateFormat(DateUtils.replaceCharsOnTimeMask(mask), this.locale);
        }
        sdf.setCalendar(DateUtils.getDefaultCalendar());
        if (TimeInJava instanceof UTCOleDateTime) {
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return sdf.format(TimeInJava);
    }

    @Override
    public double ParseNumber(String NumAsString) throws CFLocaleNumberFormatException {
        Locale loc = this.GetJavaLocaleObj();
        return CFNumberFormat.LsParseNumber(NumAsString, loc);
    }

    @Override
    public boolean IsDate(String DateAsString) {
        try {
            return this.ParseDateTime(DateAsString) != null;
        }
        catch (IllegalDateFormatException e) {
            return false;
        }
        catch (InvalidDateTimeException e) {
            return false;
        }
    }

    @Override
    public String GetCFLocaleString() {
        return this.CFString;
    }

    @Override
    public Locale GetJavaLocaleObj() {
        return this.locale;
    }

    private static DateFormatSymbols getCLDRDateFormatSymbols(Locale locale) {
        if (CLDRLocaleProvider != null) {
            try {
                Method getDFSInstanceMethod;
                Object dfsProvider;
                Method getDFSProviderMethod = CLDRLocaleProvider.getClass().getMethod("getDateFormatSymbolsProvider", new Class[0]);
                if (getDFSProviderMethod != null && (dfsProvider = getDFSProviderMethod.invoke(CLDRLocaleProvider, new Object[0])) != null && (getDFSInstanceMethod = dfsProvider.getClass().getMethod("getInstance", Locale.class)) != null) {
                    return (DateFormatSymbols)getDFSInstanceMethod.invoke(dfsProvider, locale);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        try {
            CLDRLocaleProvider = Class.forName("sun.util.cldr.CLDRLocaleProviderAdapter").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class InvalidDateTimeException
    extends ExpressionException {
        public String datetime;

        public InvalidDateTimeException(String date) {
            this.datetime = date;
        }
    }

    public static class InvalidTimezoneException
    extends ExpressionException {
        public String timeZone;

        public InvalidTimezoneException(String timeZone) {
            this.timeZone = timeZone;
        }
    }
}

