/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.locale;

import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.locale.CFLocale;
import coldfusion.runtime.locale.CFLocaleBase;
import coldfusion.runtime.locale.CFLocaleMgrException;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.FastHashtable;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.PageContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CFLocaleMgr {
    private static CFLocaleMgr mInstance = null;
    private Map locale_to_CFLocale = null;
    private FastHashtable cfName_to_Locale = null;
    private CFLocale default_CFLocale = new CFLocaleBase("en", "US");

    private CFLocaleMgr() {
        this.cfName_to_Locale = new FastHashtable();
        this.cfName_to_Locale.put("Dutch (Belgian)", (Object)new CFLocaleBase("nl", "BE"));
        this.cfName_to_Locale.put("Dutch (Standard)", (Object)new CFLocaleBase("nl", "NL"));
        this.cfName_to_Locale.put("English (Australian)", (Object)new CFLocaleBase("en", "AU"));
        this.cfName_to_Locale.put("English (Canadian)", (Object)new CFLocaleBase("en", "CA"));
        this.cfName_to_Locale.put("English (New Zealand)", (Object)new CFLocaleBase("en", "NZ"));
        this.cfName_to_Locale.put("English (UK)", (Object)new CFLocaleBase("en", "GB"));
        this.cfName_to_Locale.put("English (US)", (Object)new CFLocaleBase("en", "US"));
        this.cfName_to_Locale.put("French (Belgian)", (Object)new CFLocaleBase("fr", "BE"));
        this.cfName_to_Locale.put("French (Canadian)", (Object)new CFLocaleBase("fr", "CA"));
        this.cfName_to_Locale.put("French (Standard)", (Object)new CFLocaleBase("fr", "FR"));
        this.cfName_to_Locale.put("French (Swiss)", (Object)new CFLocaleBase("fr", "CH"));
        this.cfName_to_Locale.put("German (Austrian)", (Object)new CFLocaleBase("de", "AT"));
        this.cfName_to_Locale.put("German (Standard)", (Object)new CFLocaleBase("de", "DE"));
        this.cfName_to_Locale.put("German (Swiss)", (Object)new CFLocaleBase("de", "CH"));
        this.cfName_to_Locale.put("Italian (Standard)", (Object)new CFLocaleBase("it", "IT"));
        this.cfName_to_Locale.put("Italian (Swiss)", (Object)new CFLocaleBase("it", "CH"));
        this.cfName_to_Locale.put("Norwegian (Bokmal)", (Object)new CFLocaleBase("no", "NO"));
        this.cfName_to_Locale.put("Norwegian (Nynorsk)", (Object)new CFLocaleBase("no", "NO@nynorsk"));
        this.cfName_to_Locale.put("Portuguese (Brazilian)", (Object)new CFLocaleBase("pt", "BR"));
        this.cfName_to_Locale.put("Portuguese (Standard)", (Object)new CFLocaleBase("pt", "PT"));
        this.cfName_to_Locale.put("Spanish (Modern)", (Object)new CFLocaleBase("es", "ES"));
        this.cfName_to_Locale.put("Spanish (Standard)", (Object)new CFLocaleBase("es", "ES"));
        this.cfName_to_Locale.put("Swedish", (Object)new CFLocaleBase("sv", "SE"));
        this.cfName_to_Locale.put("Japanese", (Object)new CFLocaleBase("ja", "JP", "CLDR"));
        this.cfName_to_Locale.put("Korean", (Object)new CFLocaleBase("ko", "KR"));
        this.cfName_to_Locale.put("Chinese (China)", (Object)new CFLocaleBase("zh", "CN"));
        this.cfName_to_Locale.put("Chinese (Hong Kong)", (Object)new CFLocaleBase("zh", "HK"));
        this.cfName_to_Locale.put("Chinese (Taiwan)", (Object)new CFLocaleBase("zh", "TW"));
        this.locale_to_CFLocale = new HashMap();
        Enumeration e = this.cfName_to_Locale.elements();
        while (e.hasMoreElements()) {
            CFLocale cflocale = (CFLocale)e.nextElement();
            Locale javalocale = cflocale.GetJavaLocaleObj();
            this.locale_to_CFLocale.put(javalocale, cflocale);
        }
        Locale[] list = Locale.getAvailableLocales();
        for (int i = 0; i < list.length; ++i) {
            Locale locale = list[i];
            String name = locale.toString();
            this.cfName_to_Locale.put(name, (Object)new CFLocaleBase(name));
        }
    }

    public static synchronized CFLocaleMgr getMgr() {
        if (mInstance == null) {
            mInstance = new CFLocaleMgr();
        }
        return mInstance;
    }

    public final CFLocale getCFLocale(String locale_string) throws CFLocaleMgrException {
        CFLocale converter = (CFLocale)this.cfName_to_Locale.get(locale_string);
        if (converter == null) {
            throw new CFLocaleMgrException(locale_string);
        }
        return converter;
    }

    public final CFLocale getCFLocale(Locale locale) throws CFLocaleMgrException {
        CFLocale cflocale = (CFLocale)this.locale_to_CFLocale.get(locale);
        if (cflocale == null) {
            if (!this.cfName_to_Locale.containsKey(locale.toString())) {
                throw new CFLocaleMgrException(locale.toString());
            }
            cflocale = new CFLocaleBase(locale);
        }
        return cflocale;
    }

    public final CFLocale getDefaultCFLocale() {
        return this.default_CFLocale;
    }

    public final String getLocaleList() {
        Enumeration e = this.cfName_to_Locale.keys();
        ArrayList list = new ArrayList();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.compareTo(s2);
            }
        });
        return ArrayUtil.ArrayToList(list, ",");
    }

    public Locale getLocaleObj(PageContext pageContext) {
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        Locale locale = null;
        try {
            locale = response.getLocale();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale == null) {
            locale = this.getDefaultCFLocale().GetJavaLocaleObj();
        }
        return locale;
    }

    public boolean isResponseLocaleSet(PageContext pageContext) {
        if (ServerlessUtil.isLambdaEnv()) {
            return false;
        }
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        if (response == null) {
            return false;
        }
        Locale locale = response.getLocale();
        return locale != null;
    }
}

